// Code generated by go-swagger; DO NOT EDIT.

package ndmp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NdmpNodeSessionDeleteCollectionReader is a Reader for the NdmpNodeSessionDeleteCollection structure.
type NdmpNodeSessionDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NdmpNodeSessionDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNdmpNodeSessionDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNdmpNodeSessionDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNdmpNodeSessionDeleteCollectionOK creates a NdmpNodeSessionDeleteCollectionOK with default headers values
func NewNdmpNodeSessionDeleteCollectionOK() *NdmpNodeSessionDeleteCollectionOK {
	return &NdmpNodeSessionDeleteCollectionOK{}
}

/*
NdmpNodeSessionDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type NdmpNodeSessionDeleteCollectionOK struct {
}

// IsSuccess returns true when this ndmp node session delete collection o k response has a 2xx status code
func (o *NdmpNodeSessionDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ndmp node session delete collection o k response has a 3xx status code
func (o *NdmpNodeSessionDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ndmp node session delete collection o k response has a 4xx status code
func (o *NdmpNodeSessionDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ndmp node session delete collection o k response has a 5xx status code
func (o *NdmpNodeSessionDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ndmp node session delete collection o k response a status code equal to that given
func (o *NdmpNodeSessionDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ndmp node session delete collection o k response
func (o *NdmpNodeSessionDeleteCollectionOK) Code() int {
	return 200
}

func (o *NdmpNodeSessionDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/ndmp/sessions][%d] ndmpNodeSessionDeleteCollectionOK", 200)
}

func (o *NdmpNodeSessionDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/ndmp/sessions][%d] ndmpNodeSessionDeleteCollectionOK", 200)
}

func (o *NdmpNodeSessionDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNdmpNodeSessionDeleteCollectionDefault creates a NdmpNodeSessionDeleteCollectionDefault with default headers values
func NewNdmpNodeSessionDeleteCollectionDefault(code int) *NdmpNodeSessionDeleteCollectionDefault {
	return &NdmpNodeSessionDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	NdmpNodeSessionDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 68812802    | The UUID is not valid.|
| 68812803    | Failed to get the SVM name from the specified SVM UUID.|
| 68812804    | Failed to get the node name from the specified node UUID.|
| 68812805    | Failed to obtain the NDMP mode of operation.|
| 68812806    | UUID and Session ID are required.|
*/
type NdmpNodeSessionDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ndmp node session delete collection default response has a 2xx status code
func (o *NdmpNodeSessionDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ndmp node session delete collection default response has a 3xx status code
func (o *NdmpNodeSessionDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ndmp node session delete collection default response has a 4xx status code
func (o *NdmpNodeSessionDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ndmp node session delete collection default response has a 5xx status code
func (o *NdmpNodeSessionDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ndmp node session delete collection default response a status code equal to that given
func (o *NdmpNodeSessionDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ndmp node session delete collection default response
func (o *NdmpNodeSessionDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *NdmpNodeSessionDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/ndmp/sessions][%d] ndmp_node_session_delete_collection default %s", o._statusCode, payload)
}

func (o *NdmpNodeSessionDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/ndmp/sessions][%d] ndmp_node_session_delete_collection default %s", o._statusCode, payload)
}

func (o *NdmpNodeSessionDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NdmpNodeSessionDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NdmpNodeSessionDeleteCollectionBody ndmp node session delete collection body
swagger:model NdmpNodeSessionDeleteCollectionBody
*/
type NdmpNodeSessionDeleteCollectionBody struct {

	// ndmp session response inline records
	NdmpSessionResponseInlineRecords []*models.NdmpSession `json:"records,omitempty"`
}

// Validate validates this ndmp node session delete collection body
func (o *NdmpNodeSessionDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateNdmpSessionResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NdmpNodeSessionDeleteCollectionBody) validateNdmpSessionResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.NdmpSessionResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.NdmpSessionResponseInlineRecords); i++ {
		if swag.IsZero(o.NdmpSessionResponseInlineRecords[i]) { // not required
			continue
		}

		if o.NdmpSessionResponseInlineRecords[i] != nil {
			if err := o.NdmpSessionResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ndmp node session delete collection body based on the context it is used
func (o *NdmpNodeSessionDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNdmpSessionResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NdmpNodeSessionDeleteCollectionBody) contextValidateNdmpSessionResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.NdmpSessionResponseInlineRecords); i++ {

		if o.NdmpSessionResponseInlineRecords[i] != nil {
			if err := o.NdmpSessionResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *NdmpNodeSessionDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NdmpNodeSessionDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res NdmpNodeSessionDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
