// Code generated by go-swagger; DO NOT EDIT.

package ndmp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNdmpNodeSessionGetParams creates a new NdmpNodeSessionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNdmpNodeSessionGetParams() *NdmpNodeSessionGetParams {
	return &NdmpNodeSessionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNdmpNodeSessionGetParamsWithTimeout creates a new NdmpNodeSessionGetParams object
// with the ability to set a timeout on a request.
func NewNdmpNodeSessionGetParamsWithTimeout(timeout time.Duration) *NdmpNodeSessionGetParams {
	return &NdmpNodeSessionGetParams{
		timeout: timeout,
	}
}

// NewNdmpNodeSessionGetParamsWithContext creates a new NdmpNodeSessionGetParams object
// with the ability to set a context for a request.
func NewNdmpNodeSessionGetParamsWithContext(ctx context.Context) *NdmpNodeSessionGetParams {
	return &NdmpNodeSessionGetParams{
		Context: ctx,
	}
}

// NewNdmpNodeSessionGetParamsWithHTTPClient creates a new NdmpNodeSessionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewNdmpNodeSessionGetParamsWithHTTPClient(client *http.Client) *NdmpNodeSessionGetParams {
	return &NdmpNodeSessionGetParams{
		HTTPClient: client,
	}
}

/*
NdmpNodeSessionGetParams contains all the parameters to send to the API endpoint

	for the ndmp node session get operation.

	Typically these are written to a http.Request.
*/
type NdmpNodeSessionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* OwnerUUID.

	   The NDMP node or SVM UUID based on whether NDMP is operating in node-scope or SVM-scope mode.
	*/
	OwnerUUID string

	/* SessionID.

	   NDMP session identifier
	*/
	SessionID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ndmp node session get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NdmpNodeSessionGetParams) WithDefaults() *NdmpNodeSessionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ndmp node session get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NdmpNodeSessionGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the ndmp node session get params
func (o *NdmpNodeSessionGetParams) WithTimeout(timeout time.Duration) *NdmpNodeSessionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ndmp node session get params
func (o *NdmpNodeSessionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ndmp node session get params
func (o *NdmpNodeSessionGetParams) WithContext(ctx context.Context) *NdmpNodeSessionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ndmp node session get params
func (o *NdmpNodeSessionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ndmp node session get params
func (o *NdmpNodeSessionGetParams) WithHTTPClient(client *http.Client) *NdmpNodeSessionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ndmp node session get params
func (o *NdmpNodeSessionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the ndmp node session get params
func (o *NdmpNodeSessionGetParams) WithFields(fields []string) *NdmpNodeSessionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the ndmp node session get params
func (o *NdmpNodeSessionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithOwnerUUID adds the ownerUUID to the ndmp node session get params
func (o *NdmpNodeSessionGetParams) WithOwnerUUID(ownerUUID string) *NdmpNodeSessionGetParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the ndmp node session get params
func (o *NdmpNodeSessionGetParams) SetOwnerUUID(ownerUUID string) {
	o.OwnerUUID = ownerUUID
}

// WithSessionID adds the sessionID to the ndmp node session get params
func (o *NdmpNodeSessionGetParams) WithSessionID(sessionID string) *NdmpNodeSessionGetParams {
	o.SetSessionID(sessionID)
	return o
}

// SetSessionID adds the sessionId to the ndmp node session get params
func (o *NdmpNodeSessionGetParams) SetSessionID(sessionID string) {
	o.SessionID = sessionID
}

// WriteToRequest writes these params to a swagger request
func (o *NdmpNodeSessionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param owner.uuid
	if err := r.SetPathParam("owner.uuid", o.OwnerUUID); err != nil {
		return err
	}

	// path param session.id
	if err := r.SetPathParam("session.id", o.SessionID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamNdmpNodeSessionGet binds the parameter fields
func (o *NdmpNodeSessionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
