// Code generated by go-swagger; DO NOT EDIT.

package ndmp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNdmpNodeSessionsCollectionGetParams creates a new NdmpNodeSessionsCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNdmpNodeSessionsCollectionGetParams() *NdmpNodeSessionsCollectionGetParams {
	return &NdmpNodeSessionsCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNdmpNodeSessionsCollectionGetParamsWithTimeout creates a new NdmpNodeSessionsCollectionGetParams object
// with the ability to set a timeout on a request.
func NewNdmpNodeSessionsCollectionGetParamsWithTimeout(timeout time.Duration) *NdmpNodeSessionsCollectionGetParams {
	return &NdmpNodeSessionsCollectionGetParams{
		timeout: timeout,
	}
}

// NewNdmpNodeSessionsCollectionGetParamsWithContext creates a new NdmpNodeSessionsCollectionGetParams object
// with the ability to set a context for a request.
func NewNdmpNodeSessionsCollectionGetParamsWithContext(ctx context.Context) *NdmpNodeSessionsCollectionGetParams {
	return &NdmpNodeSessionsCollectionGetParams{
		Context: ctx,
	}
}

// NewNdmpNodeSessionsCollectionGetParamsWithHTTPClient creates a new NdmpNodeSessionsCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewNdmpNodeSessionsCollectionGetParamsWithHTTPClient(client *http.Client) *NdmpNodeSessionsCollectionGetParams {
	return &NdmpNodeSessionsCollectionGetParams{
		HTTPClient: client,
	}
}

/*
NdmpNodeSessionsCollectionGetParams contains all the parameters to send to the API endpoint

	for the ndmp node sessions collection get operation.

	Typically these are written to a http.Request.
*/
type NdmpNodeSessionsCollectionGetParams struct {

	/* BackupEngine.

	   Filter by backup_engine
	*/
	BackupEngine *string

	/* ClientAddress.

	   Filter by client_address
	*/
	ClientAddress *string

	/* ClientPort.

	   Filter by client_port
	*/
	ClientPort *int64

	/* DataBytesProcessed.

	   Filter by data.bytes_processed
	*/
	DataBytesProcessed *int64

	/* DataConnectionAddress.

	   Filter by data.connection.address
	*/
	DataConnectionAddress *string

	/* DataConnectionPort.

	   Filter by data.connection.port
	*/
	DataConnectionPort *int64

	/* DataConnectionType.

	   Filter by data.connection.type
	*/
	DataConnectionType *string

	/* DataOperation.

	   Filter by data.operation
	*/
	DataOperation *string

	/* DataReason.

	   Filter by data.reason
	*/
	DataReason *string

	/* DataState.

	   Filter by data.state
	*/
	DataState *string

	/* DataPath.

	   Filter by data_path
	*/
	DataPath *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* ID.

	   Filter by id
	*/
	ID *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* MoverBytesMoved.

	   Filter by mover.bytes_moved
	*/
	MoverBytesMoved *int64

	/* MoverConnectionAddress.

	   Filter by mover.connection.address
	*/
	MoverConnectionAddress *string

	/* MoverConnectionPort.

	   Filter by mover.connection.port
	*/
	MoverConnectionPort *int64

	/* MoverConnectionType.

	   Filter by mover.connection.type
	*/
	MoverConnectionType *string

	/* MoverMode.

	   Filter by mover.mode
	*/
	MoverMode *string

	/* MoverReason.

	   Filter by mover.reason
	*/
	MoverReason *string

	/* MoverState.

	   Filter by mover.state
	*/
	MoverState *string

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* ScsiDeviceID.

	   Filter by scsi.device_id
	*/
	ScsiDeviceID *string

	/* ScsiHostAdapter.

	   Filter by scsi.host_adapter
	*/
	ScsiHostAdapter *int64

	/* ScsiLunID.

	   Filter by scsi.lun_id
	*/
	ScsiLunID *int64

	/* ScsiTargetID.

	   Filter by scsi.target_id
	*/
	ScsiTargetID *int64

	/* SourceAddress.

	   Filter by source_address
	*/
	SourceAddress *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* TapeDevice.

	   Filter by tape_device
	*/
	TapeDevice *string

	/* TapeMode.

	   Filter by tape_mode
	*/
	TapeMode *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ndmp node sessions collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NdmpNodeSessionsCollectionGetParams) WithDefaults() *NdmpNodeSessionsCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ndmp node sessions collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NdmpNodeSessionsCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := NdmpNodeSessionsCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithTimeout(timeout time.Duration) *NdmpNodeSessionsCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithContext(ctx context.Context) *NdmpNodeSessionsCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithHTTPClient(client *http.Client) *NdmpNodeSessionsCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBackupEngine adds the backupEngine to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithBackupEngine(backupEngine *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetBackupEngine(backupEngine)
	return o
}

// SetBackupEngine adds the backupEngine to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetBackupEngine(backupEngine *string) {
	o.BackupEngine = backupEngine
}

// WithClientAddress adds the clientAddress to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithClientAddress(clientAddress *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetClientAddress(clientAddress)
	return o
}

// SetClientAddress adds the clientAddress to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetClientAddress(clientAddress *string) {
	o.ClientAddress = clientAddress
}

// WithClientPort adds the clientPort to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithClientPort(clientPort *int64) *NdmpNodeSessionsCollectionGetParams {
	o.SetClientPort(clientPort)
	return o
}

// SetClientPort adds the clientPort to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetClientPort(clientPort *int64) {
	o.ClientPort = clientPort
}

// WithDataBytesProcessed adds the dataBytesProcessed to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithDataBytesProcessed(dataBytesProcessed *int64) *NdmpNodeSessionsCollectionGetParams {
	o.SetDataBytesProcessed(dataBytesProcessed)
	return o
}

// SetDataBytesProcessed adds the dataBytesProcessed to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetDataBytesProcessed(dataBytesProcessed *int64) {
	o.DataBytesProcessed = dataBytesProcessed
}

// WithDataConnectionAddress adds the dataConnectionAddress to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithDataConnectionAddress(dataConnectionAddress *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetDataConnectionAddress(dataConnectionAddress)
	return o
}

// SetDataConnectionAddress adds the dataConnectionAddress to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetDataConnectionAddress(dataConnectionAddress *string) {
	o.DataConnectionAddress = dataConnectionAddress
}

// WithDataConnectionPort adds the dataConnectionPort to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithDataConnectionPort(dataConnectionPort *int64) *NdmpNodeSessionsCollectionGetParams {
	o.SetDataConnectionPort(dataConnectionPort)
	return o
}

// SetDataConnectionPort adds the dataConnectionPort to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetDataConnectionPort(dataConnectionPort *int64) {
	o.DataConnectionPort = dataConnectionPort
}

// WithDataConnectionType adds the dataConnectionType to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithDataConnectionType(dataConnectionType *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetDataConnectionType(dataConnectionType)
	return o
}

// SetDataConnectionType adds the dataConnectionType to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetDataConnectionType(dataConnectionType *string) {
	o.DataConnectionType = dataConnectionType
}

// WithDataOperation adds the dataOperation to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithDataOperation(dataOperation *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetDataOperation(dataOperation)
	return o
}

// SetDataOperation adds the dataOperation to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetDataOperation(dataOperation *string) {
	o.DataOperation = dataOperation
}

// WithDataReason adds the dataReason to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithDataReason(dataReason *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetDataReason(dataReason)
	return o
}

// SetDataReason adds the dataReason to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetDataReason(dataReason *string) {
	o.DataReason = dataReason
}

// WithDataState adds the dataState to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithDataState(dataState *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetDataState(dataState)
	return o
}

// SetDataState adds the dataState to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetDataState(dataState *string) {
	o.DataState = dataState
}

// WithDataPath adds the dataPath to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithDataPath(dataPath *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetDataPath(dataPath)
	return o
}

// SetDataPath adds the dataPath to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetDataPath(dataPath *string) {
	o.DataPath = dataPath
}

// WithFields adds the fields to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithFields(fields []string) *NdmpNodeSessionsCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithID adds the id to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithID(id *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetID(id *string) {
	o.ID = id
}

// WithMaxRecords adds the maxRecords to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithMaxRecords(maxRecords *int64) *NdmpNodeSessionsCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMoverBytesMoved adds the moverBytesMoved to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithMoverBytesMoved(moverBytesMoved *int64) *NdmpNodeSessionsCollectionGetParams {
	o.SetMoverBytesMoved(moverBytesMoved)
	return o
}

// SetMoverBytesMoved adds the moverBytesMoved to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetMoverBytesMoved(moverBytesMoved *int64) {
	o.MoverBytesMoved = moverBytesMoved
}

// WithMoverConnectionAddress adds the moverConnectionAddress to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithMoverConnectionAddress(moverConnectionAddress *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetMoverConnectionAddress(moverConnectionAddress)
	return o
}

// SetMoverConnectionAddress adds the moverConnectionAddress to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetMoverConnectionAddress(moverConnectionAddress *string) {
	o.MoverConnectionAddress = moverConnectionAddress
}

// WithMoverConnectionPort adds the moverConnectionPort to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithMoverConnectionPort(moverConnectionPort *int64) *NdmpNodeSessionsCollectionGetParams {
	o.SetMoverConnectionPort(moverConnectionPort)
	return o
}

// SetMoverConnectionPort adds the moverConnectionPort to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetMoverConnectionPort(moverConnectionPort *int64) {
	o.MoverConnectionPort = moverConnectionPort
}

// WithMoverConnectionType adds the moverConnectionType to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithMoverConnectionType(moverConnectionType *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetMoverConnectionType(moverConnectionType)
	return o
}

// SetMoverConnectionType adds the moverConnectionType to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetMoverConnectionType(moverConnectionType *string) {
	o.MoverConnectionType = moverConnectionType
}

// WithMoverMode adds the moverMode to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithMoverMode(moverMode *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetMoverMode(moverMode)
	return o
}

// SetMoverMode adds the moverMode to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetMoverMode(moverMode *string) {
	o.MoverMode = moverMode
}

// WithMoverReason adds the moverReason to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithMoverReason(moverReason *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetMoverReason(moverReason)
	return o
}

// SetMoverReason adds the moverReason to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetMoverReason(moverReason *string) {
	o.MoverReason = moverReason
}

// WithMoverState adds the moverState to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithMoverState(moverState *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetMoverState(moverState)
	return o
}

// SetMoverState adds the moverState to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetMoverState(moverState *string) {
	o.MoverState = moverState
}

// WithNodeName adds the nodeName to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithNodeName(nodeName *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithNodeUUID(nodeUUID *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithOrderBy(orderBy []string) *NdmpNodeSessionsCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithReturnRecords(returnRecords *bool) *NdmpNodeSessionsCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *NdmpNodeSessionsCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScsiDeviceID adds the scsiDeviceID to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithScsiDeviceID(scsiDeviceID *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetScsiDeviceID(scsiDeviceID)
	return o
}

// SetScsiDeviceID adds the scsiDeviceId to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetScsiDeviceID(scsiDeviceID *string) {
	o.ScsiDeviceID = scsiDeviceID
}

// WithScsiHostAdapter adds the scsiHostAdapter to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithScsiHostAdapter(scsiHostAdapter *int64) *NdmpNodeSessionsCollectionGetParams {
	o.SetScsiHostAdapter(scsiHostAdapter)
	return o
}

// SetScsiHostAdapter adds the scsiHostAdapter to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetScsiHostAdapter(scsiHostAdapter *int64) {
	o.ScsiHostAdapter = scsiHostAdapter
}

// WithScsiLunID adds the scsiLunID to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithScsiLunID(scsiLunID *int64) *NdmpNodeSessionsCollectionGetParams {
	o.SetScsiLunID(scsiLunID)
	return o
}

// SetScsiLunID adds the scsiLunId to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetScsiLunID(scsiLunID *int64) {
	o.ScsiLunID = scsiLunID
}

// WithScsiTargetID adds the scsiTargetID to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithScsiTargetID(scsiTargetID *int64) *NdmpNodeSessionsCollectionGetParams {
	o.SetScsiTargetID(scsiTargetID)
	return o
}

// SetScsiTargetID adds the scsiTargetId to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetScsiTargetID(scsiTargetID *int64) {
	o.ScsiTargetID = scsiTargetID
}

// WithSourceAddress adds the sourceAddress to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithSourceAddress(sourceAddress *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetSourceAddress(sourceAddress)
	return o
}

// SetSourceAddress adds the sourceAddress to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetSourceAddress(sourceAddress *string) {
	o.SourceAddress = sourceAddress
}

// WithSvmName adds the svmName to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithSvmName(svmName *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithSvmUUID(svmUUID *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTapeDevice adds the tapeDevice to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithTapeDevice(tapeDevice *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetTapeDevice(tapeDevice)
	return o
}

// SetTapeDevice adds the tapeDevice to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetTapeDevice(tapeDevice *string) {
	o.TapeDevice = tapeDevice
}

// WithTapeMode adds the tapeMode to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithTapeMode(tapeMode *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetTapeMode(tapeMode)
	return o
}

// SetTapeMode adds the tapeMode to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetTapeMode(tapeMode *string) {
	o.TapeMode = tapeMode
}

// WithUUID adds the uuid to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) WithUUID(uuid *string) *NdmpNodeSessionsCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the ndmp node sessions collection get params
func (o *NdmpNodeSessionsCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *NdmpNodeSessionsCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.BackupEngine != nil {

		// query param backup_engine
		var qrBackupEngine string

		if o.BackupEngine != nil {
			qrBackupEngine = *o.BackupEngine
		}
		qBackupEngine := qrBackupEngine
		if qBackupEngine != "" {

			if err := r.SetQueryParam("backup_engine", qBackupEngine); err != nil {
				return err
			}
		}
	}

	if o.ClientAddress != nil {

		// query param client_address
		var qrClientAddress string

		if o.ClientAddress != nil {
			qrClientAddress = *o.ClientAddress
		}
		qClientAddress := qrClientAddress
		if qClientAddress != "" {

			if err := r.SetQueryParam("client_address", qClientAddress); err != nil {
				return err
			}
		}
	}

	if o.ClientPort != nil {

		// query param client_port
		var qrClientPort int64

		if o.ClientPort != nil {
			qrClientPort = *o.ClientPort
		}
		qClientPort := swag.FormatInt64(qrClientPort)
		if qClientPort != "" {

			if err := r.SetQueryParam("client_port", qClientPort); err != nil {
				return err
			}
		}
	}

	if o.DataBytesProcessed != nil {

		// query param data.bytes_processed
		var qrDataBytesProcessed int64

		if o.DataBytesProcessed != nil {
			qrDataBytesProcessed = *o.DataBytesProcessed
		}
		qDataBytesProcessed := swag.FormatInt64(qrDataBytesProcessed)
		if qDataBytesProcessed != "" {

			if err := r.SetQueryParam("data.bytes_processed", qDataBytesProcessed); err != nil {
				return err
			}
		}
	}

	if o.DataConnectionAddress != nil {

		// query param data.connection.address
		var qrDataConnectionAddress string

		if o.DataConnectionAddress != nil {
			qrDataConnectionAddress = *o.DataConnectionAddress
		}
		qDataConnectionAddress := qrDataConnectionAddress
		if qDataConnectionAddress != "" {

			if err := r.SetQueryParam("data.connection.address", qDataConnectionAddress); err != nil {
				return err
			}
		}
	}

	if o.DataConnectionPort != nil {

		// query param data.connection.port
		var qrDataConnectionPort int64

		if o.DataConnectionPort != nil {
			qrDataConnectionPort = *o.DataConnectionPort
		}
		qDataConnectionPort := swag.FormatInt64(qrDataConnectionPort)
		if qDataConnectionPort != "" {

			if err := r.SetQueryParam("data.connection.port", qDataConnectionPort); err != nil {
				return err
			}
		}
	}

	if o.DataConnectionType != nil {

		// query param data.connection.type
		var qrDataConnectionType string

		if o.DataConnectionType != nil {
			qrDataConnectionType = *o.DataConnectionType
		}
		qDataConnectionType := qrDataConnectionType
		if qDataConnectionType != "" {

			if err := r.SetQueryParam("data.connection.type", qDataConnectionType); err != nil {
				return err
			}
		}
	}

	if o.DataOperation != nil {

		// query param data.operation
		var qrDataOperation string

		if o.DataOperation != nil {
			qrDataOperation = *o.DataOperation
		}
		qDataOperation := qrDataOperation
		if qDataOperation != "" {

			if err := r.SetQueryParam("data.operation", qDataOperation); err != nil {
				return err
			}
		}
	}

	if o.DataReason != nil {

		// query param data.reason
		var qrDataReason string

		if o.DataReason != nil {
			qrDataReason = *o.DataReason
		}
		qDataReason := qrDataReason
		if qDataReason != "" {

			if err := r.SetQueryParam("data.reason", qDataReason); err != nil {
				return err
			}
		}
	}

	if o.DataState != nil {

		// query param data.state
		var qrDataState string

		if o.DataState != nil {
			qrDataState = *o.DataState
		}
		qDataState := qrDataState
		if qDataState != "" {

			if err := r.SetQueryParam("data.state", qDataState); err != nil {
				return err
			}
		}
	}

	if o.DataPath != nil {

		// query param data_path
		var qrDataPath string

		if o.DataPath != nil {
			qrDataPath = *o.DataPath
		}
		qDataPath := qrDataPath
		if qDataPath != "" {

			if err := r.SetQueryParam("data_path", qDataPath); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.ID != nil {

		// query param id
		var qrID string

		if o.ID != nil {
			qrID = *o.ID
		}
		qID := qrID
		if qID != "" {

			if err := r.SetQueryParam("id", qID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.MoverBytesMoved != nil {

		// query param mover.bytes_moved
		var qrMoverBytesMoved int64

		if o.MoverBytesMoved != nil {
			qrMoverBytesMoved = *o.MoverBytesMoved
		}
		qMoverBytesMoved := swag.FormatInt64(qrMoverBytesMoved)
		if qMoverBytesMoved != "" {

			if err := r.SetQueryParam("mover.bytes_moved", qMoverBytesMoved); err != nil {
				return err
			}
		}
	}

	if o.MoverConnectionAddress != nil {

		// query param mover.connection.address
		var qrMoverConnectionAddress string

		if o.MoverConnectionAddress != nil {
			qrMoverConnectionAddress = *o.MoverConnectionAddress
		}
		qMoverConnectionAddress := qrMoverConnectionAddress
		if qMoverConnectionAddress != "" {

			if err := r.SetQueryParam("mover.connection.address", qMoverConnectionAddress); err != nil {
				return err
			}
		}
	}

	if o.MoverConnectionPort != nil {

		// query param mover.connection.port
		var qrMoverConnectionPort int64

		if o.MoverConnectionPort != nil {
			qrMoverConnectionPort = *o.MoverConnectionPort
		}
		qMoverConnectionPort := swag.FormatInt64(qrMoverConnectionPort)
		if qMoverConnectionPort != "" {

			if err := r.SetQueryParam("mover.connection.port", qMoverConnectionPort); err != nil {
				return err
			}
		}
	}

	if o.MoverConnectionType != nil {

		// query param mover.connection.type
		var qrMoverConnectionType string

		if o.MoverConnectionType != nil {
			qrMoverConnectionType = *o.MoverConnectionType
		}
		qMoverConnectionType := qrMoverConnectionType
		if qMoverConnectionType != "" {

			if err := r.SetQueryParam("mover.connection.type", qMoverConnectionType); err != nil {
				return err
			}
		}
	}

	if o.MoverMode != nil {

		// query param mover.mode
		var qrMoverMode string

		if o.MoverMode != nil {
			qrMoverMode = *o.MoverMode
		}
		qMoverMode := qrMoverMode
		if qMoverMode != "" {

			if err := r.SetQueryParam("mover.mode", qMoverMode); err != nil {
				return err
			}
		}
	}

	if o.MoverReason != nil {

		// query param mover.reason
		var qrMoverReason string

		if o.MoverReason != nil {
			qrMoverReason = *o.MoverReason
		}
		qMoverReason := qrMoverReason
		if qMoverReason != "" {

			if err := r.SetQueryParam("mover.reason", qMoverReason); err != nil {
				return err
			}
		}
	}

	if o.MoverState != nil {

		// query param mover.state
		var qrMoverState string

		if o.MoverState != nil {
			qrMoverState = *o.MoverState
		}
		qMoverState := qrMoverState
		if qMoverState != "" {

			if err := r.SetQueryParam("mover.state", qMoverState); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.ScsiDeviceID != nil {

		// query param scsi.device_id
		var qrScsiDeviceID string

		if o.ScsiDeviceID != nil {
			qrScsiDeviceID = *o.ScsiDeviceID
		}
		qScsiDeviceID := qrScsiDeviceID
		if qScsiDeviceID != "" {

			if err := r.SetQueryParam("scsi.device_id", qScsiDeviceID); err != nil {
				return err
			}
		}
	}

	if o.ScsiHostAdapter != nil {

		// query param scsi.host_adapter
		var qrScsiHostAdapter int64

		if o.ScsiHostAdapter != nil {
			qrScsiHostAdapter = *o.ScsiHostAdapter
		}
		qScsiHostAdapter := swag.FormatInt64(qrScsiHostAdapter)
		if qScsiHostAdapter != "" {

			if err := r.SetQueryParam("scsi.host_adapter", qScsiHostAdapter); err != nil {
				return err
			}
		}
	}

	if o.ScsiLunID != nil {

		// query param scsi.lun_id
		var qrScsiLunID int64

		if o.ScsiLunID != nil {
			qrScsiLunID = *o.ScsiLunID
		}
		qScsiLunID := swag.FormatInt64(qrScsiLunID)
		if qScsiLunID != "" {

			if err := r.SetQueryParam("scsi.lun_id", qScsiLunID); err != nil {
				return err
			}
		}
	}

	if o.ScsiTargetID != nil {

		// query param scsi.target_id
		var qrScsiTargetID int64

		if o.ScsiTargetID != nil {
			qrScsiTargetID = *o.ScsiTargetID
		}
		qScsiTargetID := swag.FormatInt64(qrScsiTargetID)
		if qScsiTargetID != "" {

			if err := r.SetQueryParam("scsi.target_id", qScsiTargetID); err != nil {
				return err
			}
		}
	}

	if o.SourceAddress != nil {

		// query param source_address
		var qrSourceAddress string

		if o.SourceAddress != nil {
			qrSourceAddress = *o.SourceAddress
		}
		qSourceAddress := qrSourceAddress
		if qSourceAddress != "" {

			if err := r.SetQueryParam("source_address", qSourceAddress); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.TapeDevice != nil {

		// query param tape_device
		var qrTapeDevice string

		if o.TapeDevice != nil {
			qrTapeDevice = *o.TapeDevice
		}
		qTapeDevice := qrTapeDevice
		if qTapeDevice != "" {

			if err := r.SetQueryParam("tape_device", qTapeDevice); err != nil {
				return err
			}
		}
	}

	if o.TapeMode != nil {

		// query param tape_mode
		var qrTapeMode string

		if o.TapeMode != nil {
			qrTapeMode = *o.TapeMode
		}
		qTapeMode := qrTapeMode
		if qTapeMode != "" {

			if err := r.SetQueryParam("tape_mode", qTapeMode); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamNdmpNodeSessionsCollectionGet binds the parameter fields
func (o *NdmpNodeSessionsCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamNdmpNodeSessionsCollectionGet binds the parameter order_by
func (o *NdmpNodeSessionsCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
