// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFabricGetParams creates a new FabricGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFabricGetParams() *FabricGetParams {
	return &FabricGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFabricGetParamsWithTimeout creates a new FabricGetParams object
// with the ability to set a timeout on a request.
func NewFabricGetParamsWithTimeout(timeout time.Duration) *FabricGetParams {
	return &FabricGetParams{
		timeout: timeout,
	}
}

// NewFabricGetParamsWithContext creates a new FabricGetParams object
// with the ability to set a context for a request.
func NewFabricGetParamsWithContext(ctx context.Context) *FabricGetParams {
	return &FabricGetParams{
		Context: ctx,
	}
}

// NewFabricGetParamsWithHTTPClient creates a new FabricGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewFabricGetParamsWithHTTPClient(client *http.Client) *FabricGetParams {
	return &FabricGetParams{
		HTTPClient: client,
	}
}

/*
FabricGetParams contains all the parameters to send to the API endpoint

	for the fabric get operation.

	Typically these are written to a http.Request.
*/
type FabricGetParams struct {

	/* CacheMaximumAge.

	   The maximum age of data in the Fibre Channel fabric cache before it should be refreshed from the fabric. The default is 15 minutes.

	   Format: iso8601
	   Default: "15 minutes"
	*/
	CacheMaximumAge *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Name.

	   The world wide name (WWN) of the primary switch of the Fibre Channel fabric.

	*/
	Name string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the fabric get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FabricGetParams) WithDefaults() *FabricGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the fabric get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FabricGetParams) SetDefaults() {
	var (
		cacheMaximumAgeDefault = string("15 minutes")
	)

	val := FabricGetParams{
		CacheMaximumAge: &cacheMaximumAgeDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the fabric get params
func (o *FabricGetParams) WithTimeout(timeout time.Duration) *FabricGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the fabric get params
func (o *FabricGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the fabric get params
func (o *FabricGetParams) WithContext(ctx context.Context) *FabricGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the fabric get params
func (o *FabricGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the fabric get params
func (o *FabricGetParams) WithHTTPClient(client *http.Client) *FabricGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the fabric get params
func (o *FabricGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCacheMaximumAge adds the cacheMaximumAge to the fabric get params
func (o *FabricGetParams) WithCacheMaximumAge(cacheMaximumAge *string) *FabricGetParams {
	o.SetCacheMaximumAge(cacheMaximumAge)
	return o
}

// SetCacheMaximumAge adds the cacheMaximumAge to the fabric get params
func (o *FabricGetParams) SetCacheMaximumAge(cacheMaximumAge *string) {
	o.CacheMaximumAge = cacheMaximumAge
}

// WithFields adds the fields to the fabric get params
func (o *FabricGetParams) WithFields(fields []string) *FabricGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the fabric get params
func (o *FabricGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithName adds the name to the fabric get params
func (o *FabricGetParams) WithName(name string) *FabricGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the fabric get params
func (o *FabricGetParams) SetName(name string) {
	o.Name = name
}

// WriteToRequest writes these params to a swagger request
func (o *FabricGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CacheMaximumAge != nil {

		// query param cache.maximum_age
		var qrCacheMaximumAge string

		if o.CacheMaximumAge != nil {
			qrCacheMaximumAge = *o.CacheMaximumAge
		}
		qCacheMaximumAge := qrCacheMaximumAge
		if qCacheMaximumAge != "" {

			if err := r.SetQueryParam("cache.maximum_age", qCacheMaximumAge); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamFabricGet binds the parameter fields
func (o *FabricGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
