// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FcInterfaceCollectionGetReader is a Reader for the FcInterfaceCollectionGet structure.
type FcInterfaceCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FcInterfaceCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFcInterfaceCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFcInterfaceCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFcInterfaceCollectionGetOK creates a FcInterfaceCollectionGetOK with default headers values
func NewFcInterfaceCollectionGetOK() *FcInterfaceCollectionGetOK {
	return &FcInterfaceCollectionGetOK{}
}

/*
FcInterfaceCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type FcInterfaceCollectionGetOK struct {
	Payload *models.FcInterfaceResponse
}

// IsSuccess returns true when this fc interface collection get o k response has a 2xx status code
func (o *FcInterfaceCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fc interface collection get o k response has a 3xx status code
func (o *FcInterfaceCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fc interface collection get o k response has a 4xx status code
func (o *FcInterfaceCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fc interface collection get o k response has a 5xx status code
func (o *FcInterfaceCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fc interface collection get o k response a status code equal to that given
func (o *FcInterfaceCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fc interface collection get o k response
func (o *FcInterfaceCollectionGetOK) Code() int {
	return 200
}

func (o *FcInterfaceCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/interfaces][%d] fcInterfaceCollectionGetOK %s", 200, payload)
}

func (o *FcInterfaceCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/interfaces][%d] fcInterfaceCollectionGetOK %s", 200, payload)
}

func (o *FcInterfaceCollectionGetOK) GetPayload() *models.FcInterfaceResponse {
	return o.Payload
}

func (o *FcInterfaceCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.FcInterfaceResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFcInterfaceCollectionGetDefault creates a FcInterfaceCollectionGetDefault with default headers values
func NewFcInterfaceCollectionGetDefault(code int) *FcInterfaceCollectionGetDefault {
	return &FcInterfaceCollectionGetDefault{
		_statusCode: code,
	}
}

/*
	FcInterfaceCollectionGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5373982 | An invalid WWN was specified. The length is incorrect. |
| 5373983 | An invalid WWN was specified. The format is incorrect. |
| 5374938 | Query parameter `recommend.data_protocol` is required when any other `recommend` query parameters are specified. |
| 5374939 | Query parameter `recommend.fabrics.name` specifies a duplicate FC fabric. |
| 5374940 | Query parameter `recommend.nodes.name` or `recommend.nodes.uuid` specifies a duplicate node. |
| 5375953 | Query parameter `recommend.fabrics.name` specifies an FC fabric to which no FC port is connected. |
| 5375954 | Query parameter `recommend.nodes.name` or `recommend.nodes.uuid` specifies a node that does not support the specified data protocol. |
| 5375955 | Query parameter `recommend.proposed.locations.port.uuid` does not specify a valid port or specifies a port that is support the specified data protocol. |
| 5375956 | Query parameter `recommend.proposed.locations.port.uuid` specifies a port that is not located on a node specified by query parameter `recommend.nodes.name` or `recommend.nodes.uuid`. If the nodes are to be constrained, only ports on those nodes may be proposed. |
| 5375957 | Query parameter `recommend.proposed.locations.port.uuid` specifies a port that is disabled. |
| 5375958 | Query parameter `recommend.proposed.locations.port.uuid` specifies a port that is not reporting a connected FC fabric. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type FcInterfaceCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fc interface collection get default response has a 2xx status code
func (o *FcInterfaceCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fc interface collection get default response has a 3xx status code
func (o *FcInterfaceCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fc interface collection get default response has a 4xx status code
func (o *FcInterfaceCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fc interface collection get default response has a 5xx status code
func (o *FcInterfaceCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fc interface collection get default response a status code equal to that given
func (o *FcInterfaceCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fc interface collection get default response
func (o *FcInterfaceCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *FcInterfaceCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/interfaces][%d] fc_interface_collection_get default %s", o._statusCode, payload)
}

func (o *FcInterfaceCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/interfaces][%d] fc_interface_collection_get default %s", o._statusCode, payload)
}

func (o *FcInterfaceCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FcInterfaceCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
