// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FcInterfaceDeleteReader is a Reader for the FcInterfaceDelete structure.
type FcInterfaceDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FcInterfaceDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFcInterfaceDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFcInterfaceDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFcInterfaceDeleteOK creates a FcInterfaceDeleteOK with default headers values
func NewFcInterfaceDeleteOK() *FcInterfaceDeleteOK {
	return &FcInterfaceDeleteOK{}
}

/*
FcInterfaceDeleteOK describes a response with status code 200, with default header values.

OK
*/
type FcInterfaceDeleteOK struct {
}

// IsSuccess returns true when this fc interface delete o k response has a 2xx status code
func (o *FcInterfaceDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fc interface delete o k response has a 3xx status code
func (o *FcInterfaceDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fc interface delete o k response has a 4xx status code
func (o *FcInterfaceDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fc interface delete o k response has a 5xx status code
func (o *FcInterfaceDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fc interface delete o k response a status code equal to that given
func (o *FcInterfaceDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fc interface delete o k response
func (o *FcInterfaceDeleteOK) Code() int {
	return 200
}

func (o *FcInterfaceDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /network/fc/interfaces/{uuid}][%d] fcInterfaceDeleteOK", 200)
}

func (o *FcInterfaceDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /network/fc/interfaces/{uuid}][%d] fcInterfaceDeleteOK", 200)
}

func (o *FcInterfaceDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewFcInterfaceDeleteDefault creates a FcInterfaceDeleteDefault with default headers values
func NewFcInterfaceDeleteDefault(code int) *FcInterfaceDeleteDefault {
	return &FcInterfaceDeleteDefault{
		_statusCode: code,
	}
}

/*
	FcInterfaceDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 53280992 | The FC interface could not be deleted because it is enabled. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type FcInterfaceDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fc interface delete default response has a 2xx status code
func (o *FcInterfaceDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fc interface delete default response has a 3xx status code
func (o *FcInterfaceDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fc interface delete default response has a 4xx status code
func (o *FcInterfaceDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fc interface delete default response has a 5xx status code
func (o *FcInterfaceDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fc interface delete default response a status code equal to that given
func (o *FcInterfaceDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fc interface delete default response
func (o *FcInterfaceDeleteDefault) Code() int {
	return o._statusCode
}

func (o *FcInterfaceDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /network/fc/interfaces/{uuid}][%d] fc_interface_delete default %s", o._statusCode, payload)
}

func (o *FcInterfaceDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /network/fc/interfaces/{uuid}][%d] fc_interface_delete default %s", o._statusCode, payload)
}

func (o *FcInterfaceDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FcInterfaceDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
