// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFcInterfaceModifyCollectionParams creates a new FcInterfaceModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFcInterfaceModifyCollectionParams() *FcInterfaceModifyCollectionParams {
	return &FcInterfaceModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFcInterfaceModifyCollectionParamsWithTimeout creates a new FcInterfaceModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewFcInterfaceModifyCollectionParamsWithTimeout(timeout time.Duration) *FcInterfaceModifyCollectionParams {
	return &FcInterfaceModifyCollectionParams{
		timeout: timeout,
	}
}

// NewFcInterfaceModifyCollectionParamsWithContext creates a new FcInterfaceModifyCollectionParams object
// with the ability to set a context for a request.
func NewFcInterfaceModifyCollectionParamsWithContext(ctx context.Context) *FcInterfaceModifyCollectionParams {
	return &FcInterfaceModifyCollectionParams{
		Context: ctx,
	}
}

// NewFcInterfaceModifyCollectionParamsWithHTTPClient creates a new FcInterfaceModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewFcInterfaceModifyCollectionParamsWithHTTPClient(client *http.Client) *FcInterfaceModifyCollectionParams {
	return &FcInterfaceModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
FcInterfaceModifyCollectionParams contains all the parameters to send to the API endpoint

	for the fc interface modify collection operation.

	Typically these are written to a http.Request.
*/
type FcInterfaceModifyCollectionParams struct {

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* DataProtocol.

	   Filter by data_protocol
	*/
	DataProtocol *string

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Info.

	   Info specification
	*/
	Info FcInterfaceModifyCollectionBody

	/* LocationHomeNodeName.

	   Filter by location.home_node.name
	*/
	LocationHomeNodeName *string

	/* LocationHomeNodeUUID.

	   Filter by location.home_node.uuid
	*/
	LocationHomeNodeUUID *string

	/* LocationHomePortName.

	   Filter by location.home_port.name
	*/
	LocationHomePortName *string

	/* LocationHomePortNodeName.

	   Filter by location.home_port.node.name
	*/
	LocationHomePortNodeName *string

	/* LocationHomePortUUID.

	   Filter by location.home_port.uuid
	*/
	LocationHomePortUUID *string

	/* LocationIsHome.

	   Filter by location.is_home
	*/
	LocationIsHome *bool

	/* LocationNodeName.

	   Filter by location.node.name
	*/
	LocationNodeName *string

	/* LocationNodeUUID.

	   Filter by location.node.uuid
	*/
	LocationNodeUUID *string

	/* LocationPortName.

	   Filter by location.port.name
	*/
	LocationPortName *string

	/* LocationPortNodeName.

	   Filter by location.port.node.name
	*/
	LocationPortNodeName *string

	/* LocationPortUUID.

	   Filter by location.port.uuid
	*/
	LocationPortUUID *string

	/* MetricDuration.

	   Filter by metric.duration
	*/
	MetricDuration *string

	/* MetricIopsOther.

	   Filter by metric.iops.other
	*/
	MetricIopsOther *int64

	/* MetricIopsRead.

	   Filter by metric.iops.read
	*/
	MetricIopsRead *int64

	/* MetricIopsTotal.

	   Filter by metric.iops.total
	*/
	MetricIopsTotal *int64

	/* MetricIopsWrite.

	   Filter by metric.iops.write
	*/
	MetricIopsWrite *int64

	/* MetricLatencyOther.

	   Filter by metric.latency.other
	*/
	MetricLatencyOther *int64

	/* MetricLatencyRead.

	   Filter by metric.latency.read
	*/
	MetricLatencyRead *int64

	/* MetricLatencyTotal.

	   Filter by metric.latency.total
	*/
	MetricLatencyTotal *int64

	/* MetricLatencyWrite.

	   Filter by metric.latency.write
	*/
	MetricLatencyWrite *int64

	/* MetricStatus.

	   Filter by metric.status
	*/
	MetricStatus *string

	/* MetricThroughputRead.

	   Filter by metric.throughput.read
	*/
	MetricThroughputRead *int64

	/* MetricThroughputTotal.

	   Filter by metric.throughput.total
	*/
	MetricThroughputTotal *int64

	/* MetricThroughputWrite.

	   Filter by metric.throughput.write
	*/
	MetricThroughputWrite *int64

	/* MetricTimestamp.

	   Filter by metric.timestamp
	*/
	MetricTimestamp *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* PortAddress.

	   Filter by port_address
	*/
	PortAddress *string

	/* RecommendDataProtocol.

	   The target data protocol for which to recommend FC interfaces. This query parameter is required when recommending FC interfaces.

	*/
	RecommendDataProtocol *string

	/* RecommendFabricsName.

	   The names of the FC fabrics to target when recommending FC interfaces. If this query parameter is not provided, FC interfaces will be recommended for each FC fabric discovered.

	*/
	RecommendFabricsName []string

	/* RecommendInterfacesPerNode.

	   The target number of interfaces per FC fabric per cluster node when recommending FC interfaces. If this query parameter is not provided, the default value is one (1).


	   Default: 1
	*/
	RecommendInterfacesPerNode *int64

	/* RecommendNodesName.

	   The names of the cluster nodes to target when recommending FC interfaces. If this query parameter is not provided, FC interfaces will be recommended for all nodes that have FC network ports supporting target data protocol. Query parameters `recommend.nodes.name` and `recommend.nodes.uuid` are mutually exclusive; use either names or UUIDs to identify cluster nodes.

	*/
	RecommendNodesName []string

	/* RecommendNodesUUID.

	   The UUIDs of the cluster nodes to target when recommending FC interfaces. If this query parameter is not provided, FC interfaces will be recommended for all nodes that have FC network ports supporting target data protocol. Query parameters `recommend.nodes.name` and `recommend.nodes.uuid` are mutually exclusive; use either names or UUIDs to identify cluster nodes.

	*/
	RecommendNodesUUID []string

	/* RecommendProposedLocationsPortUUID.

	   The UUIDs of the FC ports on which FC interfaces are proposed. A UUID may be supplied multiple times to proposed multiple FC interfaces. FC ports must be enabled, support the target data protocol and be reporting an FC fabric.

	*/
	RecommendProposedLocationsPortUUID []string

	/* RecommendSvmName.

	   The name of an existing SVM for which to recommend FC interfaces. If neither query parameter `recommend.svm.name` nor `recommend.svm.uuid` are provided when recommending FC interfaces, recommendations are made for a new, non-existent SVM.

	*/
	RecommendSvmName *string

	/* RecommendSvmUUID.

	   The UUID of an existing SVM for which to recommend FC interfaces. If neither query parameter `recommend.svm.name` nor `recommend.svm.uuid` are provided when recommending FC interfaces, recommendations are made for a new, non-existent SVM.

	*/
	RecommendSvmUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* State.

	   Filter by state
	*/
	State *string

	/* StatisticsIopsRawOther.

	   Filter by statistics.iops_raw.other
	*/
	StatisticsIopsRawOther *int64

	/* StatisticsIopsRawRead.

	   Filter by statistics.iops_raw.read
	*/
	StatisticsIopsRawRead *int64

	/* StatisticsIopsRawTotal.

	   Filter by statistics.iops_raw.total
	*/
	StatisticsIopsRawTotal *int64

	/* StatisticsIopsRawWrite.

	   Filter by statistics.iops_raw.write
	*/
	StatisticsIopsRawWrite *int64

	/* StatisticsLatencyRawOther.

	   Filter by statistics.latency_raw.other
	*/
	StatisticsLatencyRawOther *int64

	/* StatisticsLatencyRawRead.

	   Filter by statistics.latency_raw.read
	*/
	StatisticsLatencyRawRead *int64

	/* StatisticsLatencyRawTotal.

	   Filter by statistics.latency_raw.total
	*/
	StatisticsLatencyRawTotal *int64

	/* StatisticsLatencyRawWrite.

	   Filter by statistics.latency_raw.write
	*/
	StatisticsLatencyRawWrite *int64

	/* StatisticsStatus.

	   Filter by statistics.status
	*/
	StatisticsStatus *string

	/* StatisticsThroughputRawRead.

	   Filter by statistics.throughput_raw.read
	*/
	StatisticsThroughputRawRead *int64

	/* StatisticsThroughputRawTotal.

	   Filter by statistics.throughput_raw.total
	*/
	StatisticsThroughputRawTotal *int64

	/* StatisticsThroughputRawWrite.

	   Filter by statistics.throughput_raw.write
	*/
	StatisticsThroughputRawWrite *int64

	/* StatisticsTimestamp.

	   Filter by statistics.timestamp
	*/
	StatisticsTimestamp *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* Wwnn.

	   Filter by wwnn
	*/
	Wwnn *string

	/* Wwpn.

	   Filter by wwpn
	*/
	Wwpn *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the fc interface modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FcInterfaceModifyCollectionParams) WithDefaults() *FcInterfaceModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the fc interface modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FcInterfaceModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		recommendInterfacesPerNodeDefault = int64(1)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := FcInterfaceModifyCollectionParams{
		ContinueOnFailure:          &continueOnFailureDefault,
		RecommendInterfacesPerNode: &recommendInterfacesPerNodeDefault,
		ReturnRecords:              &returnRecordsDefault,
		ReturnTimeout:              &returnTimeoutDefault,
		SerialRecords:              &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithTimeout(timeout time.Duration) *FcInterfaceModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithContext(ctx context.Context) *FcInterfaceModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithHTTPClient(client *http.Client) *FcInterfaceModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithComment(comment *string) *FcInterfaceModifyCollectionParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithContinueOnFailure adds the continueOnFailure to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *FcInterfaceModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDataProtocol adds the dataProtocol to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithDataProtocol(dataProtocol *string) *FcInterfaceModifyCollectionParams {
	o.SetDataProtocol(dataProtocol)
	return o
}

// SetDataProtocol adds the dataProtocol to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetDataProtocol(dataProtocol *string) {
	o.DataProtocol = dataProtocol
}

// WithEnabled adds the enabled to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithEnabled(enabled *bool) *FcInterfaceModifyCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithInfo adds the info to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithInfo(info FcInterfaceModifyCollectionBody) *FcInterfaceModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetInfo(info FcInterfaceModifyCollectionBody) {
	o.Info = info
}

// WithLocationHomeNodeName adds the locationHomeNodeName to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithLocationHomeNodeName(locationHomeNodeName *string) *FcInterfaceModifyCollectionParams {
	o.SetLocationHomeNodeName(locationHomeNodeName)
	return o
}

// SetLocationHomeNodeName adds the locationHomeNodeName to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetLocationHomeNodeName(locationHomeNodeName *string) {
	o.LocationHomeNodeName = locationHomeNodeName
}

// WithLocationHomeNodeUUID adds the locationHomeNodeUUID to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithLocationHomeNodeUUID(locationHomeNodeUUID *string) *FcInterfaceModifyCollectionParams {
	o.SetLocationHomeNodeUUID(locationHomeNodeUUID)
	return o
}

// SetLocationHomeNodeUUID adds the locationHomeNodeUuid to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetLocationHomeNodeUUID(locationHomeNodeUUID *string) {
	o.LocationHomeNodeUUID = locationHomeNodeUUID
}

// WithLocationHomePortName adds the locationHomePortName to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithLocationHomePortName(locationHomePortName *string) *FcInterfaceModifyCollectionParams {
	o.SetLocationHomePortName(locationHomePortName)
	return o
}

// SetLocationHomePortName adds the locationHomePortName to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetLocationHomePortName(locationHomePortName *string) {
	o.LocationHomePortName = locationHomePortName
}

// WithLocationHomePortNodeName adds the locationHomePortNodeName to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithLocationHomePortNodeName(locationHomePortNodeName *string) *FcInterfaceModifyCollectionParams {
	o.SetLocationHomePortNodeName(locationHomePortNodeName)
	return o
}

// SetLocationHomePortNodeName adds the locationHomePortNodeName to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetLocationHomePortNodeName(locationHomePortNodeName *string) {
	o.LocationHomePortNodeName = locationHomePortNodeName
}

// WithLocationHomePortUUID adds the locationHomePortUUID to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithLocationHomePortUUID(locationHomePortUUID *string) *FcInterfaceModifyCollectionParams {
	o.SetLocationHomePortUUID(locationHomePortUUID)
	return o
}

// SetLocationHomePortUUID adds the locationHomePortUuid to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetLocationHomePortUUID(locationHomePortUUID *string) {
	o.LocationHomePortUUID = locationHomePortUUID
}

// WithLocationIsHome adds the locationIsHome to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithLocationIsHome(locationIsHome *bool) *FcInterfaceModifyCollectionParams {
	o.SetLocationIsHome(locationIsHome)
	return o
}

// SetLocationIsHome adds the locationIsHome to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetLocationIsHome(locationIsHome *bool) {
	o.LocationIsHome = locationIsHome
}

// WithLocationNodeName adds the locationNodeName to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithLocationNodeName(locationNodeName *string) *FcInterfaceModifyCollectionParams {
	o.SetLocationNodeName(locationNodeName)
	return o
}

// SetLocationNodeName adds the locationNodeName to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetLocationNodeName(locationNodeName *string) {
	o.LocationNodeName = locationNodeName
}

// WithLocationNodeUUID adds the locationNodeUUID to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithLocationNodeUUID(locationNodeUUID *string) *FcInterfaceModifyCollectionParams {
	o.SetLocationNodeUUID(locationNodeUUID)
	return o
}

// SetLocationNodeUUID adds the locationNodeUuid to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetLocationNodeUUID(locationNodeUUID *string) {
	o.LocationNodeUUID = locationNodeUUID
}

// WithLocationPortName adds the locationPortName to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithLocationPortName(locationPortName *string) *FcInterfaceModifyCollectionParams {
	o.SetLocationPortName(locationPortName)
	return o
}

// SetLocationPortName adds the locationPortName to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetLocationPortName(locationPortName *string) {
	o.LocationPortName = locationPortName
}

// WithLocationPortNodeName adds the locationPortNodeName to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithLocationPortNodeName(locationPortNodeName *string) *FcInterfaceModifyCollectionParams {
	o.SetLocationPortNodeName(locationPortNodeName)
	return o
}

// SetLocationPortNodeName adds the locationPortNodeName to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetLocationPortNodeName(locationPortNodeName *string) {
	o.LocationPortNodeName = locationPortNodeName
}

// WithLocationPortUUID adds the locationPortUUID to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithLocationPortUUID(locationPortUUID *string) *FcInterfaceModifyCollectionParams {
	o.SetLocationPortUUID(locationPortUUID)
	return o
}

// SetLocationPortUUID adds the locationPortUuid to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetLocationPortUUID(locationPortUUID *string) {
	o.LocationPortUUID = locationPortUUID
}

// WithMetricDuration adds the metricDuration to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithMetricDuration(metricDuration *string) *FcInterfaceModifyCollectionParams {
	o.SetMetricDuration(metricDuration)
	return o
}

// SetMetricDuration adds the metricDuration to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetMetricDuration(metricDuration *string) {
	o.MetricDuration = metricDuration
}

// WithMetricIopsOther adds the metricIopsOther to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithMetricIopsOther(metricIopsOther *int64) *FcInterfaceModifyCollectionParams {
	o.SetMetricIopsOther(metricIopsOther)
	return o
}

// SetMetricIopsOther adds the metricIopsOther to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetMetricIopsOther(metricIopsOther *int64) {
	o.MetricIopsOther = metricIopsOther
}

// WithMetricIopsRead adds the metricIopsRead to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithMetricIopsRead(metricIopsRead *int64) *FcInterfaceModifyCollectionParams {
	o.SetMetricIopsRead(metricIopsRead)
	return o
}

// SetMetricIopsRead adds the metricIopsRead to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetMetricIopsRead(metricIopsRead *int64) {
	o.MetricIopsRead = metricIopsRead
}

// WithMetricIopsTotal adds the metricIopsTotal to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithMetricIopsTotal(metricIopsTotal *int64) *FcInterfaceModifyCollectionParams {
	o.SetMetricIopsTotal(metricIopsTotal)
	return o
}

// SetMetricIopsTotal adds the metricIopsTotal to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetMetricIopsTotal(metricIopsTotal *int64) {
	o.MetricIopsTotal = metricIopsTotal
}

// WithMetricIopsWrite adds the metricIopsWrite to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithMetricIopsWrite(metricIopsWrite *int64) *FcInterfaceModifyCollectionParams {
	o.SetMetricIopsWrite(metricIopsWrite)
	return o
}

// SetMetricIopsWrite adds the metricIopsWrite to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetMetricIopsWrite(metricIopsWrite *int64) {
	o.MetricIopsWrite = metricIopsWrite
}

// WithMetricLatencyOther adds the metricLatencyOther to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithMetricLatencyOther(metricLatencyOther *int64) *FcInterfaceModifyCollectionParams {
	o.SetMetricLatencyOther(metricLatencyOther)
	return o
}

// SetMetricLatencyOther adds the metricLatencyOther to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetMetricLatencyOther(metricLatencyOther *int64) {
	o.MetricLatencyOther = metricLatencyOther
}

// WithMetricLatencyRead adds the metricLatencyRead to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithMetricLatencyRead(metricLatencyRead *int64) *FcInterfaceModifyCollectionParams {
	o.SetMetricLatencyRead(metricLatencyRead)
	return o
}

// SetMetricLatencyRead adds the metricLatencyRead to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetMetricLatencyRead(metricLatencyRead *int64) {
	o.MetricLatencyRead = metricLatencyRead
}

// WithMetricLatencyTotal adds the metricLatencyTotal to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithMetricLatencyTotal(metricLatencyTotal *int64) *FcInterfaceModifyCollectionParams {
	o.SetMetricLatencyTotal(metricLatencyTotal)
	return o
}

// SetMetricLatencyTotal adds the metricLatencyTotal to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetMetricLatencyTotal(metricLatencyTotal *int64) {
	o.MetricLatencyTotal = metricLatencyTotal
}

// WithMetricLatencyWrite adds the metricLatencyWrite to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithMetricLatencyWrite(metricLatencyWrite *int64) *FcInterfaceModifyCollectionParams {
	o.SetMetricLatencyWrite(metricLatencyWrite)
	return o
}

// SetMetricLatencyWrite adds the metricLatencyWrite to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetMetricLatencyWrite(metricLatencyWrite *int64) {
	o.MetricLatencyWrite = metricLatencyWrite
}

// WithMetricStatus adds the metricStatus to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithMetricStatus(metricStatus *string) *FcInterfaceModifyCollectionParams {
	o.SetMetricStatus(metricStatus)
	return o
}

// SetMetricStatus adds the metricStatus to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetMetricStatus(metricStatus *string) {
	o.MetricStatus = metricStatus
}

// WithMetricThroughputRead adds the metricThroughputRead to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithMetricThroughputRead(metricThroughputRead *int64) *FcInterfaceModifyCollectionParams {
	o.SetMetricThroughputRead(metricThroughputRead)
	return o
}

// SetMetricThroughputRead adds the metricThroughputRead to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetMetricThroughputRead(metricThroughputRead *int64) {
	o.MetricThroughputRead = metricThroughputRead
}

// WithMetricThroughputTotal adds the metricThroughputTotal to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithMetricThroughputTotal(metricThroughputTotal *int64) *FcInterfaceModifyCollectionParams {
	o.SetMetricThroughputTotal(metricThroughputTotal)
	return o
}

// SetMetricThroughputTotal adds the metricThroughputTotal to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetMetricThroughputTotal(metricThroughputTotal *int64) {
	o.MetricThroughputTotal = metricThroughputTotal
}

// WithMetricThroughputWrite adds the metricThroughputWrite to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithMetricThroughputWrite(metricThroughputWrite *int64) *FcInterfaceModifyCollectionParams {
	o.SetMetricThroughputWrite(metricThroughputWrite)
	return o
}

// SetMetricThroughputWrite adds the metricThroughputWrite to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetMetricThroughputWrite(metricThroughputWrite *int64) {
	o.MetricThroughputWrite = metricThroughputWrite
}

// WithMetricTimestamp adds the metricTimestamp to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithMetricTimestamp(metricTimestamp *string) *FcInterfaceModifyCollectionParams {
	o.SetMetricTimestamp(metricTimestamp)
	return o
}

// SetMetricTimestamp adds the metricTimestamp to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetMetricTimestamp(metricTimestamp *string) {
	o.MetricTimestamp = metricTimestamp
}

// WithName adds the name to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithName(name *string) *FcInterfaceModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithPortAddress adds the portAddress to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithPortAddress(portAddress *string) *FcInterfaceModifyCollectionParams {
	o.SetPortAddress(portAddress)
	return o
}

// SetPortAddress adds the portAddress to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetPortAddress(portAddress *string) {
	o.PortAddress = portAddress
}

// WithRecommendDataProtocol adds the recommendDataProtocol to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithRecommendDataProtocol(recommendDataProtocol *string) *FcInterfaceModifyCollectionParams {
	o.SetRecommendDataProtocol(recommendDataProtocol)
	return o
}

// SetRecommendDataProtocol adds the recommendDataProtocol to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetRecommendDataProtocol(recommendDataProtocol *string) {
	o.RecommendDataProtocol = recommendDataProtocol
}

// WithRecommendFabricsName adds the recommendFabricsName to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithRecommendFabricsName(recommendFabricsName []string) *FcInterfaceModifyCollectionParams {
	o.SetRecommendFabricsName(recommendFabricsName)
	return o
}

// SetRecommendFabricsName adds the recommendFabricsName to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetRecommendFabricsName(recommendFabricsName []string) {
	o.RecommendFabricsName = recommendFabricsName
}

// WithRecommendInterfacesPerNode adds the recommendInterfacesPerNode to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithRecommendInterfacesPerNode(recommendInterfacesPerNode *int64) *FcInterfaceModifyCollectionParams {
	o.SetRecommendInterfacesPerNode(recommendInterfacesPerNode)
	return o
}

// SetRecommendInterfacesPerNode adds the recommendInterfacesPerNode to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetRecommendInterfacesPerNode(recommendInterfacesPerNode *int64) {
	o.RecommendInterfacesPerNode = recommendInterfacesPerNode
}

// WithRecommendNodesName adds the recommendNodesName to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithRecommendNodesName(recommendNodesName []string) *FcInterfaceModifyCollectionParams {
	o.SetRecommendNodesName(recommendNodesName)
	return o
}

// SetRecommendNodesName adds the recommendNodesName to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetRecommendNodesName(recommendNodesName []string) {
	o.RecommendNodesName = recommendNodesName
}

// WithRecommendNodesUUID adds the recommendNodesUUID to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithRecommendNodesUUID(recommendNodesUUID []string) *FcInterfaceModifyCollectionParams {
	o.SetRecommendNodesUUID(recommendNodesUUID)
	return o
}

// SetRecommendNodesUUID adds the recommendNodesUuid to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetRecommendNodesUUID(recommendNodesUUID []string) {
	o.RecommendNodesUUID = recommendNodesUUID
}

// WithRecommendProposedLocationsPortUUID adds the recommendProposedLocationsPortUUID to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithRecommendProposedLocationsPortUUID(recommendProposedLocationsPortUUID []string) *FcInterfaceModifyCollectionParams {
	o.SetRecommendProposedLocationsPortUUID(recommendProposedLocationsPortUUID)
	return o
}

// SetRecommendProposedLocationsPortUUID adds the recommendProposedLocationsPortUuid to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetRecommendProposedLocationsPortUUID(recommendProposedLocationsPortUUID []string) {
	o.RecommendProposedLocationsPortUUID = recommendProposedLocationsPortUUID
}

// WithRecommendSvmName adds the recommendSvmName to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithRecommendSvmName(recommendSvmName *string) *FcInterfaceModifyCollectionParams {
	o.SetRecommendSvmName(recommendSvmName)
	return o
}

// SetRecommendSvmName adds the recommendSvmName to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetRecommendSvmName(recommendSvmName *string) {
	o.RecommendSvmName = recommendSvmName
}

// WithRecommendSvmUUID adds the recommendSvmUUID to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithRecommendSvmUUID(recommendSvmUUID *string) *FcInterfaceModifyCollectionParams {
	o.SetRecommendSvmUUID(recommendSvmUUID)
	return o
}

// SetRecommendSvmUUID adds the recommendSvmUuid to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetRecommendSvmUUID(recommendSvmUUID *string) {
	o.RecommendSvmUUID = recommendSvmUUID
}

// WithReturnRecords adds the returnRecords to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithReturnRecords(returnRecords *bool) *FcInterfaceModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *FcInterfaceModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithSerialRecords(serialRecords *bool) *FcInterfaceModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithState adds the state to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithState(state *string) *FcInterfaceModifyCollectionParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetState(state *string) {
	o.State = state
}

// WithStatisticsIopsRawOther adds the statisticsIopsRawOther to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithStatisticsIopsRawOther(statisticsIopsRawOther *int64) *FcInterfaceModifyCollectionParams {
	o.SetStatisticsIopsRawOther(statisticsIopsRawOther)
	return o
}

// SetStatisticsIopsRawOther adds the statisticsIopsRawOther to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetStatisticsIopsRawOther(statisticsIopsRawOther *int64) {
	o.StatisticsIopsRawOther = statisticsIopsRawOther
}

// WithStatisticsIopsRawRead adds the statisticsIopsRawRead to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithStatisticsIopsRawRead(statisticsIopsRawRead *int64) *FcInterfaceModifyCollectionParams {
	o.SetStatisticsIopsRawRead(statisticsIopsRawRead)
	return o
}

// SetStatisticsIopsRawRead adds the statisticsIopsRawRead to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetStatisticsIopsRawRead(statisticsIopsRawRead *int64) {
	o.StatisticsIopsRawRead = statisticsIopsRawRead
}

// WithStatisticsIopsRawTotal adds the statisticsIopsRawTotal to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithStatisticsIopsRawTotal(statisticsIopsRawTotal *int64) *FcInterfaceModifyCollectionParams {
	o.SetStatisticsIopsRawTotal(statisticsIopsRawTotal)
	return o
}

// SetStatisticsIopsRawTotal adds the statisticsIopsRawTotal to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetStatisticsIopsRawTotal(statisticsIopsRawTotal *int64) {
	o.StatisticsIopsRawTotal = statisticsIopsRawTotal
}

// WithStatisticsIopsRawWrite adds the statisticsIopsRawWrite to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithStatisticsIopsRawWrite(statisticsIopsRawWrite *int64) *FcInterfaceModifyCollectionParams {
	o.SetStatisticsIopsRawWrite(statisticsIopsRawWrite)
	return o
}

// SetStatisticsIopsRawWrite adds the statisticsIopsRawWrite to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetStatisticsIopsRawWrite(statisticsIopsRawWrite *int64) {
	o.StatisticsIopsRawWrite = statisticsIopsRawWrite
}

// WithStatisticsLatencyRawOther adds the statisticsLatencyRawOther to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithStatisticsLatencyRawOther(statisticsLatencyRawOther *int64) *FcInterfaceModifyCollectionParams {
	o.SetStatisticsLatencyRawOther(statisticsLatencyRawOther)
	return o
}

// SetStatisticsLatencyRawOther adds the statisticsLatencyRawOther to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetStatisticsLatencyRawOther(statisticsLatencyRawOther *int64) {
	o.StatisticsLatencyRawOther = statisticsLatencyRawOther
}

// WithStatisticsLatencyRawRead adds the statisticsLatencyRawRead to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithStatisticsLatencyRawRead(statisticsLatencyRawRead *int64) *FcInterfaceModifyCollectionParams {
	o.SetStatisticsLatencyRawRead(statisticsLatencyRawRead)
	return o
}

// SetStatisticsLatencyRawRead adds the statisticsLatencyRawRead to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetStatisticsLatencyRawRead(statisticsLatencyRawRead *int64) {
	o.StatisticsLatencyRawRead = statisticsLatencyRawRead
}

// WithStatisticsLatencyRawTotal adds the statisticsLatencyRawTotal to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithStatisticsLatencyRawTotal(statisticsLatencyRawTotal *int64) *FcInterfaceModifyCollectionParams {
	o.SetStatisticsLatencyRawTotal(statisticsLatencyRawTotal)
	return o
}

// SetStatisticsLatencyRawTotal adds the statisticsLatencyRawTotal to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetStatisticsLatencyRawTotal(statisticsLatencyRawTotal *int64) {
	o.StatisticsLatencyRawTotal = statisticsLatencyRawTotal
}

// WithStatisticsLatencyRawWrite adds the statisticsLatencyRawWrite to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithStatisticsLatencyRawWrite(statisticsLatencyRawWrite *int64) *FcInterfaceModifyCollectionParams {
	o.SetStatisticsLatencyRawWrite(statisticsLatencyRawWrite)
	return o
}

// SetStatisticsLatencyRawWrite adds the statisticsLatencyRawWrite to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetStatisticsLatencyRawWrite(statisticsLatencyRawWrite *int64) {
	o.StatisticsLatencyRawWrite = statisticsLatencyRawWrite
}

// WithStatisticsStatus adds the statisticsStatus to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithStatisticsStatus(statisticsStatus *string) *FcInterfaceModifyCollectionParams {
	o.SetStatisticsStatus(statisticsStatus)
	return o
}

// SetStatisticsStatus adds the statisticsStatus to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetStatisticsStatus(statisticsStatus *string) {
	o.StatisticsStatus = statisticsStatus
}

// WithStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) *FcInterfaceModifyCollectionParams {
	o.SetStatisticsThroughputRawRead(statisticsThroughputRawRead)
	return o
}

// SetStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) {
	o.StatisticsThroughputRawRead = statisticsThroughputRawRead
}

// WithStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) *FcInterfaceModifyCollectionParams {
	o.SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal)
	return o
}

// SetStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) {
	o.StatisticsThroughputRawTotal = statisticsThroughputRawTotal
}

// WithStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) *FcInterfaceModifyCollectionParams {
	o.SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite)
	return o
}

// SetStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) {
	o.StatisticsThroughputRawWrite = statisticsThroughputRawWrite
}

// WithStatisticsTimestamp adds the statisticsTimestamp to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithStatisticsTimestamp(statisticsTimestamp *string) *FcInterfaceModifyCollectionParams {
	o.SetStatisticsTimestamp(statisticsTimestamp)
	return o
}

// SetStatisticsTimestamp adds the statisticsTimestamp to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetStatisticsTimestamp(statisticsTimestamp *string) {
	o.StatisticsTimestamp = statisticsTimestamp
}

// WithSvmName adds the svmName to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithSvmName(svmName *string) *FcInterfaceModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithSvmUUID(svmUUID *string) *FcInterfaceModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithUUID(uuid *string) *FcInterfaceModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithWwnn adds the wwnn to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithWwnn(wwnn *string) *FcInterfaceModifyCollectionParams {
	o.SetWwnn(wwnn)
	return o
}

// SetWwnn adds the wwnn to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetWwnn(wwnn *string) {
	o.Wwnn = wwnn
}

// WithWwpn adds the wwpn to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) WithWwpn(wwpn *string) *FcInterfaceModifyCollectionParams {
	o.SetWwpn(wwpn)
	return o
}

// SetWwpn adds the wwpn to the fc interface modify collection params
func (o *FcInterfaceModifyCollectionParams) SetWwpn(wwpn *string) {
	o.Wwpn = wwpn
}

// WriteToRequest writes these params to a swagger request
func (o *FcInterfaceModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.DataProtocol != nil {

		// query param data_protocol
		var qrDataProtocol string

		if o.DataProtocol != nil {
			qrDataProtocol = *o.DataProtocol
		}
		qDataProtocol := qrDataProtocol
		if qDataProtocol != "" {

			if err := r.SetQueryParam("data_protocol", qDataProtocol); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.LocationHomeNodeName != nil {

		// query param location.home_node.name
		var qrLocationHomeNodeName string

		if o.LocationHomeNodeName != nil {
			qrLocationHomeNodeName = *o.LocationHomeNodeName
		}
		qLocationHomeNodeName := qrLocationHomeNodeName
		if qLocationHomeNodeName != "" {

			if err := r.SetQueryParam("location.home_node.name", qLocationHomeNodeName); err != nil {
				return err
			}
		}
	}

	if o.LocationHomeNodeUUID != nil {

		// query param location.home_node.uuid
		var qrLocationHomeNodeUUID string

		if o.LocationHomeNodeUUID != nil {
			qrLocationHomeNodeUUID = *o.LocationHomeNodeUUID
		}
		qLocationHomeNodeUUID := qrLocationHomeNodeUUID
		if qLocationHomeNodeUUID != "" {

			if err := r.SetQueryParam("location.home_node.uuid", qLocationHomeNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.LocationHomePortName != nil {

		// query param location.home_port.name
		var qrLocationHomePortName string

		if o.LocationHomePortName != nil {
			qrLocationHomePortName = *o.LocationHomePortName
		}
		qLocationHomePortName := qrLocationHomePortName
		if qLocationHomePortName != "" {

			if err := r.SetQueryParam("location.home_port.name", qLocationHomePortName); err != nil {
				return err
			}
		}
	}

	if o.LocationHomePortNodeName != nil {

		// query param location.home_port.node.name
		var qrLocationHomePortNodeName string

		if o.LocationHomePortNodeName != nil {
			qrLocationHomePortNodeName = *o.LocationHomePortNodeName
		}
		qLocationHomePortNodeName := qrLocationHomePortNodeName
		if qLocationHomePortNodeName != "" {

			if err := r.SetQueryParam("location.home_port.node.name", qLocationHomePortNodeName); err != nil {
				return err
			}
		}
	}

	if o.LocationHomePortUUID != nil {

		// query param location.home_port.uuid
		var qrLocationHomePortUUID string

		if o.LocationHomePortUUID != nil {
			qrLocationHomePortUUID = *o.LocationHomePortUUID
		}
		qLocationHomePortUUID := qrLocationHomePortUUID
		if qLocationHomePortUUID != "" {

			if err := r.SetQueryParam("location.home_port.uuid", qLocationHomePortUUID); err != nil {
				return err
			}
		}
	}

	if o.LocationIsHome != nil {

		// query param location.is_home
		var qrLocationIsHome bool

		if o.LocationIsHome != nil {
			qrLocationIsHome = *o.LocationIsHome
		}
		qLocationIsHome := swag.FormatBool(qrLocationIsHome)
		if qLocationIsHome != "" {

			if err := r.SetQueryParam("location.is_home", qLocationIsHome); err != nil {
				return err
			}
		}
	}

	if o.LocationNodeName != nil {

		// query param location.node.name
		var qrLocationNodeName string

		if o.LocationNodeName != nil {
			qrLocationNodeName = *o.LocationNodeName
		}
		qLocationNodeName := qrLocationNodeName
		if qLocationNodeName != "" {

			if err := r.SetQueryParam("location.node.name", qLocationNodeName); err != nil {
				return err
			}
		}
	}

	if o.LocationNodeUUID != nil {

		// query param location.node.uuid
		var qrLocationNodeUUID string

		if o.LocationNodeUUID != nil {
			qrLocationNodeUUID = *o.LocationNodeUUID
		}
		qLocationNodeUUID := qrLocationNodeUUID
		if qLocationNodeUUID != "" {

			if err := r.SetQueryParam("location.node.uuid", qLocationNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.LocationPortName != nil {

		// query param location.port.name
		var qrLocationPortName string

		if o.LocationPortName != nil {
			qrLocationPortName = *o.LocationPortName
		}
		qLocationPortName := qrLocationPortName
		if qLocationPortName != "" {

			if err := r.SetQueryParam("location.port.name", qLocationPortName); err != nil {
				return err
			}
		}
	}

	if o.LocationPortNodeName != nil {

		// query param location.port.node.name
		var qrLocationPortNodeName string

		if o.LocationPortNodeName != nil {
			qrLocationPortNodeName = *o.LocationPortNodeName
		}
		qLocationPortNodeName := qrLocationPortNodeName
		if qLocationPortNodeName != "" {

			if err := r.SetQueryParam("location.port.node.name", qLocationPortNodeName); err != nil {
				return err
			}
		}
	}

	if o.LocationPortUUID != nil {

		// query param location.port.uuid
		var qrLocationPortUUID string

		if o.LocationPortUUID != nil {
			qrLocationPortUUID = *o.LocationPortUUID
		}
		qLocationPortUUID := qrLocationPortUUID
		if qLocationPortUUID != "" {

			if err := r.SetQueryParam("location.port.uuid", qLocationPortUUID); err != nil {
				return err
			}
		}
	}

	if o.MetricDuration != nil {

		// query param metric.duration
		var qrMetricDuration string

		if o.MetricDuration != nil {
			qrMetricDuration = *o.MetricDuration
		}
		qMetricDuration := qrMetricDuration
		if qMetricDuration != "" {

			if err := r.SetQueryParam("metric.duration", qMetricDuration); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsOther != nil {

		// query param metric.iops.other
		var qrMetricIopsOther int64

		if o.MetricIopsOther != nil {
			qrMetricIopsOther = *o.MetricIopsOther
		}
		qMetricIopsOther := swag.FormatInt64(qrMetricIopsOther)
		if qMetricIopsOther != "" {

			if err := r.SetQueryParam("metric.iops.other", qMetricIopsOther); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsRead != nil {

		// query param metric.iops.read
		var qrMetricIopsRead int64

		if o.MetricIopsRead != nil {
			qrMetricIopsRead = *o.MetricIopsRead
		}
		qMetricIopsRead := swag.FormatInt64(qrMetricIopsRead)
		if qMetricIopsRead != "" {

			if err := r.SetQueryParam("metric.iops.read", qMetricIopsRead); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsTotal != nil {

		// query param metric.iops.total
		var qrMetricIopsTotal int64

		if o.MetricIopsTotal != nil {
			qrMetricIopsTotal = *o.MetricIopsTotal
		}
		qMetricIopsTotal := swag.FormatInt64(qrMetricIopsTotal)
		if qMetricIopsTotal != "" {

			if err := r.SetQueryParam("metric.iops.total", qMetricIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsWrite != nil {

		// query param metric.iops.write
		var qrMetricIopsWrite int64

		if o.MetricIopsWrite != nil {
			qrMetricIopsWrite = *o.MetricIopsWrite
		}
		qMetricIopsWrite := swag.FormatInt64(qrMetricIopsWrite)
		if qMetricIopsWrite != "" {

			if err := r.SetQueryParam("metric.iops.write", qMetricIopsWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyOther != nil {

		// query param metric.latency.other
		var qrMetricLatencyOther int64

		if o.MetricLatencyOther != nil {
			qrMetricLatencyOther = *o.MetricLatencyOther
		}
		qMetricLatencyOther := swag.FormatInt64(qrMetricLatencyOther)
		if qMetricLatencyOther != "" {

			if err := r.SetQueryParam("metric.latency.other", qMetricLatencyOther); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyRead != nil {

		// query param metric.latency.read
		var qrMetricLatencyRead int64

		if o.MetricLatencyRead != nil {
			qrMetricLatencyRead = *o.MetricLatencyRead
		}
		qMetricLatencyRead := swag.FormatInt64(qrMetricLatencyRead)
		if qMetricLatencyRead != "" {

			if err := r.SetQueryParam("metric.latency.read", qMetricLatencyRead); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyTotal != nil {

		// query param metric.latency.total
		var qrMetricLatencyTotal int64

		if o.MetricLatencyTotal != nil {
			qrMetricLatencyTotal = *o.MetricLatencyTotal
		}
		qMetricLatencyTotal := swag.FormatInt64(qrMetricLatencyTotal)
		if qMetricLatencyTotal != "" {

			if err := r.SetQueryParam("metric.latency.total", qMetricLatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyWrite != nil {

		// query param metric.latency.write
		var qrMetricLatencyWrite int64

		if o.MetricLatencyWrite != nil {
			qrMetricLatencyWrite = *o.MetricLatencyWrite
		}
		qMetricLatencyWrite := swag.FormatInt64(qrMetricLatencyWrite)
		if qMetricLatencyWrite != "" {

			if err := r.SetQueryParam("metric.latency.write", qMetricLatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricStatus != nil {

		// query param metric.status
		var qrMetricStatus string

		if o.MetricStatus != nil {
			qrMetricStatus = *o.MetricStatus
		}
		qMetricStatus := qrMetricStatus
		if qMetricStatus != "" {

			if err := r.SetQueryParam("metric.status", qMetricStatus); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputRead != nil {

		// query param metric.throughput.read
		var qrMetricThroughputRead int64

		if o.MetricThroughputRead != nil {
			qrMetricThroughputRead = *o.MetricThroughputRead
		}
		qMetricThroughputRead := swag.FormatInt64(qrMetricThroughputRead)
		if qMetricThroughputRead != "" {

			if err := r.SetQueryParam("metric.throughput.read", qMetricThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputTotal != nil {

		// query param metric.throughput.total
		var qrMetricThroughputTotal int64

		if o.MetricThroughputTotal != nil {
			qrMetricThroughputTotal = *o.MetricThroughputTotal
		}
		qMetricThroughputTotal := swag.FormatInt64(qrMetricThroughputTotal)
		if qMetricThroughputTotal != "" {

			if err := r.SetQueryParam("metric.throughput.total", qMetricThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputWrite != nil {

		// query param metric.throughput.write
		var qrMetricThroughputWrite int64

		if o.MetricThroughputWrite != nil {
			qrMetricThroughputWrite = *o.MetricThroughputWrite
		}
		qMetricThroughputWrite := swag.FormatInt64(qrMetricThroughputWrite)
		if qMetricThroughputWrite != "" {

			if err := r.SetQueryParam("metric.throughput.write", qMetricThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricTimestamp != nil {

		// query param metric.timestamp
		var qrMetricTimestamp string

		if o.MetricTimestamp != nil {
			qrMetricTimestamp = *o.MetricTimestamp
		}
		qMetricTimestamp := qrMetricTimestamp
		if qMetricTimestamp != "" {

			if err := r.SetQueryParam("metric.timestamp", qMetricTimestamp); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.PortAddress != nil {

		// query param port_address
		var qrPortAddress string

		if o.PortAddress != nil {
			qrPortAddress = *o.PortAddress
		}
		qPortAddress := qrPortAddress
		if qPortAddress != "" {

			if err := r.SetQueryParam("port_address", qPortAddress); err != nil {
				return err
			}
		}
	}

	if o.RecommendDataProtocol != nil {

		// query param recommend.data_protocol
		var qrRecommendDataProtocol string

		if o.RecommendDataProtocol != nil {
			qrRecommendDataProtocol = *o.RecommendDataProtocol
		}
		qRecommendDataProtocol := qrRecommendDataProtocol
		if qRecommendDataProtocol != "" {

			if err := r.SetQueryParam("recommend.data_protocol", qRecommendDataProtocol); err != nil {
				return err
			}
		}
	}

	if o.RecommendFabricsName != nil {

		// binding items for recommend.fabrics.name
		joinedRecommendFabricsName := o.bindParamRecommendFabricsName(reg)

		// query array param recommend.fabrics.name
		if err := r.SetQueryParam("recommend.fabrics.name", joinedRecommendFabricsName...); err != nil {
			return err
		}
	}

	if o.RecommendInterfacesPerNode != nil {

		// query param recommend.interfaces_per_node
		var qrRecommendInterfacesPerNode int64

		if o.RecommendInterfacesPerNode != nil {
			qrRecommendInterfacesPerNode = *o.RecommendInterfacesPerNode
		}
		qRecommendInterfacesPerNode := swag.FormatInt64(qrRecommendInterfacesPerNode)
		if qRecommendInterfacesPerNode != "" {

			if err := r.SetQueryParam("recommend.interfaces_per_node", qRecommendInterfacesPerNode); err != nil {
				return err
			}
		}
	}

	if o.RecommendNodesName != nil {

		// binding items for recommend.nodes.name
		joinedRecommendNodesName := o.bindParamRecommendNodesName(reg)

		// query array param recommend.nodes.name
		if err := r.SetQueryParam("recommend.nodes.name", joinedRecommendNodesName...); err != nil {
			return err
		}
	}

	if o.RecommendNodesUUID != nil {

		// binding items for recommend.nodes.uuid
		joinedRecommendNodesUUID := o.bindParamRecommendNodesUUID(reg)

		// query array param recommend.nodes.uuid
		if err := r.SetQueryParam("recommend.nodes.uuid", joinedRecommendNodesUUID...); err != nil {
			return err
		}
	}

	if o.RecommendProposedLocationsPortUUID != nil {

		// binding items for recommend.proposed.locations.port.uuid
		joinedRecommendProposedLocationsPortUUID := o.bindParamRecommendProposedLocationsPortUUID(reg)

		// query array param recommend.proposed.locations.port.uuid
		if err := r.SetQueryParam("recommend.proposed.locations.port.uuid", joinedRecommendProposedLocationsPortUUID...); err != nil {
			return err
		}
	}

	if o.RecommendSvmName != nil {

		// query param recommend.svm.name
		var qrRecommendSvmName string

		if o.RecommendSvmName != nil {
			qrRecommendSvmName = *o.RecommendSvmName
		}
		qRecommendSvmName := qrRecommendSvmName
		if qRecommendSvmName != "" {

			if err := r.SetQueryParam("recommend.svm.name", qRecommendSvmName); err != nil {
				return err
			}
		}
	}

	if o.RecommendSvmUUID != nil {

		// query param recommend.svm.uuid
		var qrRecommendSvmUUID string

		if o.RecommendSvmUUID != nil {
			qrRecommendSvmUUID = *o.RecommendSvmUUID
		}
		qRecommendSvmUUID := qrRecommendSvmUUID
		if qRecommendSvmUUID != "" {

			if err := r.SetQueryParam("recommend.svm.uuid", qRecommendSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawOther != nil {

		// query param statistics.iops_raw.other
		var qrStatisticsIopsRawOther int64

		if o.StatisticsIopsRawOther != nil {
			qrStatisticsIopsRawOther = *o.StatisticsIopsRawOther
		}
		qStatisticsIopsRawOther := swag.FormatInt64(qrStatisticsIopsRawOther)
		if qStatisticsIopsRawOther != "" {

			if err := r.SetQueryParam("statistics.iops_raw.other", qStatisticsIopsRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawRead != nil {

		// query param statistics.iops_raw.read
		var qrStatisticsIopsRawRead int64

		if o.StatisticsIopsRawRead != nil {
			qrStatisticsIopsRawRead = *o.StatisticsIopsRawRead
		}
		qStatisticsIopsRawRead := swag.FormatInt64(qrStatisticsIopsRawRead)
		if qStatisticsIopsRawRead != "" {

			if err := r.SetQueryParam("statistics.iops_raw.read", qStatisticsIopsRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawTotal != nil {

		// query param statistics.iops_raw.total
		var qrStatisticsIopsRawTotal int64

		if o.StatisticsIopsRawTotal != nil {
			qrStatisticsIopsRawTotal = *o.StatisticsIopsRawTotal
		}
		qStatisticsIopsRawTotal := swag.FormatInt64(qrStatisticsIopsRawTotal)
		if qStatisticsIopsRawTotal != "" {

			if err := r.SetQueryParam("statistics.iops_raw.total", qStatisticsIopsRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawWrite != nil {

		// query param statistics.iops_raw.write
		var qrStatisticsIopsRawWrite int64

		if o.StatisticsIopsRawWrite != nil {
			qrStatisticsIopsRawWrite = *o.StatisticsIopsRawWrite
		}
		qStatisticsIopsRawWrite := swag.FormatInt64(qrStatisticsIopsRawWrite)
		if qStatisticsIopsRawWrite != "" {

			if err := r.SetQueryParam("statistics.iops_raw.write", qStatisticsIopsRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawOther != nil {

		// query param statistics.latency_raw.other
		var qrStatisticsLatencyRawOther int64

		if o.StatisticsLatencyRawOther != nil {
			qrStatisticsLatencyRawOther = *o.StatisticsLatencyRawOther
		}
		qStatisticsLatencyRawOther := swag.FormatInt64(qrStatisticsLatencyRawOther)
		if qStatisticsLatencyRawOther != "" {

			if err := r.SetQueryParam("statistics.latency_raw.other", qStatisticsLatencyRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawRead != nil {

		// query param statistics.latency_raw.read
		var qrStatisticsLatencyRawRead int64

		if o.StatisticsLatencyRawRead != nil {
			qrStatisticsLatencyRawRead = *o.StatisticsLatencyRawRead
		}
		qStatisticsLatencyRawRead := swag.FormatInt64(qrStatisticsLatencyRawRead)
		if qStatisticsLatencyRawRead != "" {

			if err := r.SetQueryParam("statistics.latency_raw.read", qStatisticsLatencyRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawTotal != nil {

		// query param statistics.latency_raw.total
		var qrStatisticsLatencyRawTotal int64

		if o.StatisticsLatencyRawTotal != nil {
			qrStatisticsLatencyRawTotal = *o.StatisticsLatencyRawTotal
		}
		qStatisticsLatencyRawTotal := swag.FormatInt64(qrStatisticsLatencyRawTotal)
		if qStatisticsLatencyRawTotal != "" {

			if err := r.SetQueryParam("statistics.latency_raw.total", qStatisticsLatencyRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawWrite != nil {

		// query param statistics.latency_raw.write
		var qrStatisticsLatencyRawWrite int64

		if o.StatisticsLatencyRawWrite != nil {
			qrStatisticsLatencyRawWrite = *o.StatisticsLatencyRawWrite
		}
		qStatisticsLatencyRawWrite := swag.FormatInt64(qrStatisticsLatencyRawWrite)
		if qStatisticsLatencyRawWrite != "" {

			if err := r.SetQueryParam("statistics.latency_raw.write", qStatisticsLatencyRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsStatus != nil {

		// query param statistics.status
		var qrStatisticsStatus string

		if o.StatisticsStatus != nil {
			qrStatisticsStatus = *o.StatisticsStatus
		}
		qStatisticsStatus := qrStatisticsStatus
		if qStatisticsStatus != "" {

			if err := r.SetQueryParam("statistics.status", qStatisticsStatus); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawRead != nil {

		// query param statistics.throughput_raw.read
		var qrStatisticsThroughputRawRead int64

		if o.StatisticsThroughputRawRead != nil {
			qrStatisticsThroughputRawRead = *o.StatisticsThroughputRawRead
		}
		qStatisticsThroughputRawRead := swag.FormatInt64(qrStatisticsThroughputRawRead)
		if qStatisticsThroughputRawRead != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.read", qStatisticsThroughputRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawTotal != nil {

		// query param statistics.throughput_raw.total
		var qrStatisticsThroughputRawTotal int64

		if o.StatisticsThroughputRawTotal != nil {
			qrStatisticsThroughputRawTotal = *o.StatisticsThroughputRawTotal
		}
		qStatisticsThroughputRawTotal := swag.FormatInt64(qrStatisticsThroughputRawTotal)
		if qStatisticsThroughputRawTotal != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.total", qStatisticsThroughputRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawWrite != nil {

		// query param statistics.throughput_raw.write
		var qrStatisticsThroughputRawWrite int64

		if o.StatisticsThroughputRawWrite != nil {
			qrStatisticsThroughputRawWrite = *o.StatisticsThroughputRawWrite
		}
		qStatisticsThroughputRawWrite := swag.FormatInt64(qrStatisticsThroughputRawWrite)
		if qStatisticsThroughputRawWrite != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.write", qStatisticsThroughputRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsTimestamp != nil {

		// query param statistics.timestamp
		var qrStatisticsTimestamp string

		if o.StatisticsTimestamp != nil {
			qrStatisticsTimestamp = *o.StatisticsTimestamp
		}
		qStatisticsTimestamp := qrStatisticsTimestamp
		if qStatisticsTimestamp != "" {

			if err := r.SetQueryParam("statistics.timestamp", qStatisticsTimestamp); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.Wwnn != nil {

		// query param wwnn
		var qrWwnn string

		if o.Wwnn != nil {
			qrWwnn = *o.Wwnn
		}
		qWwnn := qrWwnn
		if qWwnn != "" {

			if err := r.SetQueryParam("wwnn", qWwnn); err != nil {
				return err
			}
		}
	}

	if o.Wwpn != nil {

		// query param wwpn
		var qrWwpn string

		if o.Wwpn != nil {
			qrWwpn = *o.Wwpn
		}
		qWwpn := qrWwpn
		if qWwpn != "" {

			if err := r.SetQueryParam("wwpn", qWwpn); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamFcInterfaceModifyCollection binds the parameter recommend.fabrics.name
func (o *FcInterfaceModifyCollectionParams) bindParamRecommendFabricsName(formats strfmt.Registry) []string {
	recommendFabricsNameIR := o.RecommendFabricsName

	var recommendFabricsNameIC []string
	for _, recommendFabricsNameIIR := range recommendFabricsNameIR { // explode []string

		recommendFabricsNameIIV := recommendFabricsNameIIR // string as string
		recommendFabricsNameIC = append(recommendFabricsNameIC, recommendFabricsNameIIV)
	}

	// items.CollectionFormat: ""
	recommendFabricsNameIS := swag.JoinByFormat(recommendFabricsNameIC, "")

	return recommendFabricsNameIS
}

// bindParamFcInterfaceModifyCollection binds the parameter recommend.nodes.name
func (o *FcInterfaceModifyCollectionParams) bindParamRecommendNodesName(formats strfmt.Registry) []string {
	recommendNodesNameIR := o.RecommendNodesName

	var recommendNodesNameIC []string
	for _, recommendNodesNameIIR := range recommendNodesNameIR { // explode []string

		recommendNodesNameIIV := recommendNodesNameIIR // string as string
		recommendNodesNameIC = append(recommendNodesNameIC, recommendNodesNameIIV)
	}

	// items.CollectionFormat: ""
	recommendNodesNameIS := swag.JoinByFormat(recommendNodesNameIC, "")

	return recommendNodesNameIS
}

// bindParamFcInterfaceModifyCollection binds the parameter recommend.nodes.uuid
func (o *FcInterfaceModifyCollectionParams) bindParamRecommendNodesUUID(formats strfmt.Registry) []string {
	recommendNodesUUIDIR := o.RecommendNodesUUID

	var recommendNodesUUIDIC []string
	for _, recommendNodesUUIDIIR := range recommendNodesUUIDIR { // explode []string

		recommendNodesUUIDIIV := recommendNodesUUIDIIR // string as string
		recommendNodesUUIDIC = append(recommendNodesUUIDIC, recommendNodesUUIDIIV)
	}

	// items.CollectionFormat: ""
	recommendNodesUUIDIS := swag.JoinByFormat(recommendNodesUUIDIC, "")

	return recommendNodesUUIDIS
}

// bindParamFcInterfaceModifyCollection binds the parameter recommend.proposed.locations.port.uuid
func (o *FcInterfaceModifyCollectionParams) bindParamRecommendProposedLocationsPortUUID(formats strfmt.Registry) []string {
	recommendProposedLocationsPortUUIDIR := o.RecommendProposedLocationsPortUUID

	var recommendProposedLocationsPortUUIDIC []string
	for _, recommendProposedLocationsPortUUIDIIR := range recommendProposedLocationsPortUUIDIR { // explode []string

		recommendProposedLocationsPortUUIDIIV := recommendProposedLocationsPortUUIDIIR // string as string
		recommendProposedLocationsPortUUIDIC = append(recommendProposedLocationsPortUUIDIC, recommendProposedLocationsPortUUIDIIV)
	}

	// items.CollectionFormat: ""
	recommendProposedLocationsPortUUIDIS := swag.JoinByFormat(recommendProposedLocationsPortUUIDIC, "")

	return recommendProposedLocationsPortUUIDIS
}
