// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FcInterfaceModifyCollectionReader is a Reader for the FcInterfaceModifyCollection structure.
type FcInterfaceModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FcInterfaceModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFcInterfaceModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFcInterfaceModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFcInterfaceModifyCollectionOK creates a FcInterfaceModifyCollectionOK with default headers values
func NewFcInterfaceModifyCollectionOK() *FcInterfaceModifyCollectionOK {
	return &FcInterfaceModifyCollectionOK{}
}

/*
FcInterfaceModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type FcInterfaceModifyCollectionOK struct {
}

// IsSuccess returns true when this fc interface modify collection o k response has a 2xx status code
func (o *FcInterfaceModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fc interface modify collection o k response has a 3xx status code
func (o *FcInterfaceModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fc interface modify collection o k response has a 4xx status code
func (o *FcInterfaceModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fc interface modify collection o k response has a 5xx status code
func (o *FcInterfaceModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fc interface modify collection o k response a status code equal to that given
func (o *FcInterfaceModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fc interface modify collection o k response
func (o *FcInterfaceModifyCollectionOK) Code() int {
	return 200
}

func (o *FcInterfaceModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /network/fc/interfaces][%d] fcInterfaceModifyCollectionOK", 200)
}

func (o *FcInterfaceModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /network/fc/interfaces][%d] fcInterfaceModifyCollectionOK", 200)
}

func (o *FcInterfaceModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewFcInterfaceModifyCollectionDefault creates a FcInterfaceModifyCollectionDefault with default headers values
func NewFcInterfaceModifyCollectionDefault(code int) *FcInterfaceModifyCollectionDefault {
	return &FcInterfaceModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	FcInterfaceModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1966140 | An interface with the same name already exists. |
| 1966217 | The specified port is not valid on the node provided. |
| 1966238 | The node or port of an active SAN data interface cannot be changed. |
| 1966702 | The destination node is not healthy. |
| 5373982 | An invalid WWN was specified. The length is incorrect. |
| 5373983 | An invalid WWN was specified. The format is incorrect. |
| 5374579 | The SAN Kernel Agent on the node is unavailable. |
| 5374870 | A partial failure occurred; renaming the interface failed. Correct the error and resubmit the request. |
| 5374871 | The Fibre Channel port identified by the specified UUID does not refer to the same port as that identified by the specified node name and/or port name. |
| 5374872 | If either `location.port.node.name` or `location.port.name` is supplied, both properties must be supplied. |
| 5375057 | An FC port with the provided UUID does not exist. |
| 72089674 | You cannot move a Fibre Channel interface configured for the NVMe over FC data protocol. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type FcInterfaceModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fc interface modify collection default response has a 2xx status code
func (o *FcInterfaceModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fc interface modify collection default response has a 3xx status code
func (o *FcInterfaceModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fc interface modify collection default response has a 4xx status code
func (o *FcInterfaceModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fc interface modify collection default response has a 5xx status code
func (o *FcInterfaceModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fc interface modify collection default response a status code equal to that given
func (o *FcInterfaceModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fc interface modify collection default response
func (o *FcInterfaceModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *FcInterfaceModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/fc/interfaces][%d] fc_interface_modify_collection default %s", o._statusCode, payload)
}

func (o *FcInterfaceModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/fc/interfaces][%d] fc_interface_modify_collection default %s", o._statusCode, payload)
}

func (o *FcInterfaceModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FcInterfaceModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
FcInterfaceModifyCollectionBody fc interface modify collection body
swagger:model FcInterfaceModifyCollectionBody
*/
type FcInterfaceModifyCollectionBody struct {

	// links
	Links *models.FcInterfaceInlineLinks `json:"_links,omitempty"`

	// A user configurable comment. Optional in POST; valid in PATCH. To clear a prior comment, set the property to an empty string in PATCH.
	//
	Comment *string `json:"comment,omitempty"`

	// The data protocol for which the FC interface is configured. Required in POST.
	//
	// Enum: ["fcp","fc_nvme"]
	DataProtocol *string `json:"data_protocol,omitempty"`

	// The administrative state of the FC interface. The FC interface can be disabled to block all FC communication with the SVM through this interface. Optional in POST and PATCH; defaults to _true_ (enabled) in POST.
	//
	Enabled *bool `json:"enabled,omitempty"`

	// fc interface response inline records
	FcInterfaceResponseInlineRecords []*models.FcInterface `json:"records,omitempty"`

	// location
	Location *models.FcInterfaceInlineLocation `json:"location,omitempty"`

	// metric
	Metric *models.FcInterfaceInlineMetric `json:"metric,omitempty"`

	// The name of the FC interface. Required in POST; optional in PATCH.
	//
	// Example: fc_lif1
	Name *string `json:"name,omitempty"`

	// The port address of the FC interface. Each FC port in an FC switched fabric has its own unique FC port address for routing purposes. The FC port address is assigned by a switch in the fabric when that port logs in to the fabric. This property refers to the address given by a switch to the FC interface when the SVM performs a port login (PLOGI).<br/>
	// This is useful for obtaining statistics and diagnostic information from FC switches.<br/>
	// This is a hexadecimal encoded numeric value.
	//
	// Example: 5060F
	// Read Only: true
	PortAddress *string `json:"port_address,omitempty"`

	// recommend
	Recommend *models.FcInterfaceResponseInlineRecommend `json:"recommend,omitempty"`

	// The current operational state of the FC interface. The state is set to _down_ if the interface is not enabled.<br/>
	// If the cluster node hosting the port is down or unavailable, no state value is returned.
	//
	// Read Only: true
	// Enum: ["up","down"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *models.FcInterfaceInlineStatistics `json:"statistics,omitempty"`

	// svm
	Svm *models.FcInterfaceInlineSvm `json:"svm,omitempty"`

	// The unique identifier of the FC interface. Required in the URL.
	//
	// Example: bce9827d-4d8f-60af-c771-6e8e9af2c6f0
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// The world wide node name (WWNN) of the FC interface SVM. The WWNN is generated by ONTAP when Fibre Channel Protocol or the NVMe service is created for the FC interface SVM.
	//
	// Example: 20:00:00:50:56:b4:13:01
	// Read Only: true
	Wwnn *string `json:"wwnn,omitempty"`

	// The world wide port name (WWPN) of the FC interface. The WWPN is generated by ONTAP when the FC interface is created.
	//
	// Example: 20:00:00:50:56:b4:13:a8
	// Read Only: true
	Wwpn *string `json:"wwpn,omitempty"`
}

// Validate validates this fc interface modify collection body
func (o *FcInterfaceModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDataProtocol(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFcInterfaceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRecommend(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var fcInterfaceModifyCollectionBodyTypeDataProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","fc_nvme"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcInterfaceModifyCollectionBodyTypeDataProtocolPropEnum = append(fcInterfaceModifyCollectionBodyTypeDataProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// FcInterfaceModifyCollectionBody
	// FcInterfaceModifyCollectionBody
	// data_protocol
	// DataProtocol
	// fcp
	// END DEBUGGING
	// FcInterfaceModifyCollectionBodyDataProtocolFcp captures enum value "fcp"
	FcInterfaceModifyCollectionBodyDataProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// FcInterfaceModifyCollectionBody
	// FcInterfaceModifyCollectionBody
	// data_protocol
	// DataProtocol
	// fc_nvme
	// END DEBUGGING
	// FcInterfaceModifyCollectionBodyDataProtocolFcNvme captures enum value "fc_nvme"
	FcInterfaceModifyCollectionBodyDataProtocolFcNvme string = "fc_nvme"
)

// prop value enum
func (o *FcInterfaceModifyCollectionBody) validateDataProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcInterfaceModifyCollectionBodyTypeDataProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FcInterfaceModifyCollectionBody) validateDataProtocol(formats strfmt.Registry) error {
	if swag.IsZero(o.DataProtocol) { // not required
		return nil
	}

	// value enum
	if err := o.validateDataProtocolEnum("info"+"."+"data_protocol", "body", *o.DataProtocol); err != nil {
		return err
	}

	return nil
}

func (o *FcInterfaceModifyCollectionBody) validateFcInterfaceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.FcInterfaceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.FcInterfaceResponseInlineRecords); i++ {
		if swag.IsZero(o.FcInterfaceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.FcInterfaceResponseInlineRecords[i] != nil {
			if err := o.FcInterfaceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FcInterfaceModifyCollectionBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceModifyCollectionBody) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(o.Metric) { // not required
		return nil
	}

	if o.Metric != nil {
		if err := o.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceModifyCollectionBody) validateRecommend(formats strfmt.Registry) error {
	if swag.IsZero(o.Recommend) { // not required
		return nil
	}

	if o.Recommend != nil {
		if err := o.Recommend.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "recommend")
			}
			return err
		}
	}

	return nil
}

var fcInterfaceModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcInterfaceModifyCollectionBodyTypeStatePropEnum = append(fcInterfaceModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// FcInterfaceModifyCollectionBody
	// FcInterfaceModifyCollectionBody
	// state
	// State
	// up
	// END DEBUGGING
	// FcInterfaceModifyCollectionBodyStateUp captures enum value "up"
	FcInterfaceModifyCollectionBodyStateUp string = "up"

	// BEGIN DEBUGGING
	// FcInterfaceModifyCollectionBody
	// FcInterfaceModifyCollectionBody
	// state
	// State
	// down
	// END DEBUGGING
	// FcInterfaceModifyCollectionBodyStateDown captures enum value "down"
	FcInterfaceModifyCollectionBodyStateDown string = "down"
)

// prop value enum
func (o *FcInterfaceModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcInterfaceModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FcInterfaceModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *FcInterfaceModifyCollectionBody) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(o.Statistics) { // not required
		return nil
	}

	if o.Statistics != nil {
		if err := o.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface modify collection body based on the context it is used
func (o *FcInterfaceModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFcInterfaceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePortAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRecommend(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWwnn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWwpn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceModifyCollectionBody) contextValidateFcInterfaceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.FcInterfaceResponseInlineRecords); i++ {

		if o.FcInterfaceResponseInlineRecords[i] != nil {
			if err := o.FcInterfaceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FcInterfaceModifyCollectionBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {
		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceModifyCollectionBody) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if o.Metric != nil {
		if err := o.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceModifyCollectionBody) contextValidatePortAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"port_address", "body", o.PortAddress); err != nil {
		return err
	}

	return nil
}

func (o *FcInterfaceModifyCollectionBody) contextValidateRecommend(ctx context.Context, formats strfmt.Registry) error {

	if o.Recommend != nil {
		if err := o.Recommend.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "recommend")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *FcInterfaceModifyCollectionBody) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if o.Statistics != nil {
		if err := o.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *FcInterfaceModifyCollectionBody) contextValidateWwnn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"wwnn", "body", o.Wwnn); err != nil {
		return err
	}

	return nil
}

func (o *FcInterfaceModifyCollectionBody) contextValidateWwpn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"wwpn", "body", o.Wwpn); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res FcInterfaceModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineLinks fc interface inline links
swagger:model fc_interface_inline__links
*/
type FcInterfaceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this fc interface inline links
func (o *FcInterfaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline links based on the context it is used
func (o *FcInterfaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineLocation The location of the FC interface is defined by the location of its port. An FC port is identified by its UUID, or a combination of its cluster node name and port name. Either the UUID or the cluster node name and port name are required for POST. To move an interface, supply either the port UUID or the cluster node name and port name in a PATCH.<br/>
// `location.node` and `location.port` refer to the current location of the FC interface. This can be different from `location.home_node` and `location.home_port` in instances where the FC interface has failed over to its HA partner node. The `location.node`, `location.port`, and `location.is_home` properties are not available for interfaces on the inactive side of a MetroCluster relationship.
//
swagger:model fc_interface_inline_location
*/
type FcInterfaceInlineLocation struct {

	// home node
	HomeNode *models.FcInterfaceInlineLocationInlineHomeNode `json:"home_node,omitempty"`

	// home port
	HomePort *models.FcInterfaceInlineLocationInlineHomePort `json:"home_port,omitempty"`

	// Indicates if the FC interface is currently on its home node.
	// Read Only: true
	IsHome *bool `json:"is_home,omitempty"`

	// node
	Node *models.FcInterfaceInlineLocationInlineNode `json:"node,omitempty"`

	// port
	Port *models.FcInterfaceInlineLocationInlinePort `json:"port,omitempty"`
}

// Validate validates this fc interface inline location
func (o *FcInterfaceInlineLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateHomeNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateHomePort(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineLocation) validateHomeNode(formats strfmt.Registry) error {
	if swag.IsZero(o.HomeNode) { // not required
		return nil
	}

	if o.HomeNode != nil {
		if err := o.HomeNode.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_node")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineLocation) validateHomePort(formats strfmt.Registry) error {
	if swag.IsZero(o.HomePort) { // not required
		return nil
	}

	if o.HomePort != nil {
		if err := o.HomePort.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_port")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineLocation) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineLocation) validatePort(formats strfmt.Registry) error {
	if swag.IsZero(o.Port) { // not required
		return nil
	}

	if o.Port != nil {
		if err := o.Port.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "port")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline location based on the context it is used
func (o *FcInterfaceInlineLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateHomeNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHomePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsHome(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineLocation) contextValidateHomeNode(ctx context.Context, formats strfmt.Registry) error {

	if o.HomeNode != nil {
		if err := o.HomeNode.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_node")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineLocation) contextValidateHomePort(ctx context.Context, formats strfmt.Registry) error {

	if o.HomePort != nil {
		if err := o.HomePort.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_port")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineLocation) contextValidateIsHome(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"location"+"."+"is_home", "body", o.IsHome); err != nil {
		return err
	}

	return nil
}

func (o *FcInterfaceInlineLocation) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineLocation) contextValidatePort(ctx context.Context, formats strfmt.Registry) error {

	if o.Port != nil {
		if err := o.Port.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "port")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineLocation) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineLocationInlineHomeNode fc interface inline location inline home node
swagger:model fc_interface_inline_location_inline_home_node
*/
type FcInterfaceInlineLocationInlineHomeNode struct {

	// links
	Links *models.FcInterfaceInlineLocationInlineHomeNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fc interface inline location inline home node
func (o *FcInterfaceInlineLocationInlineHomeNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineLocationInlineHomeNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline location inline home node based on the context it is used
func (o *FcInterfaceInlineLocationInlineHomeNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineLocationInlineHomeNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineLocationInlineHomeNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineLocationInlineHomeNode) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocationInlineHomeNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineLocationInlineHomeNodeInlineLinks fc interface inline location inline home node inline links
swagger:model fc_interface_inline_location_inline_home_node_inline__links
*/
type FcInterfaceInlineLocationInlineHomeNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this fc interface inline location inline home node inline links
func (o *FcInterfaceInlineLocationInlineHomeNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineLocationInlineHomeNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline location inline home node inline links based on the context it is used
func (o *FcInterfaceInlineLocationInlineHomeNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineLocationInlineHomeNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineLocationInlineHomeNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineLocationInlineHomeNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocationInlineHomeNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineLocationInlineHomePort An FC port is the physical port of an FC adapter on a cluster node that can be connected to an FC network.
//
swagger:model fc_interface_inline_location_inline_home_port
*/
type FcInterfaceInlineLocationInlineHomePort struct {

	// links
	Links *models.FcInterfaceInlineLocationInlineHomePortInlineLinks `json:"_links,omitempty"`

	// The name of the FC port.
	//
	// Example: 0a
	Name *string `json:"name,omitempty"`

	// node
	Node *models.FcInterfaceInlineLocationInlineHomePortInlineNode `json:"node,omitempty"`

	// The unique identifier of the FC port.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fc interface inline location inline home port
func (o *FcInterfaceInlineLocationInlineHomePort) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineLocationInlineHomePort) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineLocationInlineHomePort) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline location inline home port based on the context it is used
func (o *FcInterfaceInlineLocationInlineHomePort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineLocationInlineHomePort) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineLocationInlineHomePort) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineLocationInlineHomePort) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineLocationInlineHomePort) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocationInlineHomePort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineLocationInlineHomePortInlineLinks fc interface inline location inline home port inline links
swagger:model fc_interface_inline_location_inline_home_port_inline__links
*/
type FcInterfaceInlineLocationInlineHomePortInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this fc interface inline location inline home port inline links
func (o *FcInterfaceInlineLocationInlineHomePortInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineLocationInlineHomePortInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline location inline home port inline links based on the context it is used
func (o *FcInterfaceInlineLocationInlineHomePortInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineLocationInlineHomePortInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineLocationInlineHomePortInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineLocationInlineHomePortInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocationInlineHomePortInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineLocationInlineHomePortInlineNode The node on which the FC port is located.
//
swagger:model fc_interface_inline_location_inline_home_port_inline_node
*/
type FcInterfaceInlineLocationInlineHomePortInlineNode struct {

	// The name of the node on which the FC port is located.
	//
	// Example: node1
	Name *string `json:"name,omitempty"`
}

// Validate validates this fc interface inline location inline home port inline node
func (o *FcInterfaceInlineLocationInlineHomePortInlineNode) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this fc interface inline location inline home port inline node based on context it is used
func (o *FcInterfaceInlineLocationInlineHomePortInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineLocationInlineHomePortInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineLocationInlineHomePortInlineNode) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocationInlineHomePortInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineLocationInlineNode fc interface inline location inline node
swagger:model fc_interface_inline_location_inline_node
*/
type FcInterfaceInlineLocationInlineNode struct {

	// links
	Links *models.FcInterfaceInlineLocationInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fc interface inline location inline node
func (o *FcInterfaceInlineLocationInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineLocationInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline location inline node based on the context it is used
func (o *FcInterfaceInlineLocationInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineLocationInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineLocationInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineLocationInlineNode) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocationInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineLocationInlineNodeInlineLinks fc interface inline location inline node inline links
swagger:model fc_interface_inline_location_inline_node_inline__links
*/
type FcInterfaceInlineLocationInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this fc interface inline location inline node inline links
func (o *FcInterfaceInlineLocationInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineLocationInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline location inline node inline links based on the context it is used
func (o *FcInterfaceInlineLocationInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineLocationInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineLocationInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineLocationInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocationInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineLocationInlinePort An FC port is the physical port of an FC adapter on a cluster node that can be connected to an FC network.
//
swagger:model fc_interface_inline_location_inline_port
*/
type FcInterfaceInlineLocationInlinePort struct {

	// links
	Links *models.FcInterfaceInlineLocationInlinePortInlineLinks `json:"_links,omitempty"`

	// The name of the FC port.
	//
	// Example: 0a
	Name *string `json:"name,omitempty"`

	// node
	Node *models.FcInterfaceInlineLocationInlinePortInlineNode `json:"node,omitempty"`

	// The unique identifier of the FC port.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fc interface inline location inline port
func (o *FcInterfaceInlineLocationInlinePort) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineLocationInlinePort) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineLocationInlinePort) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline location inline port based on the context it is used
func (o *FcInterfaceInlineLocationInlinePort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineLocationInlinePort) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineLocationInlinePort) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineLocationInlinePort) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineLocationInlinePort) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocationInlinePort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineLocationInlinePortInlineLinks fc interface inline location inline port inline links
swagger:model fc_interface_inline_location_inline_port_inline__links
*/
type FcInterfaceInlineLocationInlinePortInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this fc interface inline location inline port inline links
func (o *FcInterfaceInlineLocationInlinePortInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineLocationInlinePortInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline location inline port inline links based on the context it is used
func (o *FcInterfaceInlineLocationInlinePortInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineLocationInlinePortInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineLocationInlinePortInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineLocationInlinePortInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocationInlinePortInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineLocationInlinePortInlineNode The node on which the FC port is located.
//
swagger:model fc_interface_inline_location_inline_port_inline_node
*/
type FcInterfaceInlineLocationInlinePortInlineNode struct {

	// The name of the node on which the FC port is located.
	//
	// Example: node1
	Name *string `json:"name,omitempty"`
}

// Validate validates this fc interface inline location inline port inline node
func (o *FcInterfaceInlineLocationInlinePortInlineNode) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this fc interface inline location inline port inline node based on context it is used
func (o *FcInterfaceInlineLocationInlinePortInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineLocationInlinePortInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineLocationInlinePortInlineNode) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocationInlinePortInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineMetric Performance numbers, such as IOPS latency and throughput
swagger:model fc_interface_inline_metric
*/
type FcInterfaceInlineMetric struct {

	// links
	Links *models.FcInterfaceInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *models.FcInterfaceInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *models.FcInterfaceInlineMetricInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *models.FcInterfaceInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this fc interface inline metric
func (o *FcInterfaceInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var fcInterfaceInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcInterfaceInlineMetricTypeDurationPropEnum = append(fcInterfaceInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// FcInterfaceInlineMetricDurationPT15S captures enum value "PT15S"
	FcInterfaceInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// FcInterfaceInlineMetricDurationPT4M captures enum value "PT4M"
	FcInterfaceInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// FcInterfaceInlineMetricDurationPT30M captures enum value "PT30M"
	FcInterfaceInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// FcInterfaceInlineMetricDurationPT2H captures enum value "PT2H"
	FcInterfaceInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// FcInterfaceInlineMetricDurationP1D captures enum value "P1D"
	FcInterfaceInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// FcInterfaceInlineMetricDurationPT5M captures enum value "PT5M"
	FcInterfaceInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (o *FcInterfaceInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcInterfaceInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FcInterfaceInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(o.Duration) { // not required
		return nil
	}

	// value enum
	if err := o.validateDurationEnum("info"+"."+"metric"+"."+"duration", "body", *o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *FcInterfaceInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(o.Iops) { // not required
		return nil
	}

	if o.Iops != nil {
		if err := o.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(o.Latency) { // not required
		return nil
	}

	if o.Latency != nil {
		if err := o.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var fcInterfaceInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcInterfaceInlineMetricTypeStatusPropEnum = append(fcInterfaceInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusOk captures enum value "ok"
	FcInterfaceInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusError captures enum value "error"
	FcInterfaceInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	FcInterfaceInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	FcInterfaceInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	FcInterfaceInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	FcInterfaceInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusNotFound captures enum value "not_found"
	FcInterfaceInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	FcInterfaceInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	FcInterfaceInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	FcInterfaceInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	FcInterfaceInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *FcInterfaceInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcInterfaceInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FcInterfaceInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"metric"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *FcInterfaceInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(o.Throughput) { // not required
		return nil
	}

	if o.Throughput != nil {
		if err := o.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"metric"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fc interface inline metric based on the context it is used
func (o *FcInterfaceInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"duration", "body", o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *FcInterfaceInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if o.Iops != nil {
		if err := o.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if o.Latency != nil {
		if err := o.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *FcInterfaceInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if o.Throughput != nil {
		if err := o.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineMetric) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineMetric) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineMetricInlineLinks fc interface inline metric inline links
swagger:model fc_interface_inline_metric_inline__links
*/
type FcInterfaceInlineMetricInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this fc interface inline metric inline links
func (o *FcInterfaceInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline metric inline links based on the context it is used
func (o *FcInterfaceInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineMetricInlineIops The rate of I/O operations observed at the storage object.
swagger:model fc_interface_inline_metric_inline_iops
*/
type FcInterfaceInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc interface inline metric inline iops
func (o *FcInterfaceInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc interface inline metric inline iops based on the context it is used
func (o *FcInterfaceInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
swagger:model fc_interface_inline_metric_inline_latency
*/
type FcInterfaceInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc interface inline metric inline latency
func (o *FcInterfaceInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc interface inline metric inline latency based on the context it is used
func (o *FcInterfaceInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
swagger:model fc_interface_inline_metric_inline_throughput
*/
type FcInterfaceInlineMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc interface inline metric inline throughput
func (o *FcInterfaceInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc interface inline metric inline throughput based on the context it is used
func (o *FcInterfaceInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineStatistics These are raw performance numbers, such as IOPS latency and throughput. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
swagger:model fc_interface_inline_statistics
*/
type FcInterfaceInlineStatistics struct {

	// iops raw
	IopsRaw *models.FcInterfaceInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *models.FcInterfaceInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *models.FcInterfaceInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this fc interface inline statistics
func (o *FcInterfaceInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.IopsRaw) { // not required
		return nil
	}

	if o.IopsRaw != nil {
		if err := o.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.LatencyRaw) { // not required
		return nil
	}

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var fcInterfaceInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcInterfaceInlineStatisticsTypeStatusPropEnum = append(fcInterfaceInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusOk captures enum value "ok"
	FcInterfaceInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusError captures enum value "error"
	FcInterfaceInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	FcInterfaceInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	FcInterfaceInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	FcInterfaceInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	FcInterfaceInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusNotFound captures enum value "not_found"
	FcInterfaceInlineStatisticsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	FcInterfaceInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	FcInterfaceInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	FcInterfaceInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	FcInterfaceInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *FcInterfaceInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcInterfaceInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FcInterfaceInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"statistics"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *FcInterfaceInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.ThroughputRaw) { // not required
		return nil
	}

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"statistics"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fc interface inline statistics based on the context it is used
func (o *FcInterfaceInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.IopsRaw != nil {
		if err := o.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *FcInterfaceInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *FcInterfaceInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineStatistics) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineStatistics) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
swagger:model fc_interface_inline_statistics_inline_iops_raw
*/
type FcInterfaceInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc interface inline statistics inline iops raw
func (o *FcInterfaceInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc interface inline statistics inline iops raw based on the context it is used
func (o *FcInterfaceInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
swagger:model fc_interface_inline_statistics_inline_latency_raw
*/
type FcInterfaceInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc interface inline statistics inline latency raw
func (o *FcInterfaceInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc interface inline statistics inline latency raw based on the context it is used
func (o *FcInterfaceInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
swagger:model fc_interface_inline_statistics_inline_throughput_raw
*/
type FcInterfaceInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc interface inline statistics inline throughput raw
func (o *FcInterfaceInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc interface inline statistics inline throughput raw based on the context it is used
func (o *FcInterfaceInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model fc_interface_inline_svm
*/
type FcInterfaceInlineSvm struct {

	// links
	Links *FcInterfaceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fc interface inline svm
func (o *FcInterfaceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline svm based on the context it is used
func (o *FcInterfaceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineSvm) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcInterfaceInlineSvmInlineLinks fc interface inline svm inline links
swagger:model fc_interface_inline_svm_inline__links
*/
type FcInterfaceInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this fc interface inline svm inline links
func (o *FcInterfaceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline svm inline links based on the context it is used
func (o *FcInterfaceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcInterfaceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcInterfaceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcInterfaceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
