// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FcPortGetReader is a Reader for the FcPortGet structure.
type FcPortGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FcPortGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFcPortGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFcPortGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFcPortGetOK creates a FcPortGetOK with default headers values
func NewFcPortGetOK() *FcPortGetOK {
	return &FcPortGetOK{}
}

/*
FcPortGetOK describes a response with status code 200, with default header values.

OK
*/
type FcPortGetOK struct {
	Payload *models.FcPort
}

// IsSuccess returns true when this fc port get o k response has a 2xx status code
func (o *FcPortGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fc port get o k response has a 3xx status code
func (o *FcPortGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fc port get o k response has a 4xx status code
func (o *FcPortGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fc port get o k response has a 5xx status code
func (o *FcPortGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fc port get o k response a status code equal to that given
func (o *FcPortGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fc port get o k response
func (o *FcPortGetOK) Code() int {
	return 200
}

func (o *FcPortGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/ports/{uuid}][%d] fcPortGetOK %s", 200, payload)
}

func (o *FcPortGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/ports/{uuid}][%d] fcPortGetOK %s", 200, payload)
}

func (o *FcPortGetOK) GetPayload() *models.FcPort {
	return o.Payload
}

func (o *FcPortGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.FcPort)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFcPortGetDefault creates a FcPortGetDefault with default headers values
func NewFcPortGetDefault(code int) *FcPortGetDefault {
	return &FcPortGetDefault{
		_statusCode: code,
	}
}

/*
FcPortGetDefault describes a response with status code -1, with default header values.

Error
*/
type FcPortGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fc port get default response has a 2xx status code
func (o *FcPortGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fc port get default response has a 3xx status code
func (o *FcPortGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fc port get default response has a 4xx status code
func (o *FcPortGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fc port get default response has a 5xx status code
func (o *FcPortGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fc port get default response a status code equal to that given
func (o *FcPortGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fc port get default response
func (o *FcPortGetDefault) Code() int {
	return o._statusCode
}

func (o *FcPortGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/ports/{uuid}][%d] fc_port_get default %s", o._statusCode, payload)
}

func (o *FcPortGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/ports/{uuid}][%d] fc_port_get default %s", o._statusCode, payload)
}

func (o *FcPortGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FcPortGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
