// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFcPortModifyCollectionParams creates a new FcPortModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFcPortModifyCollectionParams() *FcPortModifyCollectionParams {
	return &FcPortModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFcPortModifyCollectionParamsWithTimeout creates a new FcPortModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewFcPortModifyCollectionParamsWithTimeout(timeout time.Duration) *FcPortModifyCollectionParams {
	return &FcPortModifyCollectionParams{
		timeout: timeout,
	}
}

// NewFcPortModifyCollectionParamsWithContext creates a new FcPortModifyCollectionParams object
// with the ability to set a context for a request.
func NewFcPortModifyCollectionParamsWithContext(ctx context.Context) *FcPortModifyCollectionParams {
	return &FcPortModifyCollectionParams{
		Context: ctx,
	}
}

// NewFcPortModifyCollectionParamsWithHTTPClient creates a new FcPortModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewFcPortModifyCollectionParamsWithHTTPClient(client *http.Client) *FcPortModifyCollectionParams {
	return &FcPortModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
FcPortModifyCollectionParams contains all the parameters to send to the API endpoint

	for the fc port modify collection operation.

	Typically these are written to a http.Request.
*/
type FcPortModifyCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Description.

	   Filter by description
	*/
	Description *string

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* FabricConnected.

	   Filter by fabric.connected
	*/
	FabricConnected *bool

	/* FabricConnectedSpeed.

	   Filter by fabric.connected_speed
	*/
	FabricConnectedSpeed *int64

	/* FabricName.

	   Filter by fabric.name
	*/
	FabricName *string

	/* FabricPortAddress.

	   Filter by fabric.port_address
	*/
	FabricPortAddress *string

	/* FabricSwitchPort.

	   Filter by fabric.switch_port
	*/
	FabricSwitchPort *string

	/* Info.

	   Info specification
	*/
	Info FcPortModifyCollectionBody

	/* InterfaceCount.

	   Filter by interface_count
	*/
	InterfaceCount *int64

	/* MetricDuration.

	   Filter by metric.duration
	*/
	MetricDuration *string

	/* MetricIopsOther.

	   Filter by metric.iops.other
	*/
	MetricIopsOther *int64

	/* MetricIopsRead.

	   Filter by metric.iops.read
	*/
	MetricIopsRead *int64

	/* MetricIopsTotal.

	   Filter by metric.iops.total
	*/
	MetricIopsTotal *int64

	/* MetricIopsWrite.

	   Filter by metric.iops.write
	*/
	MetricIopsWrite *int64

	/* MetricLatencyOther.

	   Filter by metric.latency.other
	*/
	MetricLatencyOther *int64

	/* MetricLatencyRead.

	   Filter by metric.latency.read
	*/
	MetricLatencyRead *int64

	/* MetricLatencyTotal.

	   Filter by metric.latency.total
	*/
	MetricLatencyTotal *int64

	/* MetricLatencyWrite.

	   Filter by metric.latency.write
	*/
	MetricLatencyWrite *int64

	/* MetricStatus.

	   Filter by metric.status
	*/
	MetricStatus *string

	/* MetricThroughputRead.

	   Filter by metric.throughput.read
	*/
	MetricThroughputRead *int64

	/* MetricThroughputTotal.

	   Filter by metric.throughput.total
	*/
	MetricThroughputTotal *int64

	/* MetricThroughputWrite.

	   Filter by metric.throughput.write
	*/
	MetricThroughputWrite *int64

	/* MetricTimestamp.

	   Filter by metric.timestamp
	*/
	MetricTimestamp *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* PhysicalProtocol.

	   Filter by physical_protocol
	*/
	PhysicalProtocol *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SpeedConfigured.

	   Filter by speed.configured
	*/
	SpeedConfigured *string

	/* SpeedMaximum.

	   Filter by speed.maximum
	*/
	SpeedMaximum *string

	/* State.

	   Filter by state
	*/
	State *string

	/* StatisticsIopsRawOther.

	   Filter by statistics.iops_raw.other
	*/
	StatisticsIopsRawOther *int64

	/* StatisticsIopsRawRead.

	   Filter by statistics.iops_raw.read
	*/
	StatisticsIopsRawRead *int64

	/* StatisticsIopsRawTotal.

	   Filter by statistics.iops_raw.total
	*/
	StatisticsIopsRawTotal *int64

	/* StatisticsIopsRawWrite.

	   Filter by statistics.iops_raw.write
	*/
	StatisticsIopsRawWrite *int64

	/* StatisticsLatencyRawOther.

	   Filter by statistics.latency_raw.other
	*/
	StatisticsLatencyRawOther *int64

	/* StatisticsLatencyRawRead.

	   Filter by statistics.latency_raw.read
	*/
	StatisticsLatencyRawRead *int64

	/* StatisticsLatencyRawTotal.

	   Filter by statistics.latency_raw.total
	*/
	StatisticsLatencyRawTotal *int64

	/* StatisticsLatencyRawWrite.

	   Filter by statistics.latency_raw.write
	*/
	StatisticsLatencyRawWrite *int64

	/* StatisticsStatus.

	   Filter by statistics.status
	*/
	StatisticsStatus *string

	/* StatisticsThroughputRawRead.

	   Filter by statistics.throughput_raw.read
	*/
	StatisticsThroughputRawRead *int64

	/* StatisticsThroughputRawTotal.

	   Filter by statistics.throughput_raw.total
	*/
	StatisticsThroughputRawTotal *int64

	/* StatisticsThroughputRawWrite.

	   Filter by statistics.throughput_raw.write
	*/
	StatisticsThroughputRawWrite *int64

	/* StatisticsTimestamp.

	   Filter by statistics.timestamp
	*/
	StatisticsTimestamp *string

	/* SupportedProtocols.

	   Filter by supported_protocols
	*/
	SupportedProtocols *string

	/* TransceiverCapabilities.

	   Filter by transceiver.capabilities
	*/
	TransceiverCapabilities *int64

	/* TransceiverFormFactor.

	   Filter by transceiver.form_factor
	*/
	TransceiverFormFactor *string

	/* TransceiverManufacturer.

	   Filter by transceiver.manufacturer
	*/
	TransceiverManufacturer *string

	/* TransceiverPartNumber.

	   Filter by transceiver.part_number
	*/
	TransceiverPartNumber *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* Wwnn.

	   Filter by wwnn
	*/
	Wwnn *string

	/* Wwpn.

	   Filter by wwpn
	*/
	Wwpn *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the fc port modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FcPortModifyCollectionParams) WithDefaults() *FcPortModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the fc port modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FcPortModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := FcPortModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithTimeout(timeout time.Duration) *FcPortModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithContext(ctx context.Context) *FcPortModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithHTTPClient(client *http.Client) *FcPortModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *FcPortModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDescription adds the description to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithDescription(description *string) *FcPortModifyCollectionParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetDescription(description *string) {
	o.Description = description
}

// WithEnabled adds the enabled to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithEnabled(enabled *bool) *FcPortModifyCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithFabricConnected adds the fabricConnected to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithFabricConnected(fabricConnected *bool) *FcPortModifyCollectionParams {
	o.SetFabricConnected(fabricConnected)
	return o
}

// SetFabricConnected adds the fabricConnected to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetFabricConnected(fabricConnected *bool) {
	o.FabricConnected = fabricConnected
}

// WithFabricConnectedSpeed adds the fabricConnectedSpeed to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithFabricConnectedSpeed(fabricConnectedSpeed *int64) *FcPortModifyCollectionParams {
	o.SetFabricConnectedSpeed(fabricConnectedSpeed)
	return o
}

// SetFabricConnectedSpeed adds the fabricConnectedSpeed to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetFabricConnectedSpeed(fabricConnectedSpeed *int64) {
	o.FabricConnectedSpeed = fabricConnectedSpeed
}

// WithFabricName adds the fabricName to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithFabricName(fabricName *string) *FcPortModifyCollectionParams {
	o.SetFabricName(fabricName)
	return o
}

// SetFabricName adds the fabricName to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetFabricName(fabricName *string) {
	o.FabricName = fabricName
}

// WithFabricPortAddress adds the fabricPortAddress to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithFabricPortAddress(fabricPortAddress *string) *FcPortModifyCollectionParams {
	o.SetFabricPortAddress(fabricPortAddress)
	return o
}

// SetFabricPortAddress adds the fabricPortAddress to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetFabricPortAddress(fabricPortAddress *string) {
	o.FabricPortAddress = fabricPortAddress
}

// WithFabricSwitchPort adds the fabricSwitchPort to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithFabricSwitchPort(fabricSwitchPort *string) *FcPortModifyCollectionParams {
	o.SetFabricSwitchPort(fabricSwitchPort)
	return o
}

// SetFabricSwitchPort adds the fabricSwitchPort to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetFabricSwitchPort(fabricSwitchPort *string) {
	o.FabricSwitchPort = fabricSwitchPort
}

// WithInfo adds the info to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithInfo(info FcPortModifyCollectionBody) *FcPortModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetInfo(info FcPortModifyCollectionBody) {
	o.Info = info
}

// WithInterfaceCount adds the interfaceCount to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithInterfaceCount(interfaceCount *int64) *FcPortModifyCollectionParams {
	o.SetInterfaceCount(interfaceCount)
	return o
}

// SetInterfaceCount adds the interfaceCount to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetInterfaceCount(interfaceCount *int64) {
	o.InterfaceCount = interfaceCount
}

// WithMetricDuration adds the metricDuration to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithMetricDuration(metricDuration *string) *FcPortModifyCollectionParams {
	o.SetMetricDuration(metricDuration)
	return o
}

// SetMetricDuration adds the metricDuration to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetMetricDuration(metricDuration *string) {
	o.MetricDuration = metricDuration
}

// WithMetricIopsOther adds the metricIopsOther to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithMetricIopsOther(metricIopsOther *int64) *FcPortModifyCollectionParams {
	o.SetMetricIopsOther(metricIopsOther)
	return o
}

// SetMetricIopsOther adds the metricIopsOther to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetMetricIopsOther(metricIopsOther *int64) {
	o.MetricIopsOther = metricIopsOther
}

// WithMetricIopsRead adds the metricIopsRead to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithMetricIopsRead(metricIopsRead *int64) *FcPortModifyCollectionParams {
	o.SetMetricIopsRead(metricIopsRead)
	return o
}

// SetMetricIopsRead adds the metricIopsRead to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetMetricIopsRead(metricIopsRead *int64) {
	o.MetricIopsRead = metricIopsRead
}

// WithMetricIopsTotal adds the metricIopsTotal to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithMetricIopsTotal(metricIopsTotal *int64) *FcPortModifyCollectionParams {
	o.SetMetricIopsTotal(metricIopsTotal)
	return o
}

// SetMetricIopsTotal adds the metricIopsTotal to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetMetricIopsTotal(metricIopsTotal *int64) {
	o.MetricIopsTotal = metricIopsTotal
}

// WithMetricIopsWrite adds the metricIopsWrite to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithMetricIopsWrite(metricIopsWrite *int64) *FcPortModifyCollectionParams {
	o.SetMetricIopsWrite(metricIopsWrite)
	return o
}

// SetMetricIopsWrite adds the metricIopsWrite to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetMetricIopsWrite(metricIopsWrite *int64) {
	o.MetricIopsWrite = metricIopsWrite
}

// WithMetricLatencyOther adds the metricLatencyOther to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithMetricLatencyOther(metricLatencyOther *int64) *FcPortModifyCollectionParams {
	o.SetMetricLatencyOther(metricLatencyOther)
	return o
}

// SetMetricLatencyOther adds the metricLatencyOther to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetMetricLatencyOther(metricLatencyOther *int64) {
	o.MetricLatencyOther = metricLatencyOther
}

// WithMetricLatencyRead adds the metricLatencyRead to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithMetricLatencyRead(metricLatencyRead *int64) *FcPortModifyCollectionParams {
	o.SetMetricLatencyRead(metricLatencyRead)
	return o
}

// SetMetricLatencyRead adds the metricLatencyRead to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetMetricLatencyRead(metricLatencyRead *int64) {
	o.MetricLatencyRead = metricLatencyRead
}

// WithMetricLatencyTotal adds the metricLatencyTotal to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithMetricLatencyTotal(metricLatencyTotal *int64) *FcPortModifyCollectionParams {
	o.SetMetricLatencyTotal(metricLatencyTotal)
	return o
}

// SetMetricLatencyTotal adds the metricLatencyTotal to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetMetricLatencyTotal(metricLatencyTotal *int64) {
	o.MetricLatencyTotal = metricLatencyTotal
}

// WithMetricLatencyWrite adds the metricLatencyWrite to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithMetricLatencyWrite(metricLatencyWrite *int64) *FcPortModifyCollectionParams {
	o.SetMetricLatencyWrite(metricLatencyWrite)
	return o
}

// SetMetricLatencyWrite adds the metricLatencyWrite to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetMetricLatencyWrite(metricLatencyWrite *int64) {
	o.MetricLatencyWrite = metricLatencyWrite
}

// WithMetricStatus adds the metricStatus to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithMetricStatus(metricStatus *string) *FcPortModifyCollectionParams {
	o.SetMetricStatus(metricStatus)
	return o
}

// SetMetricStatus adds the metricStatus to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetMetricStatus(metricStatus *string) {
	o.MetricStatus = metricStatus
}

// WithMetricThroughputRead adds the metricThroughputRead to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithMetricThroughputRead(metricThroughputRead *int64) *FcPortModifyCollectionParams {
	o.SetMetricThroughputRead(metricThroughputRead)
	return o
}

// SetMetricThroughputRead adds the metricThroughputRead to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetMetricThroughputRead(metricThroughputRead *int64) {
	o.MetricThroughputRead = metricThroughputRead
}

// WithMetricThroughputTotal adds the metricThroughputTotal to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithMetricThroughputTotal(metricThroughputTotal *int64) *FcPortModifyCollectionParams {
	o.SetMetricThroughputTotal(metricThroughputTotal)
	return o
}

// SetMetricThroughputTotal adds the metricThroughputTotal to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetMetricThroughputTotal(metricThroughputTotal *int64) {
	o.MetricThroughputTotal = metricThroughputTotal
}

// WithMetricThroughputWrite adds the metricThroughputWrite to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithMetricThroughputWrite(metricThroughputWrite *int64) *FcPortModifyCollectionParams {
	o.SetMetricThroughputWrite(metricThroughputWrite)
	return o
}

// SetMetricThroughputWrite adds the metricThroughputWrite to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetMetricThroughputWrite(metricThroughputWrite *int64) {
	o.MetricThroughputWrite = metricThroughputWrite
}

// WithMetricTimestamp adds the metricTimestamp to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithMetricTimestamp(metricTimestamp *string) *FcPortModifyCollectionParams {
	o.SetMetricTimestamp(metricTimestamp)
	return o
}

// SetMetricTimestamp adds the metricTimestamp to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetMetricTimestamp(metricTimestamp *string) {
	o.MetricTimestamp = metricTimestamp
}

// WithName adds the name to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithName(name *string) *FcPortModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithNodeName adds the nodeName to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithNodeName(nodeName *string) *FcPortModifyCollectionParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithNodeUUID(nodeUUID *string) *FcPortModifyCollectionParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithPhysicalProtocol adds the physicalProtocol to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithPhysicalProtocol(physicalProtocol *string) *FcPortModifyCollectionParams {
	o.SetPhysicalProtocol(physicalProtocol)
	return o
}

// SetPhysicalProtocol adds the physicalProtocol to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetPhysicalProtocol(physicalProtocol *string) {
	o.PhysicalProtocol = physicalProtocol
}

// WithReturnRecords adds the returnRecords to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithReturnRecords(returnRecords *bool) *FcPortModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *FcPortModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithSerialRecords(serialRecords *bool) *FcPortModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSpeedConfigured adds the speedConfigured to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithSpeedConfigured(speedConfigured *string) *FcPortModifyCollectionParams {
	o.SetSpeedConfigured(speedConfigured)
	return o
}

// SetSpeedConfigured adds the speedConfigured to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetSpeedConfigured(speedConfigured *string) {
	o.SpeedConfigured = speedConfigured
}

// WithSpeedMaximum adds the speedMaximum to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithSpeedMaximum(speedMaximum *string) *FcPortModifyCollectionParams {
	o.SetSpeedMaximum(speedMaximum)
	return o
}

// SetSpeedMaximum adds the speedMaximum to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetSpeedMaximum(speedMaximum *string) {
	o.SpeedMaximum = speedMaximum
}

// WithState adds the state to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithState(state *string) *FcPortModifyCollectionParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetState(state *string) {
	o.State = state
}

// WithStatisticsIopsRawOther adds the statisticsIopsRawOther to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithStatisticsIopsRawOther(statisticsIopsRawOther *int64) *FcPortModifyCollectionParams {
	o.SetStatisticsIopsRawOther(statisticsIopsRawOther)
	return o
}

// SetStatisticsIopsRawOther adds the statisticsIopsRawOther to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetStatisticsIopsRawOther(statisticsIopsRawOther *int64) {
	o.StatisticsIopsRawOther = statisticsIopsRawOther
}

// WithStatisticsIopsRawRead adds the statisticsIopsRawRead to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithStatisticsIopsRawRead(statisticsIopsRawRead *int64) *FcPortModifyCollectionParams {
	o.SetStatisticsIopsRawRead(statisticsIopsRawRead)
	return o
}

// SetStatisticsIopsRawRead adds the statisticsIopsRawRead to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetStatisticsIopsRawRead(statisticsIopsRawRead *int64) {
	o.StatisticsIopsRawRead = statisticsIopsRawRead
}

// WithStatisticsIopsRawTotal adds the statisticsIopsRawTotal to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithStatisticsIopsRawTotal(statisticsIopsRawTotal *int64) *FcPortModifyCollectionParams {
	o.SetStatisticsIopsRawTotal(statisticsIopsRawTotal)
	return o
}

// SetStatisticsIopsRawTotal adds the statisticsIopsRawTotal to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetStatisticsIopsRawTotal(statisticsIopsRawTotal *int64) {
	o.StatisticsIopsRawTotal = statisticsIopsRawTotal
}

// WithStatisticsIopsRawWrite adds the statisticsIopsRawWrite to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithStatisticsIopsRawWrite(statisticsIopsRawWrite *int64) *FcPortModifyCollectionParams {
	o.SetStatisticsIopsRawWrite(statisticsIopsRawWrite)
	return o
}

// SetStatisticsIopsRawWrite adds the statisticsIopsRawWrite to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetStatisticsIopsRawWrite(statisticsIopsRawWrite *int64) {
	o.StatisticsIopsRawWrite = statisticsIopsRawWrite
}

// WithStatisticsLatencyRawOther adds the statisticsLatencyRawOther to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithStatisticsLatencyRawOther(statisticsLatencyRawOther *int64) *FcPortModifyCollectionParams {
	o.SetStatisticsLatencyRawOther(statisticsLatencyRawOther)
	return o
}

// SetStatisticsLatencyRawOther adds the statisticsLatencyRawOther to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetStatisticsLatencyRawOther(statisticsLatencyRawOther *int64) {
	o.StatisticsLatencyRawOther = statisticsLatencyRawOther
}

// WithStatisticsLatencyRawRead adds the statisticsLatencyRawRead to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithStatisticsLatencyRawRead(statisticsLatencyRawRead *int64) *FcPortModifyCollectionParams {
	o.SetStatisticsLatencyRawRead(statisticsLatencyRawRead)
	return o
}

// SetStatisticsLatencyRawRead adds the statisticsLatencyRawRead to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetStatisticsLatencyRawRead(statisticsLatencyRawRead *int64) {
	o.StatisticsLatencyRawRead = statisticsLatencyRawRead
}

// WithStatisticsLatencyRawTotal adds the statisticsLatencyRawTotal to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithStatisticsLatencyRawTotal(statisticsLatencyRawTotal *int64) *FcPortModifyCollectionParams {
	o.SetStatisticsLatencyRawTotal(statisticsLatencyRawTotal)
	return o
}

// SetStatisticsLatencyRawTotal adds the statisticsLatencyRawTotal to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetStatisticsLatencyRawTotal(statisticsLatencyRawTotal *int64) {
	o.StatisticsLatencyRawTotal = statisticsLatencyRawTotal
}

// WithStatisticsLatencyRawWrite adds the statisticsLatencyRawWrite to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithStatisticsLatencyRawWrite(statisticsLatencyRawWrite *int64) *FcPortModifyCollectionParams {
	o.SetStatisticsLatencyRawWrite(statisticsLatencyRawWrite)
	return o
}

// SetStatisticsLatencyRawWrite adds the statisticsLatencyRawWrite to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetStatisticsLatencyRawWrite(statisticsLatencyRawWrite *int64) {
	o.StatisticsLatencyRawWrite = statisticsLatencyRawWrite
}

// WithStatisticsStatus adds the statisticsStatus to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithStatisticsStatus(statisticsStatus *string) *FcPortModifyCollectionParams {
	o.SetStatisticsStatus(statisticsStatus)
	return o
}

// SetStatisticsStatus adds the statisticsStatus to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetStatisticsStatus(statisticsStatus *string) {
	o.StatisticsStatus = statisticsStatus
}

// WithStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) *FcPortModifyCollectionParams {
	o.SetStatisticsThroughputRawRead(statisticsThroughputRawRead)
	return o
}

// SetStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) {
	o.StatisticsThroughputRawRead = statisticsThroughputRawRead
}

// WithStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) *FcPortModifyCollectionParams {
	o.SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal)
	return o
}

// SetStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) {
	o.StatisticsThroughputRawTotal = statisticsThroughputRawTotal
}

// WithStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) *FcPortModifyCollectionParams {
	o.SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite)
	return o
}

// SetStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) {
	o.StatisticsThroughputRawWrite = statisticsThroughputRawWrite
}

// WithStatisticsTimestamp adds the statisticsTimestamp to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithStatisticsTimestamp(statisticsTimestamp *string) *FcPortModifyCollectionParams {
	o.SetStatisticsTimestamp(statisticsTimestamp)
	return o
}

// SetStatisticsTimestamp adds the statisticsTimestamp to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetStatisticsTimestamp(statisticsTimestamp *string) {
	o.StatisticsTimestamp = statisticsTimestamp
}

// WithSupportedProtocols adds the supportedProtocols to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithSupportedProtocols(supportedProtocols *string) *FcPortModifyCollectionParams {
	o.SetSupportedProtocols(supportedProtocols)
	return o
}

// SetSupportedProtocols adds the supportedProtocols to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetSupportedProtocols(supportedProtocols *string) {
	o.SupportedProtocols = supportedProtocols
}

// WithTransceiverCapabilities adds the transceiverCapabilities to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithTransceiverCapabilities(transceiverCapabilities *int64) *FcPortModifyCollectionParams {
	o.SetTransceiverCapabilities(transceiverCapabilities)
	return o
}

// SetTransceiverCapabilities adds the transceiverCapabilities to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetTransceiverCapabilities(transceiverCapabilities *int64) {
	o.TransceiverCapabilities = transceiverCapabilities
}

// WithTransceiverFormFactor adds the transceiverFormFactor to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithTransceiverFormFactor(transceiverFormFactor *string) *FcPortModifyCollectionParams {
	o.SetTransceiverFormFactor(transceiverFormFactor)
	return o
}

// SetTransceiverFormFactor adds the transceiverFormFactor to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetTransceiverFormFactor(transceiverFormFactor *string) {
	o.TransceiverFormFactor = transceiverFormFactor
}

// WithTransceiverManufacturer adds the transceiverManufacturer to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithTransceiverManufacturer(transceiverManufacturer *string) *FcPortModifyCollectionParams {
	o.SetTransceiverManufacturer(transceiverManufacturer)
	return o
}

// SetTransceiverManufacturer adds the transceiverManufacturer to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetTransceiverManufacturer(transceiverManufacturer *string) {
	o.TransceiverManufacturer = transceiverManufacturer
}

// WithTransceiverPartNumber adds the transceiverPartNumber to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithTransceiverPartNumber(transceiverPartNumber *string) *FcPortModifyCollectionParams {
	o.SetTransceiverPartNumber(transceiverPartNumber)
	return o
}

// SetTransceiverPartNumber adds the transceiverPartNumber to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetTransceiverPartNumber(transceiverPartNumber *string) {
	o.TransceiverPartNumber = transceiverPartNumber
}

// WithUUID adds the uuid to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithUUID(uuid *string) *FcPortModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithWwnn adds the wwnn to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithWwnn(wwnn *string) *FcPortModifyCollectionParams {
	o.SetWwnn(wwnn)
	return o
}

// SetWwnn adds the wwnn to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetWwnn(wwnn *string) {
	o.Wwnn = wwnn
}

// WithWwpn adds the wwpn to the fc port modify collection params
func (o *FcPortModifyCollectionParams) WithWwpn(wwpn *string) *FcPortModifyCollectionParams {
	o.SetWwpn(wwpn)
	return o
}

// SetWwpn adds the wwpn to the fc port modify collection params
func (o *FcPortModifyCollectionParams) SetWwpn(wwpn *string) {
	o.Wwpn = wwpn
}

// WriteToRequest writes these params to a swagger request
func (o *FcPortModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Description != nil {

		// query param description
		var qrDescription string

		if o.Description != nil {
			qrDescription = *o.Description
		}
		qDescription := qrDescription
		if qDescription != "" {

			if err := r.SetQueryParam("description", qDescription); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.FabricConnected != nil {

		// query param fabric.connected
		var qrFabricConnected bool

		if o.FabricConnected != nil {
			qrFabricConnected = *o.FabricConnected
		}
		qFabricConnected := swag.FormatBool(qrFabricConnected)
		if qFabricConnected != "" {

			if err := r.SetQueryParam("fabric.connected", qFabricConnected); err != nil {
				return err
			}
		}
	}

	if o.FabricConnectedSpeed != nil {

		// query param fabric.connected_speed
		var qrFabricConnectedSpeed int64

		if o.FabricConnectedSpeed != nil {
			qrFabricConnectedSpeed = *o.FabricConnectedSpeed
		}
		qFabricConnectedSpeed := swag.FormatInt64(qrFabricConnectedSpeed)
		if qFabricConnectedSpeed != "" {

			if err := r.SetQueryParam("fabric.connected_speed", qFabricConnectedSpeed); err != nil {
				return err
			}
		}
	}

	if o.FabricName != nil {

		// query param fabric.name
		var qrFabricName string

		if o.FabricName != nil {
			qrFabricName = *o.FabricName
		}
		qFabricName := qrFabricName
		if qFabricName != "" {

			if err := r.SetQueryParam("fabric.name", qFabricName); err != nil {
				return err
			}
		}
	}

	if o.FabricPortAddress != nil {

		// query param fabric.port_address
		var qrFabricPortAddress string

		if o.FabricPortAddress != nil {
			qrFabricPortAddress = *o.FabricPortAddress
		}
		qFabricPortAddress := qrFabricPortAddress
		if qFabricPortAddress != "" {

			if err := r.SetQueryParam("fabric.port_address", qFabricPortAddress); err != nil {
				return err
			}
		}
	}

	if o.FabricSwitchPort != nil {

		// query param fabric.switch_port
		var qrFabricSwitchPort string

		if o.FabricSwitchPort != nil {
			qrFabricSwitchPort = *o.FabricSwitchPort
		}
		qFabricSwitchPort := qrFabricSwitchPort
		if qFabricSwitchPort != "" {

			if err := r.SetQueryParam("fabric.switch_port", qFabricSwitchPort); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.InterfaceCount != nil {

		// query param interface_count
		var qrInterfaceCount int64

		if o.InterfaceCount != nil {
			qrInterfaceCount = *o.InterfaceCount
		}
		qInterfaceCount := swag.FormatInt64(qrInterfaceCount)
		if qInterfaceCount != "" {

			if err := r.SetQueryParam("interface_count", qInterfaceCount); err != nil {
				return err
			}
		}
	}

	if o.MetricDuration != nil {

		// query param metric.duration
		var qrMetricDuration string

		if o.MetricDuration != nil {
			qrMetricDuration = *o.MetricDuration
		}
		qMetricDuration := qrMetricDuration
		if qMetricDuration != "" {

			if err := r.SetQueryParam("metric.duration", qMetricDuration); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsOther != nil {

		// query param metric.iops.other
		var qrMetricIopsOther int64

		if o.MetricIopsOther != nil {
			qrMetricIopsOther = *o.MetricIopsOther
		}
		qMetricIopsOther := swag.FormatInt64(qrMetricIopsOther)
		if qMetricIopsOther != "" {

			if err := r.SetQueryParam("metric.iops.other", qMetricIopsOther); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsRead != nil {

		// query param metric.iops.read
		var qrMetricIopsRead int64

		if o.MetricIopsRead != nil {
			qrMetricIopsRead = *o.MetricIopsRead
		}
		qMetricIopsRead := swag.FormatInt64(qrMetricIopsRead)
		if qMetricIopsRead != "" {

			if err := r.SetQueryParam("metric.iops.read", qMetricIopsRead); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsTotal != nil {

		// query param metric.iops.total
		var qrMetricIopsTotal int64

		if o.MetricIopsTotal != nil {
			qrMetricIopsTotal = *o.MetricIopsTotal
		}
		qMetricIopsTotal := swag.FormatInt64(qrMetricIopsTotal)
		if qMetricIopsTotal != "" {

			if err := r.SetQueryParam("metric.iops.total", qMetricIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsWrite != nil {

		// query param metric.iops.write
		var qrMetricIopsWrite int64

		if o.MetricIopsWrite != nil {
			qrMetricIopsWrite = *o.MetricIopsWrite
		}
		qMetricIopsWrite := swag.FormatInt64(qrMetricIopsWrite)
		if qMetricIopsWrite != "" {

			if err := r.SetQueryParam("metric.iops.write", qMetricIopsWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyOther != nil {

		// query param metric.latency.other
		var qrMetricLatencyOther int64

		if o.MetricLatencyOther != nil {
			qrMetricLatencyOther = *o.MetricLatencyOther
		}
		qMetricLatencyOther := swag.FormatInt64(qrMetricLatencyOther)
		if qMetricLatencyOther != "" {

			if err := r.SetQueryParam("metric.latency.other", qMetricLatencyOther); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyRead != nil {

		// query param metric.latency.read
		var qrMetricLatencyRead int64

		if o.MetricLatencyRead != nil {
			qrMetricLatencyRead = *o.MetricLatencyRead
		}
		qMetricLatencyRead := swag.FormatInt64(qrMetricLatencyRead)
		if qMetricLatencyRead != "" {

			if err := r.SetQueryParam("metric.latency.read", qMetricLatencyRead); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyTotal != nil {

		// query param metric.latency.total
		var qrMetricLatencyTotal int64

		if o.MetricLatencyTotal != nil {
			qrMetricLatencyTotal = *o.MetricLatencyTotal
		}
		qMetricLatencyTotal := swag.FormatInt64(qrMetricLatencyTotal)
		if qMetricLatencyTotal != "" {

			if err := r.SetQueryParam("metric.latency.total", qMetricLatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyWrite != nil {

		// query param metric.latency.write
		var qrMetricLatencyWrite int64

		if o.MetricLatencyWrite != nil {
			qrMetricLatencyWrite = *o.MetricLatencyWrite
		}
		qMetricLatencyWrite := swag.FormatInt64(qrMetricLatencyWrite)
		if qMetricLatencyWrite != "" {

			if err := r.SetQueryParam("metric.latency.write", qMetricLatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricStatus != nil {

		// query param metric.status
		var qrMetricStatus string

		if o.MetricStatus != nil {
			qrMetricStatus = *o.MetricStatus
		}
		qMetricStatus := qrMetricStatus
		if qMetricStatus != "" {

			if err := r.SetQueryParam("metric.status", qMetricStatus); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputRead != nil {

		// query param metric.throughput.read
		var qrMetricThroughputRead int64

		if o.MetricThroughputRead != nil {
			qrMetricThroughputRead = *o.MetricThroughputRead
		}
		qMetricThroughputRead := swag.FormatInt64(qrMetricThroughputRead)
		if qMetricThroughputRead != "" {

			if err := r.SetQueryParam("metric.throughput.read", qMetricThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputTotal != nil {

		// query param metric.throughput.total
		var qrMetricThroughputTotal int64

		if o.MetricThroughputTotal != nil {
			qrMetricThroughputTotal = *o.MetricThroughputTotal
		}
		qMetricThroughputTotal := swag.FormatInt64(qrMetricThroughputTotal)
		if qMetricThroughputTotal != "" {

			if err := r.SetQueryParam("metric.throughput.total", qMetricThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputWrite != nil {

		// query param metric.throughput.write
		var qrMetricThroughputWrite int64

		if o.MetricThroughputWrite != nil {
			qrMetricThroughputWrite = *o.MetricThroughputWrite
		}
		qMetricThroughputWrite := swag.FormatInt64(qrMetricThroughputWrite)
		if qMetricThroughputWrite != "" {

			if err := r.SetQueryParam("metric.throughput.write", qMetricThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricTimestamp != nil {

		// query param metric.timestamp
		var qrMetricTimestamp string

		if o.MetricTimestamp != nil {
			qrMetricTimestamp = *o.MetricTimestamp
		}
		qMetricTimestamp := qrMetricTimestamp
		if qMetricTimestamp != "" {

			if err := r.SetQueryParam("metric.timestamp", qMetricTimestamp); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.PhysicalProtocol != nil {

		// query param physical_protocol
		var qrPhysicalProtocol string

		if o.PhysicalProtocol != nil {
			qrPhysicalProtocol = *o.PhysicalProtocol
		}
		qPhysicalProtocol := qrPhysicalProtocol
		if qPhysicalProtocol != "" {

			if err := r.SetQueryParam("physical_protocol", qPhysicalProtocol); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SpeedConfigured != nil {

		// query param speed.configured
		var qrSpeedConfigured string

		if o.SpeedConfigured != nil {
			qrSpeedConfigured = *o.SpeedConfigured
		}
		qSpeedConfigured := qrSpeedConfigured
		if qSpeedConfigured != "" {

			if err := r.SetQueryParam("speed.configured", qSpeedConfigured); err != nil {
				return err
			}
		}
	}

	if o.SpeedMaximum != nil {

		// query param speed.maximum
		var qrSpeedMaximum string

		if o.SpeedMaximum != nil {
			qrSpeedMaximum = *o.SpeedMaximum
		}
		qSpeedMaximum := qrSpeedMaximum
		if qSpeedMaximum != "" {

			if err := r.SetQueryParam("speed.maximum", qSpeedMaximum); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawOther != nil {

		// query param statistics.iops_raw.other
		var qrStatisticsIopsRawOther int64

		if o.StatisticsIopsRawOther != nil {
			qrStatisticsIopsRawOther = *o.StatisticsIopsRawOther
		}
		qStatisticsIopsRawOther := swag.FormatInt64(qrStatisticsIopsRawOther)
		if qStatisticsIopsRawOther != "" {

			if err := r.SetQueryParam("statistics.iops_raw.other", qStatisticsIopsRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawRead != nil {

		// query param statistics.iops_raw.read
		var qrStatisticsIopsRawRead int64

		if o.StatisticsIopsRawRead != nil {
			qrStatisticsIopsRawRead = *o.StatisticsIopsRawRead
		}
		qStatisticsIopsRawRead := swag.FormatInt64(qrStatisticsIopsRawRead)
		if qStatisticsIopsRawRead != "" {

			if err := r.SetQueryParam("statistics.iops_raw.read", qStatisticsIopsRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawTotal != nil {

		// query param statistics.iops_raw.total
		var qrStatisticsIopsRawTotal int64

		if o.StatisticsIopsRawTotal != nil {
			qrStatisticsIopsRawTotal = *o.StatisticsIopsRawTotal
		}
		qStatisticsIopsRawTotal := swag.FormatInt64(qrStatisticsIopsRawTotal)
		if qStatisticsIopsRawTotal != "" {

			if err := r.SetQueryParam("statistics.iops_raw.total", qStatisticsIopsRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawWrite != nil {

		// query param statistics.iops_raw.write
		var qrStatisticsIopsRawWrite int64

		if o.StatisticsIopsRawWrite != nil {
			qrStatisticsIopsRawWrite = *o.StatisticsIopsRawWrite
		}
		qStatisticsIopsRawWrite := swag.FormatInt64(qrStatisticsIopsRawWrite)
		if qStatisticsIopsRawWrite != "" {

			if err := r.SetQueryParam("statistics.iops_raw.write", qStatisticsIopsRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawOther != nil {

		// query param statistics.latency_raw.other
		var qrStatisticsLatencyRawOther int64

		if o.StatisticsLatencyRawOther != nil {
			qrStatisticsLatencyRawOther = *o.StatisticsLatencyRawOther
		}
		qStatisticsLatencyRawOther := swag.FormatInt64(qrStatisticsLatencyRawOther)
		if qStatisticsLatencyRawOther != "" {

			if err := r.SetQueryParam("statistics.latency_raw.other", qStatisticsLatencyRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawRead != nil {

		// query param statistics.latency_raw.read
		var qrStatisticsLatencyRawRead int64

		if o.StatisticsLatencyRawRead != nil {
			qrStatisticsLatencyRawRead = *o.StatisticsLatencyRawRead
		}
		qStatisticsLatencyRawRead := swag.FormatInt64(qrStatisticsLatencyRawRead)
		if qStatisticsLatencyRawRead != "" {

			if err := r.SetQueryParam("statistics.latency_raw.read", qStatisticsLatencyRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawTotal != nil {

		// query param statistics.latency_raw.total
		var qrStatisticsLatencyRawTotal int64

		if o.StatisticsLatencyRawTotal != nil {
			qrStatisticsLatencyRawTotal = *o.StatisticsLatencyRawTotal
		}
		qStatisticsLatencyRawTotal := swag.FormatInt64(qrStatisticsLatencyRawTotal)
		if qStatisticsLatencyRawTotal != "" {

			if err := r.SetQueryParam("statistics.latency_raw.total", qStatisticsLatencyRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawWrite != nil {

		// query param statistics.latency_raw.write
		var qrStatisticsLatencyRawWrite int64

		if o.StatisticsLatencyRawWrite != nil {
			qrStatisticsLatencyRawWrite = *o.StatisticsLatencyRawWrite
		}
		qStatisticsLatencyRawWrite := swag.FormatInt64(qrStatisticsLatencyRawWrite)
		if qStatisticsLatencyRawWrite != "" {

			if err := r.SetQueryParam("statistics.latency_raw.write", qStatisticsLatencyRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsStatus != nil {

		// query param statistics.status
		var qrStatisticsStatus string

		if o.StatisticsStatus != nil {
			qrStatisticsStatus = *o.StatisticsStatus
		}
		qStatisticsStatus := qrStatisticsStatus
		if qStatisticsStatus != "" {

			if err := r.SetQueryParam("statistics.status", qStatisticsStatus); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawRead != nil {

		// query param statistics.throughput_raw.read
		var qrStatisticsThroughputRawRead int64

		if o.StatisticsThroughputRawRead != nil {
			qrStatisticsThroughputRawRead = *o.StatisticsThroughputRawRead
		}
		qStatisticsThroughputRawRead := swag.FormatInt64(qrStatisticsThroughputRawRead)
		if qStatisticsThroughputRawRead != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.read", qStatisticsThroughputRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawTotal != nil {

		// query param statistics.throughput_raw.total
		var qrStatisticsThroughputRawTotal int64

		if o.StatisticsThroughputRawTotal != nil {
			qrStatisticsThroughputRawTotal = *o.StatisticsThroughputRawTotal
		}
		qStatisticsThroughputRawTotal := swag.FormatInt64(qrStatisticsThroughputRawTotal)
		if qStatisticsThroughputRawTotal != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.total", qStatisticsThroughputRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawWrite != nil {

		// query param statistics.throughput_raw.write
		var qrStatisticsThroughputRawWrite int64

		if o.StatisticsThroughputRawWrite != nil {
			qrStatisticsThroughputRawWrite = *o.StatisticsThroughputRawWrite
		}
		qStatisticsThroughputRawWrite := swag.FormatInt64(qrStatisticsThroughputRawWrite)
		if qStatisticsThroughputRawWrite != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.write", qStatisticsThroughputRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsTimestamp != nil {

		// query param statistics.timestamp
		var qrStatisticsTimestamp string

		if o.StatisticsTimestamp != nil {
			qrStatisticsTimestamp = *o.StatisticsTimestamp
		}
		qStatisticsTimestamp := qrStatisticsTimestamp
		if qStatisticsTimestamp != "" {

			if err := r.SetQueryParam("statistics.timestamp", qStatisticsTimestamp); err != nil {
				return err
			}
		}
	}

	if o.SupportedProtocols != nil {

		// query param supported_protocols
		var qrSupportedProtocols string

		if o.SupportedProtocols != nil {
			qrSupportedProtocols = *o.SupportedProtocols
		}
		qSupportedProtocols := qrSupportedProtocols
		if qSupportedProtocols != "" {

			if err := r.SetQueryParam("supported_protocols", qSupportedProtocols); err != nil {
				return err
			}
		}
	}

	if o.TransceiverCapabilities != nil {

		// query param transceiver.capabilities
		var qrTransceiverCapabilities int64

		if o.TransceiverCapabilities != nil {
			qrTransceiverCapabilities = *o.TransceiverCapabilities
		}
		qTransceiverCapabilities := swag.FormatInt64(qrTransceiverCapabilities)
		if qTransceiverCapabilities != "" {

			if err := r.SetQueryParam("transceiver.capabilities", qTransceiverCapabilities); err != nil {
				return err
			}
		}
	}

	if o.TransceiverFormFactor != nil {

		// query param transceiver.form_factor
		var qrTransceiverFormFactor string

		if o.TransceiverFormFactor != nil {
			qrTransceiverFormFactor = *o.TransceiverFormFactor
		}
		qTransceiverFormFactor := qrTransceiverFormFactor
		if qTransceiverFormFactor != "" {

			if err := r.SetQueryParam("transceiver.form_factor", qTransceiverFormFactor); err != nil {
				return err
			}
		}
	}

	if o.TransceiverManufacturer != nil {

		// query param transceiver.manufacturer
		var qrTransceiverManufacturer string

		if o.TransceiverManufacturer != nil {
			qrTransceiverManufacturer = *o.TransceiverManufacturer
		}
		qTransceiverManufacturer := qrTransceiverManufacturer
		if qTransceiverManufacturer != "" {

			if err := r.SetQueryParam("transceiver.manufacturer", qTransceiverManufacturer); err != nil {
				return err
			}
		}
	}

	if o.TransceiverPartNumber != nil {

		// query param transceiver.part_number
		var qrTransceiverPartNumber string

		if o.TransceiverPartNumber != nil {
			qrTransceiverPartNumber = *o.TransceiverPartNumber
		}
		qTransceiverPartNumber := qrTransceiverPartNumber
		if qTransceiverPartNumber != "" {

			if err := r.SetQueryParam("transceiver.part_number", qTransceiverPartNumber); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.Wwnn != nil {

		// query param wwnn
		var qrWwnn string

		if o.Wwnn != nil {
			qrWwnn = *o.Wwnn
		}
		qWwnn := qrWwnn
		if qWwnn != "" {

			if err := r.SetQueryParam("wwnn", qWwnn); err != nil {
				return err
			}
		}
	}

	if o.Wwpn != nil {

		// query param wwpn
		var qrWwpn string

		if o.Wwpn != nil {
			qrWwpn = *o.Wwpn
		}
		qWwpn := qrWwpn
		if qWwpn != "" {

			if err := r.SetQueryParam("wwpn", qWwpn); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
