// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FcPortModifyCollectionReader is a Reader for the FcPortModifyCollection structure.
type FcPortModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FcPortModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFcPortModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFcPortModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFcPortModifyCollectionOK creates a FcPortModifyCollectionOK with default headers values
func NewFcPortModifyCollectionOK() *FcPortModifyCollectionOK {
	return &FcPortModifyCollectionOK{}
}

/*
FcPortModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type FcPortModifyCollectionOK struct {
}

// IsSuccess returns true when this fc port modify collection o k response has a 2xx status code
func (o *FcPortModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fc port modify collection o k response has a 3xx status code
func (o *FcPortModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fc port modify collection o k response has a 4xx status code
func (o *FcPortModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fc port modify collection o k response has a 5xx status code
func (o *FcPortModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fc port modify collection o k response a status code equal to that given
func (o *FcPortModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fc port modify collection o k response
func (o *FcPortModifyCollectionOK) Code() int {
	return 200
}

func (o *FcPortModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /network/fc/ports][%d] fcPortModifyCollectionOK", 200)
}

func (o *FcPortModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /network/fc/ports][%d] fcPortModifyCollectionOK", 200)
}

func (o *FcPortModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewFcPortModifyCollectionDefault creates a FcPortModifyCollectionDefault with default headers values
func NewFcPortModifyCollectionDefault(code int) *FcPortModifyCollectionDefault {
	return &FcPortModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	FcPortModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5374085    | The node where the Fibre Channel port is located is offline. |
| 5374087    | The Fibre Channel port has active Fibre Channel interfaces and cannot be disabled. |
*/
type FcPortModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fc port modify collection default response has a 2xx status code
func (o *FcPortModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fc port modify collection default response has a 3xx status code
func (o *FcPortModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fc port modify collection default response has a 4xx status code
func (o *FcPortModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fc port modify collection default response has a 5xx status code
func (o *FcPortModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fc port modify collection default response a status code equal to that given
func (o *FcPortModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fc port modify collection default response
func (o *FcPortModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *FcPortModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/fc/ports][%d] fc_port_modify_collection default %s", o._statusCode, payload)
}

func (o *FcPortModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/fc/ports][%d] fc_port_modify_collection default %s", o._statusCode, payload)
}

func (o *FcPortModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FcPortModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
FcPortModifyCollectionBody fc port modify collection body
swagger:model FcPortModifyCollectionBody
*/
type FcPortModifyCollectionBody struct {

	// links
	Links *models.FcPortInlineLinks `json:"_links,omitempty"`

	// A description of the FC port.
	//
	// Example: Fibre Channel Target Adapter 0a (ACME Fibre Channel Adapter, rev. 1.0.0, 8G)
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// The administrative state of the FC port. If this property is set to _false_, all FC connectivity to FC interfaces are blocked. Optional in PATCH.
	//
	Enabled *bool `json:"enabled,omitempty"`

	// fabric
	Fabric *models.FcPortInlineFabric `json:"fabric,omitempty"`

	// fc port response inline records
	FcPortResponseInlineRecords []*models.FcPort `json:"records,omitempty"`

	// The number of FC interfaces currently provisioned on this port. This property is not supported in an SVM context.
	//
	// Read Only: true
	InterfaceCount *int64 `json:"interface_count,omitempty"`

	// metric
	Metric *models.FcPortInlineMetric `json:"metric,omitempty"`

	// The FC port name.
	//
	// Example: 0a
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// node
	Node *models.FcPortInlineNode `json:"node,omitempty"`

	// The physical network protocol of the FC port.
	//
	// Read Only: true
	// Enum: ["fibre_channel","ethernet"]
	PhysicalProtocol *string `json:"physical_protocol,omitempty"`

	// speed
	Speed *models.FcPortInlineSpeed `json:"speed,omitempty"`

	// The operational state of the FC port.
	// - startup - The port is booting up.
	// - link_not_connected - The port has finished initialization, but a link with the fabric is not established.
	// - online - The port is initialized and a link with the fabric has been established.
	// - link_disconnected - The link was present at one point on this port but is currently not established.
	// - offlined_by_user - The port is administratively disabled.
	// - offlined_by_system - The port is set to offline by the system. This happens when the port encounters too many errors.
	// - node_offline - The state information for the port cannot be retrieved. The node is offline or inaccessible.
	//
	// Example: online
	// Read Only: true
	// Enum: ["startup","link_not_connected","online","link_disconnected","offlined_by_user","offlined_by_system","node_offline","unknown"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *models.FcPortInlineStatistics `json:"statistics,omitempty"`

	// The network protocols supported by the FC port.
	//
	// Read Only: true
	SupportedProtocols []*string `json:"supported_protocols,omitempty"`

	// transceiver
	Transceiver *models.FcPortInlineTransceiver `json:"transceiver,omitempty"`

	// The unique identifier of the FC port.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// The base world wide node name (WWNN) for the FC port.
	//
	// Example: 20:00:00:50:56:b4:13:a8
	// Read Only: true
	Wwnn *string `json:"wwnn,omitempty"`

	// The base world wide port name (WWPN) for the FC port.
	//
	// Example: 20:00:00:50:56:b4:13:a8
	// Read Only: true
	Wwpn *string `json:"wwpn,omitempty"`
}

// Validate validates this fc port modify collection body
func (o *FcPortModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFabric(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFcPortResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePhysicalProtocol(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpeed(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSupportedProtocols(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTransceiver(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcPortModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortModifyCollectionBody) validateFabric(formats strfmt.Registry) error {
	if swag.IsZero(o.Fabric) { // not required
		return nil
	}

	if o.Fabric != nil {
		if err := o.Fabric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "fabric")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortModifyCollectionBody) validateFcPortResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.FcPortResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.FcPortResponseInlineRecords); i++ {
		if swag.IsZero(o.FcPortResponseInlineRecords[i]) { // not required
			continue
		}

		if o.FcPortResponseInlineRecords[i] != nil {
			if err := o.FcPortResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FcPortModifyCollectionBody) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(o.Metric) { // not required
		return nil
	}

	if o.Metric != nil {
		if err := o.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortModifyCollectionBody) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

var fcPortModifyCollectionBodyTypePhysicalProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fibre_channel","ethernet"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcPortModifyCollectionBodyTypePhysicalProtocolPropEnum = append(fcPortModifyCollectionBodyTypePhysicalProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// FcPortModifyCollectionBody
	// FcPortModifyCollectionBody
	// physical_protocol
	// PhysicalProtocol
	// fibre_channel
	// END DEBUGGING
	// FcPortModifyCollectionBodyPhysicalProtocolFibreChannel captures enum value "fibre_channel"
	FcPortModifyCollectionBodyPhysicalProtocolFibreChannel string = "fibre_channel"

	// BEGIN DEBUGGING
	// FcPortModifyCollectionBody
	// FcPortModifyCollectionBody
	// physical_protocol
	// PhysicalProtocol
	// ethernet
	// END DEBUGGING
	// FcPortModifyCollectionBodyPhysicalProtocolEthernet captures enum value "ethernet"
	FcPortModifyCollectionBodyPhysicalProtocolEthernet string = "ethernet"
)

// prop value enum
func (o *FcPortModifyCollectionBody) validatePhysicalProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcPortModifyCollectionBodyTypePhysicalProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FcPortModifyCollectionBody) validatePhysicalProtocol(formats strfmt.Registry) error {
	if swag.IsZero(o.PhysicalProtocol) { // not required
		return nil
	}

	// value enum
	if err := o.validatePhysicalProtocolEnum("info"+"."+"physical_protocol", "body", *o.PhysicalProtocol); err != nil {
		return err
	}

	return nil
}

func (o *FcPortModifyCollectionBody) validateSpeed(formats strfmt.Registry) error {
	if swag.IsZero(o.Speed) { // not required
		return nil
	}

	if o.Speed != nil {
		if err := o.Speed.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "speed")
			}
			return err
		}
	}

	return nil
}

var fcPortModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["startup","link_not_connected","online","link_disconnected","offlined_by_user","offlined_by_system","node_offline","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcPortModifyCollectionBodyTypeStatePropEnum = append(fcPortModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// FcPortModifyCollectionBody
	// FcPortModifyCollectionBody
	// state
	// State
	// startup
	// END DEBUGGING
	// FcPortModifyCollectionBodyStateStartup captures enum value "startup"
	FcPortModifyCollectionBodyStateStartup string = "startup"

	// BEGIN DEBUGGING
	// FcPortModifyCollectionBody
	// FcPortModifyCollectionBody
	// state
	// State
	// link_not_connected
	// END DEBUGGING
	// FcPortModifyCollectionBodyStateLinkNotConnected captures enum value "link_not_connected"
	FcPortModifyCollectionBodyStateLinkNotConnected string = "link_not_connected"

	// BEGIN DEBUGGING
	// FcPortModifyCollectionBody
	// FcPortModifyCollectionBody
	// state
	// State
	// online
	// END DEBUGGING
	// FcPortModifyCollectionBodyStateOnline captures enum value "online"
	FcPortModifyCollectionBodyStateOnline string = "online"

	// BEGIN DEBUGGING
	// FcPortModifyCollectionBody
	// FcPortModifyCollectionBody
	// state
	// State
	// link_disconnected
	// END DEBUGGING
	// FcPortModifyCollectionBodyStateLinkDisconnected captures enum value "link_disconnected"
	FcPortModifyCollectionBodyStateLinkDisconnected string = "link_disconnected"

	// BEGIN DEBUGGING
	// FcPortModifyCollectionBody
	// FcPortModifyCollectionBody
	// state
	// State
	// offlined_by_user
	// END DEBUGGING
	// FcPortModifyCollectionBodyStateOfflinedByUser captures enum value "offlined_by_user"
	FcPortModifyCollectionBodyStateOfflinedByUser string = "offlined_by_user"

	// BEGIN DEBUGGING
	// FcPortModifyCollectionBody
	// FcPortModifyCollectionBody
	// state
	// State
	// offlined_by_system
	// END DEBUGGING
	// FcPortModifyCollectionBodyStateOfflinedBySystem captures enum value "offlined_by_system"
	FcPortModifyCollectionBodyStateOfflinedBySystem string = "offlined_by_system"

	// BEGIN DEBUGGING
	// FcPortModifyCollectionBody
	// FcPortModifyCollectionBody
	// state
	// State
	// node_offline
	// END DEBUGGING
	// FcPortModifyCollectionBodyStateNodeOffline captures enum value "node_offline"
	FcPortModifyCollectionBodyStateNodeOffline string = "node_offline"

	// BEGIN DEBUGGING
	// FcPortModifyCollectionBody
	// FcPortModifyCollectionBody
	// state
	// State
	// unknown
	// END DEBUGGING
	// FcPortModifyCollectionBodyStateUnknown captures enum value "unknown"
	FcPortModifyCollectionBodyStateUnknown string = "unknown"
)

// prop value enum
func (o *FcPortModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcPortModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FcPortModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *FcPortModifyCollectionBody) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(o.Statistics) { // not required
		return nil
	}

	if o.Statistics != nil {
		if err := o.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

var fcPortModifyCollectionBodySupportedProtocolsItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","fc_nvme"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcPortModifyCollectionBodySupportedProtocolsItemsEnum = append(fcPortModifyCollectionBodySupportedProtocolsItemsEnum, v)
	}
}

func (o *FcPortModifyCollectionBody) validateSupportedProtocolsItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcPortModifyCollectionBodySupportedProtocolsItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FcPortModifyCollectionBody) validateSupportedProtocols(formats strfmt.Registry) error {
	if swag.IsZero(o.SupportedProtocols) { // not required
		return nil
	}

	for i := 0; i < len(o.SupportedProtocols); i++ {
		if swag.IsZero(o.SupportedProtocols[i]) { // not required
			continue
		}

		// value enum
		if err := o.validateSupportedProtocolsItemsEnum("info"+"."+"supported_protocols"+"."+strconv.Itoa(i), "body", *o.SupportedProtocols[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *FcPortModifyCollectionBody) validateTransceiver(formats strfmt.Registry) error {
	if swag.IsZero(o.Transceiver) { // not required
		return nil
	}

	if o.Transceiver != nil {
		if err := o.Transceiver.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "transceiver")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc port modify collection body based on the context it is used
func (o *FcPortModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFabric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFcPortResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInterfaceCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePhysicalProtocol(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpeed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSupportedProtocols(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTransceiver(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWwnn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWwpn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcPortModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortModifyCollectionBody) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"description", "body", o.Description); err != nil {
		return err
	}

	return nil
}

func (o *FcPortModifyCollectionBody) contextValidateFabric(ctx context.Context, formats strfmt.Registry) error {

	if o.Fabric != nil {
		if err := o.Fabric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "fabric")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortModifyCollectionBody) contextValidateFcPortResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.FcPortResponseInlineRecords); i++ {

		if o.FcPortResponseInlineRecords[i] != nil {
			if err := o.FcPortResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FcPortModifyCollectionBody) contextValidateInterfaceCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"interface_count", "body", o.InterfaceCount); err != nil {
		return err
	}

	return nil
}

func (o *FcPortModifyCollectionBody) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if o.Metric != nil {
		if err := o.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortModifyCollectionBody) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *FcPortModifyCollectionBody) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortModifyCollectionBody) contextValidatePhysicalProtocol(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"physical_protocol", "body", o.PhysicalProtocol); err != nil {
		return err
	}

	return nil
}

func (o *FcPortModifyCollectionBody) contextValidateSpeed(ctx context.Context, formats strfmt.Registry) error {

	if o.Speed != nil {
		if err := o.Speed.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "speed")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *FcPortModifyCollectionBody) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if o.Statistics != nil {
		if err := o.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortModifyCollectionBody) contextValidateSupportedProtocols(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"supported_protocols", "body", []*string(o.SupportedProtocols)); err != nil {
		return err
	}

	for i := 0; i < len(o.SupportedProtocols); i++ {

		if err := validate.ReadOnly(ctx, "info"+"."+"supported_protocols"+"."+strconv.Itoa(i), "body", o.SupportedProtocols[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *FcPortModifyCollectionBody) contextValidateTransceiver(ctx context.Context, formats strfmt.Registry) error {

	if o.Transceiver != nil {
		if err := o.Transceiver.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "transceiver")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *FcPortModifyCollectionBody) contextValidateWwnn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"wwnn", "body", o.Wwnn); err != nil {
		return err
	}

	return nil
}

func (o *FcPortModifyCollectionBody) contextValidateWwpn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"wwpn", "body", o.Wwpn); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcPortModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcPortModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res FcPortModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcPortInlineLinks fc port inline links
swagger:model fc_port_inline__links
*/
type FcPortInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this fc port inline links
func (o *FcPortInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcPortInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc port inline links based on the context it is used
func (o *FcPortInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcPortInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcPortInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcPortInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcPortInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcPortInlineFabric Properties of the fabric to which the FC port is attached.
//
swagger:model fc_port_inline_fabric
*/
type FcPortInlineFabric struct {

	// Reports if the physical port has established a connection with the FC fabric.
	//
	// Read Only: true
	Connected *bool `json:"connected,omitempty"`

	// The negotiated data rate between the target FC port and the fabric in gigabits per second.
	//
	// Example: 16
	// Read Only: true
	ConnectedSpeed *int64 `json:"connected_speed,omitempty"`

	// The name of the fabric to which the port is connected. This is only available when the FC port is connected to a fabric.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The FC port address of the host bus adapter (HBA) physical port.<br/>
	// Each FC port in an FC switched fabric has its own unique FC port address for routing purposes. The FC port address is assigned by a switch in the fabric when that port logs in to the fabric. This property refers to the FC port address given to the physical host bus adapter (HBA) port when the port performs a fabric login (FLOGI).<br/>
	// This is useful for obtaining statistics and diagnostic information from FC switches.<br/>
	// This is a six-digit hexadecimal encoded numeric value.
	//
	// Example: 52100A
	// Read Only: true
	PortAddress *string `json:"port_address,omitempty"`

	// The switch port to which the FC port is connected.
	//
	// Example: ssan-g620-03:33
	// Read Only: true
	SwitchPort *string `json:"switch_port,omitempty"`
}

// Validate validates this fc port inline fabric
func (o *FcPortInlineFabric) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc port inline fabric based on the context it is used
func (o *FcPortInlineFabric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateConnected(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConnectedSpeed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePortAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSwitchPort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcPortInlineFabric) contextValidateConnected(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"fabric"+"."+"connected", "body", o.Connected); err != nil {
		return err
	}

	return nil
}

func (o *FcPortInlineFabric) contextValidateConnectedSpeed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"fabric"+"."+"connected_speed", "body", o.ConnectedSpeed); err != nil {
		return err
	}

	return nil
}

func (o *FcPortInlineFabric) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"fabric"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *FcPortInlineFabric) contextValidatePortAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"fabric"+"."+"port_address", "body", o.PortAddress); err != nil {
		return err
	}

	return nil
}

func (o *FcPortInlineFabric) contextValidateSwitchPort(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"fabric"+"."+"switch_port", "body", o.SwitchPort); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcPortInlineFabric) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcPortInlineFabric) UnmarshalBinary(b []byte) error {
	var res FcPortInlineFabric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcPortInlineMetric Performance numbers, such as IOPS latency and throughput
swagger:model fc_port_inline_metric
*/
type FcPortInlineMetric struct {

	// links
	Links *models.FcPortInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *models.FcPortInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *models.FcPortInlineMetricInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *models.FcPortInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this fc port inline metric
func (o *FcPortInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcPortInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var fcPortInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcPortInlineMetricTypeDurationPropEnum = append(fcPortInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// FcPortInlineMetricDurationPT15S captures enum value "PT15S"
	FcPortInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// FcPortInlineMetricDurationPT4M captures enum value "PT4M"
	FcPortInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// FcPortInlineMetricDurationPT30M captures enum value "PT30M"
	FcPortInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// FcPortInlineMetricDurationPT2H captures enum value "PT2H"
	FcPortInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// FcPortInlineMetricDurationP1D captures enum value "P1D"
	FcPortInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// FcPortInlineMetricDurationPT5M captures enum value "PT5M"
	FcPortInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (o *FcPortInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcPortInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FcPortInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(o.Duration) { // not required
		return nil
	}

	// value enum
	if err := o.validateDurationEnum("info"+"."+"metric"+"."+"duration", "body", *o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *FcPortInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(o.Iops) { // not required
		return nil
	}

	if o.Iops != nil {
		if err := o.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(o.Latency) { // not required
		return nil
	}

	if o.Latency != nil {
		if err := o.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var fcPortInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcPortInlineMetricTypeStatusPropEnum = append(fcPortInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// FcPortInlineMetricStatusOk captures enum value "ok"
	FcPortInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// FcPortInlineMetricStatusError captures enum value "error"
	FcPortInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// FcPortInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	FcPortInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// FcPortInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	FcPortInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// FcPortInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	FcPortInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// FcPortInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	FcPortInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// FcPortInlineMetricStatusNotFound captures enum value "not_found"
	FcPortInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// FcPortInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	FcPortInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// FcPortInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	FcPortInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// FcPortInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	FcPortInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// FcPortInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	FcPortInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *FcPortInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcPortInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FcPortInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"metric"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *FcPortInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(o.Throughput) { // not required
		return nil
	}

	if o.Throughput != nil {
		if err := o.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"metric"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fc port inline metric based on the context it is used
func (o *FcPortInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcPortInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"duration", "body", o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *FcPortInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if o.Iops != nil {
		if err := o.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if o.Latency != nil {
		if err := o.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *FcPortInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if o.Throughput != nil {
		if err := o.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcPortInlineMetric) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcPortInlineMetric) UnmarshalBinary(b []byte) error {
	var res FcPortInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcPortInlineMetricInlineLinks fc port inline metric inline links
swagger:model fc_port_inline_metric_inline__links
*/
type FcPortInlineMetricInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this fc port inline metric inline links
func (o *FcPortInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcPortInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc port inline metric inline links based on the context it is used
func (o *FcPortInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcPortInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcPortInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcPortInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcPortInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcPortInlineMetricInlineIops The rate of I/O operations observed at the storage object.
swagger:model fc_port_inline_metric_inline_iops
*/
type FcPortInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc port inline metric inline iops
func (o *FcPortInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc port inline metric inline iops based on the context it is used
func (o *FcPortInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *FcPortInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcPortInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res FcPortInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcPortInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
swagger:model fc_port_inline_metric_inline_latency
*/
type FcPortInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc port inline metric inline latency
func (o *FcPortInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc port inline metric inline latency based on the context it is used
func (o *FcPortInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *FcPortInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcPortInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res FcPortInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcPortInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
swagger:model fc_port_inline_metric_inline_throughput
*/
type FcPortInlineMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc port inline metric inline throughput
func (o *FcPortInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc port inline metric inline throughput based on the context it is used
func (o *FcPortInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *FcPortInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcPortInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res FcPortInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcPortInlineNode fc port inline node
swagger:model fc_port_inline_node
*/
type FcPortInlineNode struct {

	// links
	Links *models.FcPortInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fc port inline node
func (o *FcPortInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcPortInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc port inline node based on the context it is used
func (o *FcPortInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcPortInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcPortInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcPortInlineNode) UnmarshalBinary(b []byte) error {
	var res FcPortInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcPortInlineNodeInlineLinks fc port inline node inline links
swagger:model fc_port_inline_node_inline__links
*/
type FcPortInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this fc port inline node inline links
func (o *FcPortInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcPortInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc port inline node inline links based on the context it is used
func (o *FcPortInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcPortInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcPortInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcPortInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcPortInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcPortInlineSpeed The physical device speed related properties of the FC port.
//
swagger:model fc_port_inline_speed
*/
type FcPortInlineSpeed struct {

	// The configured speed of the FC port in gigabits per second.
	//
	// Example: auto
	// Read Only: true
	// Enum: ["1","2","4","8","10","16","32","64","auto"]
	Configured *string `json:"configured,omitempty"`

	// The maximum speed supported by the FC port in gigabits per second.
	//
	// Example: 32
	// Read Only: true
	// Enum: ["1","2","4","8","10","16","32","64","auto"]
	Maximum *string `json:"maximum,omitempty"`
}

// Validate validates this fc port inline speed
func (o *FcPortInlineSpeed) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateConfigured(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaximum(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var fcPortInlineSpeedTypeConfiguredPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["1","2","4","8","10","16","32","64","auto"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcPortInlineSpeedTypeConfiguredPropEnum = append(fcPortInlineSpeedTypeConfiguredPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// configured
	// Configured
	// 1
	// END DEBUGGING
	// FcPortInlineSpeedConfiguredNr1 captures enum value "1"
	FcPortInlineSpeedConfiguredNr1 string = "1"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// configured
	// Configured
	// 2
	// END DEBUGGING
	// FcPortInlineSpeedConfiguredNr2 captures enum value "2"
	FcPortInlineSpeedConfiguredNr2 string = "2"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// configured
	// Configured
	// 4
	// END DEBUGGING
	// FcPortInlineSpeedConfiguredNr4 captures enum value "4"
	FcPortInlineSpeedConfiguredNr4 string = "4"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// configured
	// Configured
	// 8
	// END DEBUGGING
	// FcPortInlineSpeedConfiguredNr8 captures enum value "8"
	FcPortInlineSpeedConfiguredNr8 string = "8"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// configured
	// Configured
	// 10
	// END DEBUGGING
	// FcPortInlineSpeedConfiguredNr10 captures enum value "10"
	FcPortInlineSpeedConfiguredNr10 string = "10"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// configured
	// Configured
	// 16
	// END DEBUGGING
	// FcPortInlineSpeedConfiguredNr16 captures enum value "16"
	FcPortInlineSpeedConfiguredNr16 string = "16"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// configured
	// Configured
	// 32
	// END DEBUGGING
	// FcPortInlineSpeedConfiguredNr32 captures enum value "32"
	FcPortInlineSpeedConfiguredNr32 string = "32"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// configured
	// Configured
	// 64
	// END DEBUGGING
	// FcPortInlineSpeedConfiguredNr64 captures enum value "64"
	FcPortInlineSpeedConfiguredNr64 string = "64"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// configured
	// Configured
	// auto
	// END DEBUGGING
	// FcPortInlineSpeedConfiguredAuto captures enum value "auto"
	FcPortInlineSpeedConfiguredAuto string = "auto"
)

// prop value enum
func (o *FcPortInlineSpeed) validateConfiguredEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcPortInlineSpeedTypeConfiguredPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FcPortInlineSpeed) validateConfigured(formats strfmt.Registry) error {
	if swag.IsZero(o.Configured) { // not required
		return nil
	}

	// value enum
	if err := o.validateConfiguredEnum("info"+"."+"speed"+"."+"configured", "body", *o.Configured); err != nil {
		return err
	}

	return nil
}

var fcPortInlineSpeedTypeMaximumPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["1","2","4","8","10","16","32","64","auto"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcPortInlineSpeedTypeMaximumPropEnum = append(fcPortInlineSpeedTypeMaximumPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// maximum
	// Maximum
	// 1
	// END DEBUGGING
	// FcPortInlineSpeedMaximumNr1 captures enum value "1"
	FcPortInlineSpeedMaximumNr1 string = "1"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// maximum
	// Maximum
	// 2
	// END DEBUGGING
	// FcPortInlineSpeedMaximumNr2 captures enum value "2"
	FcPortInlineSpeedMaximumNr2 string = "2"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// maximum
	// Maximum
	// 4
	// END DEBUGGING
	// FcPortInlineSpeedMaximumNr4 captures enum value "4"
	FcPortInlineSpeedMaximumNr4 string = "4"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// maximum
	// Maximum
	// 8
	// END DEBUGGING
	// FcPortInlineSpeedMaximumNr8 captures enum value "8"
	FcPortInlineSpeedMaximumNr8 string = "8"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// maximum
	// Maximum
	// 10
	// END DEBUGGING
	// FcPortInlineSpeedMaximumNr10 captures enum value "10"
	FcPortInlineSpeedMaximumNr10 string = "10"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// maximum
	// Maximum
	// 16
	// END DEBUGGING
	// FcPortInlineSpeedMaximumNr16 captures enum value "16"
	FcPortInlineSpeedMaximumNr16 string = "16"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// maximum
	// Maximum
	// 32
	// END DEBUGGING
	// FcPortInlineSpeedMaximumNr32 captures enum value "32"
	FcPortInlineSpeedMaximumNr32 string = "32"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// maximum
	// Maximum
	// 64
	// END DEBUGGING
	// FcPortInlineSpeedMaximumNr64 captures enum value "64"
	FcPortInlineSpeedMaximumNr64 string = "64"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// maximum
	// Maximum
	// auto
	// END DEBUGGING
	// FcPortInlineSpeedMaximumAuto captures enum value "auto"
	FcPortInlineSpeedMaximumAuto string = "auto"
)

// prop value enum
func (o *FcPortInlineSpeed) validateMaximumEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcPortInlineSpeedTypeMaximumPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FcPortInlineSpeed) validateMaximum(formats strfmt.Registry) error {
	if swag.IsZero(o.Maximum) { // not required
		return nil
	}

	// value enum
	if err := o.validateMaximumEnum("info"+"."+"speed"+"."+"maximum", "body", *o.Maximum); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fc port inline speed based on the context it is used
func (o *FcPortInlineSpeed) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateConfigured(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMaximum(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcPortInlineSpeed) contextValidateConfigured(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"speed"+"."+"configured", "body", o.Configured); err != nil {
		return err
	}

	return nil
}

func (o *FcPortInlineSpeed) contextValidateMaximum(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"speed"+"."+"maximum", "body", o.Maximum); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcPortInlineSpeed) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcPortInlineSpeed) UnmarshalBinary(b []byte) error {
	var res FcPortInlineSpeed
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcPortInlineStatistics These are raw performance numbers, such as IOPS latency and throughput. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
swagger:model fc_port_inline_statistics
*/
type FcPortInlineStatistics struct {

	// iops raw
	IopsRaw *models.FcPortInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *models.FcPortInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *models.FcPortInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this fc port inline statistics
func (o *FcPortInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcPortInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.IopsRaw) { // not required
		return nil
	}

	if o.IopsRaw != nil {
		if err := o.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.LatencyRaw) { // not required
		return nil
	}

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var fcPortInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcPortInlineStatisticsTypeStatusPropEnum = append(fcPortInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// FcPortInlineStatisticsStatusOk captures enum value "ok"
	FcPortInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// FcPortInlineStatisticsStatusError captures enum value "error"
	FcPortInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// FcPortInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	FcPortInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// FcPortInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	FcPortInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// FcPortInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	FcPortInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// FcPortInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	FcPortInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// FcPortInlineStatisticsStatusNotFound captures enum value "not_found"
	FcPortInlineStatisticsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// FcPortInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	FcPortInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// FcPortInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	FcPortInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// FcPortInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	FcPortInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// FcPortInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	FcPortInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *FcPortInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcPortInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FcPortInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"statistics"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *FcPortInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.ThroughputRaw) { // not required
		return nil
	}

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"statistics"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fc port inline statistics based on the context it is used
func (o *FcPortInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcPortInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.IopsRaw != nil {
		if err := o.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *FcPortInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *FcPortInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcPortInlineStatistics) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcPortInlineStatistics) UnmarshalBinary(b []byte) error {
	var res FcPortInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcPortInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
swagger:model fc_port_inline_statistics_inline_iops_raw
*/
type FcPortInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc port inline statistics inline iops raw
func (o *FcPortInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc port inline statistics inline iops raw based on the context it is used
func (o *FcPortInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *FcPortInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcPortInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res FcPortInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcPortInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
swagger:model fc_port_inline_statistics_inline_latency_raw
*/
type FcPortInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc port inline statistics inline latency raw
func (o *FcPortInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc port inline statistics inline latency raw based on the context it is used
func (o *FcPortInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *FcPortInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcPortInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res FcPortInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcPortInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
swagger:model fc_port_inline_statistics_inline_throughput_raw
*/
type FcPortInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc port inline statistics inline throughput raw
func (o *FcPortInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc port inline statistics inline throughput raw based on the context it is used
func (o *FcPortInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *FcPortInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcPortInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res FcPortInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcPortInlineTransceiver Properties of the transceiver connected to the FC port.
//
swagger:model fc_port_inline_transceiver
*/
type FcPortInlineTransceiver struct {

	// The speeds of which the transceiver is capable in gigabits per second.
	//
	// Read Only: true
	Capabilities []*int64 `json:"capabilities,omitempty"`

	// The form factor of the transceiver. Possible values are:
	// - _sfp_ - Small Form Factor - Pluggable
	// - _sff_ - Small Form Factor
	// - _unknown_ - Unknown
	//
	// Read Only: true
	// Enum: ["sfp","sff","unknown"]
	FormFactor *string `json:"form_factor,omitempty"`

	// The manufacturer of the transceiver.
	//
	// Example: Acme, Inc.
	// Read Only: true
	Manufacturer *string `json:"manufacturer,omitempty"`

	// The part number of the transceiver.
	// Read Only: true
	PartNumber *string `json:"part_number,omitempty"`
}

// Validate validates this fc port inline transceiver
func (o *FcPortInlineTransceiver) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCapabilities(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFormFactor(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var fcPortInlineTransceiverCapabilitiesItemsEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[1,2,4,8,10,16,32,64]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcPortInlineTransceiverCapabilitiesItemsEnum = append(fcPortInlineTransceiverCapabilitiesItemsEnum, v)
	}
}

func (o *FcPortInlineTransceiver) validateCapabilitiesItemsEnum(path, location string, value int64) error {
	if err := validate.EnumCase(path, location, value, fcPortInlineTransceiverCapabilitiesItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FcPortInlineTransceiver) validateCapabilities(formats strfmt.Registry) error {
	if swag.IsZero(o.Capabilities) { // not required
		return nil
	}

	for i := 0; i < len(o.Capabilities); i++ {
		if swag.IsZero(o.Capabilities[i]) { // not required
			continue
		}

		// value enum
		if err := o.validateCapabilitiesItemsEnum("info"+"."+"transceiver"+"."+"capabilities"+"."+strconv.Itoa(i), "body", *o.Capabilities[i]); err != nil {
			return err
		}

	}

	return nil
}

var fcPortInlineTransceiverTypeFormFactorPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sfp","sff","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcPortInlineTransceiverTypeFormFactorPropEnum = append(fcPortInlineTransceiverTypeFormFactorPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_port_inline_transceiver
	// FcPortInlineTransceiver
	// form_factor
	// FormFactor
	// sfp
	// END DEBUGGING
	// FcPortInlineTransceiverFormFactorSfp captures enum value "sfp"
	FcPortInlineTransceiverFormFactorSfp string = "sfp"

	// BEGIN DEBUGGING
	// fc_port_inline_transceiver
	// FcPortInlineTransceiver
	// form_factor
	// FormFactor
	// sff
	// END DEBUGGING
	// FcPortInlineTransceiverFormFactorSff captures enum value "sff"
	FcPortInlineTransceiverFormFactorSff string = "sff"

	// BEGIN DEBUGGING
	// fc_port_inline_transceiver
	// FcPortInlineTransceiver
	// form_factor
	// FormFactor
	// unknown
	// END DEBUGGING
	// FcPortInlineTransceiverFormFactorUnknown captures enum value "unknown"
	FcPortInlineTransceiverFormFactorUnknown string = "unknown"
)

// prop value enum
func (o *FcPortInlineTransceiver) validateFormFactorEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcPortInlineTransceiverTypeFormFactorPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FcPortInlineTransceiver) validateFormFactor(formats strfmt.Registry) error {
	if swag.IsZero(o.FormFactor) { // not required
		return nil
	}

	// value enum
	if err := o.validateFormFactorEnum("info"+"."+"transceiver"+"."+"form_factor", "body", *o.FormFactor); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fc port inline transceiver based on the context it is used
func (o *FcPortInlineTransceiver) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCapabilities(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFormFactor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateManufacturer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePartNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcPortInlineTransceiver) contextValidateCapabilities(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"transceiver"+"."+"capabilities", "body", []*int64(o.Capabilities)); err != nil {
		return err
	}

	for i := 0; i < len(o.Capabilities); i++ {

		if err := validate.ReadOnly(ctx, "info"+"."+"transceiver"+"."+"capabilities"+"."+strconv.Itoa(i), "body", o.Capabilities[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *FcPortInlineTransceiver) contextValidateFormFactor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"transceiver"+"."+"form_factor", "body", o.FormFactor); err != nil {
		return err
	}

	return nil
}

func (o *FcPortInlineTransceiver) contextValidateManufacturer(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"transceiver"+"."+"manufacturer", "body", o.Manufacturer); err != nil {
		return err
	}

	return nil
}

func (o *FcPortInlineTransceiver) contextValidatePartNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"transceiver"+"."+"part_number", "body", o.PartNumber); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcPortInlineTransceiver) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcPortInlineTransceiver) UnmarshalBinary(b []byte) error {
	var res FcPortInlineTransceiver
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
