// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FcPortModifyReader is a Reader for the FcPortModify structure.
type FcPortModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FcPortModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFcPortModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFcPortModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFcPortModifyOK creates a FcPortModifyOK with default headers values
func NewFcPortModifyOK() *FcPortModifyOK {
	return &FcPortModifyOK{}
}

/*
FcPortModifyOK describes a response with status code 200, with default header values.

OK
*/
type FcPortModifyOK struct {
}

// IsSuccess returns true when this fc port modify o k response has a 2xx status code
func (o *FcPortModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fc port modify o k response has a 3xx status code
func (o *FcPortModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fc port modify o k response has a 4xx status code
func (o *FcPortModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fc port modify o k response has a 5xx status code
func (o *FcPortModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fc port modify o k response a status code equal to that given
func (o *FcPortModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fc port modify o k response
func (o *FcPortModifyOK) Code() int {
	return 200
}

func (o *FcPortModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /network/fc/ports/{uuid}][%d] fcPortModifyOK", 200)
}

func (o *FcPortModifyOK) String() string {
	return fmt.Sprintf("[PATCH /network/fc/ports/{uuid}][%d] fcPortModifyOK", 200)
}

func (o *FcPortModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewFcPortModifyDefault creates a FcPortModifyDefault with default headers values
func NewFcPortModifyDefault(code int) *FcPortModifyDefault {
	return &FcPortModifyDefault{
		_statusCode: code,
	}
}

/*
	FcPortModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5374085    | The node where the Fibre Channel port is located is offline. |
| 5374087    | The Fibre Channel port has active Fibre Channel interfaces and cannot be disabled. |
*/
type FcPortModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fc port modify default response has a 2xx status code
func (o *FcPortModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fc port modify default response has a 3xx status code
func (o *FcPortModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fc port modify default response has a 4xx status code
func (o *FcPortModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fc port modify default response has a 5xx status code
func (o *FcPortModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fc port modify default response a status code equal to that given
func (o *FcPortModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fc port modify default response
func (o *FcPortModifyDefault) Code() int {
	return o._statusCode
}

func (o *FcPortModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/fc/ports/{uuid}][%d] fc_port_modify default %s", o._statusCode, payload)
}

func (o *FcPortModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/fc/ports/{uuid}][%d] fc_port_modify default %s", o._statusCode, payload)
}

func (o *FcPortModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FcPortModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
