// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFcSwitchCollectionGetParams creates a new FcSwitchCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFcSwitchCollectionGetParams() *FcSwitchCollectionGetParams {
	return &FcSwitchCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFcSwitchCollectionGetParamsWithTimeout creates a new FcSwitchCollectionGetParams object
// with the ability to set a timeout on a request.
func NewFcSwitchCollectionGetParamsWithTimeout(timeout time.Duration) *FcSwitchCollectionGetParams {
	return &FcSwitchCollectionGetParams{
		timeout: timeout,
	}
}

// NewFcSwitchCollectionGetParamsWithContext creates a new FcSwitchCollectionGetParams object
// with the ability to set a context for a request.
func NewFcSwitchCollectionGetParamsWithContext(ctx context.Context) *FcSwitchCollectionGetParams {
	return &FcSwitchCollectionGetParams{
		Context: ctx,
	}
}

// NewFcSwitchCollectionGetParamsWithHTTPClient creates a new FcSwitchCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewFcSwitchCollectionGetParamsWithHTTPClient(client *http.Client) *FcSwitchCollectionGetParams {
	return &FcSwitchCollectionGetParams{
		HTTPClient: client,
	}
}

/*
FcSwitchCollectionGetParams contains all the parameters to send to the API endpoint

	for the fc switch collection get operation.

	Typically these are written to a http.Request.
*/
type FcSwitchCollectionGetParams struct {

	/* CacheAge.

	   Filter by cache.age
	*/
	CacheAge *string

	/* CacheIsCurrent.

	   Filter by cache.is_current
	*/
	CacheIsCurrent *bool

	/* CacheMaximumAge.

	   The maximum age of data in the Fibre Channel fabric cache before it should be refreshed from the fabric. The default is 15 minutes.

	   Format: iso8601
	   Default: "15 minutes"
	*/
	CacheMaximumAge *string

	/* CacheUpdateTime.

	   Filter by cache.update_time
	*/
	CacheUpdateTime *string

	/* DomainID.

	   Filter by domain_id
	*/
	DomainID *int64

	/* FabricName.

	   The WWN of the primary switch of the Fibre Channel fabric.

	*/
	FabricName string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PortsAttachedDevicePortID.

	   Filter by ports.attached_device.port_id
	*/
	PortsAttachedDevicePortID *string

	/* PortsAttachedDeviceWwpn.

	   Filter by ports.attached_device.wwpn
	*/
	PortsAttachedDeviceWwpn *string

	/* PortsSlot.

	   Filter by ports.slot
	*/
	PortsSlot *string

	/* PortsState.

	   Filter by ports.state
	*/
	PortsState *string

	/* PortsType.

	   Filter by ports.type
	*/
	PortsType *string

	/* PortsWwpn.

	   Filter by ports.wwpn
	*/
	PortsWwpn *string

	/* Release.

	   Filter by release
	*/
	Release *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Vendor.

	   Filter by vendor
	*/
	Vendor *string

	/* Wwn.

	   Filter by wwn
	*/
	Wwn *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the fc switch collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FcSwitchCollectionGetParams) WithDefaults() *FcSwitchCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the fc switch collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FcSwitchCollectionGetParams) SetDefaults() {
	var (
		cacheMaximumAgeDefault = string("15 minutes")

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := FcSwitchCollectionGetParams{
		CacheMaximumAge: &cacheMaximumAgeDefault,
		ReturnRecords:   &returnRecordsDefault,
		ReturnTimeout:   &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithTimeout(timeout time.Duration) *FcSwitchCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithContext(ctx context.Context) *FcSwitchCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithHTTPClient(client *http.Client) *FcSwitchCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCacheAge adds the cacheAge to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithCacheAge(cacheAge *string) *FcSwitchCollectionGetParams {
	o.SetCacheAge(cacheAge)
	return o
}

// SetCacheAge adds the cacheAge to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetCacheAge(cacheAge *string) {
	o.CacheAge = cacheAge
}

// WithCacheIsCurrent adds the cacheIsCurrent to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithCacheIsCurrent(cacheIsCurrent *bool) *FcSwitchCollectionGetParams {
	o.SetCacheIsCurrent(cacheIsCurrent)
	return o
}

// SetCacheIsCurrent adds the cacheIsCurrent to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetCacheIsCurrent(cacheIsCurrent *bool) {
	o.CacheIsCurrent = cacheIsCurrent
}

// WithCacheMaximumAge adds the cacheMaximumAge to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithCacheMaximumAge(cacheMaximumAge *string) *FcSwitchCollectionGetParams {
	o.SetCacheMaximumAge(cacheMaximumAge)
	return o
}

// SetCacheMaximumAge adds the cacheMaximumAge to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetCacheMaximumAge(cacheMaximumAge *string) {
	o.CacheMaximumAge = cacheMaximumAge
}

// WithCacheUpdateTime adds the cacheUpdateTime to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithCacheUpdateTime(cacheUpdateTime *string) *FcSwitchCollectionGetParams {
	o.SetCacheUpdateTime(cacheUpdateTime)
	return o
}

// SetCacheUpdateTime adds the cacheUpdateTime to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetCacheUpdateTime(cacheUpdateTime *string) {
	o.CacheUpdateTime = cacheUpdateTime
}

// WithDomainID adds the domainID to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithDomainID(domainID *int64) *FcSwitchCollectionGetParams {
	o.SetDomainID(domainID)
	return o
}

// SetDomainID adds the domainId to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetDomainID(domainID *int64) {
	o.DomainID = domainID
}

// WithFabricName adds the fabricName to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithFabricName(fabricName string) *FcSwitchCollectionGetParams {
	o.SetFabricName(fabricName)
	return o
}

// SetFabricName adds the fabricName to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetFabricName(fabricName string) {
	o.FabricName = fabricName
}

// WithFields adds the fields to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithFields(fields []string) *FcSwitchCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithMaxRecords(maxRecords *int64) *FcSwitchCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithName(name *string) *FcSwitchCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithOrderBy(orderBy []string) *FcSwitchCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPortsAttachedDevicePortID adds the portsAttachedDevicePortID to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithPortsAttachedDevicePortID(portsAttachedDevicePortID *string) *FcSwitchCollectionGetParams {
	o.SetPortsAttachedDevicePortID(portsAttachedDevicePortID)
	return o
}

// SetPortsAttachedDevicePortID adds the portsAttachedDevicePortId to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetPortsAttachedDevicePortID(portsAttachedDevicePortID *string) {
	o.PortsAttachedDevicePortID = portsAttachedDevicePortID
}

// WithPortsAttachedDeviceWwpn adds the portsAttachedDeviceWwpn to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithPortsAttachedDeviceWwpn(portsAttachedDeviceWwpn *string) *FcSwitchCollectionGetParams {
	o.SetPortsAttachedDeviceWwpn(portsAttachedDeviceWwpn)
	return o
}

// SetPortsAttachedDeviceWwpn adds the portsAttachedDeviceWwpn to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetPortsAttachedDeviceWwpn(portsAttachedDeviceWwpn *string) {
	o.PortsAttachedDeviceWwpn = portsAttachedDeviceWwpn
}

// WithPortsSlot adds the portsSlot to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithPortsSlot(portsSlot *string) *FcSwitchCollectionGetParams {
	o.SetPortsSlot(portsSlot)
	return o
}

// SetPortsSlot adds the portsSlot to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetPortsSlot(portsSlot *string) {
	o.PortsSlot = portsSlot
}

// WithPortsState adds the portsState to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithPortsState(portsState *string) *FcSwitchCollectionGetParams {
	o.SetPortsState(portsState)
	return o
}

// SetPortsState adds the portsState to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetPortsState(portsState *string) {
	o.PortsState = portsState
}

// WithPortsType adds the portsType to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithPortsType(portsType *string) *FcSwitchCollectionGetParams {
	o.SetPortsType(portsType)
	return o
}

// SetPortsType adds the portsType to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetPortsType(portsType *string) {
	o.PortsType = portsType
}

// WithPortsWwpn adds the portsWwpn to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithPortsWwpn(portsWwpn *string) *FcSwitchCollectionGetParams {
	o.SetPortsWwpn(portsWwpn)
	return o
}

// SetPortsWwpn adds the portsWwpn to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetPortsWwpn(portsWwpn *string) {
	o.PortsWwpn = portsWwpn
}

// WithRelease adds the release to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithRelease(release *string) *FcSwitchCollectionGetParams {
	o.SetRelease(release)
	return o
}

// SetRelease adds the release to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetRelease(release *string) {
	o.Release = release
}

// WithReturnRecords adds the returnRecords to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithReturnRecords(returnRecords *bool) *FcSwitchCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *FcSwitchCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithVendor adds the vendor to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithVendor(vendor *string) *FcSwitchCollectionGetParams {
	o.SetVendor(vendor)
	return o
}

// SetVendor adds the vendor to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetVendor(vendor *string) {
	o.Vendor = vendor
}

// WithWwn adds the wwn to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) WithWwn(wwn *string) *FcSwitchCollectionGetParams {
	o.SetWwn(wwn)
	return o
}

// SetWwn adds the wwn to the fc switch collection get params
func (o *FcSwitchCollectionGetParams) SetWwn(wwn *string) {
	o.Wwn = wwn
}

// WriteToRequest writes these params to a swagger request
func (o *FcSwitchCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CacheAge != nil {

		// query param cache.age
		var qrCacheAge string

		if o.CacheAge != nil {
			qrCacheAge = *o.CacheAge
		}
		qCacheAge := qrCacheAge
		if qCacheAge != "" {

			if err := r.SetQueryParam("cache.age", qCacheAge); err != nil {
				return err
			}
		}
	}

	if o.CacheIsCurrent != nil {

		// query param cache.is_current
		var qrCacheIsCurrent bool

		if o.CacheIsCurrent != nil {
			qrCacheIsCurrent = *o.CacheIsCurrent
		}
		qCacheIsCurrent := swag.FormatBool(qrCacheIsCurrent)
		if qCacheIsCurrent != "" {

			if err := r.SetQueryParam("cache.is_current", qCacheIsCurrent); err != nil {
				return err
			}
		}
	}

	if o.CacheMaximumAge != nil {

		// query param cache.maximum_age
		var qrCacheMaximumAge string

		if o.CacheMaximumAge != nil {
			qrCacheMaximumAge = *o.CacheMaximumAge
		}
		qCacheMaximumAge := qrCacheMaximumAge
		if qCacheMaximumAge != "" {

			if err := r.SetQueryParam("cache.maximum_age", qCacheMaximumAge); err != nil {
				return err
			}
		}
	}

	if o.CacheUpdateTime != nil {

		// query param cache.update_time
		var qrCacheUpdateTime string

		if o.CacheUpdateTime != nil {
			qrCacheUpdateTime = *o.CacheUpdateTime
		}
		qCacheUpdateTime := qrCacheUpdateTime
		if qCacheUpdateTime != "" {

			if err := r.SetQueryParam("cache.update_time", qCacheUpdateTime); err != nil {
				return err
			}
		}
	}

	if o.DomainID != nil {

		// query param domain_id
		var qrDomainID int64

		if o.DomainID != nil {
			qrDomainID = *o.DomainID
		}
		qDomainID := swag.FormatInt64(qrDomainID)
		if qDomainID != "" {

			if err := r.SetQueryParam("domain_id", qDomainID); err != nil {
				return err
			}
		}
	}

	// path param fabric.name
	if err := r.SetPathParam("fabric.name", o.FabricName); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PortsAttachedDevicePortID != nil {

		// query param ports.attached_device.port_id
		var qrPortsAttachedDevicePortID string

		if o.PortsAttachedDevicePortID != nil {
			qrPortsAttachedDevicePortID = *o.PortsAttachedDevicePortID
		}
		qPortsAttachedDevicePortID := qrPortsAttachedDevicePortID
		if qPortsAttachedDevicePortID != "" {

			if err := r.SetQueryParam("ports.attached_device.port_id", qPortsAttachedDevicePortID); err != nil {
				return err
			}
		}
	}

	if o.PortsAttachedDeviceWwpn != nil {

		// query param ports.attached_device.wwpn
		var qrPortsAttachedDeviceWwpn string

		if o.PortsAttachedDeviceWwpn != nil {
			qrPortsAttachedDeviceWwpn = *o.PortsAttachedDeviceWwpn
		}
		qPortsAttachedDeviceWwpn := qrPortsAttachedDeviceWwpn
		if qPortsAttachedDeviceWwpn != "" {

			if err := r.SetQueryParam("ports.attached_device.wwpn", qPortsAttachedDeviceWwpn); err != nil {
				return err
			}
		}
	}

	if o.PortsSlot != nil {

		// query param ports.slot
		var qrPortsSlot string

		if o.PortsSlot != nil {
			qrPortsSlot = *o.PortsSlot
		}
		qPortsSlot := qrPortsSlot
		if qPortsSlot != "" {

			if err := r.SetQueryParam("ports.slot", qPortsSlot); err != nil {
				return err
			}
		}
	}

	if o.PortsState != nil {

		// query param ports.state
		var qrPortsState string

		if o.PortsState != nil {
			qrPortsState = *o.PortsState
		}
		qPortsState := qrPortsState
		if qPortsState != "" {

			if err := r.SetQueryParam("ports.state", qPortsState); err != nil {
				return err
			}
		}
	}

	if o.PortsType != nil {

		// query param ports.type
		var qrPortsType string

		if o.PortsType != nil {
			qrPortsType = *o.PortsType
		}
		qPortsType := qrPortsType
		if qPortsType != "" {

			if err := r.SetQueryParam("ports.type", qPortsType); err != nil {
				return err
			}
		}
	}

	if o.PortsWwpn != nil {

		// query param ports.wwpn
		var qrPortsWwpn string

		if o.PortsWwpn != nil {
			qrPortsWwpn = *o.PortsWwpn
		}
		qPortsWwpn := qrPortsWwpn
		if qPortsWwpn != "" {

			if err := r.SetQueryParam("ports.wwpn", qPortsWwpn); err != nil {
				return err
			}
		}
	}

	if o.Release != nil {

		// query param release
		var qrRelease string

		if o.Release != nil {
			qrRelease = *o.Release
		}
		qRelease := qrRelease
		if qRelease != "" {

			if err := r.SetQueryParam("release", qRelease); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Vendor != nil {

		// query param vendor
		var qrVendor string

		if o.Vendor != nil {
			qrVendor = *o.Vendor
		}
		qVendor := qrVendor
		if qVendor != "" {

			if err := r.SetQueryParam("vendor", qVendor); err != nil {
				return err
			}
		}
	}

	if o.Wwn != nil {

		// query param wwn
		var qrWwn string

		if o.Wwn != nil {
			qrWwn = *o.Wwn
		}
		qWwn := qrWwn
		if qWwn != "" {

			if err := r.SetQueryParam("wwn", qWwn); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamFcSwitchCollectionGet binds the parameter fields
func (o *FcSwitchCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamFcSwitchCollectionGet binds the parameter order_by
func (o *FcSwitchCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
