// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FcSwitchCollectionGetReader is a Reader for the FcSwitchCollectionGet structure.
type FcSwitchCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FcSwitchCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFcSwitchCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFcSwitchCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFcSwitchCollectionGetOK creates a FcSwitchCollectionGetOK with default headers values
func NewFcSwitchCollectionGetOK() *FcSwitchCollectionGetOK {
	return &FcSwitchCollectionGetOK{}
}

/*
FcSwitchCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type FcSwitchCollectionGetOK struct {
	Payload *models.FcSwitchResponse
}

// IsSuccess returns true when this fc switch collection get o k response has a 2xx status code
func (o *FcSwitchCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fc switch collection get o k response has a 3xx status code
func (o *FcSwitchCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fc switch collection get o k response has a 4xx status code
func (o *FcSwitchCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fc switch collection get o k response has a 5xx status code
func (o *FcSwitchCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fc switch collection get o k response a status code equal to that given
func (o *FcSwitchCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fc switch collection get o k response
func (o *FcSwitchCollectionGetOK) Code() int {
	return 200
}

func (o *FcSwitchCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/fabrics/{fabric.name}/switches][%d] fcSwitchCollectionGetOK %s", 200, payload)
}

func (o *FcSwitchCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/fabrics/{fabric.name}/switches][%d] fcSwitchCollectionGetOK %s", 200, payload)
}

func (o *FcSwitchCollectionGetOK) GetPayload() *models.FcSwitchResponse {
	return o.Payload
}

func (o *FcSwitchCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.FcSwitchResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFcSwitchCollectionGetDefault creates a FcSwitchCollectionGetDefault with default headers values
func NewFcSwitchCollectionGetDefault(code int) *FcSwitchCollectionGetDefault {
	return &FcSwitchCollectionGetDefault{
		_statusCode: code,
	}
}

/*
	FcSwitchCollectionGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5373982 | An invalid WWN was specified. The length is incorrect. |
| 5373983 | An invalid WWN was specified. The format is incorrect. |
| 5375053 | The Fibre Channel fabric specified by name in the request URI was not found in the FC fabric cache. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type FcSwitchCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fc switch collection get default response has a 2xx status code
func (o *FcSwitchCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fc switch collection get default response has a 3xx status code
func (o *FcSwitchCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fc switch collection get default response has a 4xx status code
func (o *FcSwitchCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fc switch collection get default response has a 5xx status code
func (o *FcSwitchCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fc switch collection get default response a status code equal to that given
func (o *FcSwitchCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fc switch collection get default response
func (o *FcSwitchCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *FcSwitchCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/fabrics/{fabric.name}/switches][%d] fc_switch_collection_get default %s", o._statusCode, payload)
}

func (o *FcSwitchCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/fabrics/{fabric.name}/switches][%d] fc_switch_collection_get default %s", o._statusCode, payload)
}

func (o *FcSwitchCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FcSwitchCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
