// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFcSwitchGetParams creates a new FcSwitchGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFcSwitchGetParams() *FcSwitchGetParams {
	return &FcSwitchGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFcSwitchGetParamsWithTimeout creates a new FcSwitchGetParams object
// with the ability to set a timeout on a request.
func NewFcSwitchGetParamsWithTimeout(timeout time.Duration) *FcSwitchGetParams {
	return &FcSwitchGetParams{
		timeout: timeout,
	}
}

// NewFcSwitchGetParamsWithContext creates a new FcSwitchGetParams object
// with the ability to set a context for a request.
func NewFcSwitchGetParamsWithContext(ctx context.Context) *FcSwitchGetParams {
	return &FcSwitchGetParams{
		Context: ctx,
	}
}

// NewFcSwitchGetParamsWithHTTPClient creates a new FcSwitchGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewFcSwitchGetParamsWithHTTPClient(client *http.Client) *FcSwitchGetParams {
	return &FcSwitchGetParams{
		HTTPClient: client,
	}
}

/*
FcSwitchGetParams contains all the parameters to send to the API endpoint

	for the fc switch get operation.

	Typically these are written to a http.Request.
*/
type FcSwitchGetParams struct {

	/* CacheMaximumAge.

	   The maximum age of data in the Fibre Channel fabric cache before it should be refreshed from the fabric. The default is 15 minutes.

	   Format: iso8601
	   Default: "15 minutes"
	*/
	CacheMaximumAge *string

	/* FabricName.

	   The WWN of the primary switch of the Fibre Channel fabric.

	*/
	FabricName string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Wwn.

	   The WWN of the Fibre Channel switch.

	*/
	Wwn string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the fc switch get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FcSwitchGetParams) WithDefaults() *FcSwitchGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the fc switch get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FcSwitchGetParams) SetDefaults() {
	var (
		cacheMaximumAgeDefault = string("15 minutes")
	)

	val := FcSwitchGetParams{
		CacheMaximumAge: &cacheMaximumAgeDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the fc switch get params
func (o *FcSwitchGetParams) WithTimeout(timeout time.Duration) *FcSwitchGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the fc switch get params
func (o *FcSwitchGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the fc switch get params
func (o *FcSwitchGetParams) WithContext(ctx context.Context) *FcSwitchGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the fc switch get params
func (o *FcSwitchGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the fc switch get params
func (o *FcSwitchGetParams) WithHTTPClient(client *http.Client) *FcSwitchGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the fc switch get params
func (o *FcSwitchGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCacheMaximumAge adds the cacheMaximumAge to the fc switch get params
func (o *FcSwitchGetParams) WithCacheMaximumAge(cacheMaximumAge *string) *FcSwitchGetParams {
	o.SetCacheMaximumAge(cacheMaximumAge)
	return o
}

// SetCacheMaximumAge adds the cacheMaximumAge to the fc switch get params
func (o *FcSwitchGetParams) SetCacheMaximumAge(cacheMaximumAge *string) {
	o.CacheMaximumAge = cacheMaximumAge
}

// WithFabricName adds the fabricName to the fc switch get params
func (o *FcSwitchGetParams) WithFabricName(fabricName string) *FcSwitchGetParams {
	o.SetFabricName(fabricName)
	return o
}

// SetFabricName adds the fabricName to the fc switch get params
func (o *FcSwitchGetParams) SetFabricName(fabricName string) {
	o.FabricName = fabricName
}

// WithFields adds the fields to the fc switch get params
func (o *FcSwitchGetParams) WithFields(fields []string) *FcSwitchGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the fc switch get params
func (o *FcSwitchGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithWwn adds the wwn to the fc switch get params
func (o *FcSwitchGetParams) WithWwn(wwn string) *FcSwitchGetParams {
	o.SetWwn(wwn)
	return o
}

// SetWwn adds the wwn to the fc switch get params
func (o *FcSwitchGetParams) SetWwn(wwn string) {
	o.Wwn = wwn
}

// WriteToRequest writes these params to a swagger request
func (o *FcSwitchGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CacheMaximumAge != nil {

		// query param cache.maximum_age
		var qrCacheMaximumAge string

		if o.CacheMaximumAge != nil {
			qrCacheMaximumAge = *o.CacheMaximumAge
		}
		qCacheMaximumAge := qrCacheMaximumAge
		if qCacheMaximumAge != "" {

			if err := r.SetQueryParam("cache.maximum_age", qCacheMaximumAge); err != nil {
				return err
			}
		}
	}

	// path param fabric.name
	if err := r.SetPathParam("fabric.name", o.FabricName); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param wwn
	if err := r.SetPathParam("wwn", o.Wwn); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamFcSwitchGet binds the parameter fields
func (o *FcSwitchGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
