// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFcZoneCollectionGetParams creates a new FcZoneCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFcZoneCollectionGetParams() *FcZoneCollectionGetParams {
	return &FcZoneCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFcZoneCollectionGetParamsWithTimeout creates a new FcZoneCollectionGetParams object
// with the ability to set a timeout on a request.
func NewFcZoneCollectionGetParamsWithTimeout(timeout time.Duration) *FcZoneCollectionGetParams {
	return &FcZoneCollectionGetParams{
		timeout: timeout,
	}
}

// NewFcZoneCollectionGetParamsWithContext creates a new FcZoneCollectionGetParams object
// with the ability to set a context for a request.
func NewFcZoneCollectionGetParamsWithContext(ctx context.Context) *FcZoneCollectionGetParams {
	return &FcZoneCollectionGetParams{
		Context: ctx,
	}
}

// NewFcZoneCollectionGetParamsWithHTTPClient creates a new FcZoneCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewFcZoneCollectionGetParamsWithHTTPClient(client *http.Client) *FcZoneCollectionGetParams {
	return &FcZoneCollectionGetParams{
		HTTPClient: client,
	}
}

/*
FcZoneCollectionGetParams contains all the parameters to send to the API endpoint

	for the fc zone collection get operation.

	Typically these are written to a http.Request.
*/
type FcZoneCollectionGetParams struct {

	/* CacheAge.

	   Filter by cache.age
	*/
	CacheAge *string

	/* CacheIsCurrent.

	   Filter by cache.is_current
	*/
	CacheIsCurrent *bool

	/* CacheMaximumAge.

	   The maximum age of data in the Fibre Channel fabric cache before it should be refreshed from the fabric. The default is 15 minutes.

	   Format: iso8601
	   Default: "15 minutes"
	*/
	CacheMaximumAge *string

	/* CacheUpdateTime.

	   Filter by cache.update_time
	*/
	CacheUpdateTime *string

	/* FabricName.

	   The WWN of the primary switch of the Fibre Channel fabric.

	*/
	FabricName string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* MembersName.

	   Filter by members.name
	*/
	MembersName *string

	/* MembersType.

	   Filter by members.type
	*/
	MembersType *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the fc zone collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FcZoneCollectionGetParams) WithDefaults() *FcZoneCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the fc zone collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FcZoneCollectionGetParams) SetDefaults() {
	var (
		cacheMaximumAgeDefault = string("15 minutes")

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := FcZoneCollectionGetParams{
		CacheMaximumAge: &cacheMaximumAgeDefault,
		ReturnRecords:   &returnRecordsDefault,
		ReturnTimeout:   &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the fc zone collection get params
func (o *FcZoneCollectionGetParams) WithTimeout(timeout time.Duration) *FcZoneCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the fc zone collection get params
func (o *FcZoneCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the fc zone collection get params
func (o *FcZoneCollectionGetParams) WithContext(ctx context.Context) *FcZoneCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the fc zone collection get params
func (o *FcZoneCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the fc zone collection get params
func (o *FcZoneCollectionGetParams) WithHTTPClient(client *http.Client) *FcZoneCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the fc zone collection get params
func (o *FcZoneCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCacheAge adds the cacheAge to the fc zone collection get params
func (o *FcZoneCollectionGetParams) WithCacheAge(cacheAge *string) *FcZoneCollectionGetParams {
	o.SetCacheAge(cacheAge)
	return o
}

// SetCacheAge adds the cacheAge to the fc zone collection get params
func (o *FcZoneCollectionGetParams) SetCacheAge(cacheAge *string) {
	o.CacheAge = cacheAge
}

// WithCacheIsCurrent adds the cacheIsCurrent to the fc zone collection get params
func (o *FcZoneCollectionGetParams) WithCacheIsCurrent(cacheIsCurrent *bool) *FcZoneCollectionGetParams {
	o.SetCacheIsCurrent(cacheIsCurrent)
	return o
}

// SetCacheIsCurrent adds the cacheIsCurrent to the fc zone collection get params
func (o *FcZoneCollectionGetParams) SetCacheIsCurrent(cacheIsCurrent *bool) {
	o.CacheIsCurrent = cacheIsCurrent
}

// WithCacheMaximumAge adds the cacheMaximumAge to the fc zone collection get params
func (o *FcZoneCollectionGetParams) WithCacheMaximumAge(cacheMaximumAge *string) *FcZoneCollectionGetParams {
	o.SetCacheMaximumAge(cacheMaximumAge)
	return o
}

// SetCacheMaximumAge adds the cacheMaximumAge to the fc zone collection get params
func (o *FcZoneCollectionGetParams) SetCacheMaximumAge(cacheMaximumAge *string) {
	o.CacheMaximumAge = cacheMaximumAge
}

// WithCacheUpdateTime adds the cacheUpdateTime to the fc zone collection get params
func (o *FcZoneCollectionGetParams) WithCacheUpdateTime(cacheUpdateTime *string) *FcZoneCollectionGetParams {
	o.SetCacheUpdateTime(cacheUpdateTime)
	return o
}

// SetCacheUpdateTime adds the cacheUpdateTime to the fc zone collection get params
func (o *FcZoneCollectionGetParams) SetCacheUpdateTime(cacheUpdateTime *string) {
	o.CacheUpdateTime = cacheUpdateTime
}

// WithFabricName adds the fabricName to the fc zone collection get params
func (o *FcZoneCollectionGetParams) WithFabricName(fabricName string) *FcZoneCollectionGetParams {
	o.SetFabricName(fabricName)
	return o
}

// SetFabricName adds the fabricName to the fc zone collection get params
func (o *FcZoneCollectionGetParams) SetFabricName(fabricName string) {
	o.FabricName = fabricName
}

// WithFields adds the fields to the fc zone collection get params
func (o *FcZoneCollectionGetParams) WithFields(fields []string) *FcZoneCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the fc zone collection get params
func (o *FcZoneCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the fc zone collection get params
func (o *FcZoneCollectionGetParams) WithMaxRecords(maxRecords *int64) *FcZoneCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the fc zone collection get params
func (o *FcZoneCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMembersName adds the membersName to the fc zone collection get params
func (o *FcZoneCollectionGetParams) WithMembersName(membersName *string) *FcZoneCollectionGetParams {
	o.SetMembersName(membersName)
	return o
}

// SetMembersName adds the membersName to the fc zone collection get params
func (o *FcZoneCollectionGetParams) SetMembersName(membersName *string) {
	o.MembersName = membersName
}

// WithMembersType adds the membersType to the fc zone collection get params
func (o *FcZoneCollectionGetParams) WithMembersType(membersType *string) *FcZoneCollectionGetParams {
	o.SetMembersType(membersType)
	return o
}

// SetMembersType adds the membersType to the fc zone collection get params
func (o *FcZoneCollectionGetParams) SetMembersType(membersType *string) {
	o.MembersType = membersType
}

// WithName adds the name to the fc zone collection get params
func (o *FcZoneCollectionGetParams) WithName(name *string) *FcZoneCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the fc zone collection get params
func (o *FcZoneCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the fc zone collection get params
func (o *FcZoneCollectionGetParams) WithOrderBy(orderBy []string) *FcZoneCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the fc zone collection get params
func (o *FcZoneCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the fc zone collection get params
func (o *FcZoneCollectionGetParams) WithReturnRecords(returnRecords *bool) *FcZoneCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the fc zone collection get params
func (o *FcZoneCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the fc zone collection get params
func (o *FcZoneCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *FcZoneCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the fc zone collection get params
func (o *FcZoneCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *FcZoneCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CacheAge != nil {

		// query param cache.age
		var qrCacheAge string

		if o.CacheAge != nil {
			qrCacheAge = *o.CacheAge
		}
		qCacheAge := qrCacheAge
		if qCacheAge != "" {

			if err := r.SetQueryParam("cache.age", qCacheAge); err != nil {
				return err
			}
		}
	}

	if o.CacheIsCurrent != nil {

		// query param cache.is_current
		var qrCacheIsCurrent bool

		if o.CacheIsCurrent != nil {
			qrCacheIsCurrent = *o.CacheIsCurrent
		}
		qCacheIsCurrent := swag.FormatBool(qrCacheIsCurrent)
		if qCacheIsCurrent != "" {

			if err := r.SetQueryParam("cache.is_current", qCacheIsCurrent); err != nil {
				return err
			}
		}
	}

	if o.CacheMaximumAge != nil {

		// query param cache.maximum_age
		var qrCacheMaximumAge string

		if o.CacheMaximumAge != nil {
			qrCacheMaximumAge = *o.CacheMaximumAge
		}
		qCacheMaximumAge := qrCacheMaximumAge
		if qCacheMaximumAge != "" {

			if err := r.SetQueryParam("cache.maximum_age", qCacheMaximumAge); err != nil {
				return err
			}
		}
	}

	if o.CacheUpdateTime != nil {

		// query param cache.update_time
		var qrCacheUpdateTime string

		if o.CacheUpdateTime != nil {
			qrCacheUpdateTime = *o.CacheUpdateTime
		}
		qCacheUpdateTime := qrCacheUpdateTime
		if qCacheUpdateTime != "" {

			if err := r.SetQueryParam("cache.update_time", qCacheUpdateTime); err != nil {
				return err
			}
		}
	}

	// path param fabric.name
	if err := r.SetPathParam("fabric.name", o.FabricName); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.MembersName != nil {

		// query param members.name
		var qrMembersName string

		if o.MembersName != nil {
			qrMembersName = *o.MembersName
		}
		qMembersName := qrMembersName
		if qMembersName != "" {

			if err := r.SetQueryParam("members.name", qMembersName); err != nil {
				return err
			}
		}
	}

	if o.MembersType != nil {

		// query param members.type
		var qrMembersType string

		if o.MembersType != nil {
			qrMembersType = *o.MembersType
		}
		qMembersType := qrMembersType
		if qMembersType != "" {

			if err := r.SetQueryParam("members.type", qMembersType); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamFcZoneCollectionGet binds the parameter fields
func (o *FcZoneCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamFcZoneCollectionGet binds the parameter order_by
func (o *FcZoneCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
