// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FcZoneGetReader is a Reader for the FcZoneGet structure.
type FcZoneGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FcZoneGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFcZoneGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFcZoneGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFcZoneGetOK creates a FcZoneGetOK with default headers values
func NewFcZoneGetOK() *FcZoneGetOK {
	return &FcZoneGetOK{}
}

/*
FcZoneGetOK describes a response with status code 200, with default header values.

OK
*/
type FcZoneGetOK struct {
	Payload *models.FcZone
}

// IsSuccess returns true when this fc zone get o k response has a 2xx status code
func (o *FcZoneGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fc zone get o k response has a 3xx status code
func (o *FcZoneGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fc zone get o k response has a 4xx status code
func (o *FcZoneGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fc zone get o k response has a 5xx status code
func (o *FcZoneGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fc zone get o k response a status code equal to that given
func (o *FcZoneGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fc zone get o k response
func (o *FcZoneGetOK) Code() int {
	return 200
}

func (o *FcZoneGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/fabrics/{fabric.name}/zones/{name}][%d] fcZoneGetOK %s", 200, payload)
}

func (o *FcZoneGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/fabrics/{fabric.name}/zones/{name}][%d] fcZoneGetOK %s", 200, payload)
}

func (o *FcZoneGetOK) GetPayload() *models.FcZone {
	return o.Payload
}

func (o *FcZoneGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.FcZone)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFcZoneGetDefault creates a FcZoneGetDefault with default headers values
func NewFcZoneGetDefault(code int) *FcZoneGetDefault {
	return &FcZoneGetDefault{
		_statusCode: code,
	}
}

/*
	FcZoneGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5373982 | An invalid WWN was specified. The length is incorrect. |
| 5373983 | An invalid WWN was specified. The format is incorrect. |
| 5375053 | The Fibre Channel fabric specified by name in the request URI was not found in the FC fabric cache. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type FcZoneGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fc zone get default response has a 2xx status code
func (o *FcZoneGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fc zone get default response has a 3xx status code
func (o *FcZoneGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fc zone get default response has a 4xx status code
func (o *FcZoneGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fc zone get default response has a 5xx status code
func (o *FcZoneGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fc zone get default response a status code equal to that given
func (o *FcZoneGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fc zone get default response
func (o *FcZoneGetDefault) Code() int {
	return o._statusCode
}

func (o *FcZoneGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/fabrics/{fabric.name}/zones/{name}][%d] fc_zone_get default %s", o._statusCode, payload)
}

func (o *FcZoneGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/fabrics/{fabric.name}/zones/{name}][%d] fc_zone_get default %s", o._statusCode, payload)
}

func (o *FcZoneGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FcZoneGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
