// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewHTTPProxyCollectionGetParams creates a new HTTPProxyCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewHTTPProxyCollectionGetParams() *HTTPProxyCollectionGetParams {
	return &HTTPProxyCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewHTTPProxyCollectionGetParamsWithTimeout creates a new HTTPProxyCollectionGetParams object
// with the ability to set a timeout on a request.
func NewHTTPProxyCollectionGetParamsWithTimeout(timeout time.Duration) *HTTPProxyCollectionGetParams {
	return &HTTPProxyCollectionGetParams{
		timeout: timeout,
	}
}

// NewHTTPProxyCollectionGetParamsWithContext creates a new HTTPProxyCollectionGetParams object
// with the ability to set a context for a request.
func NewHTTPProxyCollectionGetParamsWithContext(ctx context.Context) *HTTPProxyCollectionGetParams {
	return &HTTPProxyCollectionGetParams{
		Context: ctx,
	}
}

// NewHTTPProxyCollectionGetParamsWithHTTPClient creates a new HTTPProxyCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewHTTPProxyCollectionGetParamsWithHTTPClient(client *http.Client) *HTTPProxyCollectionGetParams {
	return &HTTPProxyCollectionGetParams{
		HTTPClient: client,
	}
}

/*
HTTPProxyCollectionGetParams contains all the parameters to send to the API endpoint

	for the http proxy collection get operation.

	Typically these are written to a http.Request.
*/
type HTTPProxyCollectionGetParams struct {

	/* AuthenticationEnabled.

	   Filter by authentication_enabled
	*/
	AuthenticationEnabled *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* IpspaceName.

	   Filter by ipspace.name
	*/
	IpspaceName *string

	/* IpspaceUUID.

	   Filter by ipspace.uuid
	*/
	IpspaceUUID *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Port.

	   Filter by port
	*/
	Port *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* Server.

	   Filter by server
	*/
	Server *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the http proxy collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *HTTPProxyCollectionGetParams) WithDefaults() *HTTPProxyCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the http proxy collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *HTTPProxyCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := HTTPProxyCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) WithTimeout(timeout time.Duration) *HTTPProxyCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) WithContext(ctx context.Context) *HTTPProxyCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) WithHTTPClient(client *http.Client) *HTTPProxyCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAuthenticationEnabled adds the authenticationEnabled to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) WithAuthenticationEnabled(authenticationEnabled *bool) *HTTPProxyCollectionGetParams {
	o.SetAuthenticationEnabled(authenticationEnabled)
	return o
}

// SetAuthenticationEnabled adds the authenticationEnabled to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) SetAuthenticationEnabled(authenticationEnabled *bool) {
	o.AuthenticationEnabled = authenticationEnabled
}

// WithFields adds the fields to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) WithFields(fields []string) *HTTPProxyCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIpspaceName adds the ipspaceName to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) WithIpspaceName(ipspaceName *string) *HTTPProxyCollectionGetParams {
	o.SetIpspaceName(ipspaceName)
	return o
}

// SetIpspaceName adds the ipspaceName to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) SetIpspaceName(ipspaceName *string) {
	o.IpspaceName = ipspaceName
}

// WithIpspaceUUID adds the ipspaceUUID to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) WithIpspaceUUID(ipspaceUUID *string) *HTTPProxyCollectionGetParams {
	o.SetIpspaceUUID(ipspaceUUID)
	return o
}

// SetIpspaceUUID adds the ipspaceUuid to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) SetIpspaceUUID(ipspaceUUID *string) {
	o.IpspaceUUID = ipspaceUUID
}

// WithMaxRecords adds the maxRecords to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) WithMaxRecords(maxRecords *int64) *HTTPProxyCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) WithOrderBy(orderBy []string) *HTTPProxyCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPort adds the port to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) WithPort(port *int64) *HTTPProxyCollectionGetParams {
	o.SetPort(port)
	return o
}

// SetPort adds the port to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) SetPort(port *int64) {
	o.Port = port
}

// WithReturnRecords adds the returnRecords to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) WithReturnRecords(returnRecords *bool) *HTTPProxyCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *HTTPProxyCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) WithScope(scope *string) *HTTPProxyCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithServer adds the server to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) WithServer(server *string) *HTTPProxyCollectionGetParams {
	o.SetServer(server)
	return o
}

// SetServer adds the server to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) SetServer(server *string) {
	o.Server = server
}

// WithSvmName adds the svmName to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) WithSvmName(svmName *string) *HTTPProxyCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) WithSvmUUID(svmUUID *string) *HTTPProxyCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) WithUUID(uuid *string) *HTTPProxyCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the http proxy collection get params
func (o *HTTPProxyCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *HTTPProxyCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AuthenticationEnabled != nil {

		// query param authentication_enabled
		var qrAuthenticationEnabled bool

		if o.AuthenticationEnabled != nil {
			qrAuthenticationEnabled = *o.AuthenticationEnabled
		}
		qAuthenticationEnabled := swag.FormatBool(qrAuthenticationEnabled)
		if qAuthenticationEnabled != "" {

			if err := r.SetQueryParam("authentication_enabled", qAuthenticationEnabled); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.IpspaceName != nil {

		// query param ipspace.name
		var qrIpspaceName string

		if o.IpspaceName != nil {
			qrIpspaceName = *o.IpspaceName
		}
		qIpspaceName := qrIpspaceName
		if qIpspaceName != "" {

			if err := r.SetQueryParam("ipspace.name", qIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.IpspaceUUID != nil {

		// query param ipspace.uuid
		var qrIpspaceUUID string

		if o.IpspaceUUID != nil {
			qrIpspaceUUID = *o.IpspaceUUID
		}
		qIpspaceUUID := qrIpspaceUUID
		if qIpspaceUUID != "" {

			if err := r.SetQueryParam("ipspace.uuid", qIpspaceUUID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Port != nil {

		// query param port
		var qrPort int64

		if o.Port != nil {
			qrPort = *o.Port
		}
		qPort := swag.FormatInt64(qrPort)
		if qPort != "" {

			if err := r.SetQueryParam("port", qPort); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.Server != nil {

		// query param server
		var qrServer string

		if o.Server != nil {
			qrServer = *o.Server
		}
		qServer := qrServer
		if qServer != "" {

			if err := r.SetQueryParam("server", qServer); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamHTTPProxyCollectionGet binds the parameter fields
func (o *HTTPProxyCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamHTTPProxyCollectionGet binds the parameter order_by
func (o *HTTPProxyCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
