// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// HTTPProxyCollectionGetReader is a Reader for the HTTPProxyCollectionGet structure.
type HTTPProxyCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *HTTPProxyCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewHTTPProxyCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewHTTPProxyCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewHTTPProxyCollectionGetOK creates a HTTPProxyCollectionGetOK with default headers values
func NewHTTPProxyCollectionGetOK() *HTTPProxyCollectionGetOK {
	return &HTTPProxyCollectionGetOK{}
}

/*
HTTPProxyCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type HTTPProxyCollectionGetOK struct {
	Payload *models.NetworkHTTPProxyResponse
}

// IsSuccess returns true when this http proxy collection get o k response has a 2xx status code
func (o *HTTPProxyCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this http proxy collection get o k response has a 3xx status code
func (o *HTTPProxyCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this http proxy collection get o k response has a 4xx status code
func (o *HTTPProxyCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this http proxy collection get o k response has a 5xx status code
func (o *HTTPProxyCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this http proxy collection get o k response a status code equal to that given
func (o *HTTPProxyCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the http proxy collection get o k response
func (o *HTTPProxyCollectionGetOK) Code() int {
	return 200
}

func (o *HTTPProxyCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/http-proxy][%d] httpProxyCollectionGetOK %s", 200, payload)
}

func (o *HTTPProxyCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/http-proxy][%d] httpProxyCollectionGetOK %s", 200, payload)
}

func (o *HTTPProxyCollectionGetOK) GetPayload() *models.NetworkHTTPProxyResponse {
	return o.Payload
}

func (o *HTTPProxyCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.NetworkHTTPProxyResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewHTTPProxyCollectionGetDefault creates a HTTPProxyCollectionGetDefault with default headers values
func NewHTTPProxyCollectionGetDefault(code int) *HTTPProxyCollectionGetDefault {
	return &HTTPProxyCollectionGetDefault{
		_statusCode: code,
	}
}

/*
HTTPProxyCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type HTTPProxyCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this http proxy collection get default response has a 2xx status code
func (o *HTTPProxyCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this http proxy collection get default response has a 3xx status code
func (o *HTTPProxyCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this http proxy collection get default response has a 4xx status code
func (o *HTTPProxyCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this http proxy collection get default response has a 5xx status code
func (o *HTTPProxyCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this http proxy collection get default response a status code equal to that given
func (o *HTTPProxyCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the http proxy collection get default response
func (o *HTTPProxyCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *HTTPProxyCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/http-proxy][%d] http_proxy_collection_get default %s", o._statusCode, payload)
}

func (o *HTTPProxyCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/http-proxy][%d] http_proxy_collection_get default %s", o._statusCode, payload)
}

func (o *HTTPProxyCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *HTTPProxyCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
