// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewHTTPProxyCreateParams creates a new HTTPProxyCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewHTTPProxyCreateParams() *HTTPProxyCreateParams {
	return &HTTPProxyCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewHTTPProxyCreateParamsWithTimeout creates a new HTTPProxyCreateParams object
// with the ability to set a timeout on a request.
func NewHTTPProxyCreateParamsWithTimeout(timeout time.Duration) *HTTPProxyCreateParams {
	return &HTTPProxyCreateParams{
		timeout: timeout,
	}
}

// NewHTTPProxyCreateParamsWithContext creates a new HTTPProxyCreateParams object
// with the ability to set a context for a request.
func NewHTTPProxyCreateParamsWithContext(ctx context.Context) *HTTPProxyCreateParams {
	return &HTTPProxyCreateParams{
		Context: ctx,
	}
}

// NewHTTPProxyCreateParamsWithHTTPClient creates a new HTTPProxyCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewHTTPProxyCreateParamsWithHTTPClient(client *http.Client) *HTTPProxyCreateParams {
	return &HTTPProxyCreateParams{
		HTTPClient: client,
	}
}

/*
HTTPProxyCreateParams contains all the parameters to send to the API endpoint

	for the http proxy create operation.

	Typically these are written to a http.Request.
*/
type HTTPProxyCreateParams struct {

	/* Info.

	   Information specification
	*/
	Info *models.NetworkHTTPProxy

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the http proxy create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *HTTPProxyCreateParams) WithDefaults() *HTTPProxyCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the http proxy create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *HTTPProxyCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := HTTPProxyCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the http proxy create params
func (o *HTTPProxyCreateParams) WithTimeout(timeout time.Duration) *HTTPProxyCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the http proxy create params
func (o *HTTPProxyCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the http proxy create params
func (o *HTTPProxyCreateParams) WithContext(ctx context.Context) *HTTPProxyCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the http proxy create params
func (o *HTTPProxyCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the http proxy create params
func (o *HTTPProxyCreateParams) WithHTTPClient(client *http.Client) *HTTPProxyCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the http proxy create params
func (o *HTTPProxyCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the http proxy create params
func (o *HTTPProxyCreateParams) WithInfo(info *models.NetworkHTTPProxy) *HTTPProxyCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the http proxy create params
func (o *HTTPProxyCreateParams) SetInfo(info *models.NetworkHTTPProxy) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the http proxy create params
func (o *HTTPProxyCreateParams) WithReturnRecords(returnRecords *bool) *HTTPProxyCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the http proxy create params
func (o *HTTPProxyCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *HTTPProxyCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
