// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewHTTPProxyDeleteCollectionParams creates a new HTTPProxyDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewHTTPProxyDeleteCollectionParams() *HTTPProxyDeleteCollectionParams {
	return &HTTPProxyDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewHTTPProxyDeleteCollectionParamsWithTimeout creates a new HTTPProxyDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewHTTPProxyDeleteCollectionParamsWithTimeout(timeout time.Duration) *HTTPProxyDeleteCollectionParams {
	return &HTTPProxyDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewHTTPProxyDeleteCollectionParamsWithContext creates a new HTTPProxyDeleteCollectionParams object
// with the ability to set a context for a request.
func NewHTTPProxyDeleteCollectionParamsWithContext(ctx context.Context) *HTTPProxyDeleteCollectionParams {
	return &HTTPProxyDeleteCollectionParams{
		Context: ctx,
	}
}

// NewHTTPProxyDeleteCollectionParamsWithHTTPClient creates a new HTTPProxyDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewHTTPProxyDeleteCollectionParamsWithHTTPClient(client *http.Client) *HTTPProxyDeleteCollectionParams {
	return &HTTPProxyDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
HTTPProxyDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the http proxy delete collection operation.

	Typically these are written to a http.Request.
*/
type HTTPProxyDeleteCollectionParams struct {

	/* AuthenticationEnabled.

	   Filter by authentication_enabled
	*/
	AuthenticationEnabled *bool

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info HTTPProxyDeleteCollectionBody

	/* IpspaceName.

	   Filter by ipspace.name
	*/
	IpspaceName *string

	/* IpspaceUUID.

	   Filter by ipspace.uuid
	*/
	IpspaceUUID *string

	/* Port.

	   Filter by port
	*/
	Port *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Server.

	   Filter by server
	*/
	Server *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the http proxy delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *HTTPProxyDeleteCollectionParams) WithDefaults() *HTTPProxyDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the http proxy delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *HTTPProxyDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := HTTPProxyDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) WithTimeout(timeout time.Duration) *HTTPProxyDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) WithContext(ctx context.Context) *HTTPProxyDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) WithHTTPClient(client *http.Client) *HTTPProxyDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAuthenticationEnabled adds the authenticationEnabled to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) WithAuthenticationEnabled(authenticationEnabled *bool) *HTTPProxyDeleteCollectionParams {
	o.SetAuthenticationEnabled(authenticationEnabled)
	return o
}

// SetAuthenticationEnabled adds the authenticationEnabled to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) SetAuthenticationEnabled(authenticationEnabled *bool) {
	o.AuthenticationEnabled = authenticationEnabled
}

// WithContinueOnFailure adds the continueOnFailure to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *HTTPProxyDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) WithInfo(info HTTPProxyDeleteCollectionBody) *HTTPProxyDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) SetInfo(info HTTPProxyDeleteCollectionBody) {
	o.Info = info
}

// WithIpspaceName adds the ipspaceName to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) WithIpspaceName(ipspaceName *string) *HTTPProxyDeleteCollectionParams {
	o.SetIpspaceName(ipspaceName)
	return o
}

// SetIpspaceName adds the ipspaceName to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) SetIpspaceName(ipspaceName *string) {
	o.IpspaceName = ipspaceName
}

// WithIpspaceUUID adds the ipspaceUUID to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) WithIpspaceUUID(ipspaceUUID *string) *HTTPProxyDeleteCollectionParams {
	o.SetIpspaceUUID(ipspaceUUID)
	return o
}

// SetIpspaceUUID adds the ipspaceUuid to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) SetIpspaceUUID(ipspaceUUID *string) {
	o.IpspaceUUID = ipspaceUUID
}

// WithPort adds the port to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) WithPort(port *int64) *HTTPProxyDeleteCollectionParams {
	o.SetPort(port)
	return o
}

// SetPort adds the port to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) SetPort(port *int64) {
	o.Port = port
}

// WithReturnRecords adds the returnRecords to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *HTTPProxyDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *HTTPProxyDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) WithScope(scope *string) *HTTPProxyDeleteCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *HTTPProxyDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithServer adds the server to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) WithServer(server *string) *HTTPProxyDeleteCollectionParams {
	o.SetServer(server)
	return o
}

// SetServer adds the server to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) SetServer(server *string) {
	o.Server = server
}

// WithSvmName adds the svmName to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) WithSvmName(svmName *string) *HTTPProxyDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) WithSvmUUID(svmUUID *string) *HTTPProxyDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) WithUUID(uuid *string) *HTTPProxyDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the http proxy delete collection params
func (o *HTTPProxyDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *HTTPProxyDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AuthenticationEnabled != nil {

		// query param authentication_enabled
		var qrAuthenticationEnabled bool

		if o.AuthenticationEnabled != nil {
			qrAuthenticationEnabled = *o.AuthenticationEnabled
		}
		qAuthenticationEnabled := swag.FormatBool(qrAuthenticationEnabled)
		if qAuthenticationEnabled != "" {

			if err := r.SetQueryParam("authentication_enabled", qAuthenticationEnabled); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IpspaceName != nil {

		// query param ipspace.name
		var qrIpspaceName string

		if o.IpspaceName != nil {
			qrIpspaceName = *o.IpspaceName
		}
		qIpspaceName := qrIpspaceName
		if qIpspaceName != "" {

			if err := r.SetQueryParam("ipspace.name", qIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.IpspaceUUID != nil {

		// query param ipspace.uuid
		var qrIpspaceUUID string

		if o.IpspaceUUID != nil {
			qrIpspaceUUID = *o.IpspaceUUID
		}
		qIpspaceUUID := qrIpspaceUUID
		if qIpspaceUUID != "" {

			if err := r.SetQueryParam("ipspace.uuid", qIpspaceUUID); err != nil {
				return err
			}
		}
	}

	if o.Port != nil {

		// query param port
		var qrPort int64

		if o.Port != nil {
			qrPort = *o.Port
		}
		qPort := swag.FormatInt64(qrPort)
		if qPort != "" {

			if err := r.SetQueryParam("port", qPort); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Server != nil {

		// query param server
		var qrServer string

		if o.Server != nil {
			qrServer = *o.Server
		}
		qServer := qrServer
		if qServer != "" {

			if err := r.SetQueryParam("server", qServer); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
