// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// HTTPProxyDeleteCollectionReader is a Reader for the HTTPProxyDeleteCollection structure.
type HTTPProxyDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *HTTPProxyDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewHTTPProxyDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewHTTPProxyDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewHTTPProxyDeleteCollectionOK creates a HTTPProxyDeleteCollectionOK with default headers values
func NewHTTPProxyDeleteCollectionOK() *HTTPProxyDeleteCollectionOK {
	return &HTTPProxyDeleteCollectionOK{}
}

/*
HTTPProxyDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type HTTPProxyDeleteCollectionOK struct {
}

// IsSuccess returns true when this http proxy delete collection o k response has a 2xx status code
func (o *HTTPProxyDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this http proxy delete collection o k response has a 3xx status code
func (o *HTTPProxyDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this http proxy delete collection o k response has a 4xx status code
func (o *HTTPProxyDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this http proxy delete collection o k response has a 5xx status code
func (o *HTTPProxyDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this http proxy delete collection o k response a status code equal to that given
func (o *HTTPProxyDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the http proxy delete collection o k response
func (o *HTTPProxyDeleteCollectionOK) Code() int {
	return 200
}

func (o *HTTPProxyDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /network/http-proxy][%d] httpProxyDeleteCollectionOK", 200)
}

func (o *HTTPProxyDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /network/http-proxy][%d] httpProxyDeleteCollectionOK", 200)
}

func (o *HTTPProxyDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewHTTPProxyDeleteCollectionDefault creates a HTTPProxyDeleteCollectionDefault with default headers values
func NewHTTPProxyDeleteCollectionDefault(code int) *HTTPProxyDeleteCollectionDefault {
	return &HTTPProxyDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	HTTPProxyDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 138281013  | The HTTP Proxy cannot be deleted while in use by a cloud agent connection. |
| 2621574    | This operation is not permitted on a SVM that is configured as the destination of a Metrocluster SVM relationship. |
*/
type HTTPProxyDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this http proxy delete collection default response has a 2xx status code
func (o *HTTPProxyDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this http proxy delete collection default response has a 3xx status code
func (o *HTTPProxyDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this http proxy delete collection default response has a 4xx status code
func (o *HTTPProxyDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this http proxy delete collection default response has a 5xx status code
func (o *HTTPProxyDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this http proxy delete collection default response a status code equal to that given
func (o *HTTPProxyDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the http proxy delete collection default response
func (o *HTTPProxyDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *HTTPProxyDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /network/http-proxy][%d] http_proxy_delete_collection default %s", o._statusCode, payload)
}

func (o *HTTPProxyDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /network/http-proxy][%d] http_proxy_delete_collection default %s", o._statusCode, payload)
}

func (o *HTTPProxyDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *HTTPProxyDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
HTTPProxyDeleteCollectionBody HTTP proxy delete collection body
swagger:model HTTPProxyDeleteCollectionBody
*/
type HTTPProxyDeleteCollectionBody struct {

	// network http proxy response inline records
	NetworkHTTPProxyResponseInlineRecords []*models.NetworkHTTPProxy `json:"records,omitempty"`
}

// Validate validates this HTTP proxy delete collection body
func (o *HTTPProxyDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateNetworkHTTPProxyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *HTTPProxyDeleteCollectionBody) validateNetworkHTTPProxyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.NetworkHTTPProxyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.NetworkHTTPProxyResponseInlineRecords); i++ {
		if swag.IsZero(o.NetworkHTTPProxyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.NetworkHTTPProxyResponseInlineRecords[i] != nil {
			if err := o.NetworkHTTPProxyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this HTTP proxy delete collection body based on the context it is used
func (o *HTTPProxyDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNetworkHTTPProxyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *HTTPProxyDeleteCollectionBody) contextValidateNetworkHTTPProxyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.NetworkHTTPProxyResponseInlineRecords); i++ {

		if o.NetworkHTTPProxyResponseInlineRecords[i] != nil {
			if err := o.NetworkHTTPProxyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *HTTPProxyDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *HTTPProxyDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res HTTPProxyDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
