// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// HTTPProxyDeleteReader is a Reader for the HTTPProxyDelete structure.
type HTTPProxyDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *HTTPProxyDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewHTTPProxyDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewHTTPProxyDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewHTTPProxyDeleteOK creates a HTTPProxyDeleteOK with default headers values
func NewHTTPProxyDeleteOK() *HTTPProxyDeleteOK {
	return &HTTPProxyDeleteOK{}
}

/*
HTTPProxyDeleteOK describes a response with status code 200, with default header values.

OK
*/
type HTTPProxyDeleteOK struct {
}

// IsSuccess returns true when this http proxy delete o k response has a 2xx status code
func (o *HTTPProxyDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this http proxy delete o k response has a 3xx status code
func (o *HTTPProxyDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this http proxy delete o k response has a 4xx status code
func (o *HTTPProxyDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this http proxy delete o k response has a 5xx status code
func (o *HTTPProxyDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this http proxy delete o k response a status code equal to that given
func (o *HTTPProxyDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the http proxy delete o k response
func (o *HTTPProxyDeleteOK) Code() int {
	return 200
}

func (o *HTTPProxyDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /network/http-proxy/{uuid}][%d] httpProxyDeleteOK", 200)
}

func (o *HTTPProxyDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /network/http-proxy/{uuid}][%d] httpProxyDeleteOK", 200)
}

func (o *HTTPProxyDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewHTTPProxyDeleteDefault creates a HTTPProxyDeleteDefault with default headers values
func NewHTTPProxyDeleteDefault(code int) *HTTPProxyDeleteDefault {
	return &HTTPProxyDeleteDefault{
		_statusCode: code,
	}
}

/*
	HTTPProxyDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 138281013  | The HTTP Proxy cannot be deleted while in use by a cloud agent connection. |
| 2621574    | This operation is not permitted on a SVM that is configured as the destination of a Metrocluster SVM relationship. |
*/
type HTTPProxyDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this http proxy delete default response has a 2xx status code
func (o *HTTPProxyDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this http proxy delete default response has a 3xx status code
func (o *HTTPProxyDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this http proxy delete default response has a 4xx status code
func (o *HTTPProxyDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this http proxy delete default response has a 5xx status code
func (o *HTTPProxyDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this http proxy delete default response a status code equal to that given
func (o *HTTPProxyDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the http proxy delete default response
func (o *HTTPProxyDeleteDefault) Code() int {
	return o._statusCode
}

func (o *HTTPProxyDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /network/http-proxy/{uuid}][%d] http_proxy_delete default %s", o._statusCode, payload)
}

func (o *HTTPProxyDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /network/http-proxy/{uuid}][%d] http_proxy_delete default %s", o._statusCode, payload)
}

func (o *HTTPProxyDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *HTTPProxyDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
