// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewHTTPProxyModifyCollectionParams creates a new HTTPProxyModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewHTTPProxyModifyCollectionParams() *HTTPProxyModifyCollectionParams {
	return &HTTPProxyModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewHTTPProxyModifyCollectionParamsWithTimeout creates a new HTTPProxyModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewHTTPProxyModifyCollectionParamsWithTimeout(timeout time.Duration) *HTTPProxyModifyCollectionParams {
	return &HTTPProxyModifyCollectionParams{
		timeout: timeout,
	}
}

// NewHTTPProxyModifyCollectionParamsWithContext creates a new HTTPProxyModifyCollectionParams object
// with the ability to set a context for a request.
func NewHTTPProxyModifyCollectionParamsWithContext(ctx context.Context) *HTTPProxyModifyCollectionParams {
	return &HTTPProxyModifyCollectionParams{
		Context: ctx,
	}
}

// NewHTTPProxyModifyCollectionParamsWithHTTPClient creates a new HTTPProxyModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewHTTPProxyModifyCollectionParamsWithHTTPClient(client *http.Client) *HTTPProxyModifyCollectionParams {
	return &HTTPProxyModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
HTTPProxyModifyCollectionParams contains all the parameters to send to the API endpoint

	for the http proxy modify collection operation.

	Typically these are written to a http.Request.
*/
type HTTPProxyModifyCollectionParams struct {

	/* AuthenticationEnabled.

	   Filter by authentication_enabled
	*/
	AuthenticationEnabled *bool

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info HTTPProxyModifyCollectionBody

	/* IpspaceName.

	   Filter by ipspace.name
	*/
	IpspaceName *string

	/* IpspaceUUID.

	   Filter by ipspace.uuid
	*/
	IpspaceUUID *string

	/* Port.

	   Filter by port
	*/
	Port *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Server.

	   Filter by server
	*/
	Server *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the http proxy modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *HTTPProxyModifyCollectionParams) WithDefaults() *HTTPProxyModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the http proxy modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *HTTPProxyModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := HTTPProxyModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) WithTimeout(timeout time.Duration) *HTTPProxyModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) WithContext(ctx context.Context) *HTTPProxyModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) WithHTTPClient(client *http.Client) *HTTPProxyModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAuthenticationEnabled adds the authenticationEnabled to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) WithAuthenticationEnabled(authenticationEnabled *bool) *HTTPProxyModifyCollectionParams {
	o.SetAuthenticationEnabled(authenticationEnabled)
	return o
}

// SetAuthenticationEnabled adds the authenticationEnabled to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) SetAuthenticationEnabled(authenticationEnabled *bool) {
	o.AuthenticationEnabled = authenticationEnabled
}

// WithContinueOnFailure adds the continueOnFailure to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *HTTPProxyModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) WithInfo(info HTTPProxyModifyCollectionBody) *HTTPProxyModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) SetInfo(info HTTPProxyModifyCollectionBody) {
	o.Info = info
}

// WithIpspaceName adds the ipspaceName to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) WithIpspaceName(ipspaceName *string) *HTTPProxyModifyCollectionParams {
	o.SetIpspaceName(ipspaceName)
	return o
}

// SetIpspaceName adds the ipspaceName to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) SetIpspaceName(ipspaceName *string) {
	o.IpspaceName = ipspaceName
}

// WithIpspaceUUID adds the ipspaceUUID to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) WithIpspaceUUID(ipspaceUUID *string) *HTTPProxyModifyCollectionParams {
	o.SetIpspaceUUID(ipspaceUUID)
	return o
}

// SetIpspaceUUID adds the ipspaceUuid to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) SetIpspaceUUID(ipspaceUUID *string) {
	o.IpspaceUUID = ipspaceUUID
}

// WithPort adds the port to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) WithPort(port *int64) *HTTPProxyModifyCollectionParams {
	o.SetPort(port)
	return o
}

// SetPort adds the port to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) SetPort(port *int64) {
	o.Port = port
}

// WithReturnRecords adds the returnRecords to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) WithReturnRecords(returnRecords *bool) *HTTPProxyModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *HTTPProxyModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) WithScope(scope *string) *HTTPProxyModifyCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) WithSerialRecords(serialRecords *bool) *HTTPProxyModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithServer adds the server to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) WithServer(server *string) *HTTPProxyModifyCollectionParams {
	o.SetServer(server)
	return o
}

// SetServer adds the server to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) SetServer(server *string) {
	o.Server = server
}

// WithSvmName adds the svmName to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) WithSvmName(svmName *string) *HTTPProxyModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) WithSvmUUID(svmUUID *string) *HTTPProxyModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) WithUUID(uuid *string) *HTTPProxyModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the http proxy modify collection params
func (o *HTTPProxyModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *HTTPProxyModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AuthenticationEnabled != nil {

		// query param authentication_enabled
		var qrAuthenticationEnabled bool

		if o.AuthenticationEnabled != nil {
			qrAuthenticationEnabled = *o.AuthenticationEnabled
		}
		qAuthenticationEnabled := swag.FormatBool(qrAuthenticationEnabled)
		if qAuthenticationEnabled != "" {

			if err := r.SetQueryParam("authentication_enabled", qAuthenticationEnabled); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IpspaceName != nil {

		// query param ipspace.name
		var qrIpspaceName string

		if o.IpspaceName != nil {
			qrIpspaceName = *o.IpspaceName
		}
		qIpspaceName := qrIpspaceName
		if qIpspaceName != "" {

			if err := r.SetQueryParam("ipspace.name", qIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.IpspaceUUID != nil {

		// query param ipspace.uuid
		var qrIpspaceUUID string

		if o.IpspaceUUID != nil {
			qrIpspaceUUID = *o.IpspaceUUID
		}
		qIpspaceUUID := qrIpspaceUUID
		if qIpspaceUUID != "" {

			if err := r.SetQueryParam("ipspace.uuid", qIpspaceUUID); err != nil {
				return err
			}
		}
	}

	if o.Port != nil {

		// query param port
		var qrPort int64

		if o.Port != nil {
			qrPort = *o.Port
		}
		qPort := swag.FormatInt64(qrPort)
		if qPort != "" {

			if err := r.SetQueryParam("port", qPort); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Server != nil {

		// query param server
		var qrServer string

		if o.Server != nil {
			qrServer = *o.Server
		}
		qServer := qrServer
		if qServer != "" {

			if err := r.SetQueryParam("server", qServer); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
