// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewInterfacesMetricsCollectionGetParams creates a new InterfacesMetricsCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewInterfacesMetricsCollectionGetParams() *InterfacesMetricsCollectionGetParams {
	return &InterfacesMetricsCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewInterfacesMetricsCollectionGetParamsWithTimeout creates a new InterfacesMetricsCollectionGetParams object
// with the ability to set a timeout on a request.
func NewInterfacesMetricsCollectionGetParamsWithTimeout(timeout time.Duration) *InterfacesMetricsCollectionGetParams {
	return &InterfacesMetricsCollectionGetParams{
		timeout: timeout,
	}
}

// NewInterfacesMetricsCollectionGetParamsWithContext creates a new InterfacesMetricsCollectionGetParams object
// with the ability to set a context for a request.
func NewInterfacesMetricsCollectionGetParamsWithContext(ctx context.Context) *InterfacesMetricsCollectionGetParams {
	return &InterfacesMetricsCollectionGetParams{
		Context: ctx,
	}
}

// NewInterfacesMetricsCollectionGetParamsWithHTTPClient creates a new InterfacesMetricsCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewInterfacesMetricsCollectionGetParamsWithHTTPClient(client *http.Client) *InterfacesMetricsCollectionGetParams {
	return &InterfacesMetricsCollectionGetParams{
		HTTPClient: client,
	}
}

/*
InterfacesMetricsCollectionGetParams contains all the parameters to send to the API endpoint

	for the interfaces metrics collection get operation.

	Typically these are written to a http.Request.
*/
type InterfacesMetricsCollectionGetParams struct {

	/* Duration.

	   Filter by duration
	*/
	Duration *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Interval.

	     The time range for the data. Examples can be 1h, 1d, 1m, 1w, 1y.
	The period for each time range is as follows:
	* 1h: Metrics over the most recent hour sampled over 15 seconds.
	* 1d: Metrics over the most recent day sampled over 5 minutes.
	* 1w: Metrics over the most recent week sampled over 30 minutes.
	* 1m: Metrics over the most recent month sampled over 2 hours.
	* 1y: Metrics over the most recent year sampled over a day.


	     Default: "1h"
	*/
	Interval *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Status.

	   Filter by status
	*/
	Status *string

	/* ThroughputRead.

	   Filter by throughput.read
	*/
	ThroughputRead *int64

	/* ThroughputTotal.

	   Filter by throughput.total
	*/
	ThroughputTotal *int64

	/* ThroughputWrite.

	   Filter by throughput.write
	*/
	ThroughputWrite *int64

	/* Timestamp.

	   Filter by timestamp
	*/
	Timestamp *string

	/* UUID.

	   Unique identifier of the interface.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the interfaces metrics collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *InterfacesMetricsCollectionGetParams) WithDefaults() *InterfacesMetricsCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the interfaces metrics collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *InterfacesMetricsCollectionGetParams) SetDefaults() {
	var (
		intervalDefault = string("1h")

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := InterfacesMetricsCollectionGetParams{
		Interval:      &intervalDefault,
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) WithTimeout(timeout time.Duration) *InterfacesMetricsCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) WithContext(ctx context.Context) *InterfacesMetricsCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) WithHTTPClient(client *http.Client) *InterfacesMetricsCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDuration adds the duration to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) WithDuration(duration *string) *InterfacesMetricsCollectionGetParams {
	o.SetDuration(duration)
	return o
}

// SetDuration adds the duration to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) SetDuration(duration *string) {
	o.Duration = duration
}

// WithFields adds the fields to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) WithFields(fields []string) *InterfacesMetricsCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithInterval adds the interval to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) WithInterval(interval *string) *InterfacesMetricsCollectionGetParams {
	o.SetInterval(interval)
	return o
}

// SetInterval adds the interval to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) SetInterval(interval *string) {
	o.Interval = interval
}

// WithMaxRecords adds the maxRecords to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) WithMaxRecords(maxRecords *int64) *InterfacesMetricsCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) WithOrderBy(orderBy []string) *InterfacesMetricsCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) WithReturnRecords(returnRecords *bool) *InterfacesMetricsCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *InterfacesMetricsCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithStatus adds the status to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) WithStatus(status *string) *InterfacesMetricsCollectionGetParams {
	o.SetStatus(status)
	return o
}

// SetStatus adds the status to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) SetStatus(status *string) {
	o.Status = status
}

// WithThroughputRead adds the throughputRead to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) WithThroughputRead(throughputRead *int64) *InterfacesMetricsCollectionGetParams {
	o.SetThroughputRead(throughputRead)
	return o
}

// SetThroughputRead adds the throughputRead to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) SetThroughputRead(throughputRead *int64) {
	o.ThroughputRead = throughputRead
}

// WithThroughputTotal adds the throughputTotal to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) WithThroughputTotal(throughputTotal *int64) *InterfacesMetricsCollectionGetParams {
	o.SetThroughputTotal(throughputTotal)
	return o
}

// SetThroughputTotal adds the throughputTotal to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) SetThroughputTotal(throughputTotal *int64) {
	o.ThroughputTotal = throughputTotal
}

// WithThroughputWrite adds the throughputWrite to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) WithThroughputWrite(throughputWrite *int64) *InterfacesMetricsCollectionGetParams {
	o.SetThroughputWrite(throughputWrite)
	return o
}

// SetThroughputWrite adds the throughputWrite to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) SetThroughputWrite(throughputWrite *int64) {
	o.ThroughputWrite = throughputWrite
}

// WithTimestamp adds the timestamp to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) WithTimestamp(timestamp *string) *InterfacesMetricsCollectionGetParams {
	o.SetTimestamp(timestamp)
	return o
}

// SetTimestamp adds the timestamp to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) SetTimestamp(timestamp *string) {
	o.Timestamp = timestamp
}

// WithUUID adds the uuid to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) WithUUID(uuid string) *InterfacesMetricsCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the interfaces metrics collection get params
func (o *InterfacesMetricsCollectionGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *InterfacesMetricsCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Duration != nil {

		// query param duration
		var qrDuration string

		if o.Duration != nil {
			qrDuration = *o.Duration
		}
		qDuration := qrDuration
		if qDuration != "" {

			if err := r.SetQueryParam("duration", qDuration); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Interval != nil {

		// query param interval
		var qrInterval string

		if o.Interval != nil {
			qrInterval = *o.Interval
		}
		qInterval := qrInterval
		if qInterval != "" {

			if err := r.SetQueryParam("interval", qInterval); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Status != nil {

		// query param status
		var qrStatus string

		if o.Status != nil {
			qrStatus = *o.Status
		}
		qStatus := qrStatus
		if qStatus != "" {

			if err := r.SetQueryParam("status", qStatus); err != nil {
				return err
			}
		}
	}

	if o.ThroughputRead != nil {

		// query param throughput.read
		var qrThroughputRead int64

		if o.ThroughputRead != nil {
			qrThroughputRead = *o.ThroughputRead
		}
		qThroughputRead := swag.FormatInt64(qrThroughputRead)
		if qThroughputRead != "" {

			if err := r.SetQueryParam("throughput.read", qThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.ThroughputTotal != nil {

		// query param throughput.total
		var qrThroughputTotal int64

		if o.ThroughputTotal != nil {
			qrThroughputTotal = *o.ThroughputTotal
		}
		qThroughputTotal := swag.FormatInt64(qrThroughputTotal)
		if qThroughputTotal != "" {

			if err := r.SetQueryParam("throughput.total", qThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.ThroughputWrite != nil {

		// query param throughput.write
		var qrThroughputWrite int64

		if o.ThroughputWrite != nil {
			qrThroughputWrite = *o.ThroughputWrite
		}
		qThroughputWrite := swag.FormatInt64(qrThroughputWrite)
		if qThroughputWrite != "" {

			if err := r.SetQueryParam("throughput.write", qThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.Timestamp != nil {

		// query param timestamp
		var qrTimestamp string

		if o.Timestamp != nil {
			qrTimestamp = *o.Timestamp
		}
		qTimestamp := qrTimestamp
		if qTimestamp != "" {

			if err := r.SetQueryParam("timestamp", qTimestamp); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamInterfacesMetricsCollectionGet binds the parameter fields
func (o *InterfacesMetricsCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamInterfacesMetricsCollectionGet binds the parameter order_by
func (o *InterfacesMetricsCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
