// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewIPServicePolicyCreateParams creates a new IPServicePolicyCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIPServicePolicyCreateParams() *IPServicePolicyCreateParams {
	return &IPServicePolicyCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIPServicePolicyCreateParamsWithTimeout creates a new IPServicePolicyCreateParams object
// with the ability to set a timeout on a request.
func NewIPServicePolicyCreateParamsWithTimeout(timeout time.Duration) *IPServicePolicyCreateParams {
	return &IPServicePolicyCreateParams{
		timeout: timeout,
	}
}

// NewIPServicePolicyCreateParamsWithContext creates a new IPServicePolicyCreateParams object
// with the ability to set a context for a request.
func NewIPServicePolicyCreateParamsWithContext(ctx context.Context) *IPServicePolicyCreateParams {
	return &IPServicePolicyCreateParams{
		Context: ctx,
	}
}

// NewIPServicePolicyCreateParamsWithHTTPClient creates a new IPServicePolicyCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewIPServicePolicyCreateParamsWithHTTPClient(client *http.Client) *IPServicePolicyCreateParams {
	return &IPServicePolicyCreateParams{
		HTTPClient: client,
	}
}

/*
IPServicePolicyCreateParams contains all the parameters to send to the API endpoint

	for the ip service policy create operation.

	Typically these are written to a http.Request.
*/
type IPServicePolicyCreateParams struct {

	/* Info.

	   Policy parameters
	*/
	Info *models.IPServicePolicy

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ip service policy create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IPServicePolicyCreateParams) WithDefaults() *IPServicePolicyCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ip service policy create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IPServicePolicyCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := IPServicePolicyCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the ip service policy create params
func (o *IPServicePolicyCreateParams) WithTimeout(timeout time.Duration) *IPServicePolicyCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ip service policy create params
func (o *IPServicePolicyCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ip service policy create params
func (o *IPServicePolicyCreateParams) WithContext(ctx context.Context) *IPServicePolicyCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ip service policy create params
func (o *IPServicePolicyCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ip service policy create params
func (o *IPServicePolicyCreateParams) WithHTTPClient(client *http.Client) *IPServicePolicyCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ip service policy create params
func (o *IPServicePolicyCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the ip service policy create params
func (o *IPServicePolicyCreateParams) WithInfo(info *models.IPServicePolicy) *IPServicePolicyCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the ip service policy create params
func (o *IPServicePolicyCreateParams) SetInfo(info *models.IPServicePolicy) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the ip service policy create params
func (o *IPServicePolicyCreateParams) WithReturnRecords(returnRecords *bool) *IPServicePolicyCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the ip service policy create params
func (o *IPServicePolicyCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *IPServicePolicyCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
