// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IPServicePolicyModifyCollectionReader is a Reader for the IPServicePolicyModifyCollection structure.
type IPServicePolicyModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IPServicePolicyModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIPServicePolicyModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIPServicePolicyModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIPServicePolicyModifyCollectionOK creates a IPServicePolicyModifyCollectionOK with default headers values
func NewIPServicePolicyModifyCollectionOK() *IPServicePolicyModifyCollectionOK {
	return &IPServicePolicyModifyCollectionOK{}
}

/*
IPServicePolicyModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type IPServicePolicyModifyCollectionOK struct {
}

// IsSuccess returns true when this ip service policy modify collection o k response has a 2xx status code
func (o *IPServicePolicyModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ip service policy modify collection o k response has a 3xx status code
func (o *IPServicePolicyModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ip service policy modify collection o k response has a 4xx status code
func (o *IPServicePolicyModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ip service policy modify collection o k response has a 5xx status code
func (o *IPServicePolicyModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ip service policy modify collection o k response a status code equal to that given
func (o *IPServicePolicyModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ip service policy modify collection o k response
func (o *IPServicePolicyModifyCollectionOK) Code() int {
	return 200
}

func (o *IPServicePolicyModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /network/ip/service-policies][%d] ipServicePolicyModifyCollectionOK", 200)
}

func (o *IPServicePolicyModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /network/ip/service-policies][%d] ipServicePolicyModifyCollectionOK", 200)
}

func (o *IPServicePolicyModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewIPServicePolicyModifyCollectionDefault creates a IPServicePolicyModifyCollectionDefault with default headers values
func NewIPServicePolicyModifyCollectionDefault(code int) *IPServicePolicyModifyCollectionDefault {
	return &IPServicePolicyModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	IPServicePolicyModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1376669 | Port must reside in the same IPspace as the interface's SVM. |
| 2621740 | An unexpected error when trying to determine whether the target Vserver was locked or not on this cluster. |
| 53281911 | Modifying the service policy is disallowed because policies on this SVM are managed by the system |
| 53281929 | Service policies cannot combine block and file services. |
| 53281930 | Service policies maintained by the system cannot be renamed. |
| 53281931 | Service policy names cannot start with "default-". |
| 53281932 | Service cannot be added because the service does not exist for the specified SVM or IPspace. |
| 53281933 | A Cluster-scoped service cannot be added to a SVM-scoped service policy. |
| 53281934 | An SVM-scoped service cannot be added to a Cluster-scoped service policy. |
| 53281952 | The service policy on an SVM cannot be updated to include a block service. Use built-in service policies for SAN services. |
| 53281953 | The service policy on an SVM cannot be updated to include a new service. |
| 53281960 | Service cannot be removed from the service policy because it is used by one or more interfaces. |
| 53281961 | Service cannot be removed from the service policy because it is used by one or more interfaces. |
| 53281963 | Service cannot be removed from the service policy because it is used by one or more interfaces. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IPServicePolicyModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ip service policy modify collection default response has a 2xx status code
func (o *IPServicePolicyModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ip service policy modify collection default response has a 3xx status code
func (o *IPServicePolicyModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ip service policy modify collection default response has a 4xx status code
func (o *IPServicePolicyModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ip service policy modify collection default response has a 5xx status code
func (o *IPServicePolicyModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ip service policy modify collection default response a status code equal to that given
func (o *IPServicePolicyModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ip service policy modify collection default response
func (o *IPServicePolicyModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *IPServicePolicyModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/ip/service-policies][%d] ip_service_policy_modify_collection default %s", o._statusCode, payload)
}

func (o *IPServicePolicyModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/ip/service-policies][%d] ip_service_policy_modify_collection default %s", o._statusCode, payload)
}

func (o *IPServicePolicyModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IPServicePolicyModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
IPServicePolicyModifyCollectionBody IP service policy modify collection body
swagger:model IPServicePolicyModifyCollectionBody
*/
type IPServicePolicyModifyCollectionBody struct {

	// links
	Links *models.IPServicePolicyInlineLinks `json:"_links,omitempty"`

	// ip service policy inline services
	IPServicePolicyInlineServices []*models.IPService `json:"services,omitempty"`

	// ip service policy response inline records
	IPServicePolicyResponseInlineRecords []*models.IPServicePolicy `json:"records,omitempty"`

	// ipspace
	Ipspace *models.IPServicePolicyInlineIpspace `json:"ipspace,omitempty"`

	// is built in
	// Read Only: true
	IsBuiltIn *bool `json:"is_built_in,omitempty"`

	// name
	// Example: default-intercluster
	Name *string `json:"name,omitempty"`

	// Set to "svm" for interfaces owned by an SVM. Otherwise, set to "cluster".
	// Enum: ["svm","cluster"]
	Scope *string `json:"scope,omitempty"`

	// svm
	Svm *models.IPServicePolicyInlineSvm `json:"svm,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this IP service policy modify collection body
func (o *IPServicePolicyModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIPServicePolicyInlineServices(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIPServicePolicyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPServicePolicyModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IPServicePolicyModifyCollectionBody) validateIPServicePolicyInlineServices(formats strfmt.Registry) error {
	if swag.IsZero(o.IPServicePolicyInlineServices) { // not required
		return nil
	}

	for i := 0; i < len(o.IPServicePolicyInlineServices); i++ {
		if swag.IsZero(o.IPServicePolicyInlineServices[i]) { // not required
			continue
		}

		if o.IPServicePolicyInlineServices[i] != nil {
			if err := o.IPServicePolicyInlineServices[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "services" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IPServicePolicyModifyCollectionBody) validateIPServicePolicyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.IPServicePolicyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.IPServicePolicyResponseInlineRecords); i++ {
		if swag.IsZero(o.IPServicePolicyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.IPServicePolicyResponseInlineRecords[i] != nil {
			if err := o.IPServicePolicyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IPServicePolicyModifyCollectionBody) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(o.Ipspace) { // not required
		return nil
	}

	if o.Ipspace != nil {
		if err := o.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

var ipServicePolicyModifyCollectionBodyTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["svm","cluster"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipServicePolicyModifyCollectionBodyTypeScopePropEnum = append(ipServicePolicyModifyCollectionBodyTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// IPServicePolicyModifyCollectionBody
	// IPServicePolicyModifyCollectionBody
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// IPServicePolicyModifyCollectionBodyScopeSvm captures enum value "svm"
	IPServicePolicyModifyCollectionBodyScopeSvm string = "svm"

	// BEGIN DEBUGGING
	// IPServicePolicyModifyCollectionBody
	// IPServicePolicyModifyCollectionBody
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// IPServicePolicyModifyCollectionBodyScopeCluster captures enum value "cluster"
	IPServicePolicyModifyCollectionBodyScopeCluster string = "cluster"
)

// prop value enum
func (o *IPServicePolicyModifyCollectionBody) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ipServicePolicyModifyCollectionBodyTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *IPServicePolicyModifyCollectionBody) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(o.Scope) { // not required
		return nil
	}

	// value enum
	if err := o.validateScopeEnum("info"+"."+"scope", "body", *o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *IPServicePolicyModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this IP service policy modify collection body based on the context it is used
func (o *IPServicePolicyModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIPServicePolicyInlineServices(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIPServicePolicyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsBuiltIn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPServicePolicyModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IPServicePolicyModifyCollectionBody) contextValidateIPServicePolicyInlineServices(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.IPServicePolicyInlineServices); i++ {

		if o.IPServicePolicyInlineServices[i] != nil {
			if err := o.IPServicePolicyInlineServices[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "services" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IPServicePolicyModifyCollectionBody) contextValidateIPServicePolicyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.IPServicePolicyResponseInlineRecords); i++ {

		if o.IPServicePolicyResponseInlineRecords[i] != nil {
			if err := o.IPServicePolicyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IPServicePolicyModifyCollectionBody) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if o.Ipspace != nil {
		if err := o.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

func (o *IPServicePolicyModifyCollectionBody) contextValidateIsBuiltIn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"is_built_in", "body", o.IsBuiltIn); err != nil {
		return err
	}

	return nil
}

func (o *IPServicePolicyModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *IPServicePolicyModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPServicePolicyModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPServicePolicyModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res IPServicePolicyModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPServicePolicyInlineLinks ip service policy inline links
swagger:model ip_service_policy_inline__links
*/
type IPServicePolicyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ip service policy inline links
func (o *IPServicePolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPServicePolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip service policy inline links based on the context it is used
func (o *IPServicePolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPServicePolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPServicePolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPServicePolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPServicePolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPServicePolicyInlineIpspace ip service policy inline ipspace
swagger:model ip_service_policy_inline_ipspace
*/
type IPServicePolicyInlineIpspace struct {

	// links
	Links *models.IPServicePolicyInlineIpspaceInlineLinks `json:"_links,omitempty"`

	// IPspace name
	// Example: Default
	Name *string `json:"name,omitempty"`

	// IPspace UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ip service policy inline ipspace
func (o *IPServicePolicyInlineIpspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPServicePolicyInlineIpspace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip service policy inline ipspace based on the context it is used
func (o *IPServicePolicyInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPServicePolicyInlineIpspace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPServicePolicyInlineIpspace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPServicePolicyInlineIpspace) UnmarshalBinary(b []byte) error {
	var res IPServicePolicyInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPServicePolicyInlineIpspaceInlineLinks ip service policy inline ipspace inline links
swagger:model ip_service_policy_inline_ipspace_inline__links
*/
type IPServicePolicyInlineIpspaceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ip service policy inline ipspace inline links
func (o *IPServicePolicyInlineIpspaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPServicePolicyInlineIpspaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip service policy inline ipspace inline links based on the context it is used
func (o *IPServicePolicyInlineIpspaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPServicePolicyInlineIpspaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPServicePolicyInlineIpspaceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPServicePolicyInlineIpspaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPServicePolicyInlineIpspaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPServicePolicyInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model ip_service_policy_inline_svm
*/
type IPServicePolicyInlineSvm struct {

	// links
	Links *models.IPServicePolicyInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ip service policy inline svm
func (o *IPServicePolicyInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPServicePolicyInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip service policy inline svm based on the context it is used
func (o *IPServicePolicyInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPServicePolicyInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPServicePolicyInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPServicePolicyInlineSvm) UnmarshalBinary(b []byte) error {
	var res IPServicePolicyInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPServicePolicyInlineSvmInlineLinks ip service policy inline svm inline links
swagger:model ip_service_policy_inline_svm_inline__links
*/
type IPServicePolicyInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ip service policy inline svm inline links
func (o *IPServicePolicyInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPServicePolicyInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip service policy inline svm inline links based on the context it is used
func (o *IPServicePolicyInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPServicePolicyInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPServicePolicyInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPServicePolicyInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPServicePolicyInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
