// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewIPServicePolicyModifyParams creates a new IPServicePolicyModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIPServicePolicyModifyParams() *IPServicePolicyModifyParams {
	return &IPServicePolicyModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIPServicePolicyModifyParamsWithTimeout creates a new IPServicePolicyModifyParams object
// with the ability to set a timeout on a request.
func NewIPServicePolicyModifyParamsWithTimeout(timeout time.Duration) *IPServicePolicyModifyParams {
	return &IPServicePolicyModifyParams{
		timeout: timeout,
	}
}

// NewIPServicePolicyModifyParamsWithContext creates a new IPServicePolicyModifyParams object
// with the ability to set a context for a request.
func NewIPServicePolicyModifyParamsWithContext(ctx context.Context) *IPServicePolicyModifyParams {
	return &IPServicePolicyModifyParams{
		Context: ctx,
	}
}

// NewIPServicePolicyModifyParamsWithHTTPClient creates a new IPServicePolicyModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewIPServicePolicyModifyParamsWithHTTPClient(client *http.Client) *IPServicePolicyModifyParams {
	return &IPServicePolicyModifyParams{
		HTTPClient: client,
	}
}

/*
IPServicePolicyModifyParams contains all the parameters to send to the API endpoint

	for the ip service policy modify operation.

	Typically these are written to a http.Request.
*/
type IPServicePolicyModifyParams struct {

	/* Info.

	   policy parameters
	*/
	Info *models.IPServicePolicy

	/* UUID.

	   UUID of the service policy
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ip service policy modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IPServicePolicyModifyParams) WithDefaults() *IPServicePolicyModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ip service policy modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IPServicePolicyModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the ip service policy modify params
func (o *IPServicePolicyModifyParams) WithTimeout(timeout time.Duration) *IPServicePolicyModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ip service policy modify params
func (o *IPServicePolicyModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ip service policy modify params
func (o *IPServicePolicyModifyParams) WithContext(ctx context.Context) *IPServicePolicyModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ip service policy modify params
func (o *IPServicePolicyModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ip service policy modify params
func (o *IPServicePolicyModifyParams) WithHTTPClient(client *http.Client) *IPServicePolicyModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ip service policy modify params
func (o *IPServicePolicyModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the ip service policy modify params
func (o *IPServicePolicyModifyParams) WithInfo(info *models.IPServicePolicy) *IPServicePolicyModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the ip service policy modify params
func (o *IPServicePolicyModifyParams) SetInfo(info *models.IPServicePolicy) {
	o.Info = info
}

// WithUUID adds the uuid to the ip service policy modify params
func (o *IPServicePolicyModifyParams) WithUUID(uuid string) *IPServicePolicyModifyParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the ip service policy modify params
func (o *IPServicePolicyModifyParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *IPServicePolicyModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
