// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewIPSubnetModifyCollectionParams creates a new IPSubnetModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIPSubnetModifyCollectionParams() *IPSubnetModifyCollectionParams {
	return &IPSubnetModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIPSubnetModifyCollectionParamsWithTimeout creates a new IPSubnetModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewIPSubnetModifyCollectionParamsWithTimeout(timeout time.Duration) *IPSubnetModifyCollectionParams {
	return &IPSubnetModifyCollectionParams{
		timeout: timeout,
	}
}

// NewIPSubnetModifyCollectionParamsWithContext creates a new IPSubnetModifyCollectionParams object
// with the ability to set a context for a request.
func NewIPSubnetModifyCollectionParamsWithContext(ctx context.Context) *IPSubnetModifyCollectionParams {
	return &IPSubnetModifyCollectionParams{
		Context: ctx,
	}
}

// NewIPSubnetModifyCollectionParamsWithHTTPClient creates a new IPSubnetModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewIPSubnetModifyCollectionParamsWithHTTPClient(client *http.Client) *IPSubnetModifyCollectionParams {
	return &IPSubnetModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
IPSubnetModifyCollectionParams contains all the parameters to send to the API endpoint

	for the ip subnet modify collection operation.

	Typically these are written to a http.Request.
*/
type IPSubnetModifyCollectionParams struct {

	/* AvailableCount.

	   Filter by available_count
	*/
	AvailableCount *int64

	/* AvailableIPRangesEnd.

	   Filter by available_ip_ranges.end
	*/
	AvailableIPRangesEnd *string

	/* AvailableIPRangesFamily.

	   Filter by available_ip_ranges.family
	*/
	AvailableIPRangesFamily *string

	/* AvailableIPRangesStart.

	   Filter by available_ip_ranges.start
	*/
	AvailableIPRangesStart *string

	/* BroadcastDomainName.

	   Filter by broadcast_domain.name
	*/
	BroadcastDomainName *string

	/* BroadcastDomainUUID.

	   Filter by broadcast_domain.uuid
	*/
	BroadcastDomainUUID *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Gateway.

	   Filter by gateway
	*/
	Gateway *string

	/* Info.

	   Info specification
	*/
	Info IPSubnetModifyCollectionBody

	/* IPRangesEnd.

	   Filter by ip_ranges.end
	*/
	IPRangesEnd *string

	/* IPRangesFamily.

	   Filter by ip_ranges.family
	*/
	IPRangesFamily *string

	/* IPRangesStart.

	   Filter by ip_ranges.start
	*/
	IPRangesStart *string

	/* IpspaceName.

	   Filter by ipspace.name
	*/
	IpspaceName *string

	/* IpspaceUUID.

	   Filter by ipspace.uuid
	*/
	IpspaceUUID *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SubnetAddress.

	   Filter by subnet.address
	*/
	SubnetAddress *string

	/* SubnetFamily.

	   Filter by subnet.family
	*/
	SubnetFamily *string

	/* SubnetNetmask.

	   Filter by subnet.netmask
	*/
	SubnetNetmask *string

	/* TotalCount.

	   Filter by total_count
	*/
	TotalCount *int64

	/* UsedCount.

	   Filter by used_count
	*/
	UsedCount *int64

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ip subnet modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IPSubnetModifyCollectionParams) WithDefaults() *IPSubnetModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ip subnet modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IPSubnetModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := IPSubnetModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithTimeout(timeout time.Duration) *IPSubnetModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithContext(ctx context.Context) *IPSubnetModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithHTTPClient(client *http.Client) *IPSubnetModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAvailableCount adds the availableCount to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithAvailableCount(availableCount *int64) *IPSubnetModifyCollectionParams {
	o.SetAvailableCount(availableCount)
	return o
}

// SetAvailableCount adds the availableCount to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetAvailableCount(availableCount *int64) {
	o.AvailableCount = availableCount
}

// WithAvailableIPRangesEnd adds the availableIPRangesEnd to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithAvailableIPRangesEnd(availableIPRangesEnd *string) *IPSubnetModifyCollectionParams {
	o.SetAvailableIPRangesEnd(availableIPRangesEnd)
	return o
}

// SetAvailableIPRangesEnd adds the availableIpRangesEnd to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetAvailableIPRangesEnd(availableIPRangesEnd *string) {
	o.AvailableIPRangesEnd = availableIPRangesEnd
}

// WithAvailableIPRangesFamily adds the availableIPRangesFamily to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithAvailableIPRangesFamily(availableIPRangesFamily *string) *IPSubnetModifyCollectionParams {
	o.SetAvailableIPRangesFamily(availableIPRangesFamily)
	return o
}

// SetAvailableIPRangesFamily adds the availableIpRangesFamily to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetAvailableIPRangesFamily(availableIPRangesFamily *string) {
	o.AvailableIPRangesFamily = availableIPRangesFamily
}

// WithAvailableIPRangesStart adds the availableIPRangesStart to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithAvailableIPRangesStart(availableIPRangesStart *string) *IPSubnetModifyCollectionParams {
	o.SetAvailableIPRangesStart(availableIPRangesStart)
	return o
}

// SetAvailableIPRangesStart adds the availableIpRangesStart to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetAvailableIPRangesStart(availableIPRangesStart *string) {
	o.AvailableIPRangesStart = availableIPRangesStart
}

// WithBroadcastDomainName adds the broadcastDomainName to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithBroadcastDomainName(broadcastDomainName *string) *IPSubnetModifyCollectionParams {
	o.SetBroadcastDomainName(broadcastDomainName)
	return o
}

// SetBroadcastDomainName adds the broadcastDomainName to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetBroadcastDomainName(broadcastDomainName *string) {
	o.BroadcastDomainName = broadcastDomainName
}

// WithBroadcastDomainUUID adds the broadcastDomainUUID to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithBroadcastDomainUUID(broadcastDomainUUID *string) *IPSubnetModifyCollectionParams {
	o.SetBroadcastDomainUUID(broadcastDomainUUID)
	return o
}

// SetBroadcastDomainUUID adds the broadcastDomainUuid to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetBroadcastDomainUUID(broadcastDomainUUID *string) {
	o.BroadcastDomainUUID = broadcastDomainUUID
}

// WithContinueOnFailure adds the continueOnFailure to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *IPSubnetModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithGateway adds the gateway to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithGateway(gateway *string) *IPSubnetModifyCollectionParams {
	o.SetGateway(gateway)
	return o
}

// SetGateway adds the gateway to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetGateway(gateway *string) {
	o.Gateway = gateway
}

// WithInfo adds the info to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithInfo(info IPSubnetModifyCollectionBody) *IPSubnetModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetInfo(info IPSubnetModifyCollectionBody) {
	o.Info = info
}

// WithIPRangesEnd adds the iPRangesEnd to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithIPRangesEnd(iPRangesEnd *string) *IPSubnetModifyCollectionParams {
	o.SetIPRangesEnd(iPRangesEnd)
	return o
}

// SetIPRangesEnd adds the ipRangesEnd to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetIPRangesEnd(iPRangesEnd *string) {
	o.IPRangesEnd = iPRangesEnd
}

// WithIPRangesFamily adds the iPRangesFamily to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithIPRangesFamily(iPRangesFamily *string) *IPSubnetModifyCollectionParams {
	o.SetIPRangesFamily(iPRangesFamily)
	return o
}

// SetIPRangesFamily adds the ipRangesFamily to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetIPRangesFamily(iPRangesFamily *string) {
	o.IPRangesFamily = iPRangesFamily
}

// WithIPRangesStart adds the iPRangesStart to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithIPRangesStart(iPRangesStart *string) *IPSubnetModifyCollectionParams {
	o.SetIPRangesStart(iPRangesStart)
	return o
}

// SetIPRangesStart adds the ipRangesStart to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetIPRangesStart(iPRangesStart *string) {
	o.IPRangesStart = iPRangesStart
}

// WithIpspaceName adds the ipspaceName to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithIpspaceName(ipspaceName *string) *IPSubnetModifyCollectionParams {
	o.SetIpspaceName(ipspaceName)
	return o
}

// SetIpspaceName adds the ipspaceName to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetIpspaceName(ipspaceName *string) {
	o.IpspaceName = ipspaceName
}

// WithIpspaceUUID adds the ipspaceUUID to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithIpspaceUUID(ipspaceUUID *string) *IPSubnetModifyCollectionParams {
	o.SetIpspaceUUID(ipspaceUUID)
	return o
}

// SetIpspaceUUID adds the ipspaceUuid to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetIpspaceUUID(ipspaceUUID *string) {
	o.IpspaceUUID = ipspaceUUID
}

// WithName adds the name to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithName(name *string) *IPSubnetModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithReturnRecords adds the returnRecords to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithReturnRecords(returnRecords *bool) *IPSubnetModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *IPSubnetModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithSerialRecords(serialRecords *bool) *IPSubnetModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSubnetAddress adds the subnetAddress to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithSubnetAddress(subnetAddress *string) *IPSubnetModifyCollectionParams {
	o.SetSubnetAddress(subnetAddress)
	return o
}

// SetSubnetAddress adds the subnetAddress to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetSubnetAddress(subnetAddress *string) {
	o.SubnetAddress = subnetAddress
}

// WithSubnetFamily adds the subnetFamily to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithSubnetFamily(subnetFamily *string) *IPSubnetModifyCollectionParams {
	o.SetSubnetFamily(subnetFamily)
	return o
}

// SetSubnetFamily adds the subnetFamily to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetSubnetFamily(subnetFamily *string) {
	o.SubnetFamily = subnetFamily
}

// WithSubnetNetmask adds the subnetNetmask to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithSubnetNetmask(subnetNetmask *string) *IPSubnetModifyCollectionParams {
	o.SetSubnetNetmask(subnetNetmask)
	return o
}

// SetSubnetNetmask adds the subnetNetmask to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetSubnetNetmask(subnetNetmask *string) {
	o.SubnetNetmask = subnetNetmask
}

// WithTotalCount adds the totalCount to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithTotalCount(totalCount *int64) *IPSubnetModifyCollectionParams {
	o.SetTotalCount(totalCount)
	return o
}

// SetTotalCount adds the totalCount to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetTotalCount(totalCount *int64) {
	o.TotalCount = totalCount
}

// WithUsedCount adds the usedCount to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithUsedCount(usedCount *int64) *IPSubnetModifyCollectionParams {
	o.SetUsedCount(usedCount)
	return o
}

// SetUsedCount adds the usedCount to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetUsedCount(usedCount *int64) {
	o.UsedCount = usedCount
}

// WithUUID adds the uuid to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) WithUUID(uuid *string) *IPSubnetModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the ip subnet modify collection params
func (o *IPSubnetModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *IPSubnetModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AvailableCount != nil {

		// query param available_count
		var qrAvailableCount int64

		if o.AvailableCount != nil {
			qrAvailableCount = *o.AvailableCount
		}
		qAvailableCount := swag.FormatInt64(qrAvailableCount)
		if qAvailableCount != "" {

			if err := r.SetQueryParam("available_count", qAvailableCount); err != nil {
				return err
			}
		}
	}

	if o.AvailableIPRangesEnd != nil {

		// query param available_ip_ranges.end
		var qrAvailableIPRangesEnd string

		if o.AvailableIPRangesEnd != nil {
			qrAvailableIPRangesEnd = *o.AvailableIPRangesEnd
		}
		qAvailableIPRangesEnd := qrAvailableIPRangesEnd
		if qAvailableIPRangesEnd != "" {

			if err := r.SetQueryParam("available_ip_ranges.end", qAvailableIPRangesEnd); err != nil {
				return err
			}
		}
	}

	if o.AvailableIPRangesFamily != nil {

		// query param available_ip_ranges.family
		var qrAvailableIPRangesFamily string

		if o.AvailableIPRangesFamily != nil {
			qrAvailableIPRangesFamily = *o.AvailableIPRangesFamily
		}
		qAvailableIPRangesFamily := qrAvailableIPRangesFamily
		if qAvailableIPRangesFamily != "" {

			if err := r.SetQueryParam("available_ip_ranges.family", qAvailableIPRangesFamily); err != nil {
				return err
			}
		}
	}

	if o.AvailableIPRangesStart != nil {

		// query param available_ip_ranges.start
		var qrAvailableIPRangesStart string

		if o.AvailableIPRangesStart != nil {
			qrAvailableIPRangesStart = *o.AvailableIPRangesStart
		}
		qAvailableIPRangesStart := qrAvailableIPRangesStart
		if qAvailableIPRangesStart != "" {

			if err := r.SetQueryParam("available_ip_ranges.start", qAvailableIPRangesStart); err != nil {
				return err
			}
		}
	}

	if o.BroadcastDomainName != nil {

		// query param broadcast_domain.name
		var qrBroadcastDomainName string

		if o.BroadcastDomainName != nil {
			qrBroadcastDomainName = *o.BroadcastDomainName
		}
		qBroadcastDomainName := qrBroadcastDomainName
		if qBroadcastDomainName != "" {

			if err := r.SetQueryParam("broadcast_domain.name", qBroadcastDomainName); err != nil {
				return err
			}
		}
	}

	if o.BroadcastDomainUUID != nil {

		// query param broadcast_domain.uuid
		var qrBroadcastDomainUUID string

		if o.BroadcastDomainUUID != nil {
			qrBroadcastDomainUUID = *o.BroadcastDomainUUID
		}
		qBroadcastDomainUUID := qrBroadcastDomainUUID
		if qBroadcastDomainUUID != "" {

			if err := r.SetQueryParam("broadcast_domain.uuid", qBroadcastDomainUUID); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Gateway != nil {

		// query param gateway
		var qrGateway string

		if o.Gateway != nil {
			qrGateway = *o.Gateway
		}
		qGateway := qrGateway
		if qGateway != "" {

			if err := r.SetQueryParam("gateway", qGateway); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IPRangesEnd != nil {

		// query param ip_ranges.end
		var qrIPRangesEnd string

		if o.IPRangesEnd != nil {
			qrIPRangesEnd = *o.IPRangesEnd
		}
		qIPRangesEnd := qrIPRangesEnd
		if qIPRangesEnd != "" {

			if err := r.SetQueryParam("ip_ranges.end", qIPRangesEnd); err != nil {
				return err
			}
		}
	}

	if o.IPRangesFamily != nil {

		// query param ip_ranges.family
		var qrIPRangesFamily string

		if o.IPRangesFamily != nil {
			qrIPRangesFamily = *o.IPRangesFamily
		}
		qIPRangesFamily := qrIPRangesFamily
		if qIPRangesFamily != "" {

			if err := r.SetQueryParam("ip_ranges.family", qIPRangesFamily); err != nil {
				return err
			}
		}
	}

	if o.IPRangesStart != nil {

		// query param ip_ranges.start
		var qrIPRangesStart string

		if o.IPRangesStart != nil {
			qrIPRangesStart = *o.IPRangesStart
		}
		qIPRangesStart := qrIPRangesStart
		if qIPRangesStart != "" {

			if err := r.SetQueryParam("ip_ranges.start", qIPRangesStart); err != nil {
				return err
			}
		}
	}

	if o.IpspaceName != nil {

		// query param ipspace.name
		var qrIpspaceName string

		if o.IpspaceName != nil {
			qrIpspaceName = *o.IpspaceName
		}
		qIpspaceName := qrIpspaceName
		if qIpspaceName != "" {

			if err := r.SetQueryParam("ipspace.name", qIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.IpspaceUUID != nil {

		// query param ipspace.uuid
		var qrIpspaceUUID string

		if o.IpspaceUUID != nil {
			qrIpspaceUUID = *o.IpspaceUUID
		}
		qIpspaceUUID := qrIpspaceUUID
		if qIpspaceUUID != "" {

			if err := r.SetQueryParam("ipspace.uuid", qIpspaceUUID); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SubnetAddress != nil {

		// query param subnet.address
		var qrSubnetAddress string

		if o.SubnetAddress != nil {
			qrSubnetAddress = *o.SubnetAddress
		}
		qSubnetAddress := qrSubnetAddress
		if qSubnetAddress != "" {

			if err := r.SetQueryParam("subnet.address", qSubnetAddress); err != nil {
				return err
			}
		}
	}

	if o.SubnetFamily != nil {

		// query param subnet.family
		var qrSubnetFamily string

		if o.SubnetFamily != nil {
			qrSubnetFamily = *o.SubnetFamily
		}
		qSubnetFamily := qrSubnetFamily
		if qSubnetFamily != "" {

			if err := r.SetQueryParam("subnet.family", qSubnetFamily); err != nil {
				return err
			}
		}
	}

	if o.SubnetNetmask != nil {

		// query param subnet.netmask
		var qrSubnetNetmask string

		if o.SubnetNetmask != nil {
			qrSubnetNetmask = *o.SubnetNetmask
		}
		qSubnetNetmask := qrSubnetNetmask
		if qSubnetNetmask != "" {

			if err := r.SetQueryParam("subnet.netmask", qSubnetNetmask); err != nil {
				return err
			}
		}
	}

	if o.TotalCount != nil {

		// query param total_count
		var qrTotalCount int64

		if o.TotalCount != nil {
			qrTotalCount = *o.TotalCount
		}
		qTotalCount := swag.FormatInt64(qrTotalCount)
		if qTotalCount != "" {

			if err := r.SetQueryParam("total_count", qTotalCount); err != nil {
				return err
			}
		}
	}

	if o.UsedCount != nil {

		// query param used_count
		var qrUsedCount int64

		if o.UsedCount != nil {
			qrUsedCount = *o.UsedCount
		}
		qUsedCount := swag.FormatInt64(qrUsedCount)
		if qUsedCount != "" {

			if err := r.SetQueryParam("used_count", qUsedCount); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
