// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IPSubnetModifyCollectionReader is a Reader for the IPSubnetModifyCollection structure.
type IPSubnetModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IPSubnetModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIPSubnetModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIPSubnetModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIPSubnetModifyCollectionOK creates a IPSubnetModifyCollectionOK with default headers values
func NewIPSubnetModifyCollectionOK() *IPSubnetModifyCollectionOK {
	return &IPSubnetModifyCollectionOK{}
}

/*
IPSubnetModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type IPSubnetModifyCollectionOK struct {
}

// IsSuccess returns true when this ip subnet modify collection o k response has a 2xx status code
func (o *IPSubnetModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ip subnet modify collection o k response has a 3xx status code
func (o *IPSubnetModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ip subnet modify collection o k response has a 4xx status code
func (o *IPSubnetModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ip subnet modify collection o k response has a 5xx status code
func (o *IPSubnetModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ip subnet modify collection o k response a status code equal to that given
func (o *IPSubnetModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ip subnet modify collection o k response
func (o *IPSubnetModifyCollectionOK) Code() int {
	return 200
}

func (o *IPSubnetModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /network/ip/subnets][%d] ipSubnetModifyCollectionOK", 200)
}

func (o *IPSubnetModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /network/ip/subnets][%d] ipSubnetModifyCollectionOK", 200)
}

func (o *IPSubnetModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewIPSubnetModifyCollectionDefault creates a IPSubnetModifyCollectionDefault with default headers values
func NewIPSubnetModifyCollectionDefault(code int) *IPSubnetModifyCollectionDefault {
	return &IPSubnetModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	IPSubnetModifyCollectionDefault describes a response with status code -1, with default header values.

	Fill error codes below.

ONTAP Error Response Codes
| Error Code | Description |
| ---------- | ----------- |
| 1377658 | Invalid gateway for subnet in IPspace. |
| 1377659 | Subnet would overlap with existing subnet named in IPspace. |
| 1377660 | A subnet with the name already exists in the IPspace. |
| 1377661 | Subnet in IPspace cannot use subnet address because that address is already used by subnet in the same IPspace. |
| 1377662 | The IP range address is not within the subnet in IPspace. |
| 1377663 | The specified IP address range of subnet in IPspace contains an address already in use by a LIF. |
| 1377664 | The specified IP address range of subnet in IPspace contains an address already in use by the Service Processor. |
| 1377669 | The specified gateway address exists in a configured range. |
| 1377673 | The addresses provided must have the same address family. |
| 1377674 | Modifying the netmask is not supported because the subnet has one or more interfaces associated with it. |
| 1377675 | The netmask of the interface did not match the netmask of the subnet. |
| 1377681 | Cannot update LIF associations for LIF. The broadcast domain of the LIF does not match the broadcast domain of the subnet. |
| 1966269 | IPv4 Addresses must have a prefix length between 1 and 32. |
| 1966778 | IPv6 addresses must have a prefix length between 1 and 127. |
| 53282568 | The subnet.address must be specified together with subnet.netmask. |
| 53282569 | The specified subnet.netmask is not valid. |
| 53282570 | Each pair of ranges must have ip_ranges.start less than or equal to ip_ranges.end. |
| 53282571 | The ip_ranges.start and ip_ranges.end fields must have the same number of items. |
| 53282572 | PATCH partially succeeded with error. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IPSubnetModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ip subnet modify collection default response has a 2xx status code
func (o *IPSubnetModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ip subnet modify collection default response has a 3xx status code
func (o *IPSubnetModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ip subnet modify collection default response has a 4xx status code
func (o *IPSubnetModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ip subnet modify collection default response has a 5xx status code
func (o *IPSubnetModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ip subnet modify collection default response a status code equal to that given
func (o *IPSubnetModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ip subnet modify collection default response
func (o *IPSubnetModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *IPSubnetModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/ip/subnets][%d] ip_subnet_modify_collection default %s", o._statusCode, payload)
}

func (o *IPSubnetModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/ip/subnets][%d] ip_subnet_modify_collection default %s", o._statusCode, payload)
}

func (o *IPSubnetModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IPSubnetModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
IPSubnetModifyCollectionBody IP subnet modify collection body
swagger:model IPSubnetModifyCollectionBody
*/
type IPSubnetModifyCollectionBody struct {

	// links
	Links *models.IPSubnetInlineLinks `json:"_links,omitempty"`

	// available count
	// Read Only: true
	AvailableCount *int64 `json:"available_count,omitempty"`

	// broadcast domain
	BroadcastDomain *models.IPSubnetInlineBroadcastDomain `json:"broadcast_domain,omitempty"`

	// This action will fail if any existing interface is using an IP address in the ranges provided. Set this to false to associate any manually addressed interfaces with the subnet and allow the action to succeed.
	FailIfLifsConflict *bool `json:"fail_if_lifs_conflict,omitempty"`

	// The IP address of the gateway for this subnet.
	// Example: 10.1.1.1
	Gateway *string `json:"gateway,omitempty"`

	// ip subnet inline available ip ranges
	// Read Only: true
	IPSubnetInlineAvailableIPRanges []*models.IPAddressRange `json:"available_ip_ranges,omitempty"`

	// ip subnet inline ip ranges
	IPSubnetInlineIPRanges []*models.IPAddressRange `json:"ip_ranges,omitempty"`

	// ip subnet response inline records
	IPSubnetResponseInlineRecords []*models.IPSubnet `json:"records,omitempty"`

	// ipspace
	Ipspace *models.IPSubnetInlineIpspace `json:"ipspace,omitempty"`

	// Subnet name
	// Example: subnet1
	Name *string `json:"name,omitempty"`

	// subnet
	Subnet *models.IPInfo `json:"subnet,omitempty"`

	// total count
	// Read Only: true
	TotalCount *int64 `json:"total_count,omitempty"`

	// used count
	// Read Only: true
	UsedCount *int64 `json:"used_count,omitempty"`

	// The UUID that uniquely identifies the subnet.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this IP subnet modify collection body
func (o *IPSubnetModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateBroadcastDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIPSubnetInlineAvailableIPRanges(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIPSubnetInlineIPRanges(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIPSubnetResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubnet(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPSubnetModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IPSubnetModifyCollectionBody) validateBroadcastDomain(formats strfmt.Registry) error {
	if swag.IsZero(o.BroadcastDomain) { // not required
		return nil
	}

	if o.BroadcastDomain != nil {
		if err := o.BroadcastDomain.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "broadcast_domain")
			}
			return err
		}
	}

	return nil
}

func (o *IPSubnetModifyCollectionBody) validateIPSubnetInlineAvailableIPRanges(formats strfmt.Registry) error {
	if swag.IsZero(o.IPSubnetInlineAvailableIPRanges) { // not required
		return nil
	}

	for i := 0; i < len(o.IPSubnetInlineAvailableIPRanges); i++ {
		if swag.IsZero(o.IPSubnetInlineAvailableIPRanges[i]) { // not required
			continue
		}

		if o.IPSubnetInlineAvailableIPRanges[i] != nil {
			if err := o.IPSubnetInlineAvailableIPRanges[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "available_ip_ranges" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IPSubnetModifyCollectionBody) validateIPSubnetInlineIPRanges(formats strfmt.Registry) error {
	if swag.IsZero(o.IPSubnetInlineIPRanges) { // not required
		return nil
	}

	for i := 0; i < len(o.IPSubnetInlineIPRanges); i++ {
		if swag.IsZero(o.IPSubnetInlineIPRanges[i]) { // not required
			continue
		}

		if o.IPSubnetInlineIPRanges[i] != nil {
			if err := o.IPSubnetInlineIPRanges[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "ip_ranges" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IPSubnetModifyCollectionBody) validateIPSubnetResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.IPSubnetResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.IPSubnetResponseInlineRecords); i++ {
		if swag.IsZero(o.IPSubnetResponseInlineRecords[i]) { // not required
			continue
		}

		if o.IPSubnetResponseInlineRecords[i] != nil {
			if err := o.IPSubnetResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IPSubnetModifyCollectionBody) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(o.Ipspace) { // not required
		return nil
	}

	if o.Ipspace != nil {
		if err := o.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

func (o *IPSubnetModifyCollectionBody) validateSubnet(formats strfmt.Registry) error {
	if swag.IsZero(o.Subnet) { // not required
		return nil
	}

	if o.Subnet != nil {
		if err := o.Subnet.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subnet")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this IP subnet modify collection body based on the context it is used
func (o *IPSubnetModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAvailableCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateBroadcastDomain(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIPSubnetInlineAvailableIPRanges(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIPSubnetInlineIPRanges(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIPSubnetResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubnet(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPSubnetModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IPSubnetModifyCollectionBody) contextValidateAvailableCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"available_count", "body", o.AvailableCount); err != nil {
		return err
	}

	return nil
}

func (o *IPSubnetModifyCollectionBody) contextValidateBroadcastDomain(ctx context.Context, formats strfmt.Registry) error {

	if o.BroadcastDomain != nil {
		if err := o.BroadcastDomain.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "broadcast_domain")
			}
			return err
		}
	}

	return nil
}

func (o *IPSubnetModifyCollectionBody) contextValidateIPSubnetInlineAvailableIPRanges(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"available_ip_ranges", "body", []*models.IPAddressRange(o.IPSubnetInlineAvailableIPRanges)); err != nil {
		return err
	}

	for i := 0; i < len(o.IPSubnetInlineAvailableIPRanges); i++ {

		if o.IPSubnetInlineAvailableIPRanges[i] != nil {
			if err := o.IPSubnetInlineAvailableIPRanges[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "available_ip_ranges" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IPSubnetModifyCollectionBody) contextValidateIPSubnetInlineIPRanges(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.IPSubnetInlineIPRanges); i++ {

		if o.IPSubnetInlineIPRanges[i] != nil {
			if err := o.IPSubnetInlineIPRanges[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "ip_ranges" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IPSubnetModifyCollectionBody) contextValidateIPSubnetResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.IPSubnetResponseInlineRecords); i++ {

		if o.IPSubnetResponseInlineRecords[i] != nil {
			if err := o.IPSubnetResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IPSubnetModifyCollectionBody) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if o.Ipspace != nil {
		if err := o.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

func (o *IPSubnetModifyCollectionBody) contextValidateSubnet(ctx context.Context, formats strfmt.Registry) error {

	if o.Subnet != nil {
		if err := o.Subnet.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subnet")
			}
			return err
		}
	}

	return nil
}

func (o *IPSubnetModifyCollectionBody) contextValidateTotalCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_count", "body", o.TotalCount); err != nil {
		return err
	}

	return nil
}

func (o *IPSubnetModifyCollectionBody) contextValidateUsedCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"used_count", "body", o.UsedCount); err != nil {
		return err
	}

	return nil
}

func (o *IPSubnetModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPSubnetModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPSubnetModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res IPSubnetModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPSubnetInlineLinks ip subnet inline links
swagger:model ip_subnet_inline__links
*/
type IPSubnetInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ip subnet inline links
func (o *IPSubnetInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPSubnetInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip subnet inline links based on the context it is used
func (o *IPSubnetInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPSubnetInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPSubnetInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPSubnetInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPSubnetInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPSubnetInlineBroadcastDomain The broadcast domain that the subnet is associated with. Either the UUID or name must be supplied on POST.
swagger:model ip_subnet_inline_broadcast_domain
*/
type IPSubnetInlineBroadcastDomain struct {

	// links
	Links *models.IPSubnetInlineBroadcastDomainInlineLinks `json:"_links,omitempty"`

	// Name of the broadcast domain, scoped to its IPspace
	// Example: bd1
	Name *string `json:"name,omitempty"`

	// Broadcast domain UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ip subnet inline broadcast domain
func (o *IPSubnetInlineBroadcastDomain) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPSubnetInlineBroadcastDomain) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "broadcast_domain" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip subnet inline broadcast domain based on the context it is used
func (o *IPSubnetInlineBroadcastDomain) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPSubnetInlineBroadcastDomain) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "broadcast_domain" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPSubnetInlineBroadcastDomain) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPSubnetInlineBroadcastDomain) UnmarshalBinary(b []byte) error {
	var res IPSubnetInlineBroadcastDomain
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPSubnetInlineBroadcastDomainInlineLinks ip subnet inline broadcast domain inline links
swagger:model ip_subnet_inline_broadcast_domain_inline__links
*/
type IPSubnetInlineBroadcastDomainInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ip subnet inline broadcast domain inline links
func (o *IPSubnetInlineBroadcastDomainInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPSubnetInlineBroadcastDomainInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "broadcast_domain" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip subnet inline broadcast domain inline links based on the context it is used
func (o *IPSubnetInlineBroadcastDomainInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPSubnetInlineBroadcastDomainInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "broadcast_domain" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPSubnetInlineBroadcastDomainInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPSubnetInlineBroadcastDomainInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPSubnetInlineBroadcastDomainInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPSubnetInlineIpspace The IPspace that the subnet is associated with. Either the UUID or name must be supplied on POST.
swagger:model ip_subnet_inline_ipspace
*/
type IPSubnetInlineIpspace struct {

	// links
	Links *models.IPSubnetInlineIpspaceInlineLinks `json:"_links,omitempty"`

	// IPspace name
	// Example: Default
	Name *string `json:"name,omitempty"`

	// IPspace UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ip subnet inline ipspace
func (o *IPSubnetInlineIpspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPSubnetInlineIpspace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip subnet inline ipspace based on the context it is used
func (o *IPSubnetInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPSubnetInlineIpspace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPSubnetInlineIpspace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPSubnetInlineIpspace) UnmarshalBinary(b []byte) error {
	var res IPSubnetInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPSubnetInlineIpspaceInlineLinks ip subnet inline ipspace inline links
swagger:model ip_subnet_inline_ipspace_inline__links
*/
type IPSubnetInlineIpspaceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ip subnet inline ipspace inline links
func (o *IPSubnetInlineIpspaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPSubnetInlineIpspaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip subnet inline ipspace inline links based on the context it is used
func (o *IPSubnetInlineIpspaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPSubnetInlineIpspaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPSubnetInlineIpspaceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPSubnetInlineIpspaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPSubnetInlineIpspaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
