// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewIpspaceDeleteCollectionParams creates a new IpspaceDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIpspaceDeleteCollectionParams() *IpspaceDeleteCollectionParams {
	return &IpspaceDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIpspaceDeleteCollectionParamsWithTimeout creates a new IpspaceDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewIpspaceDeleteCollectionParamsWithTimeout(timeout time.Duration) *IpspaceDeleteCollectionParams {
	return &IpspaceDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewIpspaceDeleteCollectionParamsWithContext creates a new IpspaceDeleteCollectionParams object
// with the ability to set a context for a request.
func NewIpspaceDeleteCollectionParamsWithContext(ctx context.Context) *IpspaceDeleteCollectionParams {
	return &IpspaceDeleteCollectionParams{
		Context: ctx,
	}
}

// NewIpspaceDeleteCollectionParamsWithHTTPClient creates a new IpspaceDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewIpspaceDeleteCollectionParamsWithHTTPClient(client *http.Client) *IpspaceDeleteCollectionParams {
	return &IpspaceDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
IpspaceDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the ipspace delete collection operation.

	Typically these are written to a http.Request.
*/
type IpspaceDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info IpspaceDeleteCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ipspace delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IpspaceDeleteCollectionParams) WithDefaults() *IpspaceDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ipspace delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IpspaceDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := IpspaceDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the ipspace delete collection params
func (o *IpspaceDeleteCollectionParams) WithTimeout(timeout time.Duration) *IpspaceDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ipspace delete collection params
func (o *IpspaceDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ipspace delete collection params
func (o *IpspaceDeleteCollectionParams) WithContext(ctx context.Context) *IpspaceDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ipspace delete collection params
func (o *IpspaceDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ipspace delete collection params
func (o *IpspaceDeleteCollectionParams) WithHTTPClient(client *http.Client) *IpspaceDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ipspace delete collection params
func (o *IpspaceDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the ipspace delete collection params
func (o *IpspaceDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *IpspaceDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the ipspace delete collection params
func (o *IpspaceDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the ipspace delete collection params
func (o *IpspaceDeleteCollectionParams) WithInfo(info IpspaceDeleteCollectionBody) *IpspaceDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the ipspace delete collection params
func (o *IpspaceDeleteCollectionParams) SetInfo(info IpspaceDeleteCollectionBody) {
	o.Info = info
}

// WithName adds the name to the ipspace delete collection params
func (o *IpspaceDeleteCollectionParams) WithName(name *string) *IpspaceDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the ipspace delete collection params
func (o *IpspaceDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithReturnRecords adds the returnRecords to the ipspace delete collection params
func (o *IpspaceDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *IpspaceDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the ipspace delete collection params
func (o *IpspaceDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the ipspace delete collection params
func (o *IpspaceDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *IpspaceDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the ipspace delete collection params
func (o *IpspaceDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the ipspace delete collection params
func (o *IpspaceDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *IpspaceDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the ipspace delete collection params
func (o *IpspaceDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithUUID adds the uuid to the ipspace delete collection params
func (o *IpspaceDeleteCollectionParams) WithUUID(uuid *string) *IpspaceDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the ipspace delete collection params
func (o *IpspaceDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *IpspaceDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
