// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IpspaceDeleteCollectionReader is a Reader for the IpspaceDeleteCollection structure.
type IpspaceDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IpspaceDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIpspaceDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIpspaceDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIpspaceDeleteCollectionOK creates a IpspaceDeleteCollectionOK with default headers values
func NewIpspaceDeleteCollectionOK() *IpspaceDeleteCollectionOK {
	return &IpspaceDeleteCollectionOK{}
}

/*
IpspaceDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type IpspaceDeleteCollectionOK struct {
}

// IsSuccess returns true when this ipspace delete collection o k response has a 2xx status code
func (o *IpspaceDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ipspace delete collection o k response has a 3xx status code
func (o *IpspaceDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ipspace delete collection o k response has a 4xx status code
func (o *IpspaceDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ipspace delete collection o k response has a 5xx status code
func (o *IpspaceDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ipspace delete collection o k response a status code equal to that given
func (o *IpspaceDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ipspace delete collection o k response
func (o *IpspaceDeleteCollectionOK) Code() int {
	return 200
}

func (o *IpspaceDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /network/ipspaces][%d] ipspaceDeleteCollectionOK", 200)
}

func (o *IpspaceDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /network/ipspaces][%d] ipspaceDeleteCollectionOK", 200)
}

func (o *IpspaceDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewIpspaceDeleteCollectionDefault creates a IpspaceDeleteCollectionDefault with default headers values
func NewIpspaceDeleteCollectionDefault(code int) *IpspaceDeleteCollectionDefault {
	return &IpspaceDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	IpspaceDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1966309 | The IPspace cannot be removed because it is being used by the audit log forwarding feature. |
| 1966333 | IPspace can't be removed because it has SVMs assigned. |
| 1969180 | Cannot delete an IPspace with an existing broadcast domain. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IpspaceDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ipspace delete collection default response has a 2xx status code
func (o *IpspaceDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ipspace delete collection default response has a 3xx status code
func (o *IpspaceDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ipspace delete collection default response has a 4xx status code
func (o *IpspaceDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ipspace delete collection default response has a 5xx status code
func (o *IpspaceDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ipspace delete collection default response a status code equal to that given
func (o *IpspaceDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ipspace delete collection default response
func (o *IpspaceDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *IpspaceDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /network/ipspaces][%d] ipspace_delete_collection default %s", o._statusCode, payload)
}

func (o *IpspaceDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /network/ipspaces][%d] ipspace_delete_collection default %s", o._statusCode, payload)
}

func (o *IpspaceDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IpspaceDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
IpspaceDeleteCollectionBody ipspace delete collection body
swagger:model IpspaceDeleteCollectionBody
*/
type IpspaceDeleteCollectionBody struct {

	// ipspace response inline records
	IpspaceResponseInlineRecords []*models.Ipspace `json:"records,omitempty"`
}

// Validate validates this ipspace delete collection body
func (o *IpspaceDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIpspaceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpspaceDeleteCollectionBody) validateIpspaceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.IpspaceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.IpspaceResponseInlineRecords); i++ {
		if swag.IsZero(o.IpspaceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.IpspaceResponseInlineRecords[i] != nil {
			if err := o.IpspaceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ipspace delete collection body based on the context it is used
func (o *IpspaceDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIpspaceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpspaceDeleteCollectionBody) contextValidateIpspaceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.IpspaceResponseInlineRecords); i++ {

		if o.IpspaceResponseInlineRecords[i] != nil {
			if err := o.IpspaceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *IpspaceDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IpspaceDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res IpspaceDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
