// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IpspaceModifyCollectionReader is a Reader for the IpspaceModifyCollection structure.
type IpspaceModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IpspaceModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIpspaceModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIpspaceModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIpspaceModifyCollectionOK creates a IpspaceModifyCollectionOK with default headers values
func NewIpspaceModifyCollectionOK() *IpspaceModifyCollectionOK {
	return &IpspaceModifyCollectionOK{}
}

/*
IpspaceModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type IpspaceModifyCollectionOK struct {
}

// IsSuccess returns true when this ipspace modify collection o k response has a 2xx status code
func (o *IpspaceModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ipspace modify collection o k response has a 3xx status code
func (o *IpspaceModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ipspace modify collection o k response has a 4xx status code
func (o *IpspaceModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ipspace modify collection o k response has a 5xx status code
func (o *IpspaceModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ipspace modify collection o k response a status code equal to that given
func (o *IpspaceModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ipspace modify collection o k response
func (o *IpspaceModifyCollectionOK) Code() int {
	return 200
}

func (o *IpspaceModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /network/ipspaces][%d] ipspaceModifyCollectionOK", 200)
}

func (o *IpspaceModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /network/ipspaces][%d] ipspaceModifyCollectionOK", 200)
}

func (o *IpspaceModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewIpspaceModifyCollectionDefault creates a IpspaceModifyCollectionDefault with default headers values
func NewIpspaceModifyCollectionDefault(code int) *IpspaceModifyCollectionDefault {
	return &IpspaceModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	IpspaceModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1377256 | Another IPspace with the same name exists. |
| 1377259 | System-defined IPspaces cannot be modified or removed. |
| 1966449 | Invalid IPspace name in MetroCluster configurations. |
| 9240587 | IPspace name cannot be empty. |
| 9240588 | The specified name is too long. |
| 9240589 | Invalid character in specified name. |
| 9240590 | Invalid name, the name is reserved by the system. |
| 9240591 | Invalid name.  The name is already in use by a cluster node, Vserver, or it is the name of the local cluster. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IpspaceModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ipspace modify collection default response has a 2xx status code
func (o *IpspaceModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ipspace modify collection default response has a 3xx status code
func (o *IpspaceModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ipspace modify collection default response has a 4xx status code
func (o *IpspaceModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ipspace modify collection default response has a 5xx status code
func (o *IpspaceModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ipspace modify collection default response a status code equal to that given
func (o *IpspaceModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ipspace modify collection default response
func (o *IpspaceModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *IpspaceModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/ipspaces][%d] ipspace_modify_collection default %s", o._statusCode, payload)
}

func (o *IpspaceModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/ipspaces][%d] ipspace_modify_collection default %s", o._statusCode, payload)
}

func (o *IpspaceModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IpspaceModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
IpspaceModifyCollectionBody ipspace modify collection body
swagger:model IpspaceModifyCollectionBody
*/
type IpspaceModifyCollectionBody struct {

	// links
	Links *models.IpspaceInlineLinks `json:"_links,omitempty"`

	// ipspace response inline records
	IpspaceResponseInlineRecords []*models.Ipspace `json:"records,omitempty"`

	// IPspace name
	// Example: ipspace1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the IPspace.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ipspace modify collection body
func (o *IpspaceModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIpspaceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpspaceModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IpspaceModifyCollectionBody) validateIpspaceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.IpspaceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.IpspaceResponseInlineRecords); i++ {
		if swag.IsZero(o.IpspaceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.IpspaceResponseInlineRecords[i] != nil {
			if err := o.IpspaceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ipspace modify collection body based on the context it is used
func (o *IpspaceModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIpspaceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpspaceModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IpspaceModifyCollectionBody) contextValidateIpspaceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.IpspaceResponseInlineRecords); i++ {

		if o.IpspaceResponseInlineRecords[i] != nil {
			if err := o.IpspaceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IpspaceModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IpspaceModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IpspaceModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res IpspaceModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IpspaceInlineLinks ipspace inline links
swagger:model ipspace_inline__links
*/
type IpspaceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ipspace inline links
func (o *IpspaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpspaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipspace inline links based on the context it is used
func (o *IpspaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpspaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IpspaceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IpspaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res IpspaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
