// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewIpspaceModifyParams creates a new IpspaceModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIpspaceModifyParams() *IpspaceModifyParams {
	return &IpspaceModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIpspaceModifyParamsWithTimeout creates a new IpspaceModifyParams object
// with the ability to set a timeout on a request.
func NewIpspaceModifyParamsWithTimeout(timeout time.Duration) *IpspaceModifyParams {
	return &IpspaceModifyParams{
		timeout: timeout,
	}
}

// NewIpspaceModifyParamsWithContext creates a new IpspaceModifyParams object
// with the ability to set a context for a request.
func NewIpspaceModifyParamsWithContext(ctx context.Context) *IpspaceModifyParams {
	return &IpspaceModifyParams{
		Context: ctx,
	}
}

// NewIpspaceModifyParamsWithHTTPClient creates a new IpspaceModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewIpspaceModifyParamsWithHTTPClient(client *http.Client) *IpspaceModifyParams {
	return &IpspaceModifyParams{
		HTTPClient: client,
	}
}

/*
IpspaceModifyParams contains all the parameters to send to the API endpoint

	for the ipspace modify operation.

	Typically these are written to a http.Request.
*/
type IpspaceModifyParams struct {

	// Info.
	Info *models.Ipspace

	/* UUID.

	   IPspace UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ipspace modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IpspaceModifyParams) WithDefaults() *IpspaceModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ipspace modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IpspaceModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the ipspace modify params
func (o *IpspaceModifyParams) WithTimeout(timeout time.Duration) *IpspaceModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ipspace modify params
func (o *IpspaceModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ipspace modify params
func (o *IpspaceModifyParams) WithContext(ctx context.Context) *IpspaceModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ipspace modify params
func (o *IpspaceModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ipspace modify params
func (o *IpspaceModifyParams) WithHTTPClient(client *http.Client) *IpspaceModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ipspace modify params
func (o *IpspaceModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the ipspace modify params
func (o *IpspaceModifyParams) WithInfo(info *models.Ipspace) *IpspaceModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the ipspace modify params
func (o *IpspaceModifyParams) SetInfo(info *models.Ipspace) {
	o.Info = info
}

// WithUUID adds the uuid to the ipspace modify params
func (o *IpspaceModifyParams) WithUUID(uuid string) *IpspaceModifyParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the ipspace modify params
func (o *IpspaceModifyParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *IpspaceModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
