// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewIpspacesCreateParams creates a new IpspacesCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIpspacesCreateParams() *IpspacesCreateParams {
	return &IpspacesCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIpspacesCreateParamsWithTimeout creates a new IpspacesCreateParams object
// with the ability to set a timeout on a request.
func NewIpspacesCreateParamsWithTimeout(timeout time.Duration) *IpspacesCreateParams {
	return &IpspacesCreateParams{
		timeout: timeout,
	}
}

// NewIpspacesCreateParamsWithContext creates a new IpspacesCreateParams object
// with the ability to set a context for a request.
func NewIpspacesCreateParamsWithContext(ctx context.Context) *IpspacesCreateParams {
	return &IpspacesCreateParams{
		Context: ctx,
	}
}

// NewIpspacesCreateParamsWithHTTPClient creates a new IpspacesCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewIpspacesCreateParamsWithHTTPClient(client *http.Client) *IpspacesCreateParams {
	return &IpspacesCreateParams{
		HTTPClient: client,
	}
}

/*
IpspacesCreateParams contains all the parameters to send to the API endpoint

	for the ipspaces create operation.

	Typically these are written to a http.Request.
*/
type IpspacesCreateParams struct {

	/* Info.

	   IPspace identifiers
	*/
	Info *models.Ipspace

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ipspaces create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IpspacesCreateParams) WithDefaults() *IpspacesCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ipspaces create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IpspacesCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := IpspacesCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the ipspaces create params
func (o *IpspacesCreateParams) WithTimeout(timeout time.Duration) *IpspacesCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ipspaces create params
func (o *IpspacesCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ipspaces create params
func (o *IpspacesCreateParams) WithContext(ctx context.Context) *IpspacesCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ipspaces create params
func (o *IpspacesCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ipspaces create params
func (o *IpspacesCreateParams) WithHTTPClient(client *http.Client) *IpspacesCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ipspaces create params
func (o *IpspacesCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the ipspaces create params
func (o *IpspacesCreateParams) WithInfo(info *models.Ipspace) *IpspacesCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the ipspaces create params
func (o *IpspacesCreateParams) SetInfo(info *models.Ipspace) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the ipspaces create params
func (o *IpspacesCreateParams) WithReturnRecords(returnRecords *bool) *IpspacesCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the ipspaces create params
func (o *IpspacesCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *IpspacesCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
