// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IpspacesCreateReader is a Reader for the IpspacesCreate structure.
type IpspacesCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IpspacesCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewIpspacesCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIpspacesCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIpspacesCreateCreated creates a IpspacesCreateCreated with default headers values
func NewIpspacesCreateCreated() *IpspacesCreateCreated {
	return &IpspacesCreateCreated{}
}

/*
IpspacesCreateCreated describes a response with status code 201, with default header values.

Created
*/
type IpspacesCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string
}

// IsSuccess returns true when this ipspaces create created response has a 2xx status code
func (o *IpspacesCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ipspaces create created response has a 3xx status code
func (o *IpspacesCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ipspaces create created response has a 4xx status code
func (o *IpspacesCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this ipspaces create created response has a 5xx status code
func (o *IpspacesCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this ipspaces create created response a status code equal to that given
func (o *IpspacesCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the ipspaces create created response
func (o *IpspacesCreateCreated) Code() int {
	return 201
}

func (o *IpspacesCreateCreated) Error() string {
	return fmt.Sprintf("[POST /network/ipspaces][%d] ipspacesCreateCreated", 201)
}

func (o *IpspacesCreateCreated) String() string {
	return fmt.Sprintf("[POST /network/ipspaces][%d] ipspacesCreateCreated", 201)
}

func (o *IpspacesCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	return nil
}

// NewIpspacesCreateDefault creates a IpspacesCreateDefault with default headers values
func NewIpspacesCreateDefault(code int) *IpspacesCreateDefault {
	return &IpspacesCreateDefault{
		_statusCode: code,
	}
}

/*
	IpspacesCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1377261 | An IPspace with the same name already exists. |
| 1966449 | Invalid IPspace name in MetroCluster configurations. |
| 1966586 | The specified IPspace name is invalid because it is already used by a peered SVM. |
| 1967102 | A POST operation might have left the configuration in an inconsistent state. Check the configuration. |
| 9240587 | Name cannot be empty. |
| 9240588 | The name is too long. |
| 9240589 | Invalid character in name. |
| 9240590 | The name is reserved by the system. |
| 9240591 | The name is not valid. The name is already in use by a cluster node, Vserver, or it is the name of the local cluster. |
| 53281576 | Cannot create IPspace because the maximum number of custom IPspaces has already been reached on the cluster. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IpspacesCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ipspaces create default response has a 2xx status code
func (o *IpspacesCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ipspaces create default response has a 3xx status code
func (o *IpspacesCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ipspaces create default response has a 4xx status code
func (o *IpspacesCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ipspaces create default response has a 5xx status code
func (o *IpspacesCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ipspaces create default response a status code equal to that given
func (o *IpspacesCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ipspaces create default response
func (o *IpspacesCreateDefault) Code() int {
	return o._statusCode
}

func (o *IpspacesCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /network/ipspaces][%d] ipspaces_create default %s", o._statusCode, payload)
}

func (o *IpspacesCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /network/ipspaces][%d] ipspaces_create default %s", o._statusCode, payload)
}

func (o *IpspacesCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IpspacesCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
