// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IpspacesGetReader is a Reader for the IpspacesGet structure.
type IpspacesGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IpspacesGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIpspacesGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIpspacesGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIpspacesGetOK creates a IpspacesGetOK with default headers values
func NewIpspacesGetOK() *IpspacesGetOK {
	return &IpspacesGetOK{}
}

/*
IpspacesGetOK describes a response with status code 200, with default header values.

OK
*/
type IpspacesGetOK struct {
	Payload *models.IpspaceResponse
}

// IsSuccess returns true when this ipspaces get o k response has a 2xx status code
func (o *IpspacesGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ipspaces get o k response has a 3xx status code
func (o *IpspacesGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ipspaces get o k response has a 4xx status code
func (o *IpspacesGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ipspaces get o k response has a 5xx status code
func (o *IpspacesGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ipspaces get o k response a status code equal to that given
func (o *IpspacesGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ipspaces get o k response
func (o *IpspacesGetOK) Code() int {
	return 200
}

func (o *IpspacesGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/ipspaces][%d] ipspacesGetOK %s", 200, payload)
}

func (o *IpspacesGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/ipspaces][%d] ipspacesGetOK %s", 200, payload)
}

func (o *IpspacesGetOK) GetPayload() *models.IpspaceResponse {
	return o.Payload
}

func (o *IpspacesGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.IpspaceResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewIpspacesGetDefault creates a IpspacesGetDefault with default headers values
func NewIpspacesGetDefault(code int) *IpspacesGetDefault {
	return &IpspacesGetDefault{
		_statusCode: code,
	}
}

/*
IpspacesGetDefault describes a response with status code -1, with default header values.

Error
*/
type IpspacesGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ipspaces get default response has a 2xx status code
func (o *IpspacesGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ipspaces get default response has a 3xx status code
func (o *IpspacesGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ipspaces get default response has a 4xx status code
func (o *IpspacesGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ipspaces get default response has a 5xx status code
func (o *IpspacesGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ipspaces get default response a status code equal to that given
func (o *IpspacesGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ipspaces get default response
func (o *IpspacesGetDefault) Code() int {
	return o._statusCode
}

func (o *IpspacesGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/ipspaces][%d] ipspaces_get default %s", o._statusCode, payload)
}

func (o *IpspacesGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/ipspaces][%d] ipspaces_get default %s", o._statusCode, payload)
}

func (o *IpspacesGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IpspacesGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
