// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNetworkEthernetBroadcastDomainModifyCollectionParams creates a new NetworkEthernetBroadcastDomainModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNetworkEthernetBroadcastDomainModifyCollectionParams() *NetworkEthernetBroadcastDomainModifyCollectionParams {
	return &NetworkEthernetBroadcastDomainModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNetworkEthernetBroadcastDomainModifyCollectionParamsWithTimeout creates a new NetworkEthernetBroadcastDomainModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewNetworkEthernetBroadcastDomainModifyCollectionParamsWithTimeout(timeout time.Duration) *NetworkEthernetBroadcastDomainModifyCollectionParams {
	return &NetworkEthernetBroadcastDomainModifyCollectionParams{
		timeout: timeout,
	}
}

// NewNetworkEthernetBroadcastDomainModifyCollectionParamsWithContext creates a new NetworkEthernetBroadcastDomainModifyCollectionParams object
// with the ability to set a context for a request.
func NewNetworkEthernetBroadcastDomainModifyCollectionParamsWithContext(ctx context.Context) *NetworkEthernetBroadcastDomainModifyCollectionParams {
	return &NetworkEthernetBroadcastDomainModifyCollectionParams{
		Context: ctx,
	}
}

// NewNetworkEthernetBroadcastDomainModifyCollectionParamsWithHTTPClient creates a new NetworkEthernetBroadcastDomainModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewNetworkEthernetBroadcastDomainModifyCollectionParamsWithHTTPClient(client *http.Client) *NetworkEthernetBroadcastDomainModifyCollectionParams {
	return &NetworkEthernetBroadcastDomainModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
NetworkEthernetBroadcastDomainModifyCollectionParams contains all the parameters to send to the API endpoint

	for the network ethernet broadcast domain modify collection operation.

	Typically these are written to a http.Request.
*/
type NetworkEthernetBroadcastDomainModifyCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info NetworkEthernetBroadcastDomainModifyCollectionBody

	/* IpspaceName.

	   Filter by ipspace.name
	*/
	IpspaceName *string

	/* IpspaceUUID.

	   Filter by ipspace.uuid
	*/
	IpspaceUUID *string

	/* Mtu.

	   Filter by mtu
	*/
	Mtu *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* PortsName.

	   Filter by ports.name
	*/
	PortsName *string

	/* PortsNodeName.

	   Filter by ports.node.name
	*/
	PortsNodeName *string

	/* PortsUUID.

	   Filter by ports.uuid
	*/
	PortsUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the network ethernet broadcast domain modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) WithDefaults() *NetworkEthernetBroadcastDomainModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the network ethernet broadcast domain modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := NetworkEthernetBroadcastDomainModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) WithTimeout(timeout time.Duration) *NetworkEthernetBroadcastDomainModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) WithContext(ctx context.Context) *NetworkEthernetBroadcastDomainModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) WithHTTPClient(client *http.Client) *NetworkEthernetBroadcastDomainModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *NetworkEthernetBroadcastDomainModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) WithInfo(info NetworkEthernetBroadcastDomainModifyCollectionBody) *NetworkEthernetBroadcastDomainModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) SetInfo(info NetworkEthernetBroadcastDomainModifyCollectionBody) {
	o.Info = info
}

// WithIpspaceName adds the ipspaceName to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) WithIpspaceName(ipspaceName *string) *NetworkEthernetBroadcastDomainModifyCollectionParams {
	o.SetIpspaceName(ipspaceName)
	return o
}

// SetIpspaceName adds the ipspaceName to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) SetIpspaceName(ipspaceName *string) {
	o.IpspaceName = ipspaceName
}

// WithIpspaceUUID adds the ipspaceUUID to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) WithIpspaceUUID(ipspaceUUID *string) *NetworkEthernetBroadcastDomainModifyCollectionParams {
	o.SetIpspaceUUID(ipspaceUUID)
	return o
}

// SetIpspaceUUID adds the ipspaceUuid to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) SetIpspaceUUID(ipspaceUUID *string) {
	o.IpspaceUUID = ipspaceUUID
}

// WithMtu adds the mtu to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) WithMtu(mtu *int64) *NetworkEthernetBroadcastDomainModifyCollectionParams {
	o.SetMtu(mtu)
	return o
}

// SetMtu adds the mtu to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) SetMtu(mtu *int64) {
	o.Mtu = mtu
}

// WithName adds the name to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) WithName(name *string) *NetworkEthernetBroadcastDomainModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithPortsName adds the portsName to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) WithPortsName(portsName *string) *NetworkEthernetBroadcastDomainModifyCollectionParams {
	o.SetPortsName(portsName)
	return o
}

// SetPortsName adds the portsName to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) SetPortsName(portsName *string) {
	o.PortsName = portsName
}

// WithPortsNodeName adds the portsNodeName to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) WithPortsNodeName(portsNodeName *string) *NetworkEthernetBroadcastDomainModifyCollectionParams {
	o.SetPortsNodeName(portsNodeName)
	return o
}

// SetPortsNodeName adds the portsNodeName to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) SetPortsNodeName(portsNodeName *string) {
	o.PortsNodeName = portsNodeName
}

// WithPortsUUID adds the portsUUID to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) WithPortsUUID(portsUUID *string) *NetworkEthernetBroadcastDomainModifyCollectionParams {
	o.SetPortsUUID(portsUUID)
	return o
}

// SetPortsUUID adds the portsUuid to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) SetPortsUUID(portsUUID *string) {
	o.PortsUUID = portsUUID
}

// WithReturnRecords adds the returnRecords to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) WithReturnRecords(returnRecords *bool) *NetworkEthernetBroadcastDomainModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *NetworkEthernetBroadcastDomainModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) WithSerialRecords(serialRecords *bool) *NetworkEthernetBroadcastDomainModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithUUID adds the uuid to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) WithUUID(uuid *string) *NetworkEthernetBroadcastDomainModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the network ethernet broadcast domain modify collection params
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *NetworkEthernetBroadcastDomainModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IpspaceName != nil {

		// query param ipspace.name
		var qrIpspaceName string

		if o.IpspaceName != nil {
			qrIpspaceName = *o.IpspaceName
		}
		qIpspaceName := qrIpspaceName
		if qIpspaceName != "" {

			if err := r.SetQueryParam("ipspace.name", qIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.IpspaceUUID != nil {

		// query param ipspace.uuid
		var qrIpspaceUUID string

		if o.IpspaceUUID != nil {
			qrIpspaceUUID = *o.IpspaceUUID
		}
		qIpspaceUUID := qrIpspaceUUID
		if qIpspaceUUID != "" {

			if err := r.SetQueryParam("ipspace.uuid", qIpspaceUUID); err != nil {
				return err
			}
		}
	}

	if o.Mtu != nil {

		// query param mtu
		var qrMtu int64

		if o.Mtu != nil {
			qrMtu = *o.Mtu
		}
		qMtu := swag.FormatInt64(qrMtu)
		if qMtu != "" {

			if err := r.SetQueryParam("mtu", qMtu); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.PortsName != nil {

		// query param ports.name
		var qrPortsName string

		if o.PortsName != nil {
			qrPortsName = *o.PortsName
		}
		qPortsName := qrPortsName
		if qPortsName != "" {

			if err := r.SetQueryParam("ports.name", qPortsName); err != nil {
				return err
			}
		}
	}

	if o.PortsNodeName != nil {

		// query param ports.node.name
		var qrPortsNodeName string

		if o.PortsNodeName != nil {
			qrPortsNodeName = *o.PortsNodeName
		}
		qPortsNodeName := qrPortsNodeName
		if qPortsNodeName != "" {

			if err := r.SetQueryParam("ports.node.name", qPortsNodeName); err != nil {
				return err
			}
		}
	}

	if o.PortsUUID != nil {

		// query param ports.uuid
		var qrPortsUUID string

		if o.PortsUUID != nil {
			qrPortsUUID = *o.PortsUUID
		}
		qPortsUUID := qrPortsUUID
		if qPortsUUID != "" {

			if err := r.SetQueryParam("ports.uuid", qPortsUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
