// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNetworkEthernetPortGetParams creates a new NetworkEthernetPortGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNetworkEthernetPortGetParams() *NetworkEthernetPortGetParams {
	return &NetworkEthernetPortGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNetworkEthernetPortGetParamsWithTimeout creates a new NetworkEthernetPortGetParams object
// with the ability to set a timeout on a request.
func NewNetworkEthernetPortGetParamsWithTimeout(timeout time.Duration) *NetworkEthernetPortGetParams {
	return &NetworkEthernetPortGetParams{
		timeout: timeout,
	}
}

// NewNetworkEthernetPortGetParamsWithContext creates a new NetworkEthernetPortGetParams object
// with the ability to set a context for a request.
func NewNetworkEthernetPortGetParamsWithContext(ctx context.Context) *NetworkEthernetPortGetParams {
	return &NetworkEthernetPortGetParams{
		Context: ctx,
	}
}

// NewNetworkEthernetPortGetParamsWithHTTPClient creates a new NetworkEthernetPortGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewNetworkEthernetPortGetParamsWithHTTPClient(client *http.Client) *NetworkEthernetPortGetParams {
	return &NetworkEthernetPortGetParams{
		HTTPClient: client,
	}
}

/*
NetworkEthernetPortGetParams contains all the parameters to send to the API endpoint

	for the network ethernet port get operation.

	Typically these are written to a http.Request.
*/
type NetworkEthernetPortGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   Port UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the network ethernet port get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkEthernetPortGetParams) WithDefaults() *NetworkEthernetPortGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the network ethernet port get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkEthernetPortGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the network ethernet port get params
func (o *NetworkEthernetPortGetParams) WithTimeout(timeout time.Duration) *NetworkEthernetPortGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the network ethernet port get params
func (o *NetworkEthernetPortGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the network ethernet port get params
func (o *NetworkEthernetPortGetParams) WithContext(ctx context.Context) *NetworkEthernetPortGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the network ethernet port get params
func (o *NetworkEthernetPortGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the network ethernet port get params
func (o *NetworkEthernetPortGetParams) WithHTTPClient(client *http.Client) *NetworkEthernetPortGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the network ethernet port get params
func (o *NetworkEthernetPortGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the network ethernet port get params
func (o *NetworkEthernetPortGetParams) WithFields(fields []string) *NetworkEthernetPortGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the network ethernet port get params
func (o *NetworkEthernetPortGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the network ethernet port get params
func (o *NetworkEthernetPortGetParams) WithUUID(uuid string) *NetworkEthernetPortGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the network ethernet port get params
func (o *NetworkEthernetPortGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *NetworkEthernetPortGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamNetworkEthernetPortGet binds the parameter fields
func (o *NetworkEthernetPortGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
