// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNetworkEthernetPortModifyCollectionParams creates a new NetworkEthernetPortModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNetworkEthernetPortModifyCollectionParams() *NetworkEthernetPortModifyCollectionParams {
	return &NetworkEthernetPortModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNetworkEthernetPortModifyCollectionParamsWithTimeout creates a new NetworkEthernetPortModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewNetworkEthernetPortModifyCollectionParamsWithTimeout(timeout time.Duration) *NetworkEthernetPortModifyCollectionParams {
	return &NetworkEthernetPortModifyCollectionParams{
		timeout: timeout,
	}
}

// NewNetworkEthernetPortModifyCollectionParamsWithContext creates a new NetworkEthernetPortModifyCollectionParams object
// with the ability to set a context for a request.
func NewNetworkEthernetPortModifyCollectionParamsWithContext(ctx context.Context) *NetworkEthernetPortModifyCollectionParams {
	return &NetworkEthernetPortModifyCollectionParams{
		Context: ctx,
	}
}

// NewNetworkEthernetPortModifyCollectionParamsWithHTTPClient creates a new NetworkEthernetPortModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewNetworkEthernetPortModifyCollectionParamsWithHTTPClient(client *http.Client) *NetworkEthernetPortModifyCollectionParams {
	return &NetworkEthernetPortModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
NetworkEthernetPortModifyCollectionParams contains all the parameters to send to the API endpoint

	for the network ethernet port modify collection operation.

	Typically these are written to a http.Request.
*/
type NetworkEthernetPortModifyCollectionParams struct {

	/* BroadcastDomainIpspaceName.

	   Filter by broadcast_domain.ipspace.name
	*/
	BroadcastDomainIpspaceName *string

	/* BroadcastDomainName.

	   Filter by broadcast_domain.name
	*/
	BroadcastDomainName *string

	/* BroadcastDomainUUID.

	   Filter by broadcast_domain.uuid
	*/
	BroadcastDomainUUID *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* DiscoveredDevicesCapabilities.

	   Filter by discovered_devices.capabilities
	*/
	DiscoveredDevicesCapabilities *string

	/* DiscoveredDevicesChassisID.

	   Filter by discovered_devices.chassis_id
	*/
	DiscoveredDevicesChassisID *string

	/* DiscoveredDevicesIPAddresses.

	   Filter by discovered_devices.ip_addresses
	*/
	DiscoveredDevicesIPAddresses *string

	/* DiscoveredDevicesName.

	   Filter by discovered_devices.name
	*/
	DiscoveredDevicesName *string

	/* DiscoveredDevicesPlatform.

	   Filter by discovered_devices.platform
	*/
	DiscoveredDevicesPlatform *string

	/* DiscoveredDevicesProtocol.

	   Filter by discovered_devices.protocol
	*/
	DiscoveredDevicesProtocol *string

	/* DiscoveredDevicesRemainingHoldTime.

	   Filter by discovered_devices.remaining_hold_time
	*/
	DiscoveredDevicesRemainingHoldTime *int64

	/* DiscoveredDevicesRemotePort.

	   Filter by discovered_devices.remote_port
	*/
	DiscoveredDevicesRemotePort *string

	/* DiscoveredDevicesSystemName.

	   Filter by discovered_devices.system_name
	*/
	DiscoveredDevicesSystemName *string

	/* DiscoveredDevicesVersion.

	   Filter by discovered_devices.version
	*/
	DiscoveredDevicesVersion *string

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* FlowcontrolAdmin.

	   Filter by flowcontrol_admin
	*/
	FlowcontrolAdmin *string

	/* Info.

	   Info specification
	*/
	Info NetworkEthernetPortModifyCollectionBody

	/* InterfaceCount.

	   Filter by interface_count
	*/
	InterfaceCount *int64

	/* LagActivePortsName.

	   Filter by lag.active_ports.name
	*/
	LagActivePortsName *string

	/* LagActivePortsNodeName.

	   Filter by lag.active_ports.node.name
	*/
	LagActivePortsNodeName *string

	/* LagActivePortsUUID.

	   Filter by lag.active_ports.uuid
	*/
	LagActivePortsUUID *string

	/* LagDistributionPolicy.

	   Filter by lag.distribution_policy
	*/
	LagDistributionPolicy *string

	/* LagMemberPortsName.

	   Filter by lag.member_ports.name
	*/
	LagMemberPortsName *string

	/* LagMemberPortsNodeName.

	   Filter by lag.member_ports.node.name
	*/
	LagMemberPortsNodeName *string

	/* LagMemberPortsUUID.

	   Filter by lag.member_ports.uuid
	*/
	LagMemberPortsUUID *string

	/* LagMode.

	   Filter by lag.mode
	*/
	LagMode *string

	/* MacAddress.

	   Filter by mac_address
	*/
	MacAddress *string

	/* MetricDuration.

	   Filter by metric.duration
	*/
	MetricDuration *string

	/* MetricStatus.

	   Filter by metric.status
	*/
	MetricStatus *string

	/* MetricThroughputRead.

	   Filter by metric.throughput.read
	*/
	MetricThroughputRead *int64

	/* MetricThroughputTotal.

	   Filter by metric.throughput.total
	*/
	MetricThroughputTotal *int64

	/* MetricThroughputWrite.

	   Filter by metric.throughput.write
	*/
	MetricThroughputWrite *int64

	/* MetricTimestamp.

	   Filter by metric.timestamp
	*/
	MetricTimestamp *string

	/* Mtu.

	   Filter by mtu
	*/
	Mtu *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* PfcQueuesAdmin.

	   Filter by pfc_queues_admin
	*/
	PfcQueuesAdmin *int64

	/* RdmaProtocols.

	   Filter by rdma_protocols
	*/
	RdmaProtocols *string

	/* Reachability.

	   Filter by reachability
	*/
	Reachability *string

	/* ReachableBroadcastDomainsIpspaceName.

	   Filter by reachable_broadcast_domains.ipspace.name
	*/
	ReachableBroadcastDomainsIpspaceName *string

	/* ReachableBroadcastDomainsName.

	   Filter by reachable_broadcast_domains.name
	*/
	ReachableBroadcastDomainsName *string

	/* ReachableBroadcastDomainsUUID.

	   Filter by reachable_broadcast_domains.uuid
	*/
	ReachableBroadcastDomainsUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Speed.

	   Filter by speed
	*/
	Speed *int64

	/* State.

	   Filter by state
	*/
	State *string

	/* StatisticsDeviceLinkDownCountRaw.

	   Filter by statistics.device.link_down_count_raw
	*/
	StatisticsDeviceLinkDownCountRaw *int64

	/* StatisticsDeviceReceiveRawDiscards.

	   Filter by statistics.device.receive_raw.discards
	*/
	StatisticsDeviceReceiveRawDiscards *int64

	/* StatisticsDeviceReceiveRawErrors.

	   Filter by statistics.device.receive_raw.errors
	*/
	StatisticsDeviceReceiveRawErrors *int64

	/* StatisticsDeviceReceiveRawPackets.

	   Filter by statistics.device.receive_raw.packets
	*/
	StatisticsDeviceReceiveRawPackets *int64

	/* StatisticsDeviceTimestamp.

	   Filter by statistics.device.timestamp
	*/
	StatisticsDeviceTimestamp *string

	/* StatisticsDeviceTransmitRawDiscards.

	   Filter by statistics.device.transmit_raw.discards
	*/
	StatisticsDeviceTransmitRawDiscards *int64

	/* StatisticsDeviceTransmitRawErrors.

	   Filter by statistics.device.transmit_raw.errors
	*/
	StatisticsDeviceTransmitRawErrors *int64

	/* StatisticsDeviceTransmitRawPackets.

	   Filter by statistics.device.transmit_raw.packets
	*/
	StatisticsDeviceTransmitRawPackets *int64

	/* StatisticsStatus.

	   Filter by statistics.status
	*/
	StatisticsStatus *string

	/* StatisticsThroughputRawRead.

	   Filter by statistics.throughput_raw.read
	*/
	StatisticsThroughputRawRead *int64

	/* StatisticsThroughputRawTotal.

	   Filter by statistics.throughput_raw.total
	*/
	StatisticsThroughputRawTotal *int64

	/* StatisticsThroughputRawWrite.

	   Filter by statistics.throughput_raw.write
	*/
	StatisticsThroughputRawWrite *int64

	/* StatisticsTimestamp.

	   Filter by statistics.timestamp
	*/
	StatisticsTimestamp *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* VlanBasePortName.

	   Filter by vlan.base_port.name
	*/
	VlanBasePortName *string

	/* VlanBasePortNodeName.

	   Filter by vlan.base_port.node.name
	*/
	VlanBasePortNodeName *string

	/* VlanBasePortUUID.

	   Filter by vlan.base_port.uuid
	*/
	VlanBasePortUUID *string

	/* VlanTag.

	   Filter by vlan.tag
	*/
	VlanTag *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the network ethernet port modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkEthernetPortModifyCollectionParams) WithDefaults() *NetworkEthernetPortModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the network ethernet port modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkEthernetPortModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := NetworkEthernetPortModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithTimeout(timeout time.Duration) *NetworkEthernetPortModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithContext(ctx context.Context) *NetworkEthernetPortModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithHTTPClient(client *http.Client) *NetworkEthernetPortModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBroadcastDomainIpspaceName adds the broadcastDomainIpspaceName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithBroadcastDomainIpspaceName(broadcastDomainIpspaceName *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetBroadcastDomainIpspaceName(broadcastDomainIpspaceName)
	return o
}

// SetBroadcastDomainIpspaceName adds the broadcastDomainIpspaceName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetBroadcastDomainIpspaceName(broadcastDomainIpspaceName *string) {
	o.BroadcastDomainIpspaceName = broadcastDomainIpspaceName
}

// WithBroadcastDomainName adds the broadcastDomainName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithBroadcastDomainName(broadcastDomainName *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetBroadcastDomainName(broadcastDomainName)
	return o
}

// SetBroadcastDomainName adds the broadcastDomainName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetBroadcastDomainName(broadcastDomainName *string) {
	o.BroadcastDomainName = broadcastDomainName
}

// WithBroadcastDomainUUID adds the broadcastDomainUUID to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithBroadcastDomainUUID(broadcastDomainUUID *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetBroadcastDomainUUID(broadcastDomainUUID)
	return o
}

// SetBroadcastDomainUUID adds the broadcastDomainUuid to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetBroadcastDomainUUID(broadcastDomainUUID *string) {
	o.BroadcastDomainUUID = broadcastDomainUUID
}

// WithContinueOnFailure adds the continueOnFailure to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *NetworkEthernetPortModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDiscoveredDevicesCapabilities adds the discoveredDevicesCapabilities to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithDiscoveredDevicesCapabilities(discoveredDevicesCapabilities *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetDiscoveredDevicesCapabilities(discoveredDevicesCapabilities)
	return o
}

// SetDiscoveredDevicesCapabilities adds the discoveredDevicesCapabilities to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetDiscoveredDevicesCapabilities(discoveredDevicesCapabilities *string) {
	o.DiscoveredDevicesCapabilities = discoveredDevicesCapabilities
}

// WithDiscoveredDevicesChassisID adds the discoveredDevicesChassisID to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithDiscoveredDevicesChassisID(discoveredDevicesChassisID *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetDiscoveredDevicesChassisID(discoveredDevicesChassisID)
	return o
}

// SetDiscoveredDevicesChassisID adds the discoveredDevicesChassisId to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetDiscoveredDevicesChassisID(discoveredDevicesChassisID *string) {
	o.DiscoveredDevicesChassisID = discoveredDevicesChassisID
}

// WithDiscoveredDevicesIPAddresses adds the discoveredDevicesIPAddresses to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithDiscoveredDevicesIPAddresses(discoveredDevicesIPAddresses *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetDiscoveredDevicesIPAddresses(discoveredDevicesIPAddresses)
	return o
}

// SetDiscoveredDevicesIPAddresses adds the discoveredDevicesIpAddresses to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetDiscoveredDevicesIPAddresses(discoveredDevicesIPAddresses *string) {
	o.DiscoveredDevicesIPAddresses = discoveredDevicesIPAddresses
}

// WithDiscoveredDevicesName adds the discoveredDevicesName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithDiscoveredDevicesName(discoveredDevicesName *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetDiscoveredDevicesName(discoveredDevicesName)
	return o
}

// SetDiscoveredDevicesName adds the discoveredDevicesName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetDiscoveredDevicesName(discoveredDevicesName *string) {
	o.DiscoveredDevicesName = discoveredDevicesName
}

// WithDiscoveredDevicesPlatform adds the discoveredDevicesPlatform to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithDiscoveredDevicesPlatform(discoveredDevicesPlatform *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetDiscoveredDevicesPlatform(discoveredDevicesPlatform)
	return o
}

// SetDiscoveredDevicesPlatform adds the discoveredDevicesPlatform to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetDiscoveredDevicesPlatform(discoveredDevicesPlatform *string) {
	o.DiscoveredDevicesPlatform = discoveredDevicesPlatform
}

// WithDiscoveredDevicesProtocol adds the discoveredDevicesProtocol to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithDiscoveredDevicesProtocol(discoveredDevicesProtocol *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetDiscoveredDevicesProtocol(discoveredDevicesProtocol)
	return o
}

// SetDiscoveredDevicesProtocol adds the discoveredDevicesProtocol to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetDiscoveredDevicesProtocol(discoveredDevicesProtocol *string) {
	o.DiscoveredDevicesProtocol = discoveredDevicesProtocol
}

// WithDiscoveredDevicesRemainingHoldTime adds the discoveredDevicesRemainingHoldTime to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithDiscoveredDevicesRemainingHoldTime(discoveredDevicesRemainingHoldTime *int64) *NetworkEthernetPortModifyCollectionParams {
	o.SetDiscoveredDevicesRemainingHoldTime(discoveredDevicesRemainingHoldTime)
	return o
}

// SetDiscoveredDevicesRemainingHoldTime adds the discoveredDevicesRemainingHoldTime to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetDiscoveredDevicesRemainingHoldTime(discoveredDevicesRemainingHoldTime *int64) {
	o.DiscoveredDevicesRemainingHoldTime = discoveredDevicesRemainingHoldTime
}

// WithDiscoveredDevicesRemotePort adds the discoveredDevicesRemotePort to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithDiscoveredDevicesRemotePort(discoveredDevicesRemotePort *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetDiscoveredDevicesRemotePort(discoveredDevicesRemotePort)
	return o
}

// SetDiscoveredDevicesRemotePort adds the discoveredDevicesRemotePort to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetDiscoveredDevicesRemotePort(discoveredDevicesRemotePort *string) {
	o.DiscoveredDevicesRemotePort = discoveredDevicesRemotePort
}

// WithDiscoveredDevicesSystemName adds the discoveredDevicesSystemName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithDiscoveredDevicesSystemName(discoveredDevicesSystemName *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetDiscoveredDevicesSystemName(discoveredDevicesSystemName)
	return o
}

// SetDiscoveredDevicesSystemName adds the discoveredDevicesSystemName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetDiscoveredDevicesSystemName(discoveredDevicesSystemName *string) {
	o.DiscoveredDevicesSystemName = discoveredDevicesSystemName
}

// WithDiscoveredDevicesVersion adds the discoveredDevicesVersion to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithDiscoveredDevicesVersion(discoveredDevicesVersion *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetDiscoveredDevicesVersion(discoveredDevicesVersion)
	return o
}

// SetDiscoveredDevicesVersion adds the discoveredDevicesVersion to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetDiscoveredDevicesVersion(discoveredDevicesVersion *string) {
	o.DiscoveredDevicesVersion = discoveredDevicesVersion
}

// WithEnabled adds the enabled to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithEnabled(enabled *bool) *NetworkEthernetPortModifyCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithFlowcontrolAdmin adds the flowcontrolAdmin to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithFlowcontrolAdmin(flowcontrolAdmin *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetFlowcontrolAdmin(flowcontrolAdmin)
	return o
}

// SetFlowcontrolAdmin adds the flowcontrolAdmin to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetFlowcontrolAdmin(flowcontrolAdmin *string) {
	o.FlowcontrolAdmin = flowcontrolAdmin
}

// WithInfo adds the info to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithInfo(info NetworkEthernetPortModifyCollectionBody) *NetworkEthernetPortModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetInfo(info NetworkEthernetPortModifyCollectionBody) {
	o.Info = info
}

// WithInterfaceCount adds the interfaceCount to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithInterfaceCount(interfaceCount *int64) *NetworkEthernetPortModifyCollectionParams {
	o.SetInterfaceCount(interfaceCount)
	return o
}

// SetInterfaceCount adds the interfaceCount to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetInterfaceCount(interfaceCount *int64) {
	o.InterfaceCount = interfaceCount
}

// WithLagActivePortsName adds the lagActivePortsName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithLagActivePortsName(lagActivePortsName *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetLagActivePortsName(lagActivePortsName)
	return o
}

// SetLagActivePortsName adds the lagActivePortsName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetLagActivePortsName(lagActivePortsName *string) {
	o.LagActivePortsName = lagActivePortsName
}

// WithLagActivePortsNodeName adds the lagActivePortsNodeName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithLagActivePortsNodeName(lagActivePortsNodeName *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetLagActivePortsNodeName(lagActivePortsNodeName)
	return o
}

// SetLagActivePortsNodeName adds the lagActivePortsNodeName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetLagActivePortsNodeName(lagActivePortsNodeName *string) {
	o.LagActivePortsNodeName = lagActivePortsNodeName
}

// WithLagActivePortsUUID adds the lagActivePortsUUID to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithLagActivePortsUUID(lagActivePortsUUID *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetLagActivePortsUUID(lagActivePortsUUID)
	return o
}

// SetLagActivePortsUUID adds the lagActivePortsUuid to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetLagActivePortsUUID(lagActivePortsUUID *string) {
	o.LagActivePortsUUID = lagActivePortsUUID
}

// WithLagDistributionPolicy adds the lagDistributionPolicy to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithLagDistributionPolicy(lagDistributionPolicy *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetLagDistributionPolicy(lagDistributionPolicy)
	return o
}

// SetLagDistributionPolicy adds the lagDistributionPolicy to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetLagDistributionPolicy(lagDistributionPolicy *string) {
	o.LagDistributionPolicy = lagDistributionPolicy
}

// WithLagMemberPortsName adds the lagMemberPortsName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithLagMemberPortsName(lagMemberPortsName *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetLagMemberPortsName(lagMemberPortsName)
	return o
}

// SetLagMemberPortsName adds the lagMemberPortsName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetLagMemberPortsName(lagMemberPortsName *string) {
	o.LagMemberPortsName = lagMemberPortsName
}

// WithLagMemberPortsNodeName adds the lagMemberPortsNodeName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithLagMemberPortsNodeName(lagMemberPortsNodeName *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetLagMemberPortsNodeName(lagMemberPortsNodeName)
	return o
}

// SetLagMemberPortsNodeName adds the lagMemberPortsNodeName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetLagMemberPortsNodeName(lagMemberPortsNodeName *string) {
	o.LagMemberPortsNodeName = lagMemberPortsNodeName
}

// WithLagMemberPortsUUID adds the lagMemberPortsUUID to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithLagMemberPortsUUID(lagMemberPortsUUID *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetLagMemberPortsUUID(lagMemberPortsUUID)
	return o
}

// SetLagMemberPortsUUID adds the lagMemberPortsUuid to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetLagMemberPortsUUID(lagMemberPortsUUID *string) {
	o.LagMemberPortsUUID = lagMemberPortsUUID
}

// WithLagMode adds the lagMode to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithLagMode(lagMode *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetLagMode(lagMode)
	return o
}

// SetLagMode adds the lagMode to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetLagMode(lagMode *string) {
	o.LagMode = lagMode
}

// WithMacAddress adds the macAddress to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithMacAddress(macAddress *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetMacAddress(macAddress)
	return o
}

// SetMacAddress adds the macAddress to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetMacAddress(macAddress *string) {
	o.MacAddress = macAddress
}

// WithMetricDuration adds the metricDuration to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithMetricDuration(metricDuration *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetMetricDuration(metricDuration)
	return o
}

// SetMetricDuration adds the metricDuration to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetMetricDuration(metricDuration *string) {
	o.MetricDuration = metricDuration
}

// WithMetricStatus adds the metricStatus to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithMetricStatus(metricStatus *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetMetricStatus(metricStatus)
	return o
}

// SetMetricStatus adds the metricStatus to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetMetricStatus(metricStatus *string) {
	o.MetricStatus = metricStatus
}

// WithMetricThroughputRead adds the metricThroughputRead to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithMetricThroughputRead(metricThroughputRead *int64) *NetworkEthernetPortModifyCollectionParams {
	o.SetMetricThroughputRead(metricThroughputRead)
	return o
}

// SetMetricThroughputRead adds the metricThroughputRead to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetMetricThroughputRead(metricThroughputRead *int64) {
	o.MetricThroughputRead = metricThroughputRead
}

// WithMetricThroughputTotal adds the metricThroughputTotal to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithMetricThroughputTotal(metricThroughputTotal *int64) *NetworkEthernetPortModifyCollectionParams {
	o.SetMetricThroughputTotal(metricThroughputTotal)
	return o
}

// SetMetricThroughputTotal adds the metricThroughputTotal to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetMetricThroughputTotal(metricThroughputTotal *int64) {
	o.MetricThroughputTotal = metricThroughputTotal
}

// WithMetricThroughputWrite adds the metricThroughputWrite to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithMetricThroughputWrite(metricThroughputWrite *int64) *NetworkEthernetPortModifyCollectionParams {
	o.SetMetricThroughputWrite(metricThroughputWrite)
	return o
}

// SetMetricThroughputWrite adds the metricThroughputWrite to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetMetricThroughputWrite(metricThroughputWrite *int64) {
	o.MetricThroughputWrite = metricThroughputWrite
}

// WithMetricTimestamp adds the metricTimestamp to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithMetricTimestamp(metricTimestamp *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetMetricTimestamp(metricTimestamp)
	return o
}

// SetMetricTimestamp adds the metricTimestamp to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetMetricTimestamp(metricTimestamp *string) {
	o.MetricTimestamp = metricTimestamp
}

// WithMtu adds the mtu to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithMtu(mtu *int64) *NetworkEthernetPortModifyCollectionParams {
	o.SetMtu(mtu)
	return o
}

// SetMtu adds the mtu to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetMtu(mtu *int64) {
	o.Mtu = mtu
}

// WithName adds the name to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithName(name *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithNodeName adds the nodeName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithNodeName(nodeName *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithNodeUUID(nodeUUID *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithPfcQueuesAdmin adds the pfcQueuesAdmin to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithPfcQueuesAdmin(pfcQueuesAdmin *int64) *NetworkEthernetPortModifyCollectionParams {
	o.SetPfcQueuesAdmin(pfcQueuesAdmin)
	return o
}

// SetPfcQueuesAdmin adds the pfcQueuesAdmin to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetPfcQueuesAdmin(pfcQueuesAdmin *int64) {
	o.PfcQueuesAdmin = pfcQueuesAdmin
}

// WithRdmaProtocols adds the rdmaProtocols to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithRdmaProtocols(rdmaProtocols *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetRdmaProtocols(rdmaProtocols)
	return o
}

// SetRdmaProtocols adds the rdmaProtocols to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetRdmaProtocols(rdmaProtocols *string) {
	o.RdmaProtocols = rdmaProtocols
}

// WithReachability adds the reachability to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithReachability(reachability *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetReachability(reachability)
	return o
}

// SetReachability adds the reachability to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetReachability(reachability *string) {
	o.Reachability = reachability
}

// WithReachableBroadcastDomainsIpspaceName adds the reachableBroadcastDomainsIpspaceName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithReachableBroadcastDomainsIpspaceName(reachableBroadcastDomainsIpspaceName *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetReachableBroadcastDomainsIpspaceName(reachableBroadcastDomainsIpspaceName)
	return o
}

// SetReachableBroadcastDomainsIpspaceName adds the reachableBroadcastDomainsIpspaceName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetReachableBroadcastDomainsIpspaceName(reachableBroadcastDomainsIpspaceName *string) {
	o.ReachableBroadcastDomainsIpspaceName = reachableBroadcastDomainsIpspaceName
}

// WithReachableBroadcastDomainsName adds the reachableBroadcastDomainsName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithReachableBroadcastDomainsName(reachableBroadcastDomainsName *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetReachableBroadcastDomainsName(reachableBroadcastDomainsName)
	return o
}

// SetReachableBroadcastDomainsName adds the reachableBroadcastDomainsName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetReachableBroadcastDomainsName(reachableBroadcastDomainsName *string) {
	o.ReachableBroadcastDomainsName = reachableBroadcastDomainsName
}

// WithReachableBroadcastDomainsUUID adds the reachableBroadcastDomainsUUID to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithReachableBroadcastDomainsUUID(reachableBroadcastDomainsUUID *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetReachableBroadcastDomainsUUID(reachableBroadcastDomainsUUID)
	return o
}

// SetReachableBroadcastDomainsUUID adds the reachableBroadcastDomainsUuid to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetReachableBroadcastDomainsUUID(reachableBroadcastDomainsUUID *string) {
	o.ReachableBroadcastDomainsUUID = reachableBroadcastDomainsUUID
}

// WithReturnRecords adds the returnRecords to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithReturnRecords(returnRecords *bool) *NetworkEthernetPortModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *NetworkEthernetPortModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithSerialRecords(serialRecords *bool) *NetworkEthernetPortModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSpeed adds the speed to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithSpeed(speed *int64) *NetworkEthernetPortModifyCollectionParams {
	o.SetSpeed(speed)
	return o
}

// SetSpeed adds the speed to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetSpeed(speed *int64) {
	o.Speed = speed
}

// WithState adds the state to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithState(state *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetState(state *string) {
	o.State = state
}

// WithStatisticsDeviceLinkDownCountRaw adds the statisticsDeviceLinkDownCountRaw to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithStatisticsDeviceLinkDownCountRaw(statisticsDeviceLinkDownCountRaw *int64) *NetworkEthernetPortModifyCollectionParams {
	o.SetStatisticsDeviceLinkDownCountRaw(statisticsDeviceLinkDownCountRaw)
	return o
}

// SetStatisticsDeviceLinkDownCountRaw adds the statisticsDeviceLinkDownCountRaw to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetStatisticsDeviceLinkDownCountRaw(statisticsDeviceLinkDownCountRaw *int64) {
	o.StatisticsDeviceLinkDownCountRaw = statisticsDeviceLinkDownCountRaw
}

// WithStatisticsDeviceReceiveRawDiscards adds the statisticsDeviceReceiveRawDiscards to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithStatisticsDeviceReceiveRawDiscards(statisticsDeviceReceiveRawDiscards *int64) *NetworkEthernetPortModifyCollectionParams {
	o.SetStatisticsDeviceReceiveRawDiscards(statisticsDeviceReceiveRawDiscards)
	return o
}

// SetStatisticsDeviceReceiveRawDiscards adds the statisticsDeviceReceiveRawDiscards to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetStatisticsDeviceReceiveRawDiscards(statisticsDeviceReceiveRawDiscards *int64) {
	o.StatisticsDeviceReceiveRawDiscards = statisticsDeviceReceiveRawDiscards
}

// WithStatisticsDeviceReceiveRawErrors adds the statisticsDeviceReceiveRawErrors to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithStatisticsDeviceReceiveRawErrors(statisticsDeviceReceiveRawErrors *int64) *NetworkEthernetPortModifyCollectionParams {
	o.SetStatisticsDeviceReceiveRawErrors(statisticsDeviceReceiveRawErrors)
	return o
}

// SetStatisticsDeviceReceiveRawErrors adds the statisticsDeviceReceiveRawErrors to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetStatisticsDeviceReceiveRawErrors(statisticsDeviceReceiveRawErrors *int64) {
	o.StatisticsDeviceReceiveRawErrors = statisticsDeviceReceiveRawErrors
}

// WithStatisticsDeviceReceiveRawPackets adds the statisticsDeviceReceiveRawPackets to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithStatisticsDeviceReceiveRawPackets(statisticsDeviceReceiveRawPackets *int64) *NetworkEthernetPortModifyCollectionParams {
	o.SetStatisticsDeviceReceiveRawPackets(statisticsDeviceReceiveRawPackets)
	return o
}

// SetStatisticsDeviceReceiveRawPackets adds the statisticsDeviceReceiveRawPackets to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetStatisticsDeviceReceiveRawPackets(statisticsDeviceReceiveRawPackets *int64) {
	o.StatisticsDeviceReceiveRawPackets = statisticsDeviceReceiveRawPackets
}

// WithStatisticsDeviceTimestamp adds the statisticsDeviceTimestamp to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithStatisticsDeviceTimestamp(statisticsDeviceTimestamp *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetStatisticsDeviceTimestamp(statisticsDeviceTimestamp)
	return o
}

// SetStatisticsDeviceTimestamp adds the statisticsDeviceTimestamp to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetStatisticsDeviceTimestamp(statisticsDeviceTimestamp *string) {
	o.StatisticsDeviceTimestamp = statisticsDeviceTimestamp
}

// WithStatisticsDeviceTransmitRawDiscards adds the statisticsDeviceTransmitRawDiscards to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithStatisticsDeviceTransmitRawDiscards(statisticsDeviceTransmitRawDiscards *int64) *NetworkEthernetPortModifyCollectionParams {
	o.SetStatisticsDeviceTransmitRawDiscards(statisticsDeviceTransmitRawDiscards)
	return o
}

// SetStatisticsDeviceTransmitRawDiscards adds the statisticsDeviceTransmitRawDiscards to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetStatisticsDeviceTransmitRawDiscards(statisticsDeviceTransmitRawDiscards *int64) {
	o.StatisticsDeviceTransmitRawDiscards = statisticsDeviceTransmitRawDiscards
}

// WithStatisticsDeviceTransmitRawErrors adds the statisticsDeviceTransmitRawErrors to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithStatisticsDeviceTransmitRawErrors(statisticsDeviceTransmitRawErrors *int64) *NetworkEthernetPortModifyCollectionParams {
	o.SetStatisticsDeviceTransmitRawErrors(statisticsDeviceTransmitRawErrors)
	return o
}

// SetStatisticsDeviceTransmitRawErrors adds the statisticsDeviceTransmitRawErrors to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetStatisticsDeviceTransmitRawErrors(statisticsDeviceTransmitRawErrors *int64) {
	o.StatisticsDeviceTransmitRawErrors = statisticsDeviceTransmitRawErrors
}

// WithStatisticsDeviceTransmitRawPackets adds the statisticsDeviceTransmitRawPackets to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithStatisticsDeviceTransmitRawPackets(statisticsDeviceTransmitRawPackets *int64) *NetworkEthernetPortModifyCollectionParams {
	o.SetStatisticsDeviceTransmitRawPackets(statisticsDeviceTransmitRawPackets)
	return o
}

// SetStatisticsDeviceTransmitRawPackets adds the statisticsDeviceTransmitRawPackets to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetStatisticsDeviceTransmitRawPackets(statisticsDeviceTransmitRawPackets *int64) {
	o.StatisticsDeviceTransmitRawPackets = statisticsDeviceTransmitRawPackets
}

// WithStatisticsStatus adds the statisticsStatus to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithStatisticsStatus(statisticsStatus *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetStatisticsStatus(statisticsStatus)
	return o
}

// SetStatisticsStatus adds the statisticsStatus to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetStatisticsStatus(statisticsStatus *string) {
	o.StatisticsStatus = statisticsStatus
}

// WithStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) *NetworkEthernetPortModifyCollectionParams {
	o.SetStatisticsThroughputRawRead(statisticsThroughputRawRead)
	return o
}

// SetStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) {
	o.StatisticsThroughputRawRead = statisticsThroughputRawRead
}

// WithStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) *NetworkEthernetPortModifyCollectionParams {
	o.SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal)
	return o
}

// SetStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) {
	o.StatisticsThroughputRawTotal = statisticsThroughputRawTotal
}

// WithStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) *NetworkEthernetPortModifyCollectionParams {
	o.SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite)
	return o
}

// SetStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) {
	o.StatisticsThroughputRawWrite = statisticsThroughputRawWrite
}

// WithStatisticsTimestamp adds the statisticsTimestamp to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithStatisticsTimestamp(statisticsTimestamp *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetStatisticsTimestamp(statisticsTimestamp)
	return o
}

// SetStatisticsTimestamp adds the statisticsTimestamp to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetStatisticsTimestamp(statisticsTimestamp *string) {
	o.StatisticsTimestamp = statisticsTimestamp
}

// WithType adds the typeVar to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithType(typeVar *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUUID adds the uuid to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithUUID(uuid *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVlanBasePortName adds the vlanBasePortName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithVlanBasePortName(vlanBasePortName *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetVlanBasePortName(vlanBasePortName)
	return o
}

// SetVlanBasePortName adds the vlanBasePortName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetVlanBasePortName(vlanBasePortName *string) {
	o.VlanBasePortName = vlanBasePortName
}

// WithVlanBasePortNodeName adds the vlanBasePortNodeName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithVlanBasePortNodeName(vlanBasePortNodeName *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetVlanBasePortNodeName(vlanBasePortNodeName)
	return o
}

// SetVlanBasePortNodeName adds the vlanBasePortNodeName to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetVlanBasePortNodeName(vlanBasePortNodeName *string) {
	o.VlanBasePortNodeName = vlanBasePortNodeName
}

// WithVlanBasePortUUID adds the vlanBasePortUUID to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithVlanBasePortUUID(vlanBasePortUUID *string) *NetworkEthernetPortModifyCollectionParams {
	o.SetVlanBasePortUUID(vlanBasePortUUID)
	return o
}

// SetVlanBasePortUUID adds the vlanBasePortUuid to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetVlanBasePortUUID(vlanBasePortUUID *string) {
	o.VlanBasePortUUID = vlanBasePortUUID
}

// WithVlanTag adds the vlanTag to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) WithVlanTag(vlanTag *int64) *NetworkEthernetPortModifyCollectionParams {
	o.SetVlanTag(vlanTag)
	return o
}

// SetVlanTag adds the vlanTag to the network ethernet port modify collection params
func (o *NetworkEthernetPortModifyCollectionParams) SetVlanTag(vlanTag *int64) {
	o.VlanTag = vlanTag
}

// WriteToRequest writes these params to a swagger request
func (o *NetworkEthernetPortModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.BroadcastDomainIpspaceName != nil {

		// query param broadcast_domain.ipspace.name
		var qrBroadcastDomainIpspaceName string

		if o.BroadcastDomainIpspaceName != nil {
			qrBroadcastDomainIpspaceName = *o.BroadcastDomainIpspaceName
		}
		qBroadcastDomainIpspaceName := qrBroadcastDomainIpspaceName
		if qBroadcastDomainIpspaceName != "" {

			if err := r.SetQueryParam("broadcast_domain.ipspace.name", qBroadcastDomainIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.BroadcastDomainName != nil {

		// query param broadcast_domain.name
		var qrBroadcastDomainName string

		if o.BroadcastDomainName != nil {
			qrBroadcastDomainName = *o.BroadcastDomainName
		}
		qBroadcastDomainName := qrBroadcastDomainName
		if qBroadcastDomainName != "" {

			if err := r.SetQueryParam("broadcast_domain.name", qBroadcastDomainName); err != nil {
				return err
			}
		}
	}

	if o.BroadcastDomainUUID != nil {

		// query param broadcast_domain.uuid
		var qrBroadcastDomainUUID string

		if o.BroadcastDomainUUID != nil {
			qrBroadcastDomainUUID = *o.BroadcastDomainUUID
		}
		qBroadcastDomainUUID := qrBroadcastDomainUUID
		if qBroadcastDomainUUID != "" {

			if err := r.SetQueryParam("broadcast_domain.uuid", qBroadcastDomainUUID); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredDevicesCapabilities != nil {

		// query param discovered_devices.capabilities
		var qrDiscoveredDevicesCapabilities string

		if o.DiscoveredDevicesCapabilities != nil {
			qrDiscoveredDevicesCapabilities = *o.DiscoveredDevicesCapabilities
		}
		qDiscoveredDevicesCapabilities := qrDiscoveredDevicesCapabilities
		if qDiscoveredDevicesCapabilities != "" {

			if err := r.SetQueryParam("discovered_devices.capabilities", qDiscoveredDevicesCapabilities); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredDevicesChassisID != nil {

		// query param discovered_devices.chassis_id
		var qrDiscoveredDevicesChassisID string

		if o.DiscoveredDevicesChassisID != nil {
			qrDiscoveredDevicesChassisID = *o.DiscoveredDevicesChassisID
		}
		qDiscoveredDevicesChassisID := qrDiscoveredDevicesChassisID
		if qDiscoveredDevicesChassisID != "" {

			if err := r.SetQueryParam("discovered_devices.chassis_id", qDiscoveredDevicesChassisID); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredDevicesIPAddresses != nil {

		// query param discovered_devices.ip_addresses
		var qrDiscoveredDevicesIPAddresses string

		if o.DiscoveredDevicesIPAddresses != nil {
			qrDiscoveredDevicesIPAddresses = *o.DiscoveredDevicesIPAddresses
		}
		qDiscoveredDevicesIPAddresses := qrDiscoveredDevicesIPAddresses
		if qDiscoveredDevicesIPAddresses != "" {

			if err := r.SetQueryParam("discovered_devices.ip_addresses", qDiscoveredDevicesIPAddresses); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredDevicesName != nil {

		// query param discovered_devices.name
		var qrDiscoveredDevicesName string

		if o.DiscoveredDevicesName != nil {
			qrDiscoveredDevicesName = *o.DiscoveredDevicesName
		}
		qDiscoveredDevicesName := qrDiscoveredDevicesName
		if qDiscoveredDevicesName != "" {

			if err := r.SetQueryParam("discovered_devices.name", qDiscoveredDevicesName); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredDevicesPlatform != nil {

		// query param discovered_devices.platform
		var qrDiscoveredDevicesPlatform string

		if o.DiscoveredDevicesPlatform != nil {
			qrDiscoveredDevicesPlatform = *o.DiscoveredDevicesPlatform
		}
		qDiscoveredDevicesPlatform := qrDiscoveredDevicesPlatform
		if qDiscoveredDevicesPlatform != "" {

			if err := r.SetQueryParam("discovered_devices.platform", qDiscoveredDevicesPlatform); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredDevicesProtocol != nil {

		// query param discovered_devices.protocol
		var qrDiscoveredDevicesProtocol string

		if o.DiscoveredDevicesProtocol != nil {
			qrDiscoveredDevicesProtocol = *o.DiscoveredDevicesProtocol
		}
		qDiscoveredDevicesProtocol := qrDiscoveredDevicesProtocol
		if qDiscoveredDevicesProtocol != "" {

			if err := r.SetQueryParam("discovered_devices.protocol", qDiscoveredDevicesProtocol); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredDevicesRemainingHoldTime != nil {

		// query param discovered_devices.remaining_hold_time
		var qrDiscoveredDevicesRemainingHoldTime int64

		if o.DiscoveredDevicesRemainingHoldTime != nil {
			qrDiscoveredDevicesRemainingHoldTime = *o.DiscoveredDevicesRemainingHoldTime
		}
		qDiscoveredDevicesRemainingHoldTime := swag.FormatInt64(qrDiscoveredDevicesRemainingHoldTime)
		if qDiscoveredDevicesRemainingHoldTime != "" {

			if err := r.SetQueryParam("discovered_devices.remaining_hold_time", qDiscoveredDevicesRemainingHoldTime); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredDevicesRemotePort != nil {

		// query param discovered_devices.remote_port
		var qrDiscoveredDevicesRemotePort string

		if o.DiscoveredDevicesRemotePort != nil {
			qrDiscoveredDevicesRemotePort = *o.DiscoveredDevicesRemotePort
		}
		qDiscoveredDevicesRemotePort := qrDiscoveredDevicesRemotePort
		if qDiscoveredDevicesRemotePort != "" {

			if err := r.SetQueryParam("discovered_devices.remote_port", qDiscoveredDevicesRemotePort); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredDevicesSystemName != nil {

		// query param discovered_devices.system_name
		var qrDiscoveredDevicesSystemName string

		if o.DiscoveredDevicesSystemName != nil {
			qrDiscoveredDevicesSystemName = *o.DiscoveredDevicesSystemName
		}
		qDiscoveredDevicesSystemName := qrDiscoveredDevicesSystemName
		if qDiscoveredDevicesSystemName != "" {

			if err := r.SetQueryParam("discovered_devices.system_name", qDiscoveredDevicesSystemName); err != nil {
				return err
			}
		}
	}

	if o.DiscoveredDevicesVersion != nil {

		// query param discovered_devices.version
		var qrDiscoveredDevicesVersion string

		if o.DiscoveredDevicesVersion != nil {
			qrDiscoveredDevicesVersion = *o.DiscoveredDevicesVersion
		}
		qDiscoveredDevicesVersion := qrDiscoveredDevicesVersion
		if qDiscoveredDevicesVersion != "" {

			if err := r.SetQueryParam("discovered_devices.version", qDiscoveredDevicesVersion); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.FlowcontrolAdmin != nil {

		// query param flowcontrol_admin
		var qrFlowcontrolAdmin string

		if o.FlowcontrolAdmin != nil {
			qrFlowcontrolAdmin = *o.FlowcontrolAdmin
		}
		qFlowcontrolAdmin := qrFlowcontrolAdmin
		if qFlowcontrolAdmin != "" {

			if err := r.SetQueryParam("flowcontrol_admin", qFlowcontrolAdmin); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.InterfaceCount != nil {

		// query param interface_count
		var qrInterfaceCount int64

		if o.InterfaceCount != nil {
			qrInterfaceCount = *o.InterfaceCount
		}
		qInterfaceCount := swag.FormatInt64(qrInterfaceCount)
		if qInterfaceCount != "" {

			if err := r.SetQueryParam("interface_count", qInterfaceCount); err != nil {
				return err
			}
		}
	}

	if o.LagActivePortsName != nil {

		// query param lag.active_ports.name
		var qrLagActivePortsName string

		if o.LagActivePortsName != nil {
			qrLagActivePortsName = *o.LagActivePortsName
		}
		qLagActivePortsName := qrLagActivePortsName
		if qLagActivePortsName != "" {

			if err := r.SetQueryParam("lag.active_ports.name", qLagActivePortsName); err != nil {
				return err
			}
		}
	}

	if o.LagActivePortsNodeName != nil {

		// query param lag.active_ports.node.name
		var qrLagActivePortsNodeName string

		if o.LagActivePortsNodeName != nil {
			qrLagActivePortsNodeName = *o.LagActivePortsNodeName
		}
		qLagActivePortsNodeName := qrLagActivePortsNodeName
		if qLagActivePortsNodeName != "" {

			if err := r.SetQueryParam("lag.active_ports.node.name", qLagActivePortsNodeName); err != nil {
				return err
			}
		}
	}

	if o.LagActivePortsUUID != nil {

		// query param lag.active_ports.uuid
		var qrLagActivePortsUUID string

		if o.LagActivePortsUUID != nil {
			qrLagActivePortsUUID = *o.LagActivePortsUUID
		}
		qLagActivePortsUUID := qrLagActivePortsUUID
		if qLagActivePortsUUID != "" {

			if err := r.SetQueryParam("lag.active_ports.uuid", qLagActivePortsUUID); err != nil {
				return err
			}
		}
	}

	if o.LagDistributionPolicy != nil {

		// query param lag.distribution_policy
		var qrLagDistributionPolicy string

		if o.LagDistributionPolicy != nil {
			qrLagDistributionPolicy = *o.LagDistributionPolicy
		}
		qLagDistributionPolicy := qrLagDistributionPolicy
		if qLagDistributionPolicy != "" {

			if err := r.SetQueryParam("lag.distribution_policy", qLagDistributionPolicy); err != nil {
				return err
			}
		}
	}

	if o.LagMemberPortsName != nil {

		// query param lag.member_ports.name
		var qrLagMemberPortsName string

		if o.LagMemberPortsName != nil {
			qrLagMemberPortsName = *o.LagMemberPortsName
		}
		qLagMemberPortsName := qrLagMemberPortsName
		if qLagMemberPortsName != "" {

			if err := r.SetQueryParam("lag.member_ports.name", qLagMemberPortsName); err != nil {
				return err
			}
		}
	}

	if o.LagMemberPortsNodeName != nil {

		// query param lag.member_ports.node.name
		var qrLagMemberPortsNodeName string

		if o.LagMemberPortsNodeName != nil {
			qrLagMemberPortsNodeName = *o.LagMemberPortsNodeName
		}
		qLagMemberPortsNodeName := qrLagMemberPortsNodeName
		if qLagMemberPortsNodeName != "" {

			if err := r.SetQueryParam("lag.member_ports.node.name", qLagMemberPortsNodeName); err != nil {
				return err
			}
		}
	}

	if o.LagMemberPortsUUID != nil {

		// query param lag.member_ports.uuid
		var qrLagMemberPortsUUID string

		if o.LagMemberPortsUUID != nil {
			qrLagMemberPortsUUID = *o.LagMemberPortsUUID
		}
		qLagMemberPortsUUID := qrLagMemberPortsUUID
		if qLagMemberPortsUUID != "" {

			if err := r.SetQueryParam("lag.member_ports.uuid", qLagMemberPortsUUID); err != nil {
				return err
			}
		}
	}

	if o.LagMode != nil {

		// query param lag.mode
		var qrLagMode string

		if o.LagMode != nil {
			qrLagMode = *o.LagMode
		}
		qLagMode := qrLagMode
		if qLagMode != "" {

			if err := r.SetQueryParam("lag.mode", qLagMode); err != nil {
				return err
			}
		}
	}

	if o.MacAddress != nil {

		// query param mac_address
		var qrMacAddress string

		if o.MacAddress != nil {
			qrMacAddress = *o.MacAddress
		}
		qMacAddress := qrMacAddress
		if qMacAddress != "" {

			if err := r.SetQueryParam("mac_address", qMacAddress); err != nil {
				return err
			}
		}
	}

	if o.MetricDuration != nil {

		// query param metric.duration
		var qrMetricDuration string

		if o.MetricDuration != nil {
			qrMetricDuration = *o.MetricDuration
		}
		qMetricDuration := qrMetricDuration
		if qMetricDuration != "" {

			if err := r.SetQueryParam("metric.duration", qMetricDuration); err != nil {
				return err
			}
		}
	}

	if o.MetricStatus != nil {

		// query param metric.status
		var qrMetricStatus string

		if o.MetricStatus != nil {
			qrMetricStatus = *o.MetricStatus
		}
		qMetricStatus := qrMetricStatus
		if qMetricStatus != "" {

			if err := r.SetQueryParam("metric.status", qMetricStatus); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputRead != nil {

		// query param metric.throughput.read
		var qrMetricThroughputRead int64

		if o.MetricThroughputRead != nil {
			qrMetricThroughputRead = *o.MetricThroughputRead
		}
		qMetricThroughputRead := swag.FormatInt64(qrMetricThroughputRead)
		if qMetricThroughputRead != "" {

			if err := r.SetQueryParam("metric.throughput.read", qMetricThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputTotal != nil {

		// query param metric.throughput.total
		var qrMetricThroughputTotal int64

		if o.MetricThroughputTotal != nil {
			qrMetricThroughputTotal = *o.MetricThroughputTotal
		}
		qMetricThroughputTotal := swag.FormatInt64(qrMetricThroughputTotal)
		if qMetricThroughputTotal != "" {

			if err := r.SetQueryParam("metric.throughput.total", qMetricThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputWrite != nil {

		// query param metric.throughput.write
		var qrMetricThroughputWrite int64

		if o.MetricThroughputWrite != nil {
			qrMetricThroughputWrite = *o.MetricThroughputWrite
		}
		qMetricThroughputWrite := swag.FormatInt64(qrMetricThroughputWrite)
		if qMetricThroughputWrite != "" {

			if err := r.SetQueryParam("metric.throughput.write", qMetricThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricTimestamp != nil {

		// query param metric.timestamp
		var qrMetricTimestamp string

		if o.MetricTimestamp != nil {
			qrMetricTimestamp = *o.MetricTimestamp
		}
		qMetricTimestamp := qrMetricTimestamp
		if qMetricTimestamp != "" {

			if err := r.SetQueryParam("metric.timestamp", qMetricTimestamp); err != nil {
				return err
			}
		}
	}

	if o.Mtu != nil {

		// query param mtu
		var qrMtu int64

		if o.Mtu != nil {
			qrMtu = *o.Mtu
		}
		qMtu := swag.FormatInt64(qrMtu)
		if qMtu != "" {

			if err := r.SetQueryParam("mtu", qMtu); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.PfcQueuesAdmin != nil {

		// query param pfc_queues_admin
		var qrPfcQueuesAdmin int64

		if o.PfcQueuesAdmin != nil {
			qrPfcQueuesAdmin = *o.PfcQueuesAdmin
		}
		qPfcQueuesAdmin := swag.FormatInt64(qrPfcQueuesAdmin)
		if qPfcQueuesAdmin != "" {

			if err := r.SetQueryParam("pfc_queues_admin", qPfcQueuesAdmin); err != nil {
				return err
			}
		}
	}

	if o.RdmaProtocols != nil {

		// query param rdma_protocols
		var qrRdmaProtocols string

		if o.RdmaProtocols != nil {
			qrRdmaProtocols = *o.RdmaProtocols
		}
		qRdmaProtocols := qrRdmaProtocols
		if qRdmaProtocols != "" {

			if err := r.SetQueryParam("rdma_protocols", qRdmaProtocols); err != nil {
				return err
			}
		}
	}

	if o.Reachability != nil {

		// query param reachability
		var qrReachability string

		if o.Reachability != nil {
			qrReachability = *o.Reachability
		}
		qReachability := qrReachability
		if qReachability != "" {

			if err := r.SetQueryParam("reachability", qReachability); err != nil {
				return err
			}
		}
	}

	if o.ReachableBroadcastDomainsIpspaceName != nil {

		// query param reachable_broadcast_domains.ipspace.name
		var qrReachableBroadcastDomainsIpspaceName string

		if o.ReachableBroadcastDomainsIpspaceName != nil {
			qrReachableBroadcastDomainsIpspaceName = *o.ReachableBroadcastDomainsIpspaceName
		}
		qReachableBroadcastDomainsIpspaceName := qrReachableBroadcastDomainsIpspaceName
		if qReachableBroadcastDomainsIpspaceName != "" {

			if err := r.SetQueryParam("reachable_broadcast_domains.ipspace.name", qReachableBroadcastDomainsIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.ReachableBroadcastDomainsName != nil {

		// query param reachable_broadcast_domains.name
		var qrReachableBroadcastDomainsName string

		if o.ReachableBroadcastDomainsName != nil {
			qrReachableBroadcastDomainsName = *o.ReachableBroadcastDomainsName
		}
		qReachableBroadcastDomainsName := qrReachableBroadcastDomainsName
		if qReachableBroadcastDomainsName != "" {

			if err := r.SetQueryParam("reachable_broadcast_domains.name", qReachableBroadcastDomainsName); err != nil {
				return err
			}
		}
	}

	if o.ReachableBroadcastDomainsUUID != nil {

		// query param reachable_broadcast_domains.uuid
		var qrReachableBroadcastDomainsUUID string

		if o.ReachableBroadcastDomainsUUID != nil {
			qrReachableBroadcastDomainsUUID = *o.ReachableBroadcastDomainsUUID
		}
		qReachableBroadcastDomainsUUID := qrReachableBroadcastDomainsUUID
		if qReachableBroadcastDomainsUUID != "" {

			if err := r.SetQueryParam("reachable_broadcast_domains.uuid", qReachableBroadcastDomainsUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Speed != nil {

		// query param speed
		var qrSpeed int64

		if o.Speed != nil {
			qrSpeed = *o.Speed
		}
		qSpeed := swag.FormatInt64(qrSpeed)
		if qSpeed != "" {

			if err := r.SetQueryParam("speed", qSpeed); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.StatisticsDeviceLinkDownCountRaw != nil {

		// query param statistics.device.link_down_count_raw
		var qrStatisticsDeviceLinkDownCountRaw int64

		if o.StatisticsDeviceLinkDownCountRaw != nil {
			qrStatisticsDeviceLinkDownCountRaw = *o.StatisticsDeviceLinkDownCountRaw
		}
		qStatisticsDeviceLinkDownCountRaw := swag.FormatInt64(qrStatisticsDeviceLinkDownCountRaw)
		if qStatisticsDeviceLinkDownCountRaw != "" {

			if err := r.SetQueryParam("statistics.device.link_down_count_raw", qStatisticsDeviceLinkDownCountRaw); err != nil {
				return err
			}
		}
	}

	if o.StatisticsDeviceReceiveRawDiscards != nil {

		// query param statistics.device.receive_raw.discards
		var qrStatisticsDeviceReceiveRawDiscards int64

		if o.StatisticsDeviceReceiveRawDiscards != nil {
			qrStatisticsDeviceReceiveRawDiscards = *o.StatisticsDeviceReceiveRawDiscards
		}
		qStatisticsDeviceReceiveRawDiscards := swag.FormatInt64(qrStatisticsDeviceReceiveRawDiscards)
		if qStatisticsDeviceReceiveRawDiscards != "" {

			if err := r.SetQueryParam("statistics.device.receive_raw.discards", qStatisticsDeviceReceiveRawDiscards); err != nil {
				return err
			}
		}
	}

	if o.StatisticsDeviceReceiveRawErrors != nil {

		// query param statistics.device.receive_raw.errors
		var qrStatisticsDeviceReceiveRawErrors int64

		if o.StatisticsDeviceReceiveRawErrors != nil {
			qrStatisticsDeviceReceiveRawErrors = *o.StatisticsDeviceReceiveRawErrors
		}
		qStatisticsDeviceReceiveRawErrors := swag.FormatInt64(qrStatisticsDeviceReceiveRawErrors)
		if qStatisticsDeviceReceiveRawErrors != "" {

			if err := r.SetQueryParam("statistics.device.receive_raw.errors", qStatisticsDeviceReceiveRawErrors); err != nil {
				return err
			}
		}
	}

	if o.StatisticsDeviceReceiveRawPackets != nil {

		// query param statistics.device.receive_raw.packets
		var qrStatisticsDeviceReceiveRawPackets int64

		if o.StatisticsDeviceReceiveRawPackets != nil {
			qrStatisticsDeviceReceiveRawPackets = *o.StatisticsDeviceReceiveRawPackets
		}
		qStatisticsDeviceReceiveRawPackets := swag.FormatInt64(qrStatisticsDeviceReceiveRawPackets)
		if qStatisticsDeviceReceiveRawPackets != "" {

			if err := r.SetQueryParam("statistics.device.receive_raw.packets", qStatisticsDeviceReceiveRawPackets); err != nil {
				return err
			}
		}
	}

	if o.StatisticsDeviceTimestamp != nil {

		// query param statistics.device.timestamp
		var qrStatisticsDeviceTimestamp string

		if o.StatisticsDeviceTimestamp != nil {
			qrStatisticsDeviceTimestamp = *o.StatisticsDeviceTimestamp
		}
		qStatisticsDeviceTimestamp := qrStatisticsDeviceTimestamp
		if qStatisticsDeviceTimestamp != "" {

			if err := r.SetQueryParam("statistics.device.timestamp", qStatisticsDeviceTimestamp); err != nil {
				return err
			}
		}
	}

	if o.StatisticsDeviceTransmitRawDiscards != nil {

		// query param statistics.device.transmit_raw.discards
		var qrStatisticsDeviceTransmitRawDiscards int64

		if o.StatisticsDeviceTransmitRawDiscards != nil {
			qrStatisticsDeviceTransmitRawDiscards = *o.StatisticsDeviceTransmitRawDiscards
		}
		qStatisticsDeviceTransmitRawDiscards := swag.FormatInt64(qrStatisticsDeviceTransmitRawDiscards)
		if qStatisticsDeviceTransmitRawDiscards != "" {

			if err := r.SetQueryParam("statistics.device.transmit_raw.discards", qStatisticsDeviceTransmitRawDiscards); err != nil {
				return err
			}
		}
	}

	if o.StatisticsDeviceTransmitRawErrors != nil {

		// query param statistics.device.transmit_raw.errors
		var qrStatisticsDeviceTransmitRawErrors int64

		if o.StatisticsDeviceTransmitRawErrors != nil {
			qrStatisticsDeviceTransmitRawErrors = *o.StatisticsDeviceTransmitRawErrors
		}
		qStatisticsDeviceTransmitRawErrors := swag.FormatInt64(qrStatisticsDeviceTransmitRawErrors)
		if qStatisticsDeviceTransmitRawErrors != "" {

			if err := r.SetQueryParam("statistics.device.transmit_raw.errors", qStatisticsDeviceTransmitRawErrors); err != nil {
				return err
			}
		}
	}

	if o.StatisticsDeviceTransmitRawPackets != nil {

		// query param statistics.device.transmit_raw.packets
		var qrStatisticsDeviceTransmitRawPackets int64

		if o.StatisticsDeviceTransmitRawPackets != nil {
			qrStatisticsDeviceTransmitRawPackets = *o.StatisticsDeviceTransmitRawPackets
		}
		qStatisticsDeviceTransmitRawPackets := swag.FormatInt64(qrStatisticsDeviceTransmitRawPackets)
		if qStatisticsDeviceTransmitRawPackets != "" {

			if err := r.SetQueryParam("statistics.device.transmit_raw.packets", qStatisticsDeviceTransmitRawPackets); err != nil {
				return err
			}
		}
	}

	if o.StatisticsStatus != nil {

		// query param statistics.status
		var qrStatisticsStatus string

		if o.StatisticsStatus != nil {
			qrStatisticsStatus = *o.StatisticsStatus
		}
		qStatisticsStatus := qrStatisticsStatus
		if qStatisticsStatus != "" {

			if err := r.SetQueryParam("statistics.status", qStatisticsStatus); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawRead != nil {

		// query param statistics.throughput_raw.read
		var qrStatisticsThroughputRawRead int64

		if o.StatisticsThroughputRawRead != nil {
			qrStatisticsThroughputRawRead = *o.StatisticsThroughputRawRead
		}
		qStatisticsThroughputRawRead := swag.FormatInt64(qrStatisticsThroughputRawRead)
		if qStatisticsThroughputRawRead != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.read", qStatisticsThroughputRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawTotal != nil {

		// query param statistics.throughput_raw.total
		var qrStatisticsThroughputRawTotal int64

		if o.StatisticsThroughputRawTotal != nil {
			qrStatisticsThroughputRawTotal = *o.StatisticsThroughputRawTotal
		}
		qStatisticsThroughputRawTotal := swag.FormatInt64(qrStatisticsThroughputRawTotal)
		if qStatisticsThroughputRawTotal != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.total", qStatisticsThroughputRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawWrite != nil {

		// query param statistics.throughput_raw.write
		var qrStatisticsThroughputRawWrite int64

		if o.StatisticsThroughputRawWrite != nil {
			qrStatisticsThroughputRawWrite = *o.StatisticsThroughputRawWrite
		}
		qStatisticsThroughputRawWrite := swag.FormatInt64(qrStatisticsThroughputRawWrite)
		if qStatisticsThroughputRawWrite != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.write", qStatisticsThroughputRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsTimestamp != nil {

		// query param statistics.timestamp
		var qrStatisticsTimestamp string

		if o.StatisticsTimestamp != nil {
			qrStatisticsTimestamp = *o.StatisticsTimestamp
		}
		qStatisticsTimestamp := qrStatisticsTimestamp
		if qStatisticsTimestamp != "" {

			if err := r.SetQueryParam("statistics.timestamp", qStatisticsTimestamp); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.VlanBasePortName != nil {

		// query param vlan.base_port.name
		var qrVlanBasePortName string

		if o.VlanBasePortName != nil {
			qrVlanBasePortName = *o.VlanBasePortName
		}
		qVlanBasePortName := qrVlanBasePortName
		if qVlanBasePortName != "" {

			if err := r.SetQueryParam("vlan.base_port.name", qVlanBasePortName); err != nil {
				return err
			}
		}
	}

	if o.VlanBasePortNodeName != nil {

		// query param vlan.base_port.node.name
		var qrVlanBasePortNodeName string

		if o.VlanBasePortNodeName != nil {
			qrVlanBasePortNodeName = *o.VlanBasePortNodeName
		}
		qVlanBasePortNodeName := qrVlanBasePortNodeName
		if qVlanBasePortNodeName != "" {

			if err := r.SetQueryParam("vlan.base_port.node.name", qVlanBasePortNodeName); err != nil {
				return err
			}
		}
	}

	if o.VlanBasePortUUID != nil {

		// query param vlan.base_port.uuid
		var qrVlanBasePortUUID string

		if o.VlanBasePortUUID != nil {
			qrVlanBasePortUUID = *o.VlanBasePortUUID
		}
		qVlanBasePortUUID := qrVlanBasePortUUID
		if qVlanBasePortUUID != "" {

			if err := r.SetQueryParam("vlan.base_port.uuid", qVlanBasePortUUID); err != nil {
				return err
			}
		}
	}

	if o.VlanTag != nil {

		// query param vlan.tag
		var qrVlanTag int64

		if o.VlanTag != nil {
			qrVlanTag = *o.VlanTag
		}
		qVlanTag := swag.FormatInt64(qrVlanTag)
		if qVlanTag != "" {

			if err := r.SetQueryParam("vlan.tag", qVlanTag); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
