// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NetworkEthernetPortModifyCollectionReader is a Reader for the NetworkEthernetPortModifyCollection structure.
type NetworkEthernetPortModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NetworkEthernetPortModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNetworkEthernetPortModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNetworkEthernetPortModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNetworkEthernetPortModifyCollectionOK creates a NetworkEthernetPortModifyCollectionOK with default headers values
func NewNetworkEthernetPortModifyCollectionOK() *NetworkEthernetPortModifyCollectionOK {
	return &NetworkEthernetPortModifyCollectionOK{}
}

/*
NetworkEthernetPortModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type NetworkEthernetPortModifyCollectionOK struct {
}

// IsSuccess returns true when this network ethernet port modify collection o k response has a 2xx status code
func (o *NetworkEthernetPortModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this network ethernet port modify collection o k response has a 3xx status code
func (o *NetworkEthernetPortModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network ethernet port modify collection o k response has a 4xx status code
func (o *NetworkEthernetPortModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this network ethernet port modify collection o k response has a 5xx status code
func (o *NetworkEthernetPortModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this network ethernet port modify collection o k response a status code equal to that given
func (o *NetworkEthernetPortModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the network ethernet port modify collection o k response
func (o *NetworkEthernetPortModifyCollectionOK) Code() int {
	return 200
}

func (o *NetworkEthernetPortModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /network/ethernet/ports][%d] networkEthernetPortModifyCollectionOK", 200)
}

func (o *NetworkEthernetPortModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /network/ethernet/ports][%d] networkEthernetPortModifyCollectionOK", 200)
}

func (o *NetworkEthernetPortModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNetworkEthernetPortModifyCollectionDefault creates a NetworkEthernetPortModifyCollectionDefault with default headers values
func NewNetworkEthernetPortModifyCollectionDefault(code int) *NetworkEthernetPortModifyCollectionDefault {
	return &NetworkEthernetPortModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	NetworkEthernetPortModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1376361 | Port is already a member of a LAG. |
| 1376369 | Cannot add port to the interface group because the port hosts one or more VLANs. |
| 1376488 | Disabling the last operational cluster port on a node is not allowed. |
| 1376492 | Cannot change the MTU of a VLAN to be greater than the MTU of the port hosting it. |
| 1377563 | Port is already a member of a LAG. |
| 1377608 | Port cannot be used because it is currently the home port or current port of an interface. |
| 1377609 | The update is partially complete. Updating broadcast domain attributes on this port has failed. |
| 1966288 | Disabling the cluster ports can only be done on the local node. |
| 1967087 | The specified broadcast domain UUID is not valid. |
| 1967088 | The specified broadcast domain name does not exist in the specified IPspace. |
| 1967089 | The specified broadcast domain UUID, name and IPspace name do not match. |
| 1967094 | The specified LAG member port UUID is not valid. |
| 1967095 | The specified LAG member port name and node name combination is not valid. |
| 1967096 | The specified node does not match the specified LAG member port node. |
| 1967097 | The specified LAG member ports UUID, name, and node name do not match. |
| 1967126 | A LAG requires at least one member port. |
| 1967148 | Failure to remove port from broadcast domain. |
| 1967149 | Failure to add port to broadcast domain. |
| 1967184 | The reachability parameter cannot be patched in the same request as other parameters that might affect the target port's reachability status. |
| 1967185 | The port cannot be repaired because the port is deemed as non-repairable. |
| 1967186 | Invalid value for the reachability parameter. |
| 1967195 | Missing or incomplete name retrieval for specified port UUID. |
| 1967580 | This command is not supported as the effective cluster version is earlier than 9.8. |
| 1967582 | The reachability parameter is not supported on this cluster. |
| 53216932 | Failed to determine whether newly introduced PFC flow control is supported. |
| 53280899 | Not all nodes support enabling the PFC feature. |
| 53280900 | No PFC queues specified. |
| 53280901 | Failed to modify PFC. |
| 53280902 | Cluster ports does not support PFC flow control. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type NetworkEthernetPortModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this network ethernet port modify collection default response has a 2xx status code
func (o *NetworkEthernetPortModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this network ethernet port modify collection default response has a 3xx status code
func (o *NetworkEthernetPortModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this network ethernet port modify collection default response has a 4xx status code
func (o *NetworkEthernetPortModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this network ethernet port modify collection default response has a 5xx status code
func (o *NetworkEthernetPortModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this network ethernet port modify collection default response a status code equal to that given
func (o *NetworkEthernetPortModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the network ethernet port modify collection default response
func (o *NetworkEthernetPortModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *NetworkEthernetPortModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/ethernet/ports][%d] network_ethernet_port_modify_collection default %s", o._statusCode, payload)
}

func (o *NetworkEthernetPortModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/ethernet/ports][%d] network_ethernet_port_modify_collection default %s", o._statusCode, payload)
}

func (o *NetworkEthernetPortModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NetworkEthernetPortModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NetworkEthernetPortModifyCollectionBody network ethernet port modify collection body
swagger:model NetworkEthernetPortModifyCollectionBody
*/
type NetworkEthernetPortModifyCollectionBody struct {

	// links
	Links *models.PortInlineLinks `json:"_links,omitempty"`

	// broadcast domain
	BroadcastDomain *models.PortInlineBroadcastDomain `json:"broadcast_domain,omitempty"`

	// enabled
	Enabled *bool `json:"enabled,omitempty"`

	// Requested flow control
	// Enum: ["none","send","receive","full","pfc"]
	FlowcontrolAdmin *string `json:"flowcontrol_admin,omitempty"`

	// Number of interfaces hosted. This field is only applicable for cluster administrators. No value is returned for SVM administrators. If the node hosting a port is not healthy no value will be returned.
	// Read Only: true
	InterfaceCount *int64 `json:"interface_count,omitempty"`

	// lag
	Lag *models.PortInlineLag `json:"lag,omitempty"`

	// mac address
	// Example: 01:02:03:04:05:06
	// Read Only: true
	MacAddress *string `json:"mac_address,omitempty"`

	// metric
	Metric *models.PortInlineMetric `json:"metric,omitempty"`

	// MTU of the port in bytes. Set by broadcast domain.
	// Example: 1500
	// Read Only: true
	// Minimum: 68
	Mtu *int64 `json:"mtu,omitempty"`

	// Portname, such as e0a, e1b-100 (VLAN on Ethernet), a0c (LAG/ifgrp), a0d-200 (VLAN on LAG/ifgrp), e0a.pv1 (p-VLAN, in select environments only)
	// Example: e1b
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// node
	Node *models.PortInlineNode `json:"node,omitempty"`

	// Discovered devices
	// Read Only: true
	PortInlineDiscoveredDevices []*models.PortInlineDiscoveredDevicesInlineArrayItem `json:"discovered_devices,omitempty"`

	// List of PFC queues
	PortInlinePfcQueuesAdmin []*int64 `json:"pfc_queues_admin,omitempty"`

	// Reachable broadcast domains.
	// Read Only: true
	PortInlineReachableBroadcastDomains []*models.PortInlineReachableBroadcastDomainsInlineArrayItem `json:"reachable_broadcast_domains,omitempty"`

	// port response inline records
	PortResponseInlineRecords []*models.Port `json:"records,omitempty"`

	// Supported RDMA offload protocols
	// Read Only: true
	RdmaProtocols []*string `json:"rdma_protocols,omitempty"`

	// Reachability status of the port. Enum value "ok" is the only acceptable value for a PATCH request to repair a port.
	// Example: ok
	// Enum: ["ok","repairable","not_repairable"]
	Reachability *string `json:"reachability,omitempty"`

	// Link speed in Mbps
	// Example: 1000
	// Read Only: true
	Speed *int64 `json:"speed,omitempty"`

	// Operational state of the port. The state is set to 'down' if the operational state of the port is down. The state is set to 'up' if the link state of the port is up and the port is healthy. The state is set to 'up' if the link state of the port is up and configured to ignore health status. The state is 'degraded' if the link state of the port is up, and the port is not healthy.
	// Read Only: true
	// Enum: ["up","down","degraded"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *models.PortInlineStatistics `json:"statistics,omitempty"`

	// Type of physical or virtual port
	// Enum: ["vlan","physical","lag","pvlan"]
	Type *string `json:"type,omitempty"`

	// Port UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// vlan
	Vlan *models.PortInlineVlan `json:"vlan,omitempty"`
}

// Validate validates this network ethernet port modify collection body
func (o *NetworkEthernetPortModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateBroadcastDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFlowcontrolAdmin(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLag(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMtu(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePortInlineDiscoveredDevices(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePortInlinePfcQueuesAdmin(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePortInlineReachableBroadcastDomains(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePortResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRdmaProtocols(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateReachability(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVlan(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) validateBroadcastDomain(formats strfmt.Registry) error {
	if swag.IsZero(o.BroadcastDomain) { // not required
		return nil
	}

	if o.BroadcastDomain != nil {
		if err := o.BroadcastDomain.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "broadcast_domain")
			}
			return err
		}
	}

	return nil
}

var networkEthernetPortModifyCollectionBodyTypeFlowcontrolAdminPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","send","receive","full","pfc"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		networkEthernetPortModifyCollectionBodyTypeFlowcontrolAdminPropEnum = append(networkEthernetPortModifyCollectionBodyTypeFlowcontrolAdminPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NetworkEthernetPortModifyCollectionBody
	// NetworkEthernetPortModifyCollectionBody
	// flowcontrol_admin
	// FlowcontrolAdmin
	// none
	// END DEBUGGING
	// NetworkEthernetPortModifyCollectionBodyFlowcontrolAdminNone captures enum value "none"
	NetworkEthernetPortModifyCollectionBodyFlowcontrolAdminNone string = "none"

	// BEGIN DEBUGGING
	// NetworkEthernetPortModifyCollectionBody
	// NetworkEthernetPortModifyCollectionBody
	// flowcontrol_admin
	// FlowcontrolAdmin
	// send
	// END DEBUGGING
	// NetworkEthernetPortModifyCollectionBodyFlowcontrolAdminSend captures enum value "send"
	NetworkEthernetPortModifyCollectionBodyFlowcontrolAdminSend string = "send"

	// BEGIN DEBUGGING
	// NetworkEthernetPortModifyCollectionBody
	// NetworkEthernetPortModifyCollectionBody
	// flowcontrol_admin
	// FlowcontrolAdmin
	// receive
	// END DEBUGGING
	// NetworkEthernetPortModifyCollectionBodyFlowcontrolAdminReceive captures enum value "receive"
	NetworkEthernetPortModifyCollectionBodyFlowcontrolAdminReceive string = "receive"

	// BEGIN DEBUGGING
	// NetworkEthernetPortModifyCollectionBody
	// NetworkEthernetPortModifyCollectionBody
	// flowcontrol_admin
	// FlowcontrolAdmin
	// full
	// END DEBUGGING
	// NetworkEthernetPortModifyCollectionBodyFlowcontrolAdminFull captures enum value "full"
	NetworkEthernetPortModifyCollectionBodyFlowcontrolAdminFull string = "full"

	// BEGIN DEBUGGING
	// NetworkEthernetPortModifyCollectionBody
	// NetworkEthernetPortModifyCollectionBody
	// flowcontrol_admin
	// FlowcontrolAdmin
	// pfc
	// END DEBUGGING
	// NetworkEthernetPortModifyCollectionBodyFlowcontrolAdminPfc captures enum value "pfc"
	NetworkEthernetPortModifyCollectionBodyFlowcontrolAdminPfc string = "pfc"
)

// prop value enum
func (o *NetworkEthernetPortModifyCollectionBody) validateFlowcontrolAdminEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, networkEthernetPortModifyCollectionBodyTypeFlowcontrolAdminPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) validateFlowcontrolAdmin(formats strfmt.Registry) error {
	if swag.IsZero(o.FlowcontrolAdmin) { // not required
		return nil
	}

	// value enum
	if err := o.validateFlowcontrolAdminEnum("info"+"."+"flowcontrol_admin", "body", *o.FlowcontrolAdmin); err != nil {
		return err
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) validateLag(formats strfmt.Registry) error {
	if swag.IsZero(o.Lag) { // not required
		return nil
	}

	if o.Lag != nil {
		if err := o.Lag.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "lag")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(o.Metric) { // not required
		return nil
	}

	if o.Metric != nil {
		if err := o.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) validateMtu(formats strfmt.Registry) error {
	if swag.IsZero(o.Mtu) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"mtu", "body", *o.Mtu, 68, false); err != nil {
		return err
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) validatePortInlineDiscoveredDevices(formats strfmt.Registry) error {
	if swag.IsZero(o.PortInlineDiscoveredDevices) { // not required
		return nil
	}

	for i := 0; i < len(o.PortInlineDiscoveredDevices); i++ {
		if swag.IsZero(o.PortInlineDiscoveredDevices[i]) { // not required
			continue
		}

		if o.PortInlineDiscoveredDevices[i] != nil {
			if err := o.PortInlineDiscoveredDevices[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "discovered_devices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) validatePortInlinePfcQueuesAdmin(formats strfmt.Registry) error {
	if swag.IsZero(o.PortInlinePfcQueuesAdmin) { // not required
		return nil
	}

	for i := 0; i < len(o.PortInlinePfcQueuesAdmin); i++ {
		if swag.IsZero(o.PortInlinePfcQueuesAdmin[i]) { // not required
			continue
		}

		if err := validate.MinimumInt("info"+"."+"pfc_queues_admin"+"."+strconv.Itoa(i), "body", *o.PortInlinePfcQueuesAdmin[i], 0, false); err != nil {
			return err
		}

		if err := validate.MaximumInt("info"+"."+"pfc_queues_admin"+"."+strconv.Itoa(i), "body", *o.PortInlinePfcQueuesAdmin[i], 7, false); err != nil {
			return err
		}

	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) validatePortInlineReachableBroadcastDomains(formats strfmt.Registry) error {
	if swag.IsZero(o.PortInlineReachableBroadcastDomains) { // not required
		return nil
	}

	for i := 0; i < len(o.PortInlineReachableBroadcastDomains); i++ {
		if swag.IsZero(o.PortInlineReachableBroadcastDomains[i]) { // not required
			continue
		}

		if o.PortInlineReachableBroadcastDomains[i] != nil {
			if err := o.PortInlineReachableBroadcastDomains[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "reachable_broadcast_domains" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) validatePortResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.PortResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.PortResponseInlineRecords); i++ {
		if swag.IsZero(o.PortResponseInlineRecords[i]) { // not required
			continue
		}

		if o.PortResponseInlineRecords[i] != nil {
			if err := o.PortResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var networkEthernetPortModifyCollectionBodyRdmaProtocolsItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["roce"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		networkEthernetPortModifyCollectionBodyRdmaProtocolsItemsEnum = append(networkEthernetPortModifyCollectionBodyRdmaProtocolsItemsEnum, v)
	}
}

func (o *NetworkEthernetPortModifyCollectionBody) validateRdmaProtocolsItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, networkEthernetPortModifyCollectionBodyRdmaProtocolsItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) validateRdmaProtocols(formats strfmt.Registry) error {
	if swag.IsZero(o.RdmaProtocols) { // not required
		return nil
	}

	for i := 0; i < len(o.RdmaProtocols); i++ {
		if swag.IsZero(o.RdmaProtocols[i]) { // not required
			continue
		}

		// value enum
		if err := o.validateRdmaProtocolsItemsEnum("info"+"."+"rdma_protocols"+"."+strconv.Itoa(i), "body", *o.RdmaProtocols[i]); err != nil {
			return err
		}

	}

	return nil
}

var networkEthernetPortModifyCollectionBodyTypeReachabilityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","repairable","not_repairable"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		networkEthernetPortModifyCollectionBodyTypeReachabilityPropEnum = append(networkEthernetPortModifyCollectionBodyTypeReachabilityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NetworkEthernetPortModifyCollectionBody
	// NetworkEthernetPortModifyCollectionBody
	// reachability
	// Reachability
	// ok
	// END DEBUGGING
	// NetworkEthernetPortModifyCollectionBodyReachabilityOk captures enum value "ok"
	NetworkEthernetPortModifyCollectionBodyReachabilityOk string = "ok"

	// BEGIN DEBUGGING
	// NetworkEthernetPortModifyCollectionBody
	// NetworkEthernetPortModifyCollectionBody
	// reachability
	// Reachability
	// repairable
	// END DEBUGGING
	// NetworkEthernetPortModifyCollectionBodyReachabilityRepairable captures enum value "repairable"
	NetworkEthernetPortModifyCollectionBodyReachabilityRepairable string = "repairable"

	// BEGIN DEBUGGING
	// NetworkEthernetPortModifyCollectionBody
	// NetworkEthernetPortModifyCollectionBody
	// reachability
	// Reachability
	// not_repairable
	// END DEBUGGING
	// NetworkEthernetPortModifyCollectionBodyReachabilityNotRepairable captures enum value "not_repairable"
	NetworkEthernetPortModifyCollectionBodyReachabilityNotRepairable string = "not_repairable"
)

// prop value enum
func (o *NetworkEthernetPortModifyCollectionBody) validateReachabilityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, networkEthernetPortModifyCollectionBodyTypeReachabilityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) validateReachability(formats strfmt.Registry) error {
	if swag.IsZero(o.Reachability) { // not required
		return nil
	}

	// value enum
	if err := o.validateReachabilityEnum("info"+"."+"reachability", "body", *o.Reachability); err != nil {
		return err
	}

	return nil
}

var networkEthernetPortModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down","degraded"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		networkEthernetPortModifyCollectionBodyTypeStatePropEnum = append(networkEthernetPortModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NetworkEthernetPortModifyCollectionBody
	// NetworkEthernetPortModifyCollectionBody
	// state
	// State
	// up
	// END DEBUGGING
	// NetworkEthernetPortModifyCollectionBodyStateUp captures enum value "up"
	NetworkEthernetPortModifyCollectionBodyStateUp string = "up"

	// BEGIN DEBUGGING
	// NetworkEthernetPortModifyCollectionBody
	// NetworkEthernetPortModifyCollectionBody
	// state
	// State
	// down
	// END DEBUGGING
	// NetworkEthernetPortModifyCollectionBodyStateDown captures enum value "down"
	NetworkEthernetPortModifyCollectionBodyStateDown string = "down"

	// BEGIN DEBUGGING
	// NetworkEthernetPortModifyCollectionBody
	// NetworkEthernetPortModifyCollectionBody
	// state
	// State
	// degraded
	// END DEBUGGING
	// NetworkEthernetPortModifyCollectionBodyStateDegraded captures enum value "degraded"
	NetworkEthernetPortModifyCollectionBodyStateDegraded string = "degraded"
)

// prop value enum
func (o *NetworkEthernetPortModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, networkEthernetPortModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(o.Statistics) { // not required
		return nil
	}

	if o.Statistics != nil {
		if err := o.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

var networkEthernetPortModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["vlan","physical","lag","pvlan"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		networkEthernetPortModifyCollectionBodyTypeTypePropEnum = append(networkEthernetPortModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NetworkEthernetPortModifyCollectionBody
	// NetworkEthernetPortModifyCollectionBody
	// type
	// Type
	// vlan
	// END DEBUGGING
	// NetworkEthernetPortModifyCollectionBodyTypeVlan captures enum value "vlan"
	NetworkEthernetPortModifyCollectionBodyTypeVlan string = "vlan"

	// BEGIN DEBUGGING
	// NetworkEthernetPortModifyCollectionBody
	// NetworkEthernetPortModifyCollectionBody
	// type
	// Type
	// physical
	// END DEBUGGING
	// NetworkEthernetPortModifyCollectionBodyTypePhysical captures enum value "physical"
	NetworkEthernetPortModifyCollectionBodyTypePhysical string = "physical"

	// BEGIN DEBUGGING
	// NetworkEthernetPortModifyCollectionBody
	// NetworkEthernetPortModifyCollectionBody
	// type
	// Type
	// lag
	// END DEBUGGING
	// NetworkEthernetPortModifyCollectionBodyTypeLag captures enum value "lag"
	NetworkEthernetPortModifyCollectionBodyTypeLag string = "lag"

	// BEGIN DEBUGGING
	// NetworkEthernetPortModifyCollectionBody
	// NetworkEthernetPortModifyCollectionBody
	// type
	// Type
	// pvlan
	// END DEBUGGING
	// NetworkEthernetPortModifyCollectionBodyTypePvlan captures enum value "pvlan"
	NetworkEthernetPortModifyCollectionBodyTypePvlan string = "pvlan"
)

// prop value enum
func (o *NetworkEthernetPortModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, networkEthernetPortModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) validateVlan(formats strfmt.Registry) error {
	if swag.IsZero(o.Vlan) { // not required
		return nil
	}

	if o.Vlan != nil {
		if err := o.Vlan.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vlan")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this network ethernet port modify collection body based on the context it is used
func (o *NetworkEthernetPortModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateBroadcastDomain(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInterfaceCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLag(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMacAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMtu(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePortInlineDiscoveredDevices(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePortInlineReachableBroadcastDomains(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePortResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRdmaProtocols(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpeed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVlan(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) contextValidateBroadcastDomain(ctx context.Context, formats strfmt.Registry) error {

	if o.BroadcastDomain != nil {
		if err := o.BroadcastDomain.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "broadcast_domain")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) contextValidateInterfaceCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"interface_count", "body", o.InterfaceCount); err != nil {
		return err
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) contextValidateLag(ctx context.Context, formats strfmt.Registry) error {

	if o.Lag != nil {
		if err := o.Lag.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "lag")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) contextValidateMacAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"mac_address", "body", o.MacAddress); err != nil {
		return err
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if o.Metric != nil {
		if err := o.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) contextValidateMtu(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"mtu", "body", o.Mtu); err != nil {
		return err
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) contextValidatePortInlineDiscoveredDevices(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"discovered_devices", "body", []*models.PortInlineDiscoveredDevicesInlineArrayItem(o.PortInlineDiscoveredDevices)); err != nil {
		return err
	}

	for i := 0; i < len(o.PortInlineDiscoveredDevices); i++ {

		if o.PortInlineDiscoveredDevices[i] != nil {
			if err := o.PortInlineDiscoveredDevices[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "discovered_devices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) contextValidatePortInlineReachableBroadcastDomains(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"reachable_broadcast_domains", "body", []*models.PortInlineReachableBroadcastDomainsInlineArrayItem(o.PortInlineReachableBroadcastDomains)); err != nil {
		return err
	}

	for i := 0; i < len(o.PortInlineReachableBroadcastDomains); i++ {

		if o.PortInlineReachableBroadcastDomains[i] != nil {
			if err := o.PortInlineReachableBroadcastDomains[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "reachable_broadcast_domains" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) contextValidatePortResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.PortResponseInlineRecords); i++ {

		if o.PortResponseInlineRecords[i] != nil {
			if err := o.PortResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) contextValidateRdmaProtocols(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rdma_protocols", "body", []*string(o.RdmaProtocols)); err != nil {
		return err
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) contextValidateSpeed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"speed", "body", o.Speed); err != nil {
		return err
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if o.Statistics != nil {
		if err := o.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionBody) contextValidateVlan(ctx context.Context, formats strfmt.Registry) error {

	if o.Vlan != nil {
		if err := o.Vlan.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vlan")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NetworkEthernetPortModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkEthernetPortModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res NetworkEthernetPortModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0 Port UUID along with readable names. Either the UUID or both names may be supplied on input.
swagger:model NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0
*/
type NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0 struct {

	// links
	Links *NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0Links `json:"_links,omitempty"`

	// name
	// Example: e1b
	Name *string `json:"name,omitempty"`

	// node
	Node *NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0Node `json:"node,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this network ethernet port modify collection params body lag active ports items0
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this network ethernet port modify collection params body lag active ports items0 based on the context it is used
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0) UnmarshalBinary(b []byte) error {
	var res NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0Links network ethernet port modify collection params body lag active ports items0 links
swagger:model NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0Links
*/
type NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this network ethernet port modify collection params body lag active ports items0 links
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this network ethernet port modify collection params body lag active ports items0 links based on the context it is used
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0Links) UnmarshalBinary(b []byte) error {
	var res NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0Node network ethernet port modify collection params body lag active ports items0 node
swagger:model NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0Node
*/
type NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0Node struct {

	// Name of node on which the port is located.
	// Example: node1
	Name *string `json:"name,omitempty"`
}

// Validate validates this network ethernet port modify collection params body lag active ports items0 node
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0Node) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this network ethernet port modify collection params body lag active ports items0 node based on context it is used
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0Node) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0Node) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0Node) UnmarshalBinary(b []byte) error {
	var res NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0Node
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0 Port UUID along with readable names. Either the UUID or both names may be supplied on input.
swagger:model NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0
*/
type NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0 struct {

	// links
	Links *NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0Links `json:"_links,omitempty"`

	// name
	// Example: e1b
	Name *string `json:"name,omitempty"`

	// node
	Node *NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0Node `json:"node,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this network ethernet port modify collection params body lag member ports items0
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this network ethernet port modify collection params body lag member ports items0 based on the context it is used
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0) UnmarshalBinary(b []byte) error {
	var res NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0Links network ethernet port modify collection params body lag member ports items0 links
swagger:model NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0Links
*/
type NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this network ethernet port modify collection params body lag member ports items0 links
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this network ethernet port modify collection params body lag member ports items0 links based on the context it is used
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0Links) UnmarshalBinary(b []byte) error {
	var res NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0Node network ethernet port modify collection params body lag member ports items0 node
swagger:model NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0Node
*/
type NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0Node struct {

	// Name of node on which the port is located.
	// Example: node1
	Name *string `json:"name,omitempty"`
}

// Validate validates this network ethernet port modify collection params body lag member ports items0 node
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0Node) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this network ethernet port modify collection params body lag member ports items0 node based on context it is used
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0Node) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0Node) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0Node) UnmarshalBinary(b []byte) error {
	var res NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0Node
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineLinks port inline links
swagger:model port_inline__links
*/
type PortInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this port inline links
func (o *PortInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline links based on the context it is used
func (o *PortInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineLinks) UnmarshalBinary(b []byte) error {
	var res PortInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineBroadcastDomain Broadcast domain UUID along with a readable name. Either the UUID or both names may be provided on input.
swagger:model port_inline_broadcast_domain
*/
type PortInlineBroadcastDomain struct {

	// links
	Links *models.PortInlineBroadcastDomainInlineLinks `json:"_links,omitempty"`

	// ipspace
	Ipspace *models.PortInlineBroadcastDomainInlineIpspace `json:"ipspace,omitempty"`

	// Name of the broadcast domain, scoped to its IPspace
	// Example: bd1
	Name *string `json:"name,omitempty"`

	// Broadcast domain UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this port inline broadcast domain
func (o *PortInlineBroadcastDomain) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineBroadcastDomain) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "broadcast_domain" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *PortInlineBroadcastDomain) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(o.Ipspace) { // not required
		return nil
	}

	if o.Ipspace != nil {
		if err := o.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "broadcast_domain" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline broadcast domain based on the context it is used
func (o *PortInlineBroadcastDomain) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineBroadcastDomain) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "broadcast_domain" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *PortInlineBroadcastDomain) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if o.Ipspace != nil {
		if err := o.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "broadcast_domain" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineBroadcastDomain) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineBroadcastDomain) UnmarshalBinary(b []byte) error {
	var res PortInlineBroadcastDomain
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineBroadcastDomainInlineLinks port inline broadcast domain inline links
swagger:model port_inline_broadcast_domain_inline__links
*/
type PortInlineBroadcastDomainInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this port inline broadcast domain inline links
func (o *PortInlineBroadcastDomainInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineBroadcastDomainInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "broadcast_domain" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline broadcast domain inline links based on the context it is used
func (o *PortInlineBroadcastDomainInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineBroadcastDomainInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "broadcast_domain" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineBroadcastDomainInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineBroadcastDomainInlineLinks) UnmarshalBinary(b []byte) error {
	var res PortInlineBroadcastDomainInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineBroadcastDomainInlineIpspace port inline broadcast domain inline ipspace
swagger:model port_inline_broadcast_domain_inline_ipspace
*/
type PortInlineBroadcastDomainInlineIpspace struct {

	// Name of the broadcast domain's IPspace
	// Example: ipspace1
	Name *string `json:"name,omitempty"`
}

// Validate validates this port inline broadcast domain inline ipspace
func (o *PortInlineBroadcastDomainInlineIpspace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this port inline broadcast domain inline ipspace based on context it is used
func (o *PortInlineBroadcastDomainInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineBroadcastDomainInlineIpspace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineBroadcastDomainInlineIpspace) UnmarshalBinary(b []byte) error {
	var res PortInlineBroadcastDomainInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineDiscoveredDevicesInlineArrayItem port inline discovered devices inline array item
swagger:model port_inline_discovered_devices_inline_array_item
*/
type PortInlineDiscoveredDevicesInlineArrayItem struct {

	// The list of the capabilities of the discovered device.
	// Example: ["router","switch"]
	Capabilities []*string `json:"capabilities"`

	// Identifier associated with this specific discovered device, useful for locating the device in a data center.
	ChassisID *string `json:"chassis_id,omitempty"`

	// The IP addresses on the discovered device.
	// Example: ["192.168.100.24","192.168.100.26"]
	IPAddresses []*models.IPAddressReadonly `json:"ip_addresses"`

	// Name of the discovered device.
	// Example: ETY-R1S4-510Q13.datacenter.example.com
	Name *string `json:"name,omitempty"`

	// Hardware platform of the discovered device.
	// Example: 93180YC-EX
	Platform *string `json:"platform,omitempty"`

	// The protocol used to identify the discovered device. This can have a value of CDP or LLDP.
	// Example: cdp
	// Enum: ["cdp","lldp"]
	Protocol *string `json:"protocol,omitempty"`

	// The number of seconds until the discovered device entry expires and is removed.
	RemainingHoldTime *int64 `json:"remaining_hold_time,omitempty"`

	// The name of the remote port on the discovered device. The format is dependent on the reporting device.
	// Example: FastEthernet0/12
	RemotePort *string `json:"remote_port,omitempty"`

	// Additional name used to identify a specific piece of equipment.
	SystemName *string `json:"system_name,omitempty"`

	// The version of the software running on the discovered device.
	// Example: Cisco Nexus Operating System (NX-OS) Software, Version 8.1
	Version *string `json:"version,omitempty"`
}

// Validate validates this port inline discovered devices inline array item
func (o *PortInlineDiscoveredDevicesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCapabilities(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIPAddresses(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var portInlineDiscoveredDevicesInlineArrayItemCapabilitiesItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["router","transparent_bridge","source_route_bridge","switch","host","igmp","repeater","phone"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		portInlineDiscoveredDevicesInlineArrayItemCapabilitiesItemsEnum = append(portInlineDiscoveredDevicesInlineArrayItemCapabilitiesItemsEnum, v)
	}
}

func (o *PortInlineDiscoveredDevicesInlineArrayItem) validateCapabilitiesItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, portInlineDiscoveredDevicesInlineArrayItemCapabilitiesItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *PortInlineDiscoveredDevicesInlineArrayItem) validateCapabilities(formats strfmt.Registry) error {
	if swag.IsZero(o.Capabilities) { // not required
		return nil
	}

	for i := 0; i < len(o.Capabilities); i++ {
		if swag.IsZero(o.Capabilities[i]) { // not required
			continue
		}

		// value enum
		if err := o.validateCapabilitiesItemsEnum("capabilities"+"."+strconv.Itoa(i), "body", *o.Capabilities[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *PortInlineDiscoveredDevicesInlineArrayItem) validateIPAddresses(formats strfmt.Registry) error {
	if swag.IsZero(o.IPAddresses) { // not required
		return nil
	}

	for i := 0; i < len(o.IPAddresses); i++ {
		if swag.IsZero(o.IPAddresses[i]) { // not required
			continue
		}

		if o.IPAddresses[i] != nil {
			if err := o.IPAddresses[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ip_addresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var portInlineDiscoveredDevicesInlineArrayItemTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cdp","lldp"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		portInlineDiscoveredDevicesInlineArrayItemTypeProtocolPropEnum = append(portInlineDiscoveredDevicesInlineArrayItemTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// port_inline_discovered_devices_inline_array_item
	// PortInlineDiscoveredDevicesInlineArrayItem
	// protocol
	// Protocol
	// cdp
	// END DEBUGGING
	// PortInlineDiscoveredDevicesInlineArrayItemProtocolCdp captures enum value "cdp"
	PortInlineDiscoveredDevicesInlineArrayItemProtocolCdp string = "cdp"

	// BEGIN DEBUGGING
	// port_inline_discovered_devices_inline_array_item
	// PortInlineDiscoveredDevicesInlineArrayItem
	// protocol
	// Protocol
	// lldp
	// END DEBUGGING
	// PortInlineDiscoveredDevicesInlineArrayItemProtocolLldp captures enum value "lldp"
	PortInlineDiscoveredDevicesInlineArrayItemProtocolLldp string = "lldp"
)

// prop value enum
func (o *PortInlineDiscoveredDevicesInlineArrayItem) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, portInlineDiscoveredDevicesInlineArrayItemTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *PortInlineDiscoveredDevicesInlineArrayItem) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(o.Protocol) { // not required
		return nil
	}

	// value enum
	if err := o.validateProtocolEnum("protocol", "body", *o.Protocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this port inline discovered devices inline array item based on the context it is used
func (o *PortInlineDiscoveredDevicesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIPAddresses(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineDiscoveredDevicesInlineArrayItem) contextValidateIPAddresses(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.IPAddresses); i++ {

		if o.IPAddresses[i] != nil {
			if err := o.IPAddresses[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ip_addresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineDiscoveredDevicesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineDiscoveredDevicesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res PortInlineDiscoveredDevicesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineLag port inline lag
swagger:model port_inline_lag
*/
type PortInlineLag struct {

	// Active ports of a LAG (ifgrp). (Some member ports may be inactive.)
	// Read Only: true
	ActivePorts []*NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0 `json:"active_ports,omitempty"`

	// Policy for mapping flows to ports for outbound packets through a LAG (ifgrp).
	// Enum: ["port","ip","mac","sequential"]
	DistributionPolicy *string `json:"distribution_policy,omitempty"`

	// Array of ports belonging to the LAG, regardless of their state.
	MemberPorts []*NetworkEthernetPortModifyCollectionParamsBodyLagMemberPortsItems0 `json:"member_ports,omitempty"`

	// Determines how the ports interact with the switch.
	// Enum: ["multimode_lacp","multimode","singlemode"]
	Mode *string `json:"mode,omitempty"`
}

// Validate validates this port inline lag
func (o *PortInlineLag) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateActivePorts(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDistributionPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMemberPorts(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineLag) validateActivePorts(formats strfmt.Registry) error {
	if swag.IsZero(o.ActivePorts) { // not required
		return nil
	}

	for i := 0; i < len(o.ActivePorts); i++ {
		if swag.IsZero(o.ActivePorts[i]) { // not required
			continue
		}

		if o.ActivePorts[i] != nil {
			if err := o.ActivePorts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "lag" + "." + "active_ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var portInlineLagTypeDistributionPolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["port","ip","mac","sequential"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		portInlineLagTypeDistributionPolicyPropEnum = append(portInlineLagTypeDistributionPolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// port_inline_lag
	// PortInlineLag
	// distribution_policy
	// DistributionPolicy
	// port
	// END DEBUGGING
	// PortInlineLagDistributionPolicyPort captures enum value "port"
	PortInlineLagDistributionPolicyPort string = "port"

	// BEGIN DEBUGGING
	// port_inline_lag
	// PortInlineLag
	// distribution_policy
	// DistributionPolicy
	// ip
	// END DEBUGGING
	// PortInlineLagDistributionPolicyIP captures enum value "ip"
	PortInlineLagDistributionPolicyIP string = "ip"

	// BEGIN DEBUGGING
	// port_inline_lag
	// PortInlineLag
	// distribution_policy
	// DistributionPolicy
	// mac
	// END DEBUGGING
	// PortInlineLagDistributionPolicyMac captures enum value "mac"
	PortInlineLagDistributionPolicyMac string = "mac"

	// BEGIN DEBUGGING
	// port_inline_lag
	// PortInlineLag
	// distribution_policy
	// DistributionPolicy
	// sequential
	// END DEBUGGING
	// PortInlineLagDistributionPolicySequential captures enum value "sequential"
	PortInlineLagDistributionPolicySequential string = "sequential"
)

// prop value enum
func (o *PortInlineLag) validateDistributionPolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, portInlineLagTypeDistributionPolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *PortInlineLag) validateDistributionPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.DistributionPolicy) { // not required
		return nil
	}

	// value enum
	if err := o.validateDistributionPolicyEnum("info"+"."+"lag"+"."+"distribution_policy", "body", *o.DistributionPolicy); err != nil {
		return err
	}

	return nil
}

func (o *PortInlineLag) validateMemberPorts(formats strfmt.Registry) error {
	if swag.IsZero(o.MemberPorts) { // not required
		return nil
	}

	for i := 0; i < len(o.MemberPorts); i++ {
		if swag.IsZero(o.MemberPorts[i]) { // not required
			continue
		}

		if o.MemberPorts[i] != nil {
			if err := o.MemberPorts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "lag" + "." + "member_ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var portInlineLagTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["multimode_lacp","multimode","singlemode"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		portInlineLagTypeModePropEnum = append(portInlineLagTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// port_inline_lag
	// PortInlineLag
	// mode
	// Mode
	// multimode_lacp
	// END DEBUGGING
	// PortInlineLagModeMultimodeLacp captures enum value "multimode_lacp"
	PortInlineLagModeMultimodeLacp string = "multimode_lacp"

	// BEGIN DEBUGGING
	// port_inline_lag
	// PortInlineLag
	// mode
	// Mode
	// multimode
	// END DEBUGGING
	// PortInlineLagModeMultimode captures enum value "multimode"
	PortInlineLagModeMultimode string = "multimode"

	// BEGIN DEBUGGING
	// port_inline_lag
	// PortInlineLag
	// mode
	// Mode
	// singlemode
	// END DEBUGGING
	// PortInlineLagModeSinglemode captures enum value "singlemode"
	PortInlineLagModeSinglemode string = "singlemode"
)

// prop value enum
func (o *PortInlineLag) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, portInlineLagTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *PortInlineLag) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(o.Mode) { // not required
		return nil
	}

	// value enum
	if err := o.validateModeEnum("info"+"."+"lag"+"."+"mode", "body", *o.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this port inline lag based on the context it is used
func (o *PortInlineLag) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateActivePorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMemberPorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineLag) contextValidateActivePorts(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"lag"+"."+"active_ports", "body", []*NetworkEthernetPortModifyCollectionParamsBodyLagActivePortsItems0(o.ActivePorts)); err != nil {
		return err
	}

	for i := 0; i < len(o.ActivePorts); i++ {

		if o.ActivePorts[i] != nil {
			if err := o.ActivePorts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "lag" + "." + "active_ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *PortInlineLag) contextValidateMemberPorts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.MemberPorts); i++ {

		if o.MemberPorts[i] != nil {
			if err := o.MemberPorts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "lag" + "." + "member_ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineLag) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineLag) UnmarshalBinary(b []byte) error {
	var res PortInlineLag
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineMetric The most recent sample of I/O metrics for the port.
swagger:model port_inline_metric
*/
type PortInlineMetric struct {

	// links
	Links *models.PortInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *models.PortInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this port inline metric
func (o *PortInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var portInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		portInlineMetricTypeDurationPropEnum = append(portInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PortInlineMetricDurationPT15S captures enum value "PT15S"
	PortInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PortInlineMetricDurationPT4M captures enum value "PT4M"
	PortInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PortInlineMetricDurationPT30M captures enum value "PT30M"
	PortInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PortInlineMetricDurationPT2H captures enum value "PT2H"
	PortInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PortInlineMetricDurationP1D captures enum value "P1D"
	PortInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PortInlineMetricDurationPT5M captures enum value "PT5M"
	PortInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (o *PortInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, portInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *PortInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(o.Duration) { // not required
		return nil
	}

	// value enum
	if err := o.validateDurationEnum("info"+"."+"metric"+"."+"duration", "body", *o.Duration); err != nil {
		return err
	}

	return nil
}

var portInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		portInlineMetricTypeStatusPropEnum = append(portInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// PortInlineMetricStatusOk captures enum value "ok"
	PortInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// PortInlineMetricStatusError captures enum value "error"
	PortInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PortInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	PortInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PortInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	PortInlineMetricStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PortInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	PortInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PortInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	PortInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PortInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	PortInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PortInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	PortInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PortInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PortInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PortInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	PortInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (o *PortInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, portInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *PortInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"metric"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *PortInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(o.Throughput) { // not required
		return nil
	}

	if o.Throughput != nil {
		if err := o.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *PortInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"metric"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this port inline metric based on the context it is used
func (o *PortInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *PortInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if o.Throughput != nil {
		if err := o.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineMetric) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineMetric) UnmarshalBinary(b []byte) error {
	var res PortInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineMetricInlineLinks port inline metric inline links
swagger:model port_inline_metric_inline__links
*/
type PortInlineMetricInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this port inline metric inline links
func (o *PortInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline metric inline links based on the context it is used
func (o *PortInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res PortInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineMetricInlineThroughput The rate of throughput bytes per second observed at the interface.
swagger:model port_inline_metric_inline_throughput
*/
type PortInlineMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this port inline metric inline throughput
func (o *PortInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this port inline metric inline throughput based on context it is used
func (o *PortInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res PortInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineNode port inline node
swagger:model port_inline_node
*/
type PortInlineNode struct {

	// links
	Links *models.PortInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this port inline node
func (o *PortInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline node based on the context it is used
func (o *PortInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineNode) UnmarshalBinary(b []byte) error {
	var res PortInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineNodeInlineLinks port inline node inline links
swagger:model port_inline_node_inline__links
*/
type PortInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this port inline node inline links
func (o *PortInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline node inline links based on the context it is used
func (o *PortInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res PortInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineReachableBroadcastDomainsInlineArrayItem Broadcast domain UUID along with a readable name. Either the UUID or both names may be provided on input.
swagger:model port_inline_reachable_broadcast_domains_inline_array_item
*/
type PortInlineReachableBroadcastDomainsInlineArrayItem struct {

	// links
	Links *models.PortInlineReachableBroadcastDomainsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// ipspace
	Ipspace *models.PortInlineReachableBroadcastDomainsInlineArrayItemInlineIpspace `json:"ipspace,omitempty"`

	// Name of the broadcast domain, scoped to its IPspace
	// Example: bd1
	Name *string `json:"name,omitempty"`

	// Broadcast domain UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this port inline reachable broadcast domains inline array item
func (o *PortInlineReachableBroadcastDomainsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineReachableBroadcastDomainsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *PortInlineReachableBroadcastDomainsInlineArrayItem) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(o.Ipspace) { // not required
		return nil
	}

	if o.Ipspace != nil {
		if err := o.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline reachable broadcast domains inline array item based on the context it is used
func (o *PortInlineReachableBroadcastDomainsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineReachableBroadcastDomainsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *PortInlineReachableBroadcastDomainsInlineArrayItem) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if o.Ipspace != nil {
		if err := o.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineReachableBroadcastDomainsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineReachableBroadcastDomainsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res PortInlineReachableBroadcastDomainsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineReachableBroadcastDomainsInlineArrayItemInlineLinks port inline reachable broadcast domains inline array item inline links
swagger:model port_inline_reachable_broadcast_domains_inline_array_item_inline__links
*/
type PortInlineReachableBroadcastDomainsInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this port inline reachable broadcast domains inline array item inline links
func (o *PortInlineReachableBroadcastDomainsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineReachableBroadcastDomainsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline reachable broadcast domains inline array item inline links based on the context it is used
func (o *PortInlineReachableBroadcastDomainsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineReachableBroadcastDomainsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineReachableBroadcastDomainsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineReachableBroadcastDomainsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res PortInlineReachableBroadcastDomainsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineReachableBroadcastDomainsInlineArrayItemInlineIpspace port inline reachable broadcast domains inline array item inline ipspace
swagger:model port_inline_reachable_broadcast_domains_inline_array_item_inline_ipspace
*/
type PortInlineReachableBroadcastDomainsInlineArrayItemInlineIpspace struct {

	// Name of the broadcast domain's IPspace
	// Example: ipspace1
	Name *string `json:"name,omitempty"`
}

// Validate validates this port inline reachable broadcast domains inline array item inline ipspace
func (o *PortInlineReachableBroadcastDomainsInlineArrayItemInlineIpspace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this port inline reachable broadcast domains inline array item inline ipspace based on context it is used
func (o *PortInlineReachableBroadcastDomainsInlineArrayItemInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineReachableBroadcastDomainsInlineArrayItemInlineIpspace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineReachableBroadcastDomainsInlineArrayItemInlineIpspace) UnmarshalBinary(b []byte) error {
	var res PortInlineReachableBroadcastDomainsInlineArrayItemInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineStatistics The real time I/O statistics for the port.
swagger:model port_inline_statistics
*/
type PortInlineStatistics struct {

	// device
	Device *PortInlineStatisticsInlineDevice `json:"device,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *PortInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the throughput_raw performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this port inline statistics
func (o *PortInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDevice(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineStatistics) validateDevice(formats strfmt.Registry) error {
	if swag.IsZero(o.Device) { // not required
		return nil
	}

	if o.Device != nil {
		if err := o.Device.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "device")
			}
			return err
		}
	}

	return nil
}

var portInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		portInlineStatisticsTypeStatusPropEnum = append(portInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// port_inline_statistics
	// PortInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// PortInlineStatisticsStatusOk captures enum value "ok"
	PortInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// port_inline_statistics
	// PortInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// PortInlineStatisticsStatusError captures enum value "error"
	PortInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// port_inline_statistics
	// PortInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PortInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	PortInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// port_inline_statistics
	// PortInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PortInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	PortInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// port_inline_statistics
	// PortInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PortInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	PortInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// port_inline_statistics
	// PortInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PortInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	PortInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// port_inline_statistics
	// PortInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PortInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	PortInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// port_inline_statistics
	// PortInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PortInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	PortInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// port_inline_statistics
	// PortInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PortInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PortInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// port_inline_statistics
	// PortInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PortInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	PortInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (o *PortInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, portInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *PortInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"statistics"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *PortInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.ThroughputRaw) { // not required
		return nil
	}

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *PortInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"statistics"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this port inline statistics based on the context it is used
func (o *PortInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDevice(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineStatistics) contextValidateDevice(ctx context.Context, formats strfmt.Registry) error {

	if o.Device != nil {
		if err := o.Device.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "device")
			}
			return err
		}
	}

	return nil
}

func (o *PortInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineStatistics) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineStatistics) UnmarshalBinary(b []byte) error {
	var res PortInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineStatisticsInlineDevice Device-related counters for the port object. These counters are applicable at the lowest layer of the networking stack. These values can be used to calculate both transmit and receive packet and error rates by comparing two samples taken at different times and calculating the increase in counter value divided by the elapsed time between the two samples.
swagger:model port_inline_statistics_inline_device
*/
type PortInlineStatisticsInlineDevice struct {

	// The number of link state changes from up to down seen on the device.
	// Example: 3
	LinkDownCountRaw *int64 `json:"link_down_count_raw,omitempty"`

	// receive raw
	ReceiveRaw *PortInlineStatisticsInlineDeviceInlineReceiveRaw `json:"receive_raw,omitempty"`

	// The timestamp when the device specific counters were collected.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// transmit raw
	TransmitRaw *PortInlineStatisticsInlineDeviceInlineTransmitRaw `json:"transmit_raw,omitempty"`
}

// Validate validates this port inline statistics inline device
func (o *PortInlineStatisticsInlineDevice) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateReceiveRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTransmitRaw(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineStatisticsInlineDevice) validateReceiveRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.ReceiveRaw) { // not required
		return nil
	}

	if o.ReceiveRaw != nil {
		if err := o.ReceiveRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "device" + "." + "receive_raw")
			}
			return err
		}
	}

	return nil
}

func (o *PortInlineStatisticsInlineDevice) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"statistics"+"."+"device"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *PortInlineStatisticsInlineDevice) validateTransmitRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.TransmitRaw) { // not required
		return nil
	}

	if o.TransmitRaw != nil {
		if err := o.TransmitRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "device" + "." + "transmit_raw")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline statistics inline device based on the context it is used
func (o *PortInlineStatisticsInlineDevice) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateReceiveRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTransmitRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineStatisticsInlineDevice) contextValidateReceiveRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.ReceiveRaw != nil {
		if err := o.ReceiveRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "device" + "." + "receive_raw")
			}
			return err
		}
	}

	return nil
}

func (o *PortInlineStatisticsInlineDevice) contextValidateTransmitRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.TransmitRaw != nil {
		if err := o.TransmitRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "device" + "." + "transmit_raw")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineStatisticsInlineDevice) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineStatisticsInlineDevice) UnmarshalBinary(b []byte) error {
	var res PortInlineStatisticsInlineDevice
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineStatisticsInlineDeviceInlineReceiveRaw Packet receive counters for the Ethernet port.
swagger:model port_inline_statistics_inline_device_inline_receive_raw
*/
type PortInlineStatisticsInlineDeviceInlineReceiveRaw struct {

	// Total number of discarded packets.
	// Example: 100
	Discards *int64 `json:"discards,omitempty"`

	// Number of packet errors.
	// Example: 200
	Errors *int64 `json:"errors,omitempty"`

	// Total packet count.
	// Example: 500
	Packets *int64 `json:"packets,omitempty"`
}

// Validate validates this port inline statistics inline device inline receive raw
func (o *PortInlineStatisticsInlineDeviceInlineReceiveRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this port inline statistics inline device inline receive raw based on context it is used
func (o *PortInlineStatisticsInlineDeviceInlineReceiveRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineStatisticsInlineDeviceInlineReceiveRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineStatisticsInlineDeviceInlineReceiveRaw) UnmarshalBinary(b []byte) error {
	var res PortInlineStatisticsInlineDeviceInlineReceiveRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineStatisticsInlineDeviceInlineTransmitRaw Packet transmit counters for the Ethernet port.
swagger:model port_inline_statistics_inline_device_inline_transmit_raw
*/
type PortInlineStatisticsInlineDeviceInlineTransmitRaw struct {

	// Total number of discarded packets.
	// Example: 100
	Discards *int64 `json:"discards,omitempty"`

	// Number of packet errors.
	// Example: 200
	Errors *int64 `json:"errors,omitempty"`

	// Total packet count.
	// Example: 500
	Packets *int64 `json:"packets,omitempty"`
}

// Validate validates this port inline statistics inline device inline transmit raw
func (o *PortInlineStatisticsInlineDeviceInlineTransmitRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this port inline statistics inline device inline transmit raw based on context it is used
func (o *PortInlineStatisticsInlineDeviceInlineTransmitRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineStatisticsInlineDeviceInlineTransmitRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineStatisticsInlineDeviceInlineTransmitRaw) UnmarshalBinary(b []byte) error {
	var res PortInlineStatisticsInlineDeviceInlineTransmitRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineStatisticsInlineThroughputRaw Throughput bytes observed at the port object. This can be used along with delta time to calculate the rate of throughput bytes per unit of time.
swagger:model port_inline_statistics_inline_throughput_raw
*/
type PortInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this port inline statistics inline throughput raw
func (o *PortInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this port inline statistics inline throughput raw based on context it is used
func (o *PortInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res PortInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineVlan port inline vlan
swagger:model port_inline_vlan
*/
type PortInlineVlan struct {

	// base port
	BasePort *models.PortInlineVlanInlineBasePort `json:"base_port,omitempty"`

	// VLAN ID
	// Example: 100
	// Maximum: 4094
	// Minimum: 1
	Tag *int64 `json:"tag,omitempty"`
}

// Validate validates this port inline vlan
func (o *PortInlineVlan) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateBasePort(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTag(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineVlan) validateBasePort(formats strfmt.Registry) error {
	if swag.IsZero(o.BasePort) { // not required
		return nil
	}

	if o.BasePort != nil {
		if err := o.BasePort.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vlan" + "." + "base_port")
			}
			return err
		}
	}

	return nil
}

func (o *PortInlineVlan) validateTag(formats strfmt.Registry) error {
	if swag.IsZero(o.Tag) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"vlan"+"."+"tag", "body", *o.Tag, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"vlan"+"."+"tag", "body", *o.Tag, 4094, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this port inline vlan based on the context it is used
func (o *PortInlineVlan) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateBasePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineVlan) contextValidateBasePort(ctx context.Context, formats strfmt.Registry) error {

	if o.BasePort != nil {
		if err := o.BasePort.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vlan" + "." + "base_port")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineVlan) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineVlan) UnmarshalBinary(b []byte) error {
	var res PortInlineVlan
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineVlanInlineBasePort Port UUID along with readable names. Either the UUID or both names may be supplied on input.
swagger:model port_inline_vlan_inline_base_port
*/
type PortInlineVlanInlineBasePort struct {

	// links
	Links *models.PortInlineVlanInlineBasePortInlineLinks `json:"_links,omitempty"`

	// name
	// Example: e1b
	Name *string `json:"name,omitempty"`

	// node
	Node *models.PortInlineVlanInlineBasePortInlineNode `json:"node,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this port inline vlan inline base port
func (o *PortInlineVlanInlineBasePort) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineVlanInlineBasePort) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vlan" + "." + "base_port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *PortInlineVlanInlineBasePort) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vlan" + "." + "base_port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline vlan inline base port based on the context it is used
func (o *PortInlineVlanInlineBasePort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineVlanInlineBasePort) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vlan" + "." + "base_port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *PortInlineVlanInlineBasePort) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vlan" + "." + "base_port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineVlanInlineBasePort) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineVlanInlineBasePort) UnmarshalBinary(b []byte) error {
	var res PortInlineVlanInlineBasePort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineVlanInlineBasePortInlineLinks port inline vlan inline base port inline links
swagger:model port_inline_vlan_inline_base_port_inline__links
*/
type PortInlineVlanInlineBasePortInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this port inline vlan inline base port inline links
func (o *PortInlineVlanInlineBasePortInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineVlanInlineBasePortInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vlan" + "." + "base_port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline vlan inline base port inline links based on the context it is used
func (o *PortInlineVlanInlineBasePortInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortInlineVlanInlineBasePortInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vlan" + "." + "base_port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineVlanInlineBasePortInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineVlanInlineBasePortInlineLinks) UnmarshalBinary(b []byte) error {
	var res PortInlineVlanInlineBasePortInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PortInlineVlanInlineBasePortInlineNode port inline vlan inline base port inline node
swagger:model port_inline_vlan_inline_base_port_inline_node
*/
type PortInlineVlanInlineBasePortInlineNode struct {

	// Name of node on which the port is located.
	// Example: node1
	Name *string `json:"name,omitempty"`
}

// Validate validates this port inline vlan inline base port inline node
func (o *PortInlineVlanInlineBasePortInlineNode) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this port inline vlan inline base port inline node based on context it is used
func (o *PortInlineVlanInlineBasePortInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PortInlineVlanInlineBasePortInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortInlineVlanInlineBasePortInlineNode) UnmarshalBinary(b []byte) error {
	var res PortInlineVlanInlineBasePortInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
