// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NetworkIPBgpPeerGroupModifyCollectionReader is a Reader for the NetworkIPBgpPeerGroupModifyCollection structure.
type NetworkIPBgpPeerGroupModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NetworkIPBgpPeerGroupModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNetworkIPBgpPeerGroupModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNetworkIPBgpPeerGroupModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNetworkIPBgpPeerGroupModifyCollectionOK creates a NetworkIPBgpPeerGroupModifyCollectionOK with default headers values
func NewNetworkIPBgpPeerGroupModifyCollectionOK() *NetworkIPBgpPeerGroupModifyCollectionOK {
	return &NetworkIPBgpPeerGroupModifyCollectionOK{}
}

/*
NetworkIPBgpPeerGroupModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type NetworkIPBgpPeerGroupModifyCollectionOK struct {
}

// IsSuccess returns true when this network Ip bgp peer group modify collection o k response has a 2xx status code
func (o *NetworkIPBgpPeerGroupModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this network Ip bgp peer group modify collection o k response has a 3xx status code
func (o *NetworkIPBgpPeerGroupModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network Ip bgp peer group modify collection o k response has a 4xx status code
func (o *NetworkIPBgpPeerGroupModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this network Ip bgp peer group modify collection o k response has a 5xx status code
func (o *NetworkIPBgpPeerGroupModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this network Ip bgp peer group modify collection o k response a status code equal to that given
func (o *NetworkIPBgpPeerGroupModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the network Ip bgp peer group modify collection o k response
func (o *NetworkIPBgpPeerGroupModifyCollectionOK) Code() int {
	return 200
}

func (o *NetworkIPBgpPeerGroupModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /network/ip/bgp/peer-groups][%d] networkIpBgpPeerGroupModifyCollectionOK", 200)
}

func (o *NetworkIPBgpPeerGroupModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /network/ip/bgp/peer-groups][%d] networkIpBgpPeerGroupModifyCollectionOK", 200)
}

func (o *NetworkIPBgpPeerGroupModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNetworkIPBgpPeerGroupModifyCollectionDefault creates a NetworkIPBgpPeerGroupModifyCollectionDefault with default headers values
func NewNetworkIPBgpPeerGroupModifyCollectionDefault(code int) *NetworkIPBgpPeerGroupModifyCollectionDefault {
	return &NetworkIPBgpPeerGroupModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	NetworkIPBgpPeerGroupModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1967171 | Internal error. Fail to access or update BGP peer group. Retry the command, if necessary. |
| 1967188 | Configuring peer address as a next hop requires an effective cluster version of 9.9.1 or later. |
| 1967192 | Configuring peer.md5_enabled requires an effective cluster version of 9.16.1 or later. |
| 1967193 | Configuring peer.md5_enabled requires the peer.md5_secret parameter. |
| 1967194 | Configuring peer.md5_secret requires that peer.md5_enabled is set to true. |
| 53281998 | Failed to rename the BGP peer group because that name is already assigned to a different peer group in the IPspace. |
| 53282006 | BGP peer group could not be updated to use a peer address because the value provided is not a valid peer address. If necessary, try the command again with a routable host address. |
| 53282007 | BGP peer group could not be updated to use a peer address because the address represents a different address family to the address of the associated BGP LIF. If necessary, try the command again with a matching address family. |
| 53282018 | Failed to create BGP peer group because an existing peer group has already established a BGP session between LIF and peer address. If necessary, try the command again with a different BGP LIF or a different peer address. |
| 53282020 | To utilize the peer as the next hop, the peer IP address must be within the same subnet as the BGP LIF. |
| 53282021 | IPsec must be enabled to use TCP MD5 in BGP sessions with a BGP peer-group. |
| 53282024 | peer.md5_secret should be 1-80 bytes. |
| 53282025 | peer.md5_secret should have an even length. |
| 53282026 | The hex format of peer.md5_secret should only contain a hex string starting with '0x'. The specified peer.md5-secret contains non-hex characters. |
| 53282027 | peer.md5_secret should be 1-79 characters. |
| 53282028 | peer.md5_secret supports only printable ASCII characters such as numbers, alphabets, or special characters. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type NetworkIPBgpPeerGroupModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this network ip bgp peer group modify collection default response has a 2xx status code
func (o *NetworkIPBgpPeerGroupModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this network ip bgp peer group modify collection default response has a 3xx status code
func (o *NetworkIPBgpPeerGroupModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this network ip bgp peer group modify collection default response has a 4xx status code
func (o *NetworkIPBgpPeerGroupModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this network ip bgp peer group modify collection default response has a 5xx status code
func (o *NetworkIPBgpPeerGroupModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this network ip bgp peer group modify collection default response a status code equal to that given
func (o *NetworkIPBgpPeerGroupModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the network ip bgp peer group modify collection default response
func (o *NetworkIPBgpPeerGroupModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *NetworkIPBgpPeerGroupModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/ip/bgp/peer-groups][%d] network_ip_bgp_peer_group_modify_collection default %s", o._statusCode, payload)
}

func (o *NetworkIPBgpPeerGroupModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/ip/bgp/peer-groups][%d] network_ip_bgp_peer_group_modify_collection default %s", o._statusCode, payload)
}

func (o *NetworkIPBgpPeerGroupModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NetworkIPBgpPeerGroupModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NetworkIPBgpPeerGroupModifyCollectionBody network IP bgp peer group modify collection body
swagger:model NetworkIPBgpPeerGroupModifyCollectionBody
*/
type NetworkIPBgpPeerGroupModifyCollectionBody struct {

	// bgp peer group response inline records
	BgpPeerGroupResponseInlineRecords []*models.BgpPeerGroup `json:"records,omitempty"`

	// ipspace
	Ipspace *models.BgpPeerGroupInlineIpspace `json:"ipspace,omitempty"`

	// local
	Local *models.BgpPeerGroupInlineLocal `json:"local,omitempty"`

	// Name of the peer group
	// Example: bgpv4peer
	Name *string `json:"name,omitempty"`

	// peer
	Peer *models.BgpPeerGroupInlinePeer `json:"peer,omitempty"`

	// State of the peer group
	// Read Only: true
	// Enum: ["up","down"]
	State *string `json:"state,omitempty"`

	// UUID of the peer group
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this network IP bgp peer group modify collection body
func (o *NetworkIPBgpPeerGroupModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateBgpPeerGroupResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocal(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePeer(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NetworkIPBgpPeerGroupModifyCollectionBody) validateBgpPeerGroupResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.BgpPeerGroupResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.BgpPeerGroupResponseInlineRecords); i++ {
		if swag.IsZero(o.BgpPeerGroupResponseInlineRecords[i]) { // not required
			continue
		}

		if o.BgpPeerGroupResponseInlineRecords[i] != nil {
			if err := o.BgpPeerGroupResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NetworkIPBgpPeerGroupModifyCollectionBody) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(o.Ipspace) { // not required
		return nil
	}

	if o.Ipspace != nil {
		if err := o.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPBgpPeerGroupModifyCollectionBody) validateLocal(formats strfmt.Registry) error {
	if swag.IsZero(o.Local) { // not required
		return nil
	}

	if o.Local != nil {
		if err := o.Local.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPBgpPeerGroupModifyCollectionBody) validatePeer(formats strfmt.Registry) error {
	if swag.IsZero(o.Peer) { // not required
		return nil
	}

	if o.Peer != nil {
		if err := o.Peer.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "peer")
			}
			return err
		}
	}

	return nil
}

var networkIpBgpPeerGroupModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		networkIpBgpPeerGroupModifyCollectionBodyTypeStatePropEnum = append(networkIpBgpPeerGroupModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NetworkIPBgpPeerGroupModifyCollectionBody
	// NetworkIPBgpPeerGroupModifyCollectionBody
	// state
	// State
	// up
	// END DEBUGGING
	// NetworkIPBgpPeerGroupModifyCollectionBodyStateUp captures enum value "up"
	NetworkIPBgpPeerGroupModifyCollectionBodyStateUp string = "up"

	// BEGIN DEBUGGING
	// NetworkIPBgpPeerGroupModifyCollectionBody
	// NetworkIPBgpPeerGroupModifyCollectionBody
	// state
	// State
	// down
	// END DEBUGGING
	// NetworkIPBgpPeerGroupModifyCollectionBodyStateDown captures enum value "down"
	NetworkIPBgpPeerGroupModifyCollectionBodyStateDown string = "down"
)

// prop value enum
func (o *NetworkIPBgpPeerGroupModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, networkIpBgpPeerGroupModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NetworkIPBgpPeerGroupModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this network IP bgp peer group modify collection body based on the context it is used
func (o *NetworkIPBgpPeerGroupModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateBgpPeerGroupResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePeer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NetworkIPBgpPeerGroupModifyCollectionBody) contextValidateBgpPeerGroupResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.BgpPeerGroupResponseInlineRecords); i++ {

		if o.BgpPeerGroupResponseInlineRecords[i] != nil {
			if err := o.BgpPeerGroupResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NetworkIPBgpPeerGroupModifyCollectionBody) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if o.Ipspace != nil {
		if err := o.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPBgpPeerGroupModifyCollectionBody) contextValidateLocal(ctx context.Context, formats strfmt.Registry) error {

	if o.Local != nil {
		if err := o.Local.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPBgpPeerGroupModifyCollectionBody) contextValidatePeer(ctx context.Context, formats strfmt.Registry) error {

	if o.Peer != nil {
		if err := o.Peer.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "peer")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPBgpPeerGroupModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *NetworkIPBgpPeerGroupModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NetworkIPBgpPeerGroupModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkIPBgpPeerGroupModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res NetworkIPBgpPeerGroupModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
BgpPeerGroupInlineIpspace Either the UUID or name is supplied on input.
swagger:model bgp_peer_group_inline_ipspace
*/
type BgpPeerGroupInlineIpspace struct {

	// links
	Links *models.BgpPeerGroupInlineIpspaceInlineLinks `json:"_links,omitempty"`

	// IPspace name
	// Example: Default
	Name *string `json:"name,omitempty"`

	// IPspace UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this bgp peer group inline ipspace
func (o *BgpPeerGroupInlineIpspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BgpPeerGroupInlineIpspace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this bgp peer group inline ipspace based on the context it is used
func (o *BgpPeerGroupInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BgpPeerGroupInlineIpspace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *BgpPeerGroupInlineIpspace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *BgpPeerGroupInlineIpspace) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
BgpPeerGroupInlineIpspaceInlineLinks bgp peer group inline ipspace inline links
swagger:model bgp_peer_group_inline_ipspace_inline__links
*/
type BgpPeerGroupInlineIpspaceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this bgp peer group inline ipspace inline links
func (o *BgpPeerGroupInlineIpspaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BgpPeerGroupInlineIpspaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this bgp peer group inline ipspace inline links based on the context it is used
func (o *BgpPeerGroupInlineIpspaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BgpPeerGroupInlineIpspaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *BgpPeerGroupInlineIpspaceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *BgpPeerGroupInlineIpspaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlineIpspaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
BgpPeerGroupInlineLocal Information describing the local interface that is being used to peer with a router using BGP. On a POST operation, an existing BGP interface is used by specifying the interface, or create a new one by specifying the port and IP address.
swagger:model bgp_peer_group_inline_local
*/
type BgpPeerGroupInlineLocal struct {

	// interface
	Interface *models.BgpPeerGroupInlineLocalInlineInterface `json:"interface,omitempty"`

	// ip
	IP *models.BgpPeerGroupInlineLocalInlineIP `json:"ip,omitempty"`

	// port
	Port *models.BgpPeerGroupInlineLocalInlinePort `json:"port,omitempty"`
}

// Validate validates this bgp peer group inline local
func (o *BgpPeerGroupInlineLocal) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BgpPeerGroupInlineLocal) validateInterface(formats strfmt.Registry) error {
	if swag.IsZero(o.Interface) { // not required
		return nil
	}

	if o.Interface != nil {
		if err := o.Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "interface")
			}
			return err
		}
	}

	return nil
}

func (o *BgpPeerGroupInlineLocal) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(o.IP) { // not required
		return nil
	}

	if o.IP != nil {
		if err := o.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

func (o *BgpPeerGroupInlineLocal) validatePort(formats strfmt.Registry) error {
	if swag.IsZero(o.Port) { // not required
		return nil
	}

	if o.Port != nil {
		if err := o.Port.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "port")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this bgp peer group inline local based on the context it is used
func (o *BgpPeerGroupInlineLocal) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BgpPeerGroupInlineLocal) contextValidateInterface(ctx context.Context, formats strfmt.Registry) error {

	if o.Interface != nil {
		if err := o.Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "interface")
			}
			return err
		}
	}

	return nil
}

func (o *BgpPeerGroupInlineLocal) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if o.IP != nil {
		if err := o.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

func (o *BgpPeerGroupInlineLocal) contextValidatePort(ctx context.Context, formats strfmt.Registry) error {

	if o.Port != nil {
		if err := o.Port.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "port")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *BgpPeerGroupInlineLocal) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *BgpPeerGroupInlineLocal) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlineLocal
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
BgpPeerGroupInlineLocalInlineInterface A network interface. Either UUID or name may be supplied on input.
swagger:model bgp_peer_group_inline_local_inline_interface
*/
type BgpPeerGroupInlineLocalInlineInterface struct {

	// links
	Links *models.BgpPeerGroupInlineLocalInlineInterfaceInlineLinks `json:"_links,omitempty"`

	// ip
	IP *models.BgpPeerGroupInlineLocalInlineInterfaceInlineIP `json:"ip,omitempty"`

	// The name of the interface. If only the name is provided, the SVM scope
	// must be provided by the object this object is embedded in.
	//
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this bgp peer group inline local inline interface
func (o *BgpPeerGroupInlineLocalInlineInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BgpPeerGroupInlineLocalInlineInterface) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "interface" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *BgpPeerGroupInlineLocalInlineInterface) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(o.IP) { // not required
		return nil
	}

	if o.IP != nil {
		if err := o.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this bgp peer group inline local inline interface based on the context it is used
func (o *BgpPeerGroupInlineLocalInlineInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BgpPeerGroupInlineLocalInlineInterface) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "interface" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *BgpPeerGroupInlineLocalInlineInterface) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if o.IP != nil {
		if err := o.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *BgpPeerGroupInlineLocalInlineInterface) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *BgpPeerGroupInlineLocalInlineInterface) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlineLocalInlineInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
BgpPeerGroupInlineLocalInlineInterfaceInlineLinks bgp peer group inline local inline interface inline links
swagger:model bgp_peer_group_inline_local_inline_interface_inline__links
*/
type BgpPeerGroupInlineLocalInlineInterfaceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this bgp peer group inline local inline interface inline links
func (o *BgpPeerGroupInlineLocalInlineInterfaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BgpPeerGroupInlineLocalInlineInterfaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "interface" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this bgp peer group inline local inline interface inline links based on the context it is used
func (o *BgpPeerGroupInlineLocalInlineInterfaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BgpPeerGroupInlineLocalInlineInterfaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "interface" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *BgpPeerGroupInlineLocalInlineInterfaceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *BgpPeerGroupInlineLocalInlineInterfaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlineLocalInlineInterfaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
BgpPeerGroupInlineLocalInlineInterfaceInlineIP IP information
swagger:model bgp_peer_group_inline_local_inline_interface_inline_ip
*/
type BgpPeerGroupInlineLocalInlineInterfaceInlineIP struct {

	// address
	Address *models.IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this bgp peer group inline local inline interface inline ip
func (o *BgpPeerGroupInlineLocalInlineInterfaceInlineIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BgpPeerGroupInlineLocalInlineInterfaceInlineIP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(o.Address) { // not required
		return nil
	}

	if o.Address != nil {
		if err := o.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "interface" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this bgp peer group inline local inline interface inline ip based on the context it is used
func (o *BgpPeerGroupInlineLocalInlineInterfaceInlineIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BgpPeerGroupInlineLocalInlineInterfaceInlineIP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if o.Address != nil {
		if err := o.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "interface" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *BgpPeerGroupInlineLocalInlineInterfaceInlineIP) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *BgpPeerGroupInlineLocalInlineInterfaceInlineIP) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlineLocalInlineInterfaceInlineIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
BgpPeerGroupInlineLocalInlineIP IP information to create a new interface.
swagger:model bgp_peer_group_inline_local_inline_ip
*/
type BgpPeerGroupInlineLocalInlineIP struct {

	// address
	Address *models.IPAddress `json:"address,omitempty"`

	// netmask
	Netmask *models.IPNetmask `json:"netmask,omitempty"`
}

// Validate validates this bgp peer group inline local inline ip
func (o *BgpPeerGroupInlineLocalInlineIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNetmask(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BgpPeerGroupInlineLocalInlineIP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(o.Address) { // not required
		return nil
	}

	if o.Address != nil {
		if err := o.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

func (o *BgpPeerGroupInlineLocalInlineIP) validateNetmask(formats strfmt.Registry) error {
	if swag.IsZero(o.Netmask) { // not required
		return nil
	}

	if o.Netmask != nil {
		if err := o.Netmask.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "ip" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this bgp peer group inline local inline ip based on the context it is used
func (o *BgpPeerGroupInlineLocalInlineIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNetmask(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BgpPeerGroupInlineLocalInlineIP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if o.Address != nil {
		if err := o.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

func (o *BgpPeerGroupInlineLocalInlineIP) contextValidateNetmask(ctx context.Context, formats strfmt.Registry) error {

	if o.Netmask != nil {
		if err := o.Netmask.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "ip" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *BgpPeerGroupInlineLocalInlineIP) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *BgpPeerGroupInlineLocalInlineIP) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlineLocalInlineIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
BgpPeerGroupInlineLocalInlinePort Port UUID along with readable names. Either the UUID or both names may be supplied on input.
swagger:model bgp_peer_group_inline_local_inline_port
*/
type BgpPeerGroupInlineLocalInlinePort struct {

	// links
	Links *models.BgpPeerGroupInlineLocalInlinePortInlineLinks `json:"_links,omitempty"`

	// name
	// Example: e1b
	Name *string `json:"name,omitempty"`

	// node
	Node *models.BgpPeerGroupInlineLocalInlinePortInlineNode `json:"node,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this bgp peer group inline local inline port
func (o *BgpPeerGroupInlineLocalInlinePort) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BgpPeerGroupInlineLocalInlinePort) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *BgpPeerGroupInlineLocalInlinePort) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this bgp peer group inline local inline port based on the context it is used
func (o *BgpPeerGroupInlineLocalInlinePort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BgpPeerGroupInlineLocalInlinePort) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *BgpPeerGroupInlineLocalInlinePort) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *BgpPeerGroupInlineLocalInlinePort) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *BgpPeerGroupInlineLocalInlinePort) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlineLocalInlinePort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
BgpPeerGroupInlineLocalInlinePortInlineLinks bgp peer group inline local inline port inline links
swagger:model bgp_peer_group_inline_local_inline_port_inline__links
*/
type BgpPeerGroupInlineLocalInlinePortInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this bgp peer group inline local inline port inline links
func (o *BgpPeerGroupInlineLocalInlinePortInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BgpPeerGroupInlineLocalInlinePortInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this bgp peer group inline local inline port inline links based on the context it is used
func (o *BgpPeerGroupInlineLocalInlinePortInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BgpPeerGroupInlineLocalInlinePortInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local" + "." + "port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *BgpPeerGroupInlineLocalInlinePortInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *BgpPeerGroupInlineLocalInlinePortInlineLinks) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlineLocalInlinePortInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
BgpPeerGroupInlineLocalInlinePortInlineNode bgp peer group inline local inline port inline node
swagger:model bgp_peer_group_inline_local_inline_port_inline_node
*/
type BgpPeerGroupInlineLocalInlinePortInlineNode struct {

	// Name of node on which the port is located.
	// Example: node1
	Name *string `json:"name,omitempty"`
}

// Validate validates this bgp peer group inline local inline port inline node
func (o *BgpPeerGroupInlineLocalInlinePortInlineNode) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this bgp peer group inline local inline port inline node based on context it is used
func (o *BgpPeerGroupInlineLocalInlinePortInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *BgpPeerGroupInlineLocalInlinePortInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *BgpPeerGroupInlineLocalInlinePortInlineNode) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlineLocalInlinePortInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
BgpPeerGroupInlinePeer Information describing the router to peer with
swagger:model bgp_peer_group_inline_peer
*/
type BgpPeerGroupInlinePeer struct {

	// Peer router address
	// Example: 10.10.10.7
	Address *string `json:"address,omitempty"`

	// Autonomous system number of peer
	Asn *int64 `json:"asn,omitempty"`

	// Use peer address as next hop.
	IsNextHop *bool `json:"is_next_hop,omitempty"`

	// Enable or disable TCP MD5 signatures per RFC 2385.
	// Example: true
	Md5Enabled *bool `json:"md5_enabled,omitempty"`

	// The shared TCP MD5 secret key. This can either be given as a password or hexadecimal key.
	// Example: SECRET_WORD
	// Max Length: 79
	// Min Length: 1
	Md5Secret *string `json:"md5_secret,omitempty"`
}

// Validate validates this bgp peer group inline peer
func (o *BgpPeerGroupInlinePeer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateMd5Secret(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BgpPeerGroupInlinePeer) validateMd5Secret(formats strfmt.Registry) error {
	if swag.IsZero(o.Md5Secret) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"peer"+"."+"md5_secret", "body", *o.Md5Secret, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"peer"+"."+"md5_secret", "body", *o.Md5Secret, 79); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this bgp peer group inline peer based on context it is used
func (o *BgpPeerGroupInlinePeer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *BgpPeerGroupInlinePeer) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *BgpPeerGroupInlinePeer) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlinePeer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
