// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewNetworkIPBgpPeerGroupModifyParams creates a new NetworkIPBgpPeerGroupModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNetworkIPBgpPeerGroupModifyParams() *NetworkIPBgpPeerGroupModifyParams {
	return &NetworkIPBgpPeerGroupModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNetworkIPBgpPeerGroupModifyParamsWithTimeout creates a new NetworkIPBgpPeerGroupModifyParams object
// with the ability to set a timeout on a request.
func NewNetworkIPBgpPeerGroupModifyParamsWithTimeout(timeout time.Duration) *NetworkIPBgpPeerGroupModifyParams {
	return &NetworkIPBgpPeerGroupModifyParams{
		timeout: timeout,
	}
}

// NewNetworkIPBgpPeerGroupModifyParamsWithContext creates a new NetworkIPBgpPeerGroupModifyParams object
// with the ability to set a context for a request.
func NewNetworkIPBgpPeerGroupModifyParamsWithContext(ctx context.Context) *NetworkIPBgpPeerGroupModifyParams {
	return &NetworkIPBgpPeerGroupModifyParams{
		Context: ctx,
	}
}

// NewNetworkIPBgpPeerGroupModifyParamsWithHTTPClient creates a new NetworkIPBgpPeerGroupModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewNetworkIPBgpPeerGroupModifyParamsWithHTTPClient(client *http.Client) *NetworkIPBgpPeerGroupModifyParams {
	return &NetworkIPBgpPeerGroupModifyParams{
		HTTPClient: client,
	}
}

/*
NetworkIPBgpPeerGroupModifyParams contains all the parameters to send to the API endpoint

	for the network ip bgp peer group modify operation.

	Typically these are written to a http.Request.
*/
type NetworkIPBgpPeerGroupModifyParams struct {

	// Info.
	Info *models.BgpPeerGroup

	/* UUID.

	   UUID of the peer group
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the network ip bgp peer group modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkIPBgpPeerGroupModifyParams) WithDefaults() *NetworkIPBgpPeerGroupModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the network ip bgp peer group modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkIPBgpPeerGroupModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the network ip bgp peer group modify params
func (o *NetworkIPBgpPeerGroupModifyParams) WithTimeout(timeout time.Duration) *NetworkIPBgpPeerGroupModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the network ip bgp peer group modify params
func (o *NetworkIPBgpPeerGroupModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the network ip bgp peer group modify params
func (o *NetworkIPBgpPeerGroupModifyParams) WithContext(ctx context.Context) *NetworkIPBgpPeerGroupModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the network ip bgp peer group modify params
func (o *NetworkIPBgpPeerGroupModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the network ip bgp peer group modify params
func (o *NetworkIPBgpPeerGroupModifyParams) WithHTTPClient(client *http.Client) *NetworkIPBgpPeerGroupModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the network ip bgp peer group modify params
func (o *NetworkIPBgpPeerGroupModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the network ip bgp peer group modify params
func (o *NetworkIPBgpPeerGroupModifyParams) WithInfo(info *models.BgpPeerGroup) *NetworkIPBgpPeerGroupModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the network ip bgp peer group modify params
func (o *NetworkIPBgpPeerGroupModifyParams) SetInfo(info *models.BgpPeerGroup) {
	o.Info = info
}

// WithUUID adds the uuid to the network ip bgp peer group modify params
func (o *NetworkIPBgpPeerGroupModifyParams) WithUUID(uuid string) *NetworkIPBgpPeerGroupModifyParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the network ip bgp peer group modify params
func (o *NetworkIPBgpPeerGroupModifyParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *NetworkIPBgpPeerGroupModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
