// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NetworkIPBgpPeerGroupModifyReader is a Reader for the NetworkIPBgpPeerGroupModify structure.
type NetworkIPBgpPeerGroupModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NetworkIPBgpPeerGroupModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNetworkIPBgpPeerGroupModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNetworkIPBgpPeerGroupModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNetworkIPBgpPeerGroupModifyOK creates a NetworkIPBgpPeerGroupModifyOK with default headers values
func NewNetworkIPBgpPeerGroupModifyOK() *NetworkIPBgpPeerGroupModifyOK {
	return &NetworkIPBgpPeerGroupModifyOK{}
}

/*
NetworkIPBgpPeerGroupModifyOK describes a response with status code 200, with default header values.

OK
*/
type NetworkIPBgpPeerGroupModifyOK struct {
}

// IsSuccess returns true when this network Ip bgp peer group modify o k response has a 2xx status code
func (o *NetworkIPBgpPeerGroupModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this network Ip bgp peer group modify o k response has a 3xx status code
func (o *NetworkIPBgpPeerGroupModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network Ip bgp peer group modify o k response has a 4xx status code
func (o *NetworkIPBgpPeerGroupModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this network Ip bgp peer group modify o k response has a 5xx status code
func (o *NetworkIPBgpPeerGroupModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this network Ip bgp peer group modify o k response a status code equal to that given
func (o *NetworkIPBgpPeerGroupModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the network Ip bgp peer group modify o k response
func (o *NetworkIPBgpPeerGroupModifyOK) Code() int {
	return 200
}

func (o *NetworkIPBgpPeerGroupModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /network/ip/bgp/peer-groups/{uuid}][%d] networkIpBgpPeerGroupModifyOK", 200)
}

func (o *NetworkIPBgpPeerGroupModifyOK) String() string {
	return fmt.Sprintf("[PATCH /network/ip/bgp/peer-groups/{uuid}][%d] networkIpBgpPeerGroupModifyOK", 200)
}

func (o *NetworkIPBgpPeerGroupModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNetworkIPBgpPeerGroupModifyDefault creates a NetworkIPBgpPeerGroupModifyDefault with default headers values
func NewNetworkIPBgpPeerGroupModifyDefault(code int) *NetworkIPBgpPeerGroupModifyDefault {
	return &NetworkIPBgpPeerGroupModifyDefault{
		_statusCode: code,
	}
}

/*
	NetworkIPBgpPeerGroupModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1967171 | Internal error. Fail to access or update BGP peer group. Retry the command, if necessary. |
| 1967188 | Configuring peer address as a next hop requires an effective cluster version of 9.9.1 or later. |
| 1967192 | Configuring peer.md5_enabled requires an effective cluster version of 9.16.1 or later. |
| 1967193 | Configuring peer.md5_enabled requires the peer.md5_secret parameter. |
| 1967194 | Configuring peer.md5_secret requires that peer.md5_enabled is set to true. |
| 53281998 | Failed to rename the BGP peer group because that name is already assigned to a different peer group in the IPspace. |
| 53282006 | BGP peer group could not be updated to use a peer address because the value provided is not a valid peer address. If necessary, try the command again with a routable host address. |
| 53282007 | BGP peer group could not be updated to use a peer address because the address represents a different address family to the address of the associated BGP LIF. If necessary, try the command again with a matching address family. |
| 53282018 | Failed to create BGP peer group because an existing peer group has already established a BGP session between LIF and peer address. If necessary, try the command again with a different BGP LIF or a different peer address. |
| 53282020 | To utilize the peer as the next hop, the peer IP address must be within the same subnet as the BGP LIF. |
| 53282021 | IPsec must be enabled to use TCP MD5 in BGP sessions with a BGP peer-group. |
| 53282024 | peer.md5_secret should be 1-80 bytes. |
| 53282025 | peer.md5_secret should have an even length. |
| 53282026 | The hex format of peer.md5_secret should only contain a hex string starting with '0x'. The specified peer.md5-secret contains non-hex characters. |
| 53282027 | peer.md5_secret should be 1-79 characters. |
| 53282028 | peer.md5_secret supports only printable ASCII characters such as numbers, alphabets, or special characters. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type NetworkIPBgpPeerGroupModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this network ip bgp peer group modify default response has a 2xx status code
func (o *NetworkIPBgpPeerGroupModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this network ip bgp peer group modify default response has a 3xx status code
func (o *NetworkIPBgpPeerGroupModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this network ip bgp peer group modify default response has a 4xx status code
func (o *NetworkIPBgpPeerGroupModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this network ip bgp peer group modify default response has a 5xx status code
func (o *NetworkIPBgpPeerGroupModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this network ip bgp peer group modify default response a status code equal to that given
func (o *NetworkIPBgpPeerGroupModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the network ip bgp peer group modify default response
func (o *NetworkIPBgpPeerGroupModifyDefault) Code() int {
	return o._statusCode
}

func (o *NetworkIPBgpPeerGroupModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/ip/bgp/peer-groups/{uuid}][%d] network_ip_bgp_peer_group_modify default %s", o._statusCode, payload)
}

func (o *NetworkIPBgpPeerGroupModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/ip/bgp/peer-groups/{uuid}][%d] network_ip_bgp_peer_group_modify default %s", o._statusCode, payload)
}

func (o *NetworkIPBgpPeerGroupModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NetworkIPBgpPeerGroupModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
