// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NetworkIPInterfaceDeleteReader is a Reader for the NetworkIPInterfaceDelete structure.
type NetworkIPInterfaceDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NetworkIPInterfaceDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNetworkIPInterfaceDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNetworkIPInterfaceDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNetworkIPInterfaceDeleteOK creates a NetworkIPInterfaceDeleteOK with default headers values
func NewNetworkIPInterfaceDeleteOK() *NetworkIPInterfaceDeleteOK {
	return &NetworkIPInterfaceDeleteOK{}
}

/*
NetworkIPInterfaceDeleteOK describes a response with status code 200, with default header values.

OK
*/
type NetworkIPInterfaceDeleteOK struct {
}

// IsSuccess returns true when this network Ip interface delete o k response has a 2xx status code
func (o *NetworkIPInterfaceDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this network Ip interface delete o k response has a 3xx status code
func (o *NetworkIPInterfaceDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network Ip interface delete o k response has a 4xx status code
func (o *NetworkIPInterfaceDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this network Ip interface delete o k response has a 5xx status code
func (o *NetworkIPInterfaceDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this network Ip interface delete o k response a status code equal to that given
func (o *NetworkIPInterfaceDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the network Ip interface delete o k response
func (o *NetworkIPInterfaceDeleteOK) Code() int {
	return 200
}

func (o *NetworkIPInterfaceDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /network/ip/interfaces/{uuid}][%d] networkIpInterfaceDeleteOK", 200)
}

func (o *NetworkIPInterfaceDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /network/ip/interfaces/{uuid}][%d] networkIpInterfaceDeleteOK", 200)
}

func (o *NetworkIPInterfaceDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNetworkIPInterfaceDeleteDefault creates a NetworkIPInterfaceDeleteDefault with default headers values
func NewNetworkIPInterfaceDeleteDefault(code int) *NetworkIPInterfaceDeleteDefault {
	return &NetworkIPInterfaceDeleteDefault{
		_statusCode: code,
	}
}

/*
	NetworkIPInterfaceDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1966465 | LIF cannot be removed because it is required to maintain quorum on the node. |
| 5376953 | The interface is part of one or more portsets. Remove the interface from all portsets before deleting it. |
| 53281112 | Failed to delete the interface because it has an associated BGP peer group. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type NetworkIPInterfaceDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this network ip interface delete default response has a 2xx status code
func (o *NetworkIPInterfaceDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this network ip interface delete default response has a 3xx status code
func (o *NetworkIPInterfaceDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this network ip interface delete default response has a 4xx status code
func (o *NetworkIPInterfaceDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this network ip interface delete default response has a 5xx status code
func (o *NetworkIPInterfaceDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this network ip interface delete default response a status code equal to that given
func (o *NetworkIPInterfaceDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the network ip interface delete default response
func (o *NetworkIPInterfaceDeleteDefault) Code() int {
	return o._statusCode
}

func (o *NetworkIPInterfaceDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /network/ip/interfaces/{uuid}][%d] network_ip_interface_delete default %s", o._statusCode, payload)
}

func (o *NetworkIPInterfaceDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /network/ip/interfaces/{uuid}][%d] network_ip_interface_delete default %s", o._statusCode, payload)
}

func (o *NetworkIPInterfaceDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NetworkIPInterfaceDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
