// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNetworkIPInterfaceModifyCollectionParams creates a new NetworkIPInterfaceModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNetworkIPInterfaceModifyCollectionParams() *NetworkIPInterfaceModifyCollectionParams {
	return &NetworkIPInterfaceModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNetworkIPInterfaceModifyCollectionParamsWithTimeout creates a new NetworkIPInterfaceModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewNetworkIPInterfaceModifyCollectionParamsWithTimeout(timeout time.Duration) *NetworkIPInterfaceModifyCollectionParams {
	return &NetworkIPInterfaceModifyCollectionParams{
		timeout: timeout,
	}
}

// NewNetworkIPInterfaceModifyCollectionParamsWithContext creates a new NetworkIPInterfaceModifyCollectionParams object
// with the ability to set a context for a request.
func NewNetworkIPInterfaceModifyCollectionParamsWithContext(ctx context.Context) *NetworkIPInterfaceModifyCollectionParams {
	return &NetworkIPInterfaceModifyCollectionParams{
		Context: ctx,
	}
}

// NewNetworkIPInterfaceModifyCollectionParamsWithHTTPClient creates a new NetworkIPInterfaceModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewNetworkIPInterfaceModifyCollectionParamsWithHTTPClient(client *http.Client) *NetworkIPInterfaceModifyCollectionParams {
	return &NetworkIPInterfaceModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
NetworkIPInterfaceModifyCollectionParams contains all the parameters to send to the API endpoint

	for the network ip interface modify collection operation.

	Typically these are written to a http.Request.
*/
type NetworkIPInterfaceModifyCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* DdnsEnabled.

	   Filter by ddns_enabled
	*/
	DdnsEnabled *bool

	/* DNSZone.

	   Filter by dns_zone
	*/
	DNSZone *string

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Info.

	   Info specification
	*/
	Info NetworkIPInterfaceModifyCollectionBody

	/* IPAddress.

	   Filter by ip.address
	*/
	IPAddress *string

	/* IPFamily.

	   Filter by ip.family
	*/
	IPFamily *string

	/* IPNetmask.

	   Filter by ip.netmask
	*/
	IPNetmask *string

	/* IpspaceName.

	   Filter by ipspace.name
	*/
	IpspaceName *string

	/* IpspaceUUID.

	   Filter by ipspace.uuid
	*/
	IpspaceUUID *string

	/* LocationAutoRevert.

	   Filter by location.auto_revert
	*/
	LocationAutoRevert *bool

	/* LocationFailover.

	   Filter by location.failover
	*/
	LocationFailover *string

	/* LocationHomeNodeName.

	   Filter by location.home_node.name
	*/
	LocationHomeNodeName *string

	/* LocationHomeNodeUUID.

	   Filter by location.home_node.uuid
	*/
	LocationHomeNodeUUID *string

	/* LocationHomePortName.

	   Filter by location.home_port.name
	*/
	LocationHomePortName *string

	/* LocationHomePortNodeName.

	   Filter by location.home_port.node.name
	*/
	LocationHomePortNodeName *string

	/* LocationHomePortUUID.

	   Filter by location.home_port.uuid
	*/
	LocationHomePortUUID *string

	/* LocationIsHome.

	   Filter by location.is_home
	*/
	LocationIsHome *bool

	/* LocationNodeName.

	   Filter by location.node.name
	*/
	LocationNodeName *string

	/* LocationNodeUUID.

	   Filter by location.node.uuid
	*/
	LocationNodeUUID *string

	/* LocationPortName.

	   Filter by location.port.name
	*/
	LocationPortName *string

	/* LocationPortNodeName.

	   Filter by location.port.node.name
	*/
	LocationPortNodeName *string

	/* LocationPortUUID.

	   Filter by location.port.uuid
	*/
	LocationPortUUID *string

	/* MetricDuration.

	   Filter by metric.duration
	*/
	MetricDuration *string

	/* MetricStatus.

	   Filter by metric.status
	*/
	MetricStatus *string

	/* MetricThroughputRead.

	   Filter by metric.throughput.read
	*/
	MetricThroughputRead *int64

	/* MetricThroughputTotal.

	   Filter by metric.throughput.total
	*/
	MetricThroughputTotal *int64

	/* MetricThroughputWrite.

	   Filter by metric.throughput.write
	*/
	MetricThroughputWrite *int64

	/* MetricTimestamp.

	   Filter by metric.timestamp
	*/
	MetricTimestamp *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* ProbePort.

	   Filter by probe_port
	*/
	ProbePort *int64

	/* RdmaProtocols.

	   Filter by rdma_protocols
	*/
	RdmaProtocols *string

	/* RecommendInterfacesPerNode.

	   The number of IP interfaces to recommend per node.

	*/
	RecommendInterfacesPerNode *int64

	/* RecommendIPFamily.

	   The name of an IP Address Family for which to recommend IP interfaces. Unless ipv6 is specified, the default value is ipv4.

	*/
	RecommendIPFamily *string

	/* RecommendIpspaceName.

	   The name of an existing IPspace for which to recommend IP interfaces.

	*/
	RecommendIpspaceName *string

	/* RecommendIpspaceUUID.

	   The UUID of an existing IPspace for which to recommend IP interfaces.

	*/
	RecommendIpspaceUUID *string

	/* RecommendLocationBroadcastDomainName.

	   The name of an existing broadcast domain for which to recommend IP interfaces.

	*/
	RecommendLocationBroadcastDomainName *string

	/* RecommendLocationBroadcastDomainUUID.

	   The UUID of an existing broadcast domain for which to recommend IP interfaces.

	*/
	RecommendLocationBroadcastDomainUUID *string

	/* RecommendLocationPortRdmaProtocol.

	   The RDMA protocol supported on locations for which to recommend IP interfaces.

	*/
	RecommendLocationPortRdmaProtocol *string

	/* RecommendServicePolicyName.

	   The name of an IP service policy for which to recommend IP interfaces.

	*/
	RecommendServicePolicyName *string

	/* RecommendServicePolicyUUID.

	   The UUID of an IP service policy for which to recommend IP interfaces.

	*/
	RecommendServicePolicyUUID *string

	/* RecommendSubnetName.

	   The name of an existing subnet for which to recommend IP interfaces.

	*/
	RecommendSubnetName *string

	/* RecommendSubnetUUID.

	   The UUID of an existing subnet for which to recommend IP interfaces.

	*/
	RecommendSubnetUUID *string

	/* RecommendSvmName.

	   The name of an existing SVM for which to recommend IP interfaces.

	*/
	RecommendSvmName *string

	/* RecommendSvmUUID.

	   The UUID of an existing SVM for which to recommend IP interfaces.

	*/
	RecommendSvmUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* ServicePolicyName.

	   Filter by service_policy.name
	*/
	ServicePolicyName *string

	/* ServicePolicyUUID.

	   Filter by service_policy.uuid
	*/
	ServicePolicyUUID *string

	/* Services.

	   Filter by services
	*/
	Services *string

	/* State.

	   Filter by state
	*/
	State *string

	/* StatisticsStatus.

	   Filter by statistics.status
	*/
	StatisticsStatus *string

	/* StatisticsThroughputRawRead.

	   Filter by statistics.throughput_raw.read
	*/
	StatisticsThroughputRawRead *int64

	/* StatisticsThroughputRawTotal.

	   Filter by statistics.throughput_raw.total
	*/
	StatisticsThroughputRawTotal *int64

	/* StatisticsThroughputRawWrite.

	   Filter by statistics.throughput_raw.write
	*/
	StatisticsThroughputRawWrite *int64

	/* StatisticsTimestamp.

	   Filter by statistics.timestamp
	*/
	StatisticsTimestamp *string

	/* SubnetName.

	   Filter by subnet.name
	*/
	SubnetName *string

	/* SubnetUUID.

	   Filter by subnet.uuid
	*/
	SubnetUUID *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* Vip.

	   Filter by vip
	*/
	Vip *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the network ip interface modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkIPInterfaceModifyCollectionParams) WithDefaults() *NetworkIPInterfaceModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the network ip interface modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkIPInterfaceModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := NetworkIPInterfaceModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithTimeout(timeout time.Duration) *NetworkIPInterfaceModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithContext(ctx context.Context) *NetworkIPInterfaceModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithHTTPClient(client *http.Client) *NetworkIPInterfaceModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *NetworkIPInterfaceModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDdnsEnabled adds the ddnsEnabled to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithDdnsEnabled(ddnsEnabled *bool) *NetworkIPInterfaceModifyCollectionParams {
	o.SetDdnsEnabled(ddnsEnabled)
	return o
}

// SetDdnsEnabled adds the ddnsEnabled to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetDdnsEnabled(ddnsEnabled *bool) {
	o.DdnsEnabled = ddnsEnabled
}

// WithDNSZone adds the dNSZone to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithDNSZone(dNSZone *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetDNSZone(dNSZone)
	return o
}

// SetDNSZone adds the dnsZone to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetDNSZone(dNSZone *string) {
	o.DNSZone = dNSZone
}

// WithEnabled adds the enabled to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithEnabled(enabled *bool) *NetworkIPInterfaceModifyCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithInfo adds the info to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithInfo(info NetworkIPInterfaceModifyCollectionBody) *NetworkIPInterfaceModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetInfo(info NetworkIPInterfaceModifyCollectionBody) {
	o.Info = info
}

// WithIPAddress adds the iPAddress to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithIPAddress(iPAddress *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetIPAddress(iPAddress)
	return o
}

// SetIPAddress adds the ipAddress to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetIPAddress(iPAddress *string) {
	o.IPAddress = iPAddress
}

// WithIPFamily adds the iPFamily to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithIPFamily(iPFamily *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetIPFamily(iPFamily)
	return o
}

// SetIPFamily adds the ipFamily to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetIPFamily(iPFamily *string) {
	o.IPFamily = iPFamily
}

// WithIPNetmask adds the iPNetmask to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithIPNetmask(iPNetmask *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetIPNetmask(iPNetmask)
	return o
}

// SetIPNetmask adds the ipNetmask to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetIPNetmask(iPNetmask *string) {
	o.IPNetmask = iPNetmask
}

// WithIpspaceName adds the ipspaceName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithIpspaceName(ipspaceName *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetIpspaceName(ipspaceName)
	return o
}

// SetIpspaceName adds the ipspaceName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetIpspaceName(ipspaceName *string) {
	o.IpspaceName = ipspaceName
}

// WithIpspaceUUID adds the ipspaceUUID to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithIpspaceUUID(ipspaceUUID *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetIpspaceUUID(ipspaceUUID)
	return o
}

// SetIpspaceUUID adds the ipspaceUuid to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetIpspaceUUID(ipspaceUUID *string) {
	o.IpspaceUUID = ipspaceUUID
}

// WithLocationAutoRevert adds the locationAutoRevert to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithLocationAutoRevert(locationAutoRevert *bool) *NetworkIPInterfaceModifyCollectionParams {
	o.SetLocationAutoRevert(locationAutoRevert)
	return o
}

// SetLocationAutoRevert adds the locationAutoRevert to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetLocationAutoRevert(locationAutoRevert *bool) {
	o.LocationAutoRevert = locationAutoRevert
}

// WithLocationFailover adds the locationFailover to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithLocationFailover(locationFailover *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetLocationFailover(locationFailover)
	return o
}

// SetLocationFailover adds the locationFailover to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetLocationFailover(locationFailover *string) {
	o.LocationFailover = locationFailover
}

// WithLocationHomeNodeName adds the locationHomeNodeName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithLocationHomeNodeName(locationHomeNodeName *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetLocationHomeNodeName(locationHomeNodeName)
	return o
}

// SetLocationHomeNodeName adds the locationHomeNodeName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetLocationHomeNodeName(locationHomeNodeName *string) {
	o.LocationHomeNodeName = locationHomeNodeName
}

// WithLocationHomeNodeUUID adds the locationHomeNodeUUID to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithLocationHomeNodeUUID(locationHomeNodeUUID *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetLocationHomeNodeUUID(locationHomeNodeUUID)
	return o
}

// SetLocationHomeNodeUUID adds the locationHomeNodeUuid to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetLocationHomeNodeUUID(locationHomeNodeUUID *string) {
	o.LocationHomeNodeUUID = locationHomeNodeUUID
}

// WithLocationHomePortName adds the locationHomePortName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithLocationHomePortName(locationHomePortName *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetLocationHomePortName(locationHomePortName)
	return o
}

// SetLocationHomePortName adds the locationHomePortName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetLocationHomePortName(locationHomePortName *string) {
	o.LocationHomePortName = locationHomePortName
}

// WithLocationHomePortNodeName adds the locationHomePortNodeName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithLocationHomePortNodeName(locationHomePortNodeName *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetLocationHomePortNodeName(locationHomePortNodeName)
	return o
}

// SetLocationHomePortNodeName adds the locationHomePortNodeName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetLocationHomePortNodeName(locationHomePortNodeName *string) {
	o.LocationHomePortNodeName = locationHomePortNodeName
}

// WithLocationHomePortUUID adds the locationHomePortUUID to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithLocationHomePortUUID(locationHomePortUUID *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetLocationHomePortUUID(locationHomePortUUID)
	return o
}

// SetLocationHomePortUUID adds the locationHomePortUuid to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetLocationHomePortUUID(locationHomePortUUID *string) {
	o.LocationHomePortUUID = locationHomePortUUID
}

// WithLocationIsHome adds the locationIsHome to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithLocationIsHome(locationIsHome *bool) *NetworkIPInterfaceModifyCollectionParams {
	o.SetLocationIsHome(locationIsHome)
	return o
}

// SetLocationIsHome adds the locationIsHome to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetLocationIsHome(locationIsHome *bool) {
	o.LocationIsHome = locationIsHome
}

// WithLocationNodeName adds the locationNodeName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithLocationNodeName(locationNodeName *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetLocationNodeName(locationNodeName)
	return o
}

// SetLocationNodeName adds the locationNodeName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetLocationNodeName(locationNodeName *string) {
	o.LocationNodeName = locationNodeName
}

// WithLocationNodeUUID adds the locationNodeUUID to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithLocationNodeUUID(locationNodeUUID *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetLocationNodeUUID(locationNodeUUID)
	return o
}

// SetLocationNodeUUID adds the locationNodeUuid to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetLocationNodeUUID(locationNodeUUID *string) {
	o.LocationNodeUUID = locationNodeUUID
}

// WithLocationPortName adds the locationPortName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithLocationPortName(locationPortName *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetLocationPortName(locationPortName)
	return o
}

// SetLocationPortName adds the locationPortName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetLocationPortName(locationPortName *string) {
	o.LocationPortName = locationPortName
}

// WithLocationPortNodeName adds the locationPortNodeName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithLocationPortNodeName(locationPortNodeName *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetLocationPortNodeName(locationPortNodeName)
	return o
}

// SetLocationPortNodeName adds the locationPortNodeName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetLocationPortNodeName(locationPortNodeName *string) {
	o.LocationPortNodeName = locationPortNodeName
}

// WithLocationPortUUID adds the locationPortUUID to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithLocationPortUUID(locationPortUUID *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetLocationPortUUID(locationPortUUID)
	return o
}

// SetLocationPortUUID adds the locationPortUuid to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetLocationPortUUID(locationPortUUID *string) {
	o.LocationPortUUID = locationPortUUID
}

// WithMetricDuration adds the metricDuration to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithMetricDuration(metricDuration *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetMetricDuration(metricDuration)
	return o
}

// SetMetricDuration adds the metricDuration to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetMetricDuration(metricDuration *string) {
	o.MetricDuration = metricDuration
}

// WithMetricStatus adds the metricStatus to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithMetricStatus(metricStatus *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetMetricStatus(metricStatus)
	return o
}

// SetMetricStatus adds the metricStatus to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetMetricStatus(metricStatus *string) {
	o.MetricStatus = metricStatus
}

// WithMetricThroughputRead adds the metricThroughputRead to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithMetricThroughputRead(metricThroughputRead *int64) *NetworkIPInterfaceModifyCollectionParams {
	o.SetMetricThroughputRead(metricThroughputRead)
	return o
}

// SetMetricThroughputRead adds the metricThroughputRead to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetMetricThroughputRead(metricThroughputRead *int64) {
	o.MetricThroughputRead = metricThroughputRead
}

// WithMetricThroughputTotal adds the metricThroughputTotal to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithMetricThroughputTotal(metricThroughputTotal *int64) *NetworkIPInterfaceModifyCollectionParams {
	o.SetMetricThroughputTotal(metricThroughputTotal)
	return o
}

// SetMetricThroughputTotal adds the metricThroughputTotal to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetMetricThroughputTotal(metricThroughputTotal *int64) {
	o.MetricThroughputTotal = metricThroughputTotal
}

// WithMetricThroughputWrite adds the metricThroughputWrite to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithMetricThroughputWrite(metricThroughputWrite *int64) *NetworkIPInterfaceModifyCollectionParams {
	o.SetMetricThroughputWrite(metricThroughputWrite)
	return o
}

// SetMetricThroughputWrite adds the metricThroughputWrite to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetMetricThroughputWrite(metricThroughputWrite *int64) {
	o.MetricThroughputWrite = metricThroughputWrite
}

// WithMetricTimestamp adds the metricTimestamp to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithMetricTimestamp(metricTimestamp *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetMetricTimestamp(metricTimestamp)
	return o
}

// SetMetricTimestamp adds the metricTimestamp to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetMetricTimestamp(metricTimestamp *string) {
	o.MetricTimestamp = metricTimestamp
}

// WithName adds the name to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithName(name *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithProbePort adds the probePort to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithProbePort(probePort *int64) *NetworkIPInterfaceModifyCollectionParams {
	o.SetProbePort(probePort)
	return o
}

// SetProbePort adds the probePort to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetProbePort(probePort *int64) {
	o.ProbePort = probePort
}

// WithRdmaProtocols adds the rdmaProtocols to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithRdmaProtocols(rdmaProtocols *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetRdmaProtocols(rdmaProtocols)
	return o
}

// SetRdmaProtocols adds the rdmaProtocols to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetRdmaProtocols(rdmaProtocols *string) {
	o.RdmaProtocols = rdmaProtocols
}

// WithRecommendInterfacesPerNode adds the recommendInterfacesPerNode to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithRecommendInterfacesPerNode(recommendInterfacesPerNode *int64) *NetworkIPInterfaceModifyCollectionParams {
	o.SetRecommendInterfacesPerNode(recommendInterfacesPerNode)
	return o
}

// SetRecommendInterfacesPerNode adds the recommendInterfacesPerNode to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetRecommendInterfacesPerNode(recommendInterfacesPerNode *int64) {
	o.RecommendInterfacesPerNode = recommendInterfacesPerNode
}

// WithRecommendIPFamily adds the recommendIPFamily to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithRecommendIPFamily(recommendIPFamily *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetRecommendIPFamily(recommendIPFamily)
	return o
}

// SetRecommendIPFamily adds the recommendIpFamily to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetRecommendIPFamily(recommendIPFamily *string) {
	o.RecommendIPFamily = recommendIPFamily
}

// WithRecommendIpspaceName adds the recommendIpspaceName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithRecommendIpspaceName(recommendIpspaceName *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetRecommendIpspaceName(recommendIpspaceName)
	return o
}

// SetRecommendIpspaceName adds the recommendIpspaceName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetRecommendIpspaceName(recommendIpspaceName *string) {
	o.RecommendIpspaceName = recommendIpspaceName
}

// WithRecommendIpspaceUUID adds the recommendIpspaceUUID to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithRecommendIpspaceUUID(recommendIpspaceUUID *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetRecommendIpspaceUUID(recommendIpspaceUUID)
	return o
}

// SetRecommendIpspaceUUID adds the recommendIpspaceUuid to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetRecommendIpspaceUUID(recommendIpspaceUUID *string) {
	o.RecommendIpspaceUUID = recommendIpspaceUUID
}

// WithRecommendLocationBroadcastDomainName adds the recommendLocationBroadcastDomainName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithRecommendLocationBroadcastDomainName(recommendLocationBroadcastDomainName *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetRecommendLocationBroadcastDomainName(recommendLocationBroadcastDomainName)
	return o
}

// SetRecommendLocationBroadcastDomainName adds the recommendLocationBroadcastDomainName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetRecommendLocationBroadcastDomainName(recommendLocationBroadcastDomainName *string) {
	o.RecommendLocationBroadcastDomainName = recommendLocationBroadcastDomainName
}

// WithRecommendLocationBroadcastDomainUUID adds the recommendLocationBroadcastDomainUUID to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithRecommendLocationBroadcastDomainUUID(recommendLocationBroadcastDomainUUID *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetRecommendLocationBroadcastDomainUUID(recommendLocationBroadcastDomainUUID)
	return o
}

// SetRecommendLocationBroadcastDomainUUID adds the recommendLocationBroadcastDomainUuid to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetRecommendLocationBroadcastDomainUUID(recommendLocationBroadcastDomainUUID *string) {
	o.RecommendLocationBroadcastDomainUUID = recommendLocationBroadcastDomainUUID
}

// WithRecommendLocationPortRdmaProtocol adds the recommendLocationPortRdmaProtocol to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithRecommendLocationPortRdmaProtocol(recommendLocationPortRdmaProtocol *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetRecommendLocationPortRdmaProtocol(recommendLocationPortRdmaProtocol)
	return o
}

// SetRecommendLocationPortRdmaProtocol adds the recommendLocationPortRdmaProtocol to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetRecommendLocationPortRdmaProtocol(recommendLocationPortRdmaProtocol *string) {
	o.RecommendLocationPortRdmaProtocol = recommendLocationPortRdmaProtocol
}

// WithRecommendServicePolicyName adds the recommendServicePolicyName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithRecommendServicePolicyName(recommendServicePolicyName *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetRecommendServicePolicyName(recommendServicePolicyName)
	return o
}

// SetRecommendServicePolicyName adds the recommendServicePolicyName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetRecommendServicePolicyName(recommendServicePolicyName *string) {
	o.RecommendServicePolicyName = recommendServicePolicyName
}

// WithRecommendServicePolicyUUID adds the recommendServicePolicyUUID to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithRecommendServicePolicyUUID(recommendServicePolicyUUID *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetRecommendServicePolicyUUID(recommendServicePolicyUUID)
	return o
}

// SetRecommendServicePolicyUUID adds the recommendServicePolicyUuid to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetRecommendServicePolicyUUID(recommendServicePolicyUUID *string) {
	o.RecommendServicePolicyUUID = recommendServicePolicyUUID
}

// WithRecommendSubnetName adds the recommendSubnetName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithRecommendSubnetName(recommendSubnetName *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetRecommendSubnetName(recommendSubnetName)
	return o
}

// SetRecommendSubnetName adds the recommendSubnetName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetRecommendSubnetName(recommendSubnetName *string) {
	o.RecommendSubnetName = recommendSubnetName
}

// WithRecommendSubnetUUID adds the recommendSubnetUUID to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithRecommendSubnetUUID(recommendSubnetUUID *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetRecommendSubnetUUID(recommendSubnetUUID)
	return o
}

// SetRecommendSubnetUUID adds the recommendSubnetUuid to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetRecommendSubnetUUID(recommendSubnetUUID *string) {
	o.RecommendSubnetUUID = recommendSubnetUUID
}

// WithRecommendSvmName adds the recommendSvmName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithRecommendSvmName(recommendSvmName *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetRecommendSvmName(recommendSvmName)
	return o
}

// SetRecommendSvmName adds the recommendSvmName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetRecommendSvmName(recommendSvmName *string) {
	o.RecommendSvmName = recommendSvmName
}

// WithRecommendSvmUUID adds the recommendSvmUUID to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithRecommendSvmUUID(recommendSvmUUID *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetRecommendSvmUUID(recommendSvmUUID)
	return o
}

// SetRecommendSvmUUID adds the recommendSvmUuid to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetRecommendSvmUUID(recommendSvmUUID *string) {
	o.RecommendSvmUUID = recommendSvmUUID
}

// WithReturnRecords adds the returnRecords to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithReturnRecords(returnRecords *bool) *NetworkIPInterfaceModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *NetworkIPInterfaceModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithScope(scope *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithSerialRecords(serialRecords *bool) *NetworkIPInterfaceModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithServicePolicyName adds the servicePolicyName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithServicePolicyName(servicePolicyName *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetServicePolicyName(servicePolicyName)
	return o
}

// SetServicePolicyName adds the servicePolicyName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetServicePolicyName(servicePolicyName *string) {
	o.ServicePolicyName = servicePolicyName
}

// WithServicePolicyUUID adds the servicePolicyUUID to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithServicePolicyUUID(servicePolicyUUID *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetServicePolicyUUID(servicePolicyUUID)
	return o
}

// SetServicePolicyUUID adds the servicePolicyUuid to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetServicePolicyUUID(servicePolicyUUID *string) {
	o.ServicePolicyUUID = servicePolicyUUID
}

// WithServices adds the services to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithServices(services *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetServices(services)
	return o
}

// SetServices adds the services to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetServices(services *string) {
	o.Services = services
}

// WithState adds the state to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithState(state *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetState(state *string) {
	o.State = state
}

// WithStatisticsStatus adds the statisticsStatus to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithStatisticsStatus(statisticsStatus *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetStatisticsStatus(statisticsStatus)
	return o
}

// SetStatisticsStatus adds the statisticsStatus to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetStatisticsStatus(statisticsStatus *string) {
	o.StatisticsStatus = statisticsStatus
}

// WithStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) *NetworkIPInterfaceModifyCollectionParams {
	o.SetStatisticsThroughputRawRead(statisticsThroughputRawRead)
	return o
}

// SetStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) {
	o.StatisticsThroughputRawRead = statisticsThroughputRawRead
}

// WithStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) *NetworkIPInterfaceModifyCollectionParams {
	o.SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal)
	return o
}

// SetStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) {
	o.StatisticsThroughputRawTotal = statisticsThroughputRawTotal
}

// WithStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) *NetworkIPInterfaceModifyCollectionParams {
	o.SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite)
	return o
}

// SetStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) {
	o.StatisticsThroughputRawWrite = statisticsThroughputRawWrite
}

// WithStatisticsTimestamp adds the statisticsTimestamp to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithStatisticsTimestamp(statisticsTimestamp *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetStatisticsTimestamp(statisticsTimestamp)
	return o
}

// SetStatisticsTimestamp adds the statisticsTimestamp to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetStatisticsTimestamp(statisticsTimestamp *string) {
	o.StatisticsTimestamp = statisticsTimestamp
}

// WithSubnetName adds the subnetName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithSubnetName(subnetName *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetSubnetName(subnetName)
	return o
}

// SetSubnetName adds the subnetName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetSubnetName(subnetName *string) {
	o.SubnetName = subnetName
}

// WithSubnetUUID adds the subnetUUID to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithSubnetUUID(subnetUUID *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetSubnetUUID(subnetUUID)
	return o
}

// SetSubnetUUID adds the subnetUuid to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetSubnetUUID(subnetUUID *string) {
	o.SubnetUUID = subnetUUID
}

// WithSvmName adds the svmName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithSvmName(svmName *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithSvmUUID(svmUUID *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithUUID(uuid *string) *NetworkIPInterfaceModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVip adds the vip to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) WithVip(vip *bool) *NetworkIPInterfaceModifyCollectionParams {
	o.SetVip(vip)
	return o
}

// SetVip adds the vip to the network ip interface modify collection params
func (o *NetworkIPInterfaceModifyCollectionParams) SetVip(vip *bool) {
	o.Vip = vip
}

// WriteToRequest writes these params to a swagger request
func (o *NetworkIPInterfaceModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.DdnsEnabled != nil {

		// query param ddns_enabled
		var qrDdnsEnabled bool

		if o.DdnsEnabled != nil {
			qrDdnsEnabled = *o.DdnsEnabled
		}
		qDdnsEnabled := swag.FormatBool(qrDdnsEnabled)
		if qDdnsEnabled != "" {

			if err := r.SetQueryParam("ddns_enabled", qDdnsEnabled); err != nil {
				return err
			}
		}
	}

	if o.DNSZone != nil {

		// query param dns_zone
		var qrDNSZone string

		if o.DNSZone != nil {
			qrDNSZone = *o.DNSZone
		}
		qDNSZone := qrDNSZone
		if qDNSZone != "" {

			if err := r.SetQueryParam("dns_zone", qDNSZone); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IPAddress != nil {

		// query param ip.address
		var qrIPAddress string

		if o.IPAddress != nil {
			qrIPAddress = *o.IPAddress
		}
		qIPAddress := qrIPAddress
		if qIPAddress != "" {

			if err := r.SetQueryParam("ip.address", qIPAddress); err != nil {
				return err
			}
		}
	}

	if o.IPFamily != nil {

		// query param ip.family
		var qrIPFamily string

		if o.IPFamily != nil {
			qrIPFamily = *o.IPFamily
		}
		qIPFamily := qrIPFamily
		if qIPFamily != "" {

			if err := r.SetQueryParam("ip.family", qIPFamily); err != nil {
				return err
			}
		}
	}

	if o.IPNetmask != nil {

		// query param ip.netmask
		var qrIPNetmask string

		if o.IPNetmask != nil {
			qrIPNetmask = *o.IPNetmask
		}
		qIPNetmask := qrIPNetmask
		if qIPNetmask != "" {

			if err := r.SetQueryParam("ip.netmask", qIPNetmask); err != nil {
				return err
			}
		}
	}

	if o.IpspaceName != nil {

		// query param ipspace.name
		var qrIpspaceName string

		if o.IpspaceName != nil {
			qrIpspaceName = *o.IpspaceName
		}
		qIpspaceName := qrIpspaceName
		if qIpspaceName != "" {

			if err := r.SetQueryParam("ipspace.name", qIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.IpspaceUUID != nil {

		// query param ipspace.uuid
		var qrIpspaceUUID string

		if o.IpspaceUUID != nil {
			qrIpspaceUUID = *o.IpspaceUUID
		}
		qIpspaceUUID := qrIpspaceUUID
		if qIpspaceUUID != "" {

			if err := r.SetQueryParam("ipspace.uuid", qIpspaceUUID); err != nil {
				return err
			}
		}
	}

	if o.LocationAutoRevert != nil {

		// query param location.auto_revert
		var qrLocationAutoRevert bool

		if o.LocationAutoRevert != nil {
			qrLocationAutoRevert = *o.LocationAutoRevert
		}
		qLocationAutoRevert := swag.FormatBool(qrLocationAutoRevert)
		if qLocationAutoRevert != "" {

			if err := r.SetQueryParam("location.auto_revert", qLocationAutoRevert); err != nil {
				return err
			}
		}
	}

	if o.LocationFailover != nil {

		// query param location.failover
		var qrLocationFailover string

		if o.LocationFailover != nil {
			qrLocationFailover = *o.LocationFailover
		}
		qLocationFailover := qrLocationFailover
		if qLocationFailover != "" {

			if err := r.SetQueryParam("location.failover", qLocationFailover); err != nil {
				return err
			}
		}
	}

	if o.LocationHomeNodeName != nil {

		// query param location.home_node.name
		var qrLocationHomeNodeName string

		if o.LocationHomeNodeName != nil {
			qrLocationHomeNodeName = *o.LocationHomeNodeName
		}
		qLocationHomeNodeName := qrLocationHomeNodeName
		if qLocationHomeNodeName != "" {

			if err := r.SetQueryParam("location.home_node.name", qLocationHomeNodeName); err != nil {
				return err
			}
		}
	}

	if o.LocationHomeNodeUUID != nil {

		// query param location.home_node.uuid
		var qrLocationHomeNodeUUID string

		if o.LocationHomeNodeUUID != nil {
			qrLocationHomeNodeUUID = *o.LocationHomeNodeUUID
		}
		qLocationHomeNodeUUID := qrLocationHomeNodeUUID
		if qLocationHomeNodeUUID != "" {

			if err := r.SetQueryParam("location.home_node.uuid", qLocationHomeNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.LocationHomePortName != nil {

		// query param location.home_port.name
		var qrLocationHomePortName string

		if o.LocationHomePortName != nil {
			qrLocationHomePortName = *o.LocationHomePortName
		}
		qLocationHomePortName := qrLocationHomePortName
		if qLocationHomePortName != "" {

			if err := r.SetQueryParam("location.home_port.name", qLocationHomePortName); err != nil {
				return err
			}
		}
	}

	if o.LocationHomePortNodeName != nil {

		// query param location.home_port.node.name
		var qrLocationHomePortNodeName string

		if o.LocationHomePortNodeName != nil {
			qrLocationHomePortNodeName = *o.LocationHomePortNodeName
		}
		qLocationHomePortNodeName := qrLocationHomePortNodeName
		if qLocationHomePortNodeName != "" {

			if err := r.SetQueryParam("location.home_port.node.name", qLocationHomePortNodeName); err != nil {
				return err
			}
		}
	}

	if o.LocationHomePortUUID != nil {

		// query param location.home_port.uuid
		var qrLocationHomePortUUID string

		if o.LocationHomePortUUID != nil {
			qrLocationHomePortUUID = *o.LocationHomePortUUID
		}
		qLocationHomePortUUID := qrLocationHomePortUUID
		if qLocationHomePortUUID != "" {

			if err := r.SetQueryParam("location.home_port.uuid", qLocationHomePortUUID); err != nil {
				return err
			}
		}
	}

	if o.LocationIsHome != nil {

		// query param location.is_home
		var qrLocationIsHome bool

		if o.LocationIsHome != nil {
			qrLocationIsHome = *o.LocationIsHome
		}
		qLocationIsHome := swag.FormatBool(qrLocationIsHome)
		if qLocationIsHome != "" {

			if err := r.SetQueryParam("location.is_home", qLocationIsHome); err != nil {
				return err
			}
		}
	}

	if o.LocationNodeName != nil {

		// query param location.node.name
		var qrLocationNodeName string

		if o.LocationNodeName != nil {
			qrLocationNodeName = *o.LocationNodeName
		}
		qLocationNodeName := qrLocationNodeName
		if qLocationNodeName != "" {

			if err := r.SetQueryParam("location.node.name", qLocationNodeName); err != nil {
				return err
			}
		}
	}

	if o.LocationNodeUUID != nil {

		// query param location.node.uuid
		var qrLocationNodeUUID string

		if o.LocationNodeUUID != nil {
			qrLocationNodeUUID = *o.LocationNodeUUID
		}
		qLocationNodeUUID := qrLocationNodeUUID
		if qLocationNodeUUID != "" {

			if err := r.SetQueryParam("location.node.uuid", qLocationNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.LocationPortName != nil {

		// query param location.port.name
		var qrLocationPortName string

		if o.LocationPortName != nil {
			qrLocationPortName = *o.LocationPortName
		}
		qLocationPortName := qrLocationPortName
		if qLocationPortName != "" {

			if err := r.SetQueryParam("location.port.name", qLocationPortName); err != nil {
				return err
			}
		}
	}

	if o.LocationPortNodeName != nil {

		// query param location.port.node.name
		var qrLocationPortNodeName string

		if o.LocationPortNodeName != nil {
			qrLocationPortNodeName = *o.LocationPortNodeName
		}
		qLocationPortNodeName := qrLocationPortNodeName
		if qLocationPortNodeName != "" {

			if err := r.SetQueryParam("location.port.node.name", qLocationPortNodeName); err != nil {
				return err
			}
		}
	}

	if o.LocationPortUUID != nil {

		// query param location.port.uuid
		var qrLocationPortUUID string

		if o.LocationPortUUID != nil {
			qrLocationPortUUID = *o.LocationPortUUID
		}
		qLocationPortUUID := qrLocationPortUUID
		if qLocationPortUUID != "" {

			if err := r.SetQueryParam("location.port.uuid", qLocationPortUUID); err != nil {
				return err
			}
		}
	}

	if o.MetricDuration != nil {

		// query param metric.duration
		var qrMetricDuration string

		if o.MetricDuration != nil {
			qrMetricDuration = *o.MetricDuration
		}
		qMetricDuration := qrMetricDuration
		if qMetricDuration != "" {

			if err := r.SetQueryParam("metric.duration", qMetricDuration); err != nil {
				return err
			}
		}
	}

	if o.MetricStatus != nil {

		// query param metric.status
		var qrMetricStatus string

		if o.MetricStatus != nil {
			qrMetricStatus = *o.MetricStatus
		}
		qMetricStatus := qrMetricStatus
		if qMetricStatus != "" {

			if err := r.SetQueryParam("metric.status", qMetricStatus); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputRead != nil {

		// query param metric.throughput.read
		var qrMetricThroughputRead int64

		if o.MetricThroughputRead != nil {
			qrMetricThroughputRead = *o.MetricThroughputRead
		}
		qMetricThroughputRead := swag.FormatInt64(qrMetricThroughputRead)
		if qMetricThroughputRead != "" {

			if err := r.SetQueryParam("metric.throughput.read", qMetricThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputTotal != nil {

		// query param metric.throughput.total
		var qrMetricThroughputTotal int64

		if o.MetricThroughputTotal != nil {
			qrMetricThroughputTotal = *o.MetricThroughputTotal
		}
		qMetricThroughputTotal := swag.FormatInt64(qrMetricThroughputTotal)
		if qMetricThroughputTotal != "" {

			if err := r.SetQueryParam("metric.throughput.total", qMetricThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputWrite != nil {

		// query param metric.throughput.write
		var qrMetricThroughputWrite int64

		if o.MetricThroughputWrite != nil {
			qrMetricThroughputWrite = *o.MetricThroughputWrite
		}
		qMetricThroughputWrite := swag.FormatInt64(qrMetricThroughputWrite)
		if qMetricThroughputWrite != "" {

			if err := r.SetQueryParam("metric.throughput.write", qMetricThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricTimestamp != nil {

		// query param metric.timestamp
		var qrMetricTimestamp string

		if o.MetricTimestamp != nil {
			qrMetricTimestamp = *o.MetricTimestamp
		}
		qMetricTimestamp := qrMetricTimestamp
		if qMetricTimestamp != "" {

			if err := r.SetQueryParam("metric.timestamp", qMetricTimestamp); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.ProbePort != nil {

		// query param probe_port
		var qrProbePort int64

		if o.ProbePort != nil {
			qrProbePort = *o.ProbePort
		}
		qProbePort := swag.FormatInt64(qrProbePort)
		if qProbePort != "" {

			if err := r.SetQueryParam("probe_port", qProbePort); err != nil {
				return err
			}
		}
	}

	if o.RdmaProtocols != nil {

		// query param rdma_protocols
		var qrRdmaProtocols string

		if o.RdmaProtocols != nil {
			qrRdmaProtocols = *o.RdmaProtocols
		}
		qRdmaProtocols := qrRdmaProtocols
		if qRdmaProtocols != "" {

			if err := r.SetQueryParam("rdma_protocols", qRdmaProtocols); err != nil {
				return err
			}
		}
	}

	if o.RecommendInterfacesPerNode != nil {

		// query param recommend.interfaces_per_node
		var qrRecommendInterfacesPerNode int64

		if o.RecommendInterfacesPerNode != nil {
			qrRecommendInterfacesPerNode = *o.RecommendInterfacesPerNode
		}
		qRecommendInterfacesPerNode := swag.FormatInt64(qrRecommendInterfacesPerNode)
		if qRecommendInterfacesPerNode != "" {

			if err := r.SetQueryParam("recommend.interfaces_per_node", qRecommendInterfacesPerNode); err != nil {
				return err
			}
		}
	}

	if o.RecommendIPFamily != nil {

		// query param recommend.ip.family
		var qrRecommendIPFamily string

		if o.RecommendIPFamily != nil {
			qrRecommendIPFamily = *o.RecommendIPFamily
		}
		qRecommendIPFamily := qrRecommendIPFamily
		if qRecommendIPFamily != "" {

			if err := r.SetQueryParam("recommend.ip.family", qRecommendIPFamily); err != nil {
				return err
			}
		}
	}

	if o.RecommendIpspaceName != nil {

		// query param recommend.ipspace.name
		var qrRecommendIpspaceName string

		if o.RecommendIpspaceName != nil {
			qrRecommendIpspaceName = *o.RecommendIpspaceName
		}
		qRecommendIpspaceName := qrRecommendIpspaceName
		if qRecommendIpspaceName != "" {

			if err := r.SetQueryParam("recommend.ipspace.name", qRecommendIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.RecommendIpspaceUUID != nil {

		// query param recommend.ipspace.uuid
		var qrRecommendIpspaceUUID string

		if o.RecommendIpspaceUUID != nil {
			qrRecommendIpspaceUUID = *o.RecommendIpspaceUUID
		}
		qRecommendIpspaceUUID := qrRecommendIpspaceUUID
		if qRecommendIpspaceUUID != "" {

			if err := r.SetQueryParam("recommend.ipspace.uuid", qRecommendIpspaceUUID); err != nil {
				return err
			}
		}
	}

	if o.RecommendLocationBroadcastDomainName != nil {

		// query param recommend.location.broadcast_domain.name
		var qrRecommendLocationBroadcastDomainName string

		if o.RecommendLocationBroadcastDomainName != nil {
			qrRecommendLocationBroadcastDomainName = *o.RecommendLocationBroadcastDomainName
		}
		qRecommendLocationBroadcastDomainName := qrRecommendLocationBroadcastDomainName
		if qRecommendLocationBroadcastDomainName != "" {

			if err := r.SetQueryParam("recommend.location.broadcast_domain.name", qRecommendLocationBroadcastDomainName); err != nil {
				return err
			}
		}
	}

	if o.RecommendLocationBroadcastDomainUUID != nil {

		// query param recommend.location.broadcast_domain.uuid
		var qrRecommendLocationBroadcastDomainUUID string

		if o.RecommendLocationBroadcastDomainUUID != nil {
			qrRecommendLocationBroadcastDomainUUID = *o.RecommendLocationBroadcastDomainUUID
		}
		qRecommendLocationBroadcastDomainUUID := qrRecommendLocationBroadcastDomainUUID
		if qRecommendLocationBroadcastDomainUUID != "" {

			if err := r.SetQueryParam("recommend.location.broadcast_domain.uuid", qRecommendLocationBroadcastDomainUUID); err != nil {
				return err
			}
		}
	}

	if o.RecommendLocationPortRdmaProtocol != nil {

		// query param recommend.location.port.rdma_protocol
		var qrRecommendLocationPortRdmaProtocol string

		if o.RecommendLocationPortRdmaProtocol != nil {
			qrRecommendLocationPortRdmaProtocol = *o.RecommendLocationPortRdmaProtocol
		}
		qRecommendLocationPortRdmaProtocol := qrRecommendLocationPortRdmaProtocol
		if qRecommendLocationPortRdmaProtocol != "" {

			if err := r.SetQueryParam("recommend.location.port.rdma_protocol", qRecommendLocationPortRdmaProtocol); err != nil {
				return err
			}
		}
	}

	if o.RecommendServicePolicyName != nil {

		// query param recommend.service_policy.name
		var qrRecommendServicePolicyName string

		if o.RecommendServicePolicyName != nil {
			qrRecommendServicePolicyName = *o.RecommendServicePolicyName
		}
		qRecommendServicePolicyName := qrRecommendServicePolicyName
		if qRecommendServicePolicyName != "" {

			if err := r.SetQueryParam("recommend.service_policy.name", qRecommendServicePolicyName); err != nil {
				return err
			}
		}
	}

	if o.RecommendServicePolicyUUID != nil {

		// query param recommend.service_policy.uuid
		var qrRecommendServicePolicyUUID string

		if o.RecommendServicePolicyUUID != nil {
			qrRecommendServicePolicyUUID = *o.RecommendServicePolicyUUID
		}
		qRecommendServicePolicyUUID := qrRecommendServicePolicyUUID
		if qRecommendServicePolicyUUID != "" {

			if err := r.SetQueryParam("recommend.service_policy.uuid", qRecommendServicePolicyUUID); err != nil {
				return err
			}
		}
	}

	if o.RecommendSubnetName != nil {

		// query param recommend.subnet.name
		var qrRecommendSubnetName string

		if o.RecommendSubnetName != nil {
			qrRecommendSubnetName = *o.RecommendSubnetName
		}
		qRecommendSubnetName := qrRecommendSubnetName
		if qRecommendSubnetName != "" {

			if err := r.SetQueryParam("recommend.subnet.name", qRecommendSubnetName); err != nil {
				return err
			}
		}
	}

	if o.RecommendSubnetUUID != nil {

		// query param recommend.subnet.uuid
		var qrRecommendSubnetUUID string

		if o.RecommendSubnetUUID != nil {
			qrRecommendSubnetUUID = *o.RecommendSubnetUUID
		}
		qRecommendSubnetUUID := qrRecommendSubnetUUID
		if qRecommendSubnetUUID != "" {

			if err := r.SetQueryParam("recommend.subnet.uuid", qRecommendSubnetUUID); err != nil {
				return err
			}
		}
	}

	if o.RecommendSvmName != nil {

		// query param recommend.svm.name
		var qrRecommendSvmName string

		if o.RecommendSvmName != nil {
			qrRecommendSvmName = *o.RecommendSvmName
		}
		qRecommendSvmName := qrRecommendSvmName
		if qRecommendSvmName != "" {

			if err := r.SetQueryParam("recommend.svm.name", qRecommendSvmName); err != nil {
				return err
			}
		}
	}

	if o.RecommendSvmUUID != nil {

		// query param recommend.svm.uuid
		var qrRecommendSvmUUID string

		if o.RecommendSvmUUID != nil {
			qrRecommendSvmUUID = *o.RecommendSvmUUID
		}
		qRecommendSvmUUID := qrRecommendSvmUUID
		if qRecommendSvmUUID != "" {

			if err := r.SetQueryParam("recommend.svm.uuid", qRecommendSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.ServicePolicyName != nil {

		// query param service_policy.name
		var qrServicePolicyName string

		if o.ServicePolicyName != nil {
			qrServicePolicyName = *o.ServicePolicyName
		}
		qServicePolicyName := qrServicePolicyName
		if qServicePolicyName != "" {

			if err := r.SetQueryParam("service_policy.name", qServicePolicyName); err != nil {
				return err
			}
		}
	}

	if o.ServicePolicyUUID != nil {

		// query param service_policy.uuid
		var qrServicePolicyUUID string

		if o.ServicePolicyUUID != nil {
			qrServicePolicyUUID = *o.ServicePolicyUUID
		}
		qServicePolicyUUID := qrServicePolicyUUID
		if qServicePolicyUUID != "" {

			if err := r.SetQueryParam("service_policy.uuid", qServicePolicyUUID); err != nil {
				return err
			}
		}
	}

	if o.Services != nil {

		// query param services
		var qrServices string

		if o.Services != nil {
			qrServices = *o.Services
		}
		qServices := qrServices
		if qServices != "" {

			if err := r.SetQueryParam("services", qServices); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.StatisticsStatus != nil {

		// query param statistics.status
		var qrStatisticsStatus string

		if o.StatisticsStatus != nil {
			qrStatisticsStatus = *o.StatisticsStatus
		}
		qStatisticsStatus := qrStatisticsStatus
		if qStatisticsStatus != "" {

			if err := r.SetQueryParam("statistics.status", qStatisticsStatus); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawRead != nil {

		// query param statistics.throughput_raw.read
		var qrStatisticsThroughputRawRead int64

		if o.StatisticsThroughputRawRead != nil {
			qrStatisticsThroughputRawRead = *o.StatisticsThroughputRawRead
		}
		qStatisticsThroughputRawRead := swag.FormatInt64(qrStatisticsThroughputRawRead)
		if qStatisticsThroughputRawRead != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.read", qStatisticsThroughputRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawTotal != nil {

		// query param statistics.throughput_raw.total
		var qrStatisticsThroughputRawTotal int64

		if o.StatisticsThroughputRawTotal != nil {
			qrStatisticsThroughputRawTotal = *o.StatisticsThroughputRawTotal
		}
		qStatisticsThroughputRawTotal := swag.FormatInt64(qrStatisticsThroughputRawTotal)
		if qStatisticsThroughputRawTotal != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.total", qStatisticsThroughputRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawWrite != nil {

		// query param statistics.throughput_raw.write
		var qrStatisticsThroughputRawWrite int64

		if o.StatisticsThroughputRawWrite != nil {
			qrStatisticsThroughputRawWrite = *o.StatisticsThroughputRawWrite
		}
		qStatisticsThroughputRawWrite := swag.FormatInt64(qrStatisticsThroughputRawWrite)
		if qStatisticsThroughputRawWrite != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.write", qStatisticsThroughputRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsTimestamp != nil {

		// query param statistics.timestamp
		var qrStatisticsTimestamp string

		if o.StatisticsTimestamp != nil {
			qrStatisticsTimestamp = *o.StatisticsTimestamp
		}
		qStatisticsTimestamp := qrStatisticsTimestamp
		if qStatisticsTimestamp != "" {

			if err := r.SetQueryParam("statistics.timestamp", qStatisticsTimestamp); err != nil {
				return err
			}
		}
	}

	if o.SubnetName != nil {

		// query param subnet.name
		var qrSubnetName string

		if o.SubnetName != nil {
			qrSubnetName = *o.SubnetName
		}
		qSubnetName := qrSubnetName
		if qSubnetName != "" {

			if err := r.SetQueryParam("subnet.name", qSubnetName); err != nil {
				return err
			}
		}
	}

	if o.SubnetUUID != nil {

		// query param subnet.uuid
		var qrSubnetUUID string

		if o.SubnetUUID != nil {
			qrSubnetUUID = *o.SubnetUUID
		}
		qSubnetUUID := qrSubnetUUID
		if qSubnetUUID != "" {

			if err := r.SetQueryParam("subnet.uuid", qSubnetUUID); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.Vip != nil {

		// query param vip
		var qrVip bool

		if o.Vip != nil {
			qrVip = *o.Vip
		}
		qVip := swag.FormatBool(qrVip)
		if qVip != "" {

			if err := r.SetQueryParam("vip", qVip); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
