// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NetworkIPInterfaceModifyCollectionReader is a Reader for the NetworkIPInterfaceModifyCollection structure.
type NetworkIPInterfaceModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NetworkIPInterfaceModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNetworkIPInterfaceModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNetworkIPInterfaceModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNetworkIPInterfaceModifyCollectionOK creates a NetworkIPInterfaceModifyCollectionOK with default headers values
func NewNetworkIPInterfaceModifyCollectionOK() *NetworkIPInterfaceModifyCollectionOK {
	return &NetworkIPInterfaceModifyCollectionOK{}
}

/*
NetworkIPInterfaceModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type NetworkIPInterfaceModifyCollectionOK struct {
}

// IsSuccess returns true when this network Ip interface modify collection o k response has a 2xx status code
func (o *NetworkIPInterfaceModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this network Ip interface modify collection o k response has a 3xx status code
func (o *NetworkIPInterfaceModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network Ip interface modify collection o k response has a 4xx status code
func (o *NetworkIPInterfaceModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this network Ip interface modify collection o k response has a 5xx status code
func (o *NetworkIPInterfaceModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this network Ip interface modify collection o k response a status code equal to that given
func (o *NetworkIPInterfaceModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the network Ip interface modify collection o k response
func (o *NetworkIPInterfaceModifyCollectionOK) Code() int {
	return 200
}

func (o *NetworkIPInterfaceModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /network/ip/interfaces][%d] networkIpInterfaceModifyCollectionOK", 200)
}

func (o *NetworkIPInterfaceModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /network/ip/interfaces][%d] networkIpInterfaceModifyCollectionOK", 200)
}

func (o *NetworkIPInterfaceModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNetworkIPInterfaceModifyCollectionDefault creates a NetworkIPInterfaceModifyCollectionDefault with default headers values
func NewNetworkIPInterfaceModifyCollectionDefault(code int) *NetworkIPInterfaceModifyCollectionDefault {
	return &NetworkIPInterfaceModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	NetworkIPInterfaceModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262196 | Field cannot be set in this operation. |
| 1376663 | Cannot add interface to DNS zone because all interfaces from a single DNS zone must be in the same SVM. |
| 1376963 | Duplicate IP address. |
| 1376976 | The specified port is not capable of hosting this LIF. |
| 1376986 | The interface could not migrate because no additional interfaces can be hosted on the specified node. |
| 1376997 | Interface failed to migrate because the node hosting the port is not healthy. |
| 1376998 | The specified location.node does not own any ports in the same broadcast domain as the home port of the interface. |
| 1376999 | Interface failed to migrate because port is in the down admin state. |
| 1377607 | The specified location.port is not in the same broadcast domain as the home port of the interface. |
| 1377666 | Subnet does not have any addresses available. |
| 1966081 | Failed to lookup the port on the node. |
| 1966133 | The netmask cannot represent the entire IP subnet. |
| 1966135 | Cluster configuration can only be changed from node where the cluster LIF resides. |
| 1966138 | The same IP address may not be used for both a mgmt interface and a gateway address. |
| 1966141 | Invalid DNS zone name. |
| 1966142 | Only data LIFs can be assigned a DNS zone. |
| 1966191 | The interface could not be created because interface identifier creation failed. |
| 1966197 | Migration of cluster interfaces must be done from the local node. |
| 1966238 | Cannot change the home-node or home-port of an active SAN or NVMe data interface. |
| 1966267 | IPv6 addresses must have a prefix length between 1 and 127. |
| 1966269 | IPv4 addresses must have a prefix length between 1 and 32. |
| 1966299 | Changing a cluster LIF's administrative status to down is not a supported operation. |
| 1966419 | Subnet not found in the IPspace of the SVM. |
| 1966419 | Specified subnet not found in the IPspace of the LIF. |
| 1966476 | DNS Update is supported only on data interfaces. |
| 1966477 | DNS Update is supported only on interfaces configured with the NFS or CIFS protocol. |
| 1966507 | A port on the node has been identified as potentially unhealthy. |
| 1966685 | There are no ports on the node that are in the broadcast domain associated with the IPspace. |
| 1967106 | The specified location.home_port.name does not match the specified port name of location.home_port.uuid. |
| 1967107 | The specified location.home_port.uuid is not valid. |
| 1967111 | A home node must be specified by at least one location.home_node, location.home_port, or location.broadcast_domain field. |
| 1967113 | The specified location.port.name does not match the port name of location.port.uuid. |
| 1967114 | The specified location.port.uuid is not valid. |
| 1967115 | The specified location.node.name does not match the node name of location.node.uuid. |
| 1967116 | The specified location.port.node.name does not match the node name of location.node.uuid. |
| 1967117 | The specified location.port.node.name does not match location.node.name. |
| 1967118 | A node must be specified by at least one location.node or location.port field. |
| 1967119 | The specified location.node.name does not match the node name of location.port.uuid. |
| 1967120 | The specified service_policy.name does not match the specified service policy name of service_policy.uuid. |
| 1967121 | The specified service_policy.uuid is not valid. |
| 1967125 | You cannot patch the "location.node" or "location.port" fields to migrate interfaces using the iSCSI data protocol. Instead perform the following PATCH operations on the interface: set the "enabled" field to "false"; change one or more "location.home_port" fields to migrate the interface; and then set the "enabled" field to "true". |
| 1967129 | The specified location.home_port.uuid is not valid. |
| 1967130 | The specified location.home_port.name is not valid. |
| 1967131 | The specified location.home_port.uuid and location.home_port.name are not valid. |
| 1967132 | The specified location.port.uuid is not valid. |
| 1967133 | The specified location.port.name is not valid. |
| 1967134 | The specified location.port.uuid and location.port.name are not valid. |
| 1967138 | Cannot patch port for a VIP interface. The specified parameter location.port.uuid is not valid. |
| 1967139 | Cannot patch port for a VIP interface. The specified parameter location.port.name is not valid. |
| 1967140 | Cannot patch port for a VIP interface. The specified parameters location.port.uuid and location.port.name are not valid. |
| 1967141 | Cannot patch home_port for a VIP interface. The specified parameter location.home_port.uuid is not valid. |
| 1967142 | Cannot patch home_port for a VIP interface. The specified parameter location.home_port.name is not valid. |
| 1967143 | Cannot patch home_port for a VIP interface. The specified parameters location.home_port.uuid and location.home_port.name  are not valid. |
| 1967145 | The specified location.failover is not valid. |
| 1967153 | No suitable port exists on location.home_node to host the interface. |
| 1967380 | Cannot patch home_port for a VIP interface. The specified parameter location.home_port.node.name is not valid. Consider using location.home_node.name instead. |
| 1967385 | VIP interface address and netmask error. |
| 1967386 | Cannot patch port for a VIP interface. The specified parameter location.port.node.name is not valid. Consider using location.node.name instead. |
| 1967387 | The specified IP address is in use by a subnet in this IPspace. |
| 1967389 | Patching location.is_home to the value "false" is not supported. The value "true" would revert a network interface to its home port if the current value is "false". |
| 1967390 | Cannot patch a LIF revert as it requires an effective cluster version of 9.9.1 or later. |
| 1967391 | Patching the DNS zone requires an effective cluster version of 9.9.1 or later. |
| 1967392 | Patching the DDNS enable parameter requires an effective cluster version of 9.9.1 or later. |
| 1967396 | The specified subnet.name does not match the subnet name of subnet.uuid. |
| 1967397 | The specified subnet.uuid does not match any configured subnet."; |
| 1967398 | Address must be specified by either ip.address and ip.netmask, or at least one subnet field, not both."; |
| 2621574 | This operation is not permitted on an SVM that is configured as the destination of a MetroCluster SVM relationship. |
| 53281018 | Failover policy is not compatible with one or more services in service policy |
| 53281065 | The service_policy does not exist in the SVM. |
| 53281072 | The failover policy is not valid for interfaces in the SVM. |
| 53281086 | LIF would exceed the maximum number of supported intercluster LIFs in IPspace. |
| 53281087 | SVM must have an NVMe service to perform this operation. |
| 53281089 | LIF on SVM cannot be updated to use service policy because that service policy includes SAN services and the target LIF is not home. |
| 53281096 | LIF could not be modified because the current port does not support the specified rdma-protocols. |
| 53281106 | Failed checking the cluster capabilities. |
| 53281109 | The interface could not be updated to use the service policy because the interface is currently associated with BGP peer group. |
| 53281111 | Cannot update the service policy because the interface is associated with a BGP peer-group. |
| 53281113 | Configuration details for LIF were modified but an error was encountered while updating the LIF's operational status. |
| 53281114 | The specified parameter is only supported on data SVMs. |
| 53281468 | Failed to update external route tables for IP. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type NetworkIPInterfaceModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this network ip interface modify collection default response has a 2xx status code
func (o *NetworkIPInterfaceModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this network ip interface modify collection default response has a 3xx status code
func (o *NetworkIPInterfaceModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this network ip interface modify collection default response has a 4xx status code
func (o *NetworkIPInterfaceModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this network ip interface modify collection default response has a 5xx status code
func (o *NetworkIPInterfaceModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this network ip interface modify collection default response a status code equal to that given
func (o *NetworkIPInterfaceModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the network ip interface modify collection default response
func (o *NetworkIPInterfaceModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *NetworkIPInterfaceModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/ip/interfaces][%d] network_ip_interface_modify_collection default %s", o._statusCode, payload)
}

func (o *NetworkIPInterfaceModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/ip/interfaces][%d] network_ip_interface_modify_collection default %s", o._statusCode, payload)
}

func (o *NetworkIPInterfaceModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NetworkIPInterfaceModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NetworkIPInterfaceModifyCollectionBody network IP interface modify collection body
swagger:model NetworkIPInterfaceModifyCollectionBody
*/
type NetworkIPInterfaceModifyCollectionBody struct {

	// links
	Links *models.IPInterfaceInlineLinks `json:"_links,omitempty"`

	// Indicates whether or not dynamic DNS updates are enabled. Defaults to true if the interface supports "data_nfs" or "data_cifs" services, otherwise false.
	DdnsEnabled *bool `json:"ddns_enabled,omitempty"`

	// Fully qualified DNS zone name
	// Example: storage.company.com
	DNSZone *string `json:"dns_zone,omitempty"`

	// The administrative state of the interface.
	Enabled *bool `json:"enabled,omitempty"`

	// This command fails if the specified IP address falls within the address range of a named subnet. Set this value to false to use the specified IP address and to assign the subnet owning that address to the interface.
	FailIfSubnetConflicts *bool `json:"fail_if_subnet_conflicts,omitempty"`

	// ip
	IP *models.IPInfo `json:"ip,omitempty"`

	// The services associated with the interface.
	// Read Only: true
	IPInterfaceInlineServices []*models.IPService `json:"services,omitempty"`

	// ip interface response inline records
	IPInterfaceResponseInlineRecords []*models.IPInterface `json:"records,omitempty"`

	// ipspace
	Ipspace *models.IPInterfaceInlineIpspace `json:"ipspace,omitempty"`

	// location
	Location *models.IPInterfaceInlineLocation `json:"location,omitempty"`

	// metric
	Metric *models.IPInterfaceInlineMetric `json:"metric,omitempty"`

	// Interface name
	// Example: dataLif1
	Name *string `json:"name,omitempty"`

	// Probe port for Cloud load balancer
	// Example: 64001
	ProbePort *int64 `json:"probe_port,omitempty"`

	// Supported RDMA offload protocols
	RdmaProtocols []*string `json:"rdma_protocols,omitempty"`

	// recommend
	Recommend *models.IPInterfaceResponseInlineRecommend `json:"recommend,omitempty"`

	// Set to "svm" for interfaces owned by an SVM. Otherwise, set to "cluster".
	// Enum: ["svm","cluster"]
	Scope *string `json:"scope,omitempty"`

	// service policy
	ServicePolicy *models.IPInterfaceInlineServicePolicy `json:"service_policy,omitempty"`

	// The operational state of the interface.
	// Read Only: true
	// Enum: ["up","down"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *models.IPInterfaceInlineStatistics `json:"statistics,omitempty"`

	// Use this field to allocate an interface address from a subnet. If needed, a default route is created for this subnet.
	Subnet *models.IPSubnetReference `json:"subnet,omitempty"`

	// svm
	Svm *models.IPInterfaceInlineSvm `json:"svm,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// True for a VIP interface, whose location is announced via BGP.
	Vip *bool `json:"vip,omitempty"`
}

// Validate validates this network IP interface modify collection body
func (o *NetworkIPInterfaceModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIPInterfaceInlineServices(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIPInterfaceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRdmaProtocols(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRecommend(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateServicePolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubnet(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(o.IP) { // not required
		return nil
	}

	if o.IP != nil {
		if err := o.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) validateIPInterfaceInlineServices(formats strfmt.Registry) error {
	if swag.IsZero(o.IPInterfaceInlineServices) { // not required
		return nil
	}

	for i := 0; i < len(o.IPInterfaceInlineServices); i++ {
		if swag.IsZero(o.IPInterfaceInlineServices[i]) { // not required
			continue
		}

		if o.IPInterfaceInlineServices[i] != nil {
			if err := o.IPInterfaceInlineServices[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "services" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) validateIPInterfaceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.IPInterfaceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.IPInterfaceResponseInlineRecords); i++ {
		if swag.IsZero(o.IPInterfaceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.IPInterfaceResponseInlineRecords[i] != nil {
			if err := o.IPInterfaceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(o.Ipspace) { // not required
		return nil
	}

	if o.Ipspace != nil {
		if err := o.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(o.Metric) { // not required
		return nil
	}

	if o.Metric != nil {
		if err := o.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

var networkIpInterfaceModifyCollectionBodyRdmaProtocolsItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["roce"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		networkIpInterfaceModifyCollectionBodyRdmaProtocolsItemsEnum = append(networkIpInterfaceModifyCollectionBodyRdmaProtocolsItemsEnum, v)
	}
}

func (o *NetworkIPInterfaceModifyCollectionBody) validateRdmaProtocolsItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, networkIpInterfaceModifyCollectionBodyRdmaProtocolsItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) validateRdmaProtocols(formats strfmt.Registry) error {
	if swag.IsZero(o.RdmaProtocols) { // not required
		return nil
	}

	for i := 0; i < len(o.RdmaProtocols); i++ {
		if swag.IsZero(o.RdmaProtocols[i]) { // not required
			continue
		}

		// value enum
		if err := o.validateRdmaProtocolsItemsEnum("info"+"."+"rdma_protocols"+"."+strconv.Itoa(i), "body", *o.RdmaProtocols[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) validateRecommend(formats strfmt.Registry) error {
	if swag.IsZero(o.Recommend) { // not required
		return nil
	}

	if o.Recommend != nil {
		if err := o.Recommend.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "recommend")
			}
			return err
		}
	}

	return nil
}

var networkIpInterfaceModifyCollectionBodyTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["svm","cluster"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		networkIpInterfaceModifyCollectionBodyTypeScopePropEnum = append(networkIpInterfaceModifyCollectionBodyTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NetworkIPInterfaceModifyCollectionBody
	// NetworkIPInterfaceModifyCollectionBody
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// NetworkIPInterfaceModifyCollectionBodyScopeSvm captures enum value "svm"
	NetworkIPInterfaceModifyCollectionBodyScopeSvm string = "svm"

	// BEGIN DEBUGGING
	// NetworkIPInterfaceModifyCollectionBody
	// NetworkIPInterfaceModifyCollectionBody
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// NetworkIPInterfaceModifyCollectionBodyScopeCluster captures enum value "cluster"
	NetworkIPInterfaceModifyCollectionBodyScopeCluster string = "cluster"
)

// prop value enum
func (o *NetworkIPInterfaceModifyCollectionBody) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, networkIpInterfaceModifyCollectionBodyTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(o.Scope) { // not required
		return nil
	}

	// value enum
	if err := o.validateScopeEnum("info"+"."+"scope", "body", *o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) validateServicePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.ServicePolicy) { // not required
		return nil
	}

	if o.ServicePolicy != nil {
		if err := o.ServicePolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "service_policy")
			}
			return err
		}
	}

	return nil
}

var networkIpInterfaceModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		networkIpInterfaceModifyCollectionBodyTypeStatePropEnum = append(networkIpInterfaceModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NetworkIPInterfaceModifyCollectionBody
	// NetworkIPInterfaceModifyCollectionBody
	// state
	// State
	// up
	// END DEBUGGING
	// NetworkIPInterfaceModifyCollectionBodyStateUp captures enum value "up"
	NetworkIPInterfaceModifyCollectionBodyStateUp string = "up"

	// BEGIN DEBUGGING
	// NetworkIPInterfaceModifyCollectionBody
	// NetworkIPInterfaceModifyCollectionBody
	// state
	// State
	// down
	// END DEBUGGING
	// NetworkIPInterfaceModifyCollectionBodyStateDown captures enum value "down"
	NetworkIPInterfaceModifyCollectionBodyStateDown string = "down"
)

// prop value enum
func (o *NetworkIPInterfaceModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, networkIpInterfaceModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(o.Statistics) { // not required
		return nil
	}

	if o.Statistics != nil {
		if err := o.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) validateSubnet(formats strfmt.Registry) error {
	if swag.IsZero(o.Subnet) { // not required
		return nil
	}

	if o.Subnet != nil {
		if err := o.Subnet.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subnet")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this network IP interface modify collection body based on the context it is used
func (o *NetworkIPInterfaceModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIPInterfaceInlineServices(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIPInterfaceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRecommend(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateServicePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubnet(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if o.IP != nil {
		if err := o.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) contextValidateIPInterfaceInlineServices(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"services", "body", []*models.IPService(o.IPInterfaceInlineServices)); err != nil {
		return err
	}

	for i := 0; i < len(o.IPInterfaceInlineServices); i++ {

		if o.IPInterfaceInlineServices[i] != nil {
			if err := o.IPInterfaceInlineServices[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "services" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) contextValidateIPInterfaceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.IPInterfaceResponseInlineRecords); i++ {

		if o.IPInterfaceResponseInlineRecords[i] != nil {
			if err := o.IPInterfaceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if o.Ipspace != nil {
		if err := o.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {
		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if o.Metric != nil {
		if err := o.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) contextValidateRecommend(ctx context.Context, formats strfmt.Registry) error {

	if o.Recommend != nil {
		if err := o.Recommend.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "recommend")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) contextValidateServicePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.ServicePolicy != nil {
		if err := o.ServicePolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "service_policy")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if o.Statistics != nil {
		if err := o.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) contextValidateSubnet(ctx context.Context, formats strfmt.Registry) error {

	if o.Subnet != nil {
		if err := o.Subnet.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subnet")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPInterfaceModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NetworkIPInterfaceModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkIPInterfaceModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res NetworkIPInterfaceModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineLinks ip interface inline links
swagger:model ip_interface_inline__links
*/
type IPInterfaceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ip interface inline links
func (o *IPInterfaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline links based on the context it is used
func (o *IPInterfaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineIpspace Either the UUID or name must be supplied on POST for cluster-scoped objects.
swagger:model ip_interface_inline_ipspace
*/
type IPInterfaceInlineIpspace struct {

	// links
	Links *models.IPInterfaceInlineIpspaceInlineLinks `json:"_links,omitempty"`

	// IPspace name
	// Example: Default
	Name *string `json:"name,omitempty"`

	// IPspace UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ip interface inline ipspace
func (o *IPInterfaceInlineIpspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineIpspace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline ipspace based on the context it is used
func (o *IPInterfaceInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineIpspace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineIpspace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineIpspace) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineIpspaceInlineLinks ip interface inline ipspace inline links
swagger:model ip_interface_inline_ipspace_inline__links
*/
type IPInterfaceInlineIpspaceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ip interface inline ipspace inline links
func (o *IPInterfaceInlineIpspaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineIpspaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline ipspace inline links based on the context it is used
func (o *IPInterfaceInlineIpspaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineIpspaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineIpspaceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineIpspaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineIpspaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineLocation Current or home location can be modified. Specifying a port implies a node. Specifying a node allows an appropriate port to be automatically selected. Ports are not valid and not shown for VIP interfaces. For POST, broadcast_domain can be specified alone or with home_node.  For PATCH, set is_home to true to revert a LIF back to its home port.
swagger:model ip_interface_inline_location
*/
type IPInterfaceInlineLocation struct {

	// auto revert
	AutoRevert *bool `json:"auto_revert,omitempty"`

	// broadcast domain
	BroadcastDomain *models.IPInterfaceInlineLocationInlineBroadcastDomain `json:"broadcast_domain,omitempty"`

	// failover
	Failover *models.FailoverScope `json:"failover,omitempty"`

	// home node
	HomeNode *models.IPInterfaceInlineLocationInlineHomeNode `json:"home_node,omitempty"`

	// home port
	HomePort *models.IPInterfaceInlineLocationInlineHomePort `json:"home_port,omitempty"`

	// is home
	IsHome *bool `json:"is_home,omitempty"`

	// node
	Node *models.IPInterfaceInlineLocationInlineNode `json:"node,omitempty"`

	// port
	Port *models.IPInterfaceInlineLocationInlinePort `json:"port,omitempty"`
}

// Validate validates this ip interface inline location
func (o *IPInterfaceInlineLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateBroadcastDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFailover(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateHomeNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateHomePort(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocation) validateBroadcastDomain(formats strfmt.Registry) error {
	if swag.IsZero(o.BroadcastDomain) { // not required
		return nil
	}

	if o.BroadcastDomain != nil {
		if err := o.BroadcastDomain.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "broadcast_domain")
			}
			return err
		}
	}

	return nil
}

func (o *IPInterfaceInlineLocation) validateFailover(formats strfmt.Registry) error {
	if swag.IsZero(o.Failover) { // not required
		return nil
	}

	if o.Failover != nil {
		if err := o.Failover.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "failover")
			}
			return err
		}
	}

	return nil
}

func (o *IPInterfaceInlineLocation) validateHomeNode(formats strfmt.Registry) error {
	if swag.IsZero(o.HomeNode) { // not required
		return nil
	}

	if o.HomeNode != nil {
		if err := o.HomeNode.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_node")
			}
			return err
		}
	}

	return nil
}

func (o *IPInterfaceInlineLocation) validateHomePort(formats strfmt.Registry) error {
	if swag.IsZero(o.HomePort) { // not required
		return nil
	}

	if o.HomePort != nil {
		if err := o.HomePort.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_port")
			}
			return err
		}
	}

	return nil
}

func (o *IPInterfaceInlineLocation) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *IPInterfaceInlineLocation) validatePort(formats strfmt.Registry) error {
	if swag.IsZero(o.Port) { // not required
		return nil
	}

	if o.Port != nil {
		if err := o.Port.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "port")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location based on the context it is used
func (o *IPInterfaceInlineLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateBroadcastDomain(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFailover(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHomeNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHomePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocation) contextValidateBroadcastDomain(ctx context.Context, formats strfmt.Registry) error {

	if o.BroadcastDomain != nil {
		if err := o.BroadcastDomain.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "broadcast_domain")
			}
			return err
		}
	}

	return nil
}

func (o *IPInterfaceInlineLocation) contextValidateFailover(ctx context.Context, formats strfmt.Registry) error {

	if o.Failover != nil {
		if err := o.Failover.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "failover")
			}
			return err
		}
	}

	return nil
}

func (o *IPInterfaceInlineLocation) contextValidateHomeNode(ctx context.Context, formats strfmt.Registry) error {

	if o.HomeNode != nil {
		if err := o.HomeNode.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_node")
			}
			return err
		}
	}

	return nil
}

func (o *IPInterfaceInlineLocation) contextValidateHomePort(ctx context.Context, formats strfmt.Registry) error {

	if o.HomePort != nil {
		if err := o.HomePort.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_port")
			}
			return err
		}
	}

	return nil
}

func (o *IPInterfaceInlineLocation) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *IPInterfaceInlineLocation) contextValidatePort(ctx context.Context, formats strfmt.Registry) error {

	if o.Port != nil {
		if err := o.Port.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "port")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineLocation) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineLocationInlineBroadcastDomain Broadcast domain UUID along with a readable name.
swagger:model ip_interface_inline_location_inline_broadcast_domain
*/
type IPInterfaceInlineLocationInlineBroadcastDomain struct {

	// links
	Links *models.IPInterfaceInlineLocationInlineBroadcastDomainInlineLinks `json:"_links,omitempty"`

	// Name of the broadcast domain, scoped to its IPspace
	// Example: bd1
	Name *string `json:"name,omitempty"`

	// Broadcast domain UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ip interface inline location inline broadcast domain
func (o *IPInterfaceInlineLocationInlineBroadcastDomain) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocationInlineBroadcastDomain) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "broadcast_domain" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location inline broadcast domain based on the context it is used
func (o *IPInterfaceInlineLocationInlineBroadcastDomain) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocationInlineBroadcastDomain) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "broadcast_domain" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlineBroadcastDomain) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlineBroadcastDomain) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlineBroadcastDomain
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineLocationInlineBroadcastDomainInlineLinks ip interface inline location inline broadcast domain inline links
swagger:model ip_interface_inline_location_inline_broadcast_domain_inline__links
*/
type IPInterfaceInlineLocationInlineBroadcastDomainInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ip interface inline location inline broadcast domain inline links
func (o *IPInterfaceInlineLocationInlineBroadcastDomainInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocationInlineBroadcastDomainInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "broadcast_domain" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location inline broadcast domain inline links based on the context it is used
func (o *IPInterfaceInlineLocationInlineBroadcastDomainInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocationInlineBroadcastDomainInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "broadcast_domain" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlineBroadcastDomainInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlineBroadcastDomainInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlineBroadcastDomainInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineLocationInlineHomeNode ip interface inline location inline home node
swagger:model ip_interface_inline_location_inline_home_node
*/
type IPInterfaceInlineLocationInlineHomeNode struct {

	// links
	Links *models.IPInterfaceInlineLocationInlineHomeNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ip interface inline location inline home node
func (o *IPInterfaceInlineLocationInlineHomeNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocationInlineHomeNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location inline home node based on the context it is used
func (o *IPInterfaceInlineLocationInlineHomeNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocationInlineHomeNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlineHomeNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlineHomeNode) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlineHomeNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineLocationInlineHomeNodeInlineLinks ip interface inline location inline home node inline links
swagger:model ip_interface_inline_location_inline_home_node_inline__links
*/
type IPInterfaceInlineLocationInlineHomeNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ip interface inline location inline home node inline links
func (o *IPInterfaceInlineLocationInlineHomeNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocationInlineHomeNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location inline home node inline links based on the context it is used
func (o *IPInterfaceInlineLocationInlineHomeNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocationInlineHomeNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlineHomeNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlineHomeNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlineHomeNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineLocationInlineHomePort Port UUID along with readable names. Either the UUID or both names may be supplied on input.
swagger:model ip_interface_inline_location_inline_home_port
*/
type IPInterfaceInlineLocationInlineHomePort struct {

	// links
	Links *models.IPInterfaceInlineLocationInlineHomePortInlineLinks `json:"_links,omitempty"`

	// name
	// Example: e1b
	Name *string `json:"name,omitempty"`

	// node
	Node *models.IPInterfaceInlineLocationInlineHomePortInlineNode `json:"node,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ip interface inline location inline home port
func (o *IPInterfaceInlineLocationInlineHomePort) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocationInlineHomePort) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IPInterfaceInlineLocationInlineHomePort) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location inline home port based on the context it is used
func (o *IPInterfaceInlineLocationInlineHomePort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocationInlineHomePort) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IPInterfaceInlineLocationInlineHomePort) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlineHomePort) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlineHomePort) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlineHomePort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineLocationInlineHomePortInlineLinks ip interface inline location inline home port inline links
swagger:model ip_interface_inline_location_inline_home_port_inline__links
*/
type IPInterfaceInlineLocationInlineHomePortInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ip interface inline location inline home port inline links
func (o *IPInterfaceInlineLocationInlineHomePortInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocationInlineHomePortInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location inline home port inline links based on the context it is used
func (o *IPInterfaceInlineLocationInlineHomePortInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocationInlineHomePortInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "home_port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlineHomePortInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlineHomePortInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlineHomePortInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineLocationInlineHomePortInlineNode ip interface inline location inline home port inline node
swagger:model ip_interface_inline_location_inline_home_port_inline_node
*/
type IPInterfaceInlineLocationInlineHomePortInlineNode struct {

	// Name of node on which the port is located.
	// Example: node1
	Name *string `json:"name,omitempty"`
}

// Validate validates this ip interface inline location inline home port inline node
func (o *IPInterfaceInlineLocationInlineHomePortInlineNode) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this ip interface inline location inline home port inline node based on context it is used
func (o *IPInterfaceInlineLocationInlineHomePortInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlineHomePortInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlineHomePortInlineNode) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlineHomePortInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineLocationInlineNode ip interface inline location inline node
swagger:model ip_interface_inline_location_inline_node
*/
type IPInterfaceInlineLocationInlineNode struct {

	// links
	Links *models.IPInterfaceInlineLocationInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ip interface inline location inline node
func (o *IPInterfaceInlineLocationInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocationInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location inline node based on the context it is used
func (o *IPInterfaceInlineLocationInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocationInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlineNode) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineLocationInlineNodeInlineLinks ip interface inline location inline node inline links
swagger:model ip_interface_inline_location_inline_node_inline__links
*/
type IPInterfaceInlineLocationInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ip interface inline location inline node inline links
func (o *IPInterfaceInlineLocationInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocationInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location inline node inline links based on the context it is used
func (o *IPInterfaceInlineLocationInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocationInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineLocationInlinePort Port UUID along with readable names. Either the UUID or both names may be supplied on input.
swagger:model ip_interface_inline_location_inline_port
*/
type IPInterfaceInlineLocationInlinePort struct {

	// links
	Links *models.IPInterfaceInlineLocationInlinePortInlineLinks `json:"_links,omitempty"`

	// name
	// Example: e1b
	Name *string `json:"name,omitempty"`

	// node
	Node *models.IPInterfaceInlineLocationInlinePortInlineNode `json:"node,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ip interface inline location inline port
func (o *IPInterfaceInlineLocationInlinePort) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocationInlinePort) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IPInterfaceInlineLocationInlinePort) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location inline port based on the context it is used
func (o *IPInterfaceInlineLocationInlinePort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocationInlinePort) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IPInterfaceInlineLocationInlinePort) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlinePort) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlinePort) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlinePort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineLocationInlinePortInlineLinks ip interface inline location inline port inline links
swagger:model ip_interface_inline_location_inline_port_inline__links
*/
type IPInterfaceInlineLocationInlinePortInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ip interface inline location inline port inline links
func (o *IPInterfaceInlineLocationInlinePortInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocationInlinePortInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location inline port inline links based on the context it is used
func (o *IPInterfaceInlineLocationInlinePortInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineLocationInlinePortInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlinePortInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlinePortInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlinePortInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineLocationInlinePortInlineNode ip interface inline location inline port inline node
swagger:model ip_interface_inline_location_inline_port_inline_node
*/
type IPInterfaceInlineLocationInlinePortInlineNode struct {

	// Name of node on which the port is located.
	// Example: node1
	Name *string `json:"name,omitempty"`
}

// Validate validates this ip interface inline location inline port inline node
func (o *IPInterfaceInlineLocationInlinePortInlineNode) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this ip interface inline location inline port inline node based on context it is used
func (o *IPInterfaceInlineLocationInlinePortInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlinePortInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineLocationInlinePortInlineNode) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlinePortInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineMetric The most recent sample of I/O metrics for the interface.
swagger:model ip_interface_inline_metric
*/
type IPInterfaceInlineMetric struct {

	// links
	Links *models.IPInterfaceInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *models.IPInterfaceInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this ip interface inline metric
func (o *IPInterfaceInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var ipInterfaceInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipInterfaceInlineMetricTypeDurationPropEnum = append(ipInterfaceInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// IPInterfaceInlineMetricDurationPT15S captures enum value "PT15S"
	IPInterfaceInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// IPInterfaceInlineMetricDurationPT4M captures enum value "PT4M"
	IPInterfaceInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// IPInterfaceInlineMetricDurationPT30M captures enum value "PT30M"
	IPInterfaceInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// IPInterfaceInlineMetricDurationPT2H captures enum value "PT2H"
	IPInterfaceInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// IPInterfaceInlineMetricDurationP1D captures enum value "P1D"
	IPInterfaceInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// IPInterfaceInlineMetricDurationPT5M captures enum value "PT5M"
	IPInterfaceInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (o *IPInterfaceInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ipInterfaceInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *IPInterfaceInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(o.Duration) { // not required
		return nil
	}

	// value enum
	if err := o.validateDurationEnum("info"+"."+"metric"+"."+"duration", "body", *o.Duration); err != nil {
		return err
	}

	return nil
}

var ipInterfaceInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipInterfaceInlineMetricTypeStatusPropEnum = append(ipInterfaceInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// IPInterfaceInlineMetricStatusOk captures enum value "ok"
	IPInterfaceInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// IPInterfaceInlineMetricStatusError captures enum value "error"
	IPInterfaceInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// IPInterfaceInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	IPInterfaceInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// IPInterfaceInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	IPInterfaceInlineMetricStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// IPInterfaceInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	IPInterfaceInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// IPInterfaceInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	IPInterfaceInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// IPInterfaceInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	IPInterfaceInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// IPInterfaceInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	IPInterfaceInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// IPInterfaceInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	IPInterfaceInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// IPInterfaceInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	IPInterfaceInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (o *IPInterfaceInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ipInterfaceInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *IPInterfaceInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"metric"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *IPInterfaceInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(o.Throughput) { // not required
		return nil
	}

	if o.Throughput != nil {
		if err := o.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *IPInterfaceInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"metric"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ip interface inline metric based on the context it is used
func (o *IPInterfaceInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IPInterfaceInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if o.Throughput != nil {
		if err := o.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineMetric) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineMetric) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineMetricInlineLinks ip interface inline metric inline links
swagger:model ip_interface_inline_metric_inline__links
*/
type IPInterfaceInlineMetricInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ip interface inline metric inline links
func (o *IPInterfaceInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline metric inline links based on the context it is used
func (o *IPInterfaceInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineMetricInlineThroughput The rate of throughput bytes per second observed at the interface.
swagger:model ip_interface_inline_metric_inline_throughput
*/
type IPInterfaceInlineMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this ip interface inline metric inline throughput
func (o *IPInterfaceInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this ip interface inline metric inline throughput based on context it is used
func (o *IPInterfaceInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineServicePolicy ip interface inline service policy
swagger:model ip_interface_inline_service_policy
*/
type IPInterfaceInlineServicePolicy struct {

	// links
	Links *models.IPInterfaceInlineServicePolicyInlineLinks `json:"_links,omitempty"`

	// name
	// Example: default-intercluster
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ip interface inline service policy
func (o *IPInterfaceInlineServicePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineServicePolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "service_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline service policy based on the context it is used
func (o *IPInterfaceInlineServicePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineServicePolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "service_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineServicePolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineServicePolicy) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineServicePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineServicePolicyInlineLinks ip interface inline service policy inline links
swagger:model ip_interface_inline_service_policy_inline__links
*/
type IPInterfaceInlineServicePolicyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ip interface inline service policy inline links
func (o *IPInterfaceInlineServicePolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineServicePolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "service_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline service policy inline links based on the context it is used
func (o *IPInterfaceInlineServicePolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineServicePolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "service_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineServicePolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineServicePolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineServicePolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineStatistics The real time I/O statistics for the interface.
swagger:model ip_interface_inline_statistics
*/
type IPInterfaceInlineStatistics struct {

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *models.IPInterfaceInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this ip interface inline statistics
func (o *IPInterfaceInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var ipInterfaceInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipInterfaceInlineStatisticsTypeStatusPropEnum = append(ipInterfaceInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ip_interface_inline_statistics
	// IPInterfaceInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// IPInterfaceInlineStatisticsStatusOk captures enum value "ok"
	IPInterfaceInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// ip_interface_inline_statistics
	// IPInterfaceInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// IPInterfaceInlineStatisticsStatusError captures enum value "error"
	IPInterfaceInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// ip_interface_inline_statistics
	// IPInterfaceInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// IPInterfaceInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	IPInterfaceInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// ip_interface_inline_statistics
	// IPInterfaceInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// IPInterfaceInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	IPInterfaceInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// ip_interface_inline_statistics
	// IPInterfaceInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// IPInterfaceInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	IPInterfaceInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// ip_interface_inline_statistics
	// IPInterfaceInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// IPInterfaceInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	IPInterfaceInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// ip_interface_inline_statistics
	// IPInterfaceInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// IPInterfaceInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	IPInterfaceInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// ip_interface_inline_statistics
	// IPInterfaceInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// IPInterfaceInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	IPInterfaceInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// ip_interface_inline_statistics
	// IPInterfaceInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// IPInterfaceInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	IPInterfaceInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// ip_interface_inline_statistics
	// IPInterfaceInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// IPInterfaceInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	IPInterfaceInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (o *IPInterfaceInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ipInterfaceInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *IPInterfaceInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"statistics"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *IPInterfaceInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.ThroughputRaw) { // not required
		return nil
	}

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *IPInterfaceInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"statistics"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ip interface inline statistics based on the context it is used
func (o *IPInterfaceInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineStatistics) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineStatistics) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineStatisticsInlineThroughputRaw Throughput bytes observed at the interface. This can be used along with delta time to calculate the rate of throughput bytes per unit of time.
swagger:model ip_interface_inline_statistics_inline_throughput_raw
*/
type IPInterfaceInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this ip interface inline statistics inline throughput raw
func (o *IPInterfaceInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this ip interface inline statistics inline throughput raw based on context it is used
func (o *IPInterfaceInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineSvm Applies only to SVM-scoped objects. Either the UUID or name must be supplied on POST.
swagger:model ip_interface_inline_svm
*/
type IPInterfaceInlineSvm struct {

	// links
	Links *IPInterfaceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ip interface inline svm
func (o *IPInterfaceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline svm based on the context it is used
func (o *IPInterfaceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineSvm) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IPInterfaceInlineSvmInlineLinks ip interface inline svm inline links
swagger:model ip_interface_inline_svm_inline__links
*/
type IPInterfaceInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ip interface inline svm inline links
func (o *IPInterfaceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline svm inline links based on the context it is used
func (o *IPInterfaceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IPInterfaceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IPInterfaceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IPInterfaceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
