// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NetworkIPInterfaceModifyReader is a Reader for the NetworkIPInterfaceModify structure.
type NetworkIPInterfaceModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NetworkIPInterfaceModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNetworkIPInterfaceModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNetworkIPInterfaceModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNetworkIPInterfaceModifyOK creates a NetworkIPInterfaceModifyOK with default headers values
func NewNetworkIPInterfaceModifyOK() *NetworkIPInterfaceModifyOK {
	return &NetworkIPInterfaceModifyOK{}
}

/*
NetworkIPInterfaceModifyOK describes a response with status code 200, with default header values.

OK
*/
type NetworkIPInterfaceModifyOK struct {
}

// IsSuccess returns true when this network Ip interface modify o k response has a 2xx status code
func (o *NetworkIPInterfaceModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this network Ip interface modify o k response has a 3xx status code
func (o *NetworkIPInterfaceModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network Ip interface modify o k response has a 4xx status code
func (o *NetworkIPInterfaceModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this network Ip interface modify o k response has a 5xx status code
func (o *NetworkIPInterfaceModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this network Ip interface modify o k response a status code equal to that given
func (o *NetworkIPInterfaceModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the network Ip interface modify o k response
func (o *NetworkIPInterfaceModifyOK) Code() int {
	return 200
}

func (o *NetworkIPInterfaceModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /network/ip/interfaces/{uuid}][%d] networkIpInterfaceModifyOK", 200)
}

func (o *NetworkIPInterfaceModifyOK) String() string {
	return fmt.Sprintf("[PATCH /network/ip/interfaces/{uuid}][%d] networkIpInterfaceModifyOK", 200)
}

func (o *NetworkIPInterfaceModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNetworkIPInterfaceModifyDefault creates a NetworkIPInterfaceModifyDefault with default headers values
func NewNetworkIPInterfaceModifyDefault(code int) *NetworkIPInterfaceModifyDefault {
	return &NetworkIPInterfaceModifyDefault{
		_statusCode: code,
	}
}

/*
	NetworkIPInterfaceModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262196 | Field cannot be set in this operation. |
| 1376663 | Cannot add interface to DNS zone because all interfaces from a single DNS zone must be in the same SVM. |
| 1376963 | Duplicate IP address. |
| 1376976 | The specified port is not capable of hosting this LIF. |
| 1376986 | The interface could not migrate because no additional interfaces can be hosted on the specified node. |
| 1376997 | Interface failed to migrate because the node hosting the port is not healthy. |
| 1376998 | The specified location.node does not own any ports in the same broadcast domain as the home port of the interface. |
| 1376999 | Interface failed to migrate because port is in the down admin state. |
| 1377607 | The specified location.port is not in the same broadcast domain as the home port of the interface. |
| 1377666 | Subnet does not have any addresses available. |
| 1966081 | Failed to lookup the port on the node. |
| 1966133 | The netmask cannot represent the entire IP subnet. |
| 1966135 | Cluster configuration can only be changed from node where the cluster LIF resides. |
| 1966138 | The same IP address may not be used for both a mgmt interface and a gateway address. |
| 1966141 | Invalid DNS zone name. |
| 1966142 | Only data LIFs can be assigned a DNS zone. |
| 1966191 | The interface could not be created because interface identifier creation failed. |
| 1966197 | Migration of cluster interfaces must be done from the local node. |
| 1966238 | Cannot change the home-node or home-port of an active SAN or NVMe data interface. |
| 1966267 | IPv6 addresses must have a prefix length between 1 and 127. |
| 1966269 | IPv4 addresses must have a prefix length between 1 and 32. |
| 1966299 | Changing a cluster LIF's administrative status to down is not a supported operation. |
| 1966419 | Subnet not found in the IPspace of the SVM. |
| 1966419 | Specified subnet not found in the IPspace of the LIF. |
| 1966476 | DNS Update is supported only on data interfaces. |
| 1966477 | DNS Update is supported only on interfaces configured with the NFS or CIFS protocol. |
| 1966507 | A port on the node has been identified as potentially unhealthy. |
| 1966685 | There are no ports on the node that are in the broadcast domain associated with the IPspace. |
| 1967106 | The specified location.home_port.name does not match the specified port name of location.home_port.uuid. |
| 1967107 | The specified location.home_port.uuid is not valid. |
| 1967111 | A home node must be specified by at least one location.home_node, location.home_port, or location.broadcast_domain field. |
| 1967113 | The specified location.port.name does not match the port name of location.port.uuid. |
| 1967114 | The specified location.port.uuid is not valid. |
| 1967115 | The specified location.node.name does not match the node name of location.node.uuid. |
| 1967116 | The specified location.port.node.name does not match the node name of location.node.uuid. |
| 1967117 | The specified location.port.node.name does not match location.node.name. |
| 1967118 | A node must be specified by at least one location.node or location.port field. |
| 1967119 | The specified location.node.name does not match the node name of location.port.uuid. |
| 1967120 | The specified service_policy.name does not match the specified service policy name of service_policy.uuid. |
| 1967121 | The specified service_policy.uuid is not valid. |
| 1967125 | You cannot patch the "location.node" or "location.port" fields to migrate interfaces using the iSCSI data protocol. Instead perform the following PATCH operations on the interface: set the "enabled" field to "false"; change one or more "location.home_port" fields to migrate the interface; and then set the "enabled" field to "true". |
| 1967129 | The specified location.home_port.uuid is not valid. |
| 1967130 | The specified location.home_port.name is not valid. |
| 1967131 | The specified location.home_port.uuid and location.home_port.name are not valid. |
| 1967132 | The specified location.port.uuid is not valid. |
| 1967133 | The specified location.port.name is not valid. |
| 1967134 | The specified location.port.uuid and location.port.name are not valid. |
| 1967138 | Cannot patch port for a VIP interface. The specified parameter location.port.uuid is not valid. |
| 1967139 | Cannot patch port for a VIP interface. The specified parameter location.port.name is not valid. |
| 1967140 | Cannot patch port for a VIP interface. The specified parameters location.port.uuid and location.port.name are not valid. |
| 1967141 | Cannot patch home_port for a VIP interface. The specified parameter location.home_port.uuid is not valid. |
| 1967142 | Cannot patch home_port for a VIP interface. The specified parameter location.home_port.name is not valid. |
| 1967143 | Cannot patch home_port for a VIP interface. The specified parameters location.home_port.uuid and location.home_port.name  are not valid. |
| 1967145 | The specified location.failover is not valid. |
| 1967153 | No suitable port exists on location.home_node to host the interface. |
| 1967380 | Cannot patch home_port for a VIP interface. The specified parameter location.home_port.node.name is not valid. Consider using location.home_node.name instead. |
| 1967385 | VIP interface address and netmask error. |
| 1967386 | Cannot patch port for a VIP interface. The specified parameter location.port.node.name is not valid. Consider using location.node.name instead. |
| 1967387 | The specified IP address is in use by a subnet in this IPspace. |
| 1967389 | Patching location.is_home to the value "false" is not supported. The value "true" would revert a network interface to its home port if the current value is "false". |
| 1967390 | Cannot patch a LIF revert as it requires an effective cluster version of 9.9.1 or later. |
| 1967391 | Patching the DNS zone requires an effective cluster version of 9.9.1 or later. |
| 1967392 | Patching the DDNS enable parameter requires an effective cluster version of 9.9.1 or later. |
| 1967396 | The specified subnet.name does not match the subnet name of subnet.uuid. |
| 1967397 | The specified subnet.uuid does not match any configured subnet."; |
| 1967398 | Address must be specified by either ip.address and ip.netmask, or at least one subnet field, not both."; |
| 2621574 | This operation is not permitted on an SVM that is configured as the destination of a MetroCluster SVM relationship. |
| 53281018 | Failover policy is not compatible with one or more services in service policy |
| 53281065 | The service_policy does not exist in the SVM. |
| 53281072 | The failover policy is not valid for interfaces in the SVM. |
| 53281086 | LIF would exceed the maximum number of supported intercluster LIFs in IPspace. |
| 53281087 | SVM must have an NVMe service to perform this operation. |
| 53281089 | LIF on SVM cannot be updated to use service policy because that service policy includes SAN services and the target LIF is not home. |
| 53281096 | LIF could not be modified because the current port does not support the specified rdma-protocols. |
| 53281106 | Failed checking the cluster capabilities. |
| 53281109 | The interface could not be updated to use the service policy because the interface is currently associated with BGP peer group. |
| 53281111 | Cannot update the service policy because the interface is associated with a BGP peer-group. |
| 53281113 | Configuration details for LIF were modified but an error was encountered while updating the LIF's operational status. |
| 53281114 | The specified parameter is only supported on data SVMs. |
| 53281468 | Failed to update external route tables for IP. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type NetworkIPInterfaceModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this network ip interface modify default response has a 2xx status code
func (o *NetworkIPInterfaceModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this network ip interface modify default response has a 3xx status code
func (o *NetworkIPInterfaceModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this network ip interface modify default response has a 4xx status code
func (o *NetworkIPInterfaceModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this network ip interface modify default response has a 5xx status code
func (o *NetworkIPInterfaceModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this network ip interface modify default response a status code equal to that given
func (o *NetworkIPInterfaceModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the network ip interface modify default response
func (o *NetworkIPInterfaceModifyDefault) Code() int {
	return o._statusCode
}

func (o *NetworkIPInterfaceModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/ip/interfaces/{uuid}][%d] network_ip_interface_modify default %s", o._statusCode, payload)
}

func (o *NetworkIPInterfaceModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /network/ip/interfaces/{uuid}][%d] network_ip_interface_modify default %s", o._statusCode, payload)
}

func (o *NetworkIPInterfaceModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NetworkIPInterfaceModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
