// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NetworkIPInterfacesGetReader is a Reader for the NetworkIPInterfacesGet structure.
type NetworkIPInterfacesGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NetworkIPInterfacesGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNetworkIPInterfacesGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNetworkIPInterfacesGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNetworkIPInterfacesGetOK creates a NetworkIPInterfacesGetOK with default headers values
func NewNetworkIPInterfacesGetOK() *NetworkIPInterfacesGetOK {
	return &NetworkIPInterfacesGetOK{}
}

/*
NetworkIPInterfacesGetOK describes a response with status code 200, with default header values.

OK
*/
type NetworkIPInterfacesGetOK struct {
	Payload *models.IPInterfaceResponse
}

// IsSuccess returns true when this network Ip interfaces get o k response has a 2xx status code
func (o *NetworkIPInterfacesGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this network Ip interfaces get o k response has a 3xx status code
func (o *NetworkIPInterfacesGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network Ip interfaces get o k response has a 4xx status code
func (o *NetworkIPInterfacesGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this network Ip interfaces get o k response has a 5xx status code
func (o *NetworkIPInterfacesGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this network Ip interfaces get o k response a status code equal to that given
func (o *NetworkIPInterfacesGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the network Ip interfaces get o k response
func (o *NetworkIPInterfacesGetOK) Code() int {
	return 200
}

func (o *NetworkIPInterfacesGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/ip/interfaces][%d] networkIpInterfacesGetOK %s", 200, payload)
}

func (o *NetworkIPInterfacesGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/ip/interfaces][%d] networkIpInterfacesGetOK %s", 200, payload)
}

func (o *NetworkIPInterfacesGetOK) GetPayload() *models.IPInterfaceResponse {
	return o.Payload
}

func (o *NetworkIPInterfacesGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.IPInterfaceResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNetworkIPInterfacesGetDefault creates a NetworkIPInterfacesGetDefault with default headers values
func NewNetworkIPInterfacesGetDefault(code int) *NetworkIPInterfacesGetDefault {
	return &NetworkIPInterfacesGetDefault{
		_statusCode: code,
	}
}

/*
	NetworkIPInterfacesGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 53282769 | Not all nodes support enabling the LIF recommendations feature. |
| 53282770 | No matching subnets are configured in IPspace. |
| 53282772 | Not enough available IPs in subnet. |
| 53282773 | Not enough locations available on node for subnet. |
| 53282774 | The specified SVM UUID is invalid. |
| 53282775 | The specified SVM name is invalid. |
| 53282776 | The specified SVM name and UUID do not match. |
| 53282777 | The specified SVM does not exist in the IPspace. |
| 53282778 | The specified SVM does not exist in the IPspace. |
| 53282779 | The specified IPspace UUID is invalid. |
| 53282780 | The specified IPspace name is invalid. |
| 53282781 | The specified IPspace UUID and name do not match. |
| 53282782 | The specified service policy UUID does not exist. |
| 53282783 | THe specified service policy UUID and name do not match. |
| 53282784 | The specified service policy does not exist in the SVM. |
| 53282785 | The specified service policy does not exist in the IPspace. |
| 53282786 | The specified broadcast domain does not exist. |
| 53282787 | The specified broadcast domain UUID and name do not match. |
| 53282788 | The specified broadcast domain UUID does not exist in the IPspace. |
| 53282789 | The specified broadcast domain name does not exist in the IPspace. |
| 53282790 | The specified subnet UUID does not exist. |
| 53282791 | The specified subnet UUID and name do not match. |
| 53282792 | The specified subnet does not exist in the IPspace. |
| 53282793 | The specified subnet does not match the specified broadcast domain. |
| 53282794 | The specified subnet name does not exist in the IPspace. |
| 53282795 | The specified subnet name does not exist in the broadcast domain. |
| 53282796 | The specified SVM has a type that is not supported. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type NetworkIPInterfacesGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this network ip interfaces get default response has a 2xx status code
func (o *NetworkIPInterfacesGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this network ip interfaces get default response has a 3xx status code
func (o *NetworkIPInterfacesGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this network ip interfaces get default response has a 4xx status code
func (o *NetworkIPInterfacesGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this network ip interfaces get default response has a 5xx status code
func (o *NetworkIPInterfacesGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this network ip interfaces get default response a status code equal to that given
func (o *NetworkIPInterfacesGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the network ip interfaces get default response
func (o *NetworkIPInterfacesGetDefault) Code() int {
	return o._statusCode
}

func (o *NetworkIPInterfacesGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/ip/interfaces][%d] network_ip_interfaces_get default %s", o._statusCode, payload)
}

func (o *NetworkIPInterfacesGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/ip/interfaces][%d] network_ip_interfaces_get default %s", o._statusCode, payload)
}

func (o *NetworkIPInterfacesGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NetworkIPInterfacesGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
