// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNetworkIPRouteDeleteCollectionParams creates a new NetworkIPRouteDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNetworkIPRouteDeleteCollectionParams() *NetworkIPRouteDeleteCollectionParams {
	return &NetworkIPRouteDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNetworkIPRouteDeleteCollectionParamsWithTimeout creates a new NetworkIPRouteDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewNetworkIPRouteDeleteCollectionParamsWithTimeout(timeout time.Duration) *NetworkIPRouteDeleteCollectionParams {
	return &NetworkIPRouteDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewNetworkIPRouteDeleteCollectionParamsWithContext creates a new NetworkIPRouteDeleteCollectionParams object
// with the ability to set a context for a request.
func NewNetworkIPRouteDeleteCollectionParamsWithContext(ctx context.Context) *NetworkIPRouteDeleteCollectionParams {
	return &NetworkIPRouteDeleteCollectionParams{
		Context: ctx,
	}
}

// NewNetworkIPRouteDeleteCollectionParamsWithHTTPClient creates a new NetworkIPRouteDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewNetworkIPRouteDeleteCollectionParamsWithHTTPClient(client *http.Client) *NetworkIPRouteDeleteCollectionParams {
	return &NetworkIPRouteDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
NetworkIPRouteDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the network ip route delete collection operation.

	Typically these are written to a http.Request.
*/
type NetworkIPRouteDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* DestinationAddress.

	   Filter by destination.address
	*/
	DestinationAddress *string

	/* DestinationFamily.

	   Filter by destination.family
	*/
	DestinationFamily *string

	/* DestinationNetmask.

	   Filter by destination.netmask
	*/
	DestinationNetmask *string

	/* Gateway.

	   Filter by gateway
	*/
	Gateway *string

	/* Info.

	   Info specification
	*/
	Info NetworkIPRouteDeleteCollectionBody

	/* InterfacesIPAddress.

	   Filter by interfaces.ip.address
	*/
	InterfacesIPAddress *string

	/* InterfacesName.

	   Filter by interfaces.name
	*/
	InterfacesName *string

	/* InterfacesUUID.

	   Filter by interfaces.uuid
	*/
	InterfacesUUID *string

	/* IpspaceName.

	   Filter by ipspace.name
	*/
	IpspaceName *string

	/* IpspaceUUID.

	   Filter by ipspace.uuid
	*/
	IpspaceUUID *string

	/* Metric.

	   Filter by metric
	*/
	Metric *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the network ip route delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkIPRouteDeleteCollectionParams) WithDefaults() *NetworkIPRouteDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the network ip route delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkIPRouteDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := NetworkIPRouteDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithTimeout(timeout time.Duration) *NetworkIPRouteDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithContext(ctx context.Context) *NetworkIPRouteDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithHTTPClient(client *http.Client) *NetworkIPRouteDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *NetworkIPRouteDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDestinationAddress adds the destinationAddress to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithDestinationAddress(destinationAddress *string) *NetworkIPRouteDeleteCollectionParams {
	o.SetDestinationAddress(destinationAddress)
	return o
}

// SetDestinationAddress adds the destinationAddress to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetDestinationAddress(destinationAddress *string) {
	o.DestinationAddress = destinationAddress
}

// WithDestinationFamily adds the destinationFamily to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithDestinationFamily(destinationFamily *string) *NetworkIPRouteDeleteCollectionParams {
	o.SetDestinationFamily(destinationFamily)
	return o
}

// SetDestinationFamily adds the destinationFamily to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetDestinationFamily(destinationFamily *string) {
	o.DestinationFamily = destinationFamily
}

// WithDestinationNetmask adds the destinationNetmask to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithDestinationNetmask(destinationNetmask *string) *NetworkIPRouteDeleteCollectionParams {
	o.SetDestinationNetmask(destinationNetmask)
	return o
}

// SetDestinationNetmask adds the destinationNetmask to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetDestinationNetmask(destinationNetmask *string) {
	o.DestinationNetmask = destinationNetmask
}

// WithGateway adds the gateway to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithGateway(gateway *string) *NetworkIPRouteDeleteCollectionParams {
	o.SetGateway(gateway)
	return o
}

// SetGateway adds the gateway to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetGateway(gateway *string) {
	o.Gateway = gateway
}

// WithInfo adds the info to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithInfo(info NetworkIPRouteDeleteCollectionBody) *NetworkIPRouteDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetInfo(info NetworkIPRouteDeleteCollectionBody) {
	o.Info = info
}

// WithInterfacesIPAddress adds the interfacesIPAddress to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithInterfacesIPAddress(interfacesIPAddress *string) *NetworkIPRouteDeleteCollectionParams {
	o.SetInterfacesIPAddress(interfacesIPAddress)
	return o
}

// SetInterfacesIPAddress adds the interfacesIpAddress to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetInterfacesIPAddress(interfacesIPAddress *string) {
	o.InterfacesIPAddress = interfacesIPAddress
}

// WithInterfacesName adds the interfacesName to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithInterfacesName(interfacesName *string) *NetworkIPRouteDeleteCollectionParams {
	o.SetInterfacesName(interfacesName)
	return o
}

// SetInterfacesName adds the interfacesName to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetInterfacesName(interfacesName *string) {
	o.InterfacesName = interfacesName
}

// WithInterfacesUUID adds the interfacesUUID to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithInterfacesUUID(interfacesUUID *string) *NetworkIPRouteDeleteCollectionParams {
	o.SetInterfacesUUID(interfacesUUID)
	return o
}

// SetInterfacesUUID adds the interfacesUuid to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetInterfacesUUID(interfacesUUID *string) {
	o.InterfacesUUID = interfacesUUID
}

// WithIpspaceName adds the ipspaceName to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithIpspaceName(ipspaceName *string) *NetworkIPRouteDeleteCollectionParams {
	o.SetIpspaceName(ipspaceName)
	return o
}

// SetIpspaceName adds the ipspaceName to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetIpspaceName(ipspaceName *string) {
	o.IpspaceName = ipspaceName
}

// WithIpspaceUUID adds the ipspaceUUID to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithIpspaceUUID(ipspaceUUID *string) *NetworkIPRouteDeleteCollectionParams {
	o.SetIpspaceUUID(ipspaceUUID)
	return o
}

// SetIpspaceUUID adds the ipspaceUuid to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetIpspaceUUID(ipspaceUUID *string) {
	o.IpspaceUUID = ipspaceUUID
}

// WithMetric adds the metric to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithMetric(metric *int64) *NetworkIPRouteDeleteCollectionParams {
	o.SetMetric(metric)
	return o
}

// SetMetric adds the metric to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetMetric(metric *int64) {
	o.Metric = metric
}

// WithReturnRecords adds the returnRecords to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *NetworkIPRouteDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *NetworkIPRouteDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithScope(scope *string) *NetworkIPRouteDeleteCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *NetworkIPRouteDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithSvmName(svmName *string) *NetworkIPRouteDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithSvmUUID(svmUUID *string) *NetworkIPRouteDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) WithUUID(uuid *string) *NetworkIPRouteDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the network ip route delete collection params
func (o *NetworkIPRouteDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *NetworkIPRouteDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.DestinationAddress != nil {

		// query param destination.address
		var qrDestinationAddress string

		if o.DestinationAddress != nil {
			qrDestinationAddress = *o.DestinationAddress
		}
		qDestinationAddress := qrDestinationAddress
		if qDestinationAddress != "" {

			if err := r.SetQueryParam("destination.address", qDestinationAddress); err != nil {
				return err
			}
		}
	}

	if o.DestinationFamily != nil {

		// query param destination.family
		var qrDestinationFamily string

		if o.DestinationFamily != nil {
			qrDestinationFamily = *o.DestinationFamily
		}
		qDestinationFamily := qrDestinationFamily
		if qDestinationFamily != "" {

			if err := r.SetQueryParam("destination.family", qDestinationFamily); err != nil {
				return err
			}
		}
	}

	if o.DestinationNetmask != nil {

		// query param destination.netmask
		var qrDestinationNetmask string

		if o.DestinationNetmask != nil {
			qrDestinationNetmask = *o.DestinationNetmask
		}
		qDestinationNetmask := qrDestinationNetmask
		if qDestinationNetmask != "" {

			if err := r.SetQueryParam("destination.netmask", qDestinationNetmask); err != nil {
				return err
			}
		}
	}

	if o.Gateway != nil {

		// query param gateway
		var qrGateway string

		if o.Gateway != nil {
			qrGateway = *o.Gateway
		}
		qGateway := qrGateway
		if qGateway != "" {

			if err := r.SetQueryParam("gateway", qGateway); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.InterfacesIPAddress != nil {

		// query param interfaces.ip.address
		var qrInterfacesIPAddress string

		if o.InterfacesIPAddress != nil {
			qrInterfacesIPAddress = *o.InterfacesIPAddress
		}
		qInterfacesIPAddress := qrInterfacesIPAddress
		if qInterfacesIPAddress != "" {

			if err := r.SetQueryParam("interfaces.ip.address", qInterfacesIPAddress); err != nil {
				return err
			}
		}
	}

	if o.InterfacesName != nil {

		// query param interfaces.name
		var qrInterfacesName string

		if o.InterfacesName != nil {
			qrInterfacesName = *o.InterfacesName
		}
		qInterfacesName := qrInterfacesName
		if qInterfacesName != "" {

			if err := r.SetQueryParam("interfaces.name", qInterfacesName); err != nil {
				return err
			}
		}
	}

	if o.InterfacesUUID != nil {

		// query param interfaces.uuid
		var qrInterfacesUUID string

		if o.InterfacesUUID != nil {
			qrInterfacesUUID = *o.InterfacesUUID
		}
		qInterfacesUUID := qrInterfacesUUID
		if qInterfacesUUID != "" {

			if err := r.SetQueryParam("interfaces.uuid", qInterfacesUUID); err != nil {
				return err
			}
		}
	}

	if o.IpspaceName != nil {

		// query param ipspace.name
		var qrIpspaceName string

		if o.IpspaceName != nil {
			qrIpspaceName = *o.IpspaceName
		}
		qIpspaceName := qrIpspaceName
		if qIpspaceName != "" {

			if err := r.SetQueryParam("ipspace.name", qIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.IpspaceUUID != nil {

		// query param ipspace.uuid
		var qrIpspaceUUID string

		if o.IpspaceUUID != nil {
			qrIpspaceUUID = *o.IpspaceUUID
		}
		qIpspaceUUID := qrIpspaceUUID
		if qIpspaceUUID != "" {

			if err := r.SetQueryParam("ipspace.uuid", qIpspaceUUID); err != nil {
				return err
			}
		}
	}

	if o.Metric != nil {

		// query param metric
		var qrMetric int64

		if o.Metric != nil {
			qrMetric = *o.Metric
		}
		qMetric := swag.FormatInt64(qrMetric)
		if qMetric != "" {

			if err := r.SetQueryParam("metric", qMetric); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
